/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLoggingConfigurationResponse extends NetworkFirewallResponse implements
        ToCopyableBuilder<UpdateLoggingConfigurationResponse.Builder, UpdateLoggingConfigurationResponse> {
    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallArn").getter(getter(UpdateLoggingConfigurationResponse::firewallArn))
            .setter(setter(Builder::firewallArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()).build();

    private static final SdkField<String> FIREWALL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallName").getter(getter(UpdateLoggingConfigurationResponse::firewallName))
            .setter(setter(Builder::firewallName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallName").build()).build();

    private static final SdkField<LoggingConfiguration> LOGGING_CONFIGURATION_FIELD = SdkField
            .<LoggingConfiguration> builder(MarshallingType.SDK_POJO).memberName("LoggingConfiguration")
            .getter(getter(UpdateLoggingConfigurationResponse::loggingConfiguration))
            .setter(setter(Builder::loggingConfiguration)).constructor(LoggingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfiguration").build())
            .build();

    private static final SdkField<Boolean> ENABLE_MONITORING_DASHBOARD_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("EnableMonitoringDashboard")
            .getter(getter(UpdateLoggingConfigurationResponse::enableMonitoringDashboard))
            .setter(setter(Builder::enableMonitoringDashboard))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableMonitoringDashboard").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_ARN_FIELD,
            FIREWALL_NAME_FIELD, LOGGING_CONFIGURATION_FIELD, ENABLE_MONITORING_DASHBOARD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String firewallArn;

    private final String firewallName;

    private final LoggingConfiguration loggingConfiguration;

    private final Boolean enableMonitoringDashboard;

    private UpdateLoggingConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.firewallArn = builder.firewallArn;
        this.firewallName = builder.firewallName;
        this.loggingConfiguration = builder.loggingConfiguration;
        this.enableMonitoringDashboard = builder.enableMonitoringDashboard;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the firewall.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the firewall.
     */
    public final String firewallArn() {
        return firewallArn;
    }

    /**
     * <p>
     * The descriptive name of the firewall. You can't change the name of a firewall after you create it.
     * </p>
     * 
     * @return The descriptive name of the firewall. You can't change the name of a firewall after you create it.
     */
    public final String firewallName() {
        return firewallName;
    }

    /**
     * Returns the value of the LoggingConfiguration property for this object.
     * 
     * @return The value of the LoggingConfiguration property for this object.
     */
    public final LoggingConfiguration loggingConfiguration() {
        return loggingConfiguration;
    }

    /**
     * <p>
     * A boolean that reflects whether or not the firewall monitoring dashboard is enabled on a firewall.
     * </p>
     * <p>
     * Returns <code>TRUE</code> when the firewall monitoring dashboard is enabled on the firewall. Returns
     * <code>FALSE</code> when the firewall monitoring dashboard is not enabled on the firewall.
     * </p>
     * 
     * @return A boolean that reflects whether or not the firewall monitoring dashboard is enabled on a firewall.</p>
     *         <p>
     *         Returns <code>TRUE</code> when the firewall monitoring dashboard is enabled on the firewall. Returns
     *         <code>FALSE</code> when the firewall monitoring dashboard is not enabled on the firewall.
     */
    public final Boolean enableMonitoringDashboard() {
        return enableMonitoringDashboard;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(firewallArn());
        hashCode = 31 * hashCode + Objects.hashCode(firewallName());
        hashCode = 31 * hashCode + Objects.hashCode(loggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(enableMonitoringDashboard());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLoggingConfigurationResponse)) {
            return false;
        }
        UpdateLoggingConfigurationResponse other = (UpdateLoggingConfigurationResponse) obj;
        return Objects.equals(firewallArn(), other.firewallArn()) && Objects.equals(firewallName(), other.firewallName())
                && Objects.equals(loggingConfiguration(), other.loggingConfiguration())
                && Objects.equals(enableMonitoringDashboard(), other.enableMonitoringDashboard());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLoggingConfigurationResponse").add("FirewallArn", firewallArn())
                .add("FirewallName", firewallName()).add("LoggingConfiguration", loggingConfiguration())
                .add("EnableMonitoringDashboard", enableMonitoringDashboard()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallArn":
            return Optional.ofNullable(clazz.cast(firewallArn()));
        case "FirewallName":
            return Optional.ofNullable(clazz.cast(firewallName()));
        case "LoggingConfiguration":
            return Optional.ofNullable(clazz.cast(loggingConfiguration()));
        case "EnableMonitoringDashboard":
            return Optional.ofNullable(clazz.cast(enableMonitoringDashboard()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FirewallArn", FIREWALL_ARN_FIELD);
        map.put("FirewallName", FIREWALL_NAME_FIELD);
        map.put("LoggingConfiguration", LOGGING_CONFIGURATION_FIELD);
        map.put("EnableMonitoringDashboard", ENABLE_MONITORING_DASHBOARD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLoggingConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateLoggingConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateLoggingConfigurationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the firewall.
         * </p>
         * 
         * @param firewallArn
         *        The Amazon Resource Name (ARN) of the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallArn(String firewallArn);

        /**
         * <p>
         * The descriptive name of the firewall. You can't change the name of a firewall after you create it.
         * </p>
         * 
         * @param firewallName
         *        The descriptive name of the firewall. You can't change the name of a firewall after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallName(String firewallName);

        /**
         * Sets the value of the LoggingConfiguration property for this object.
         *
         * @param loggingConfiguration
         *        The new value for the LoggingConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfiguration(LoggingConfiguration loggingConfiguration);

        /**
         * Sets the value of the LoggingConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LoggingConfiguration.Builder} avoiding
         * the need to create one manually via {@link LoggingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoggingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #loggingConfiguration(LoggingConfiguration)}.
         * 
         * @param loggingConfiguration
         *        a consumer that will call methods on {@link LoggingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfiguration(LoggingConfiguration)
         */
        default Builder loggingConfiguration(Consumer<LoggingConfiguration.Builder> loggingConfiguration) {
            return loggingConfiguration(LoggingConfiguration.builder().applyMutation(loggingConfiguration).build());
        }

        /**
         * <p>
         * A boolean that reflects whether or not the firewall monitoring dashboard is enabled on a firewall.
         * </p>
         * <p>
         * Returns <code>TRUE</code> when the firewall monitoring dashboard is enabled on the firewall. Returns
         * <code>FALSE</code> when the firewall monitoring dashboard is not enabled on the firewall.
         * </p>
         * 
         * @param enableMonitoringDashboard
         *        A boolean that reflects whether or not the firewall monitoring dashboard is enabled on a firewall.</p>
         *        <p>
         *        Returns <code>TRUE</code> when the firewall monitoring dashboard is enabled on the firewall. Returns
         *        <code>FALSE</code> when the firewall monitoring dashboard is not enabled on the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableMonitoringDashboard(Boolean enableMonitoringDashboard);
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private String firewallArn;

        private String firewallName;

        private LoggingConfiguration loggingConfiguration;

        private Boolean enableMonitoringDashboard;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLoggingConfigurationResponse model) {
            super(model);
            firewallArn(model.firewallArn);
            firewallName(model.firewallName);
            loggingConfiguration(model.loggingConfiguration);
            enableMonitoringDashboard(model.enableMonitoringDashboard);
        }

        public final String getFirewallArn() {
            return firewallArn;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        @Override
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        public final String getFirewallName() {
            return firewallName;
        }

        public final void setFirewallName(String firewallName) {
            this.firewallName = firewallName;
        }

        @Override
        public final Builder firewallName(String firewallName) {
            this.firewallName = firewallName;
            return this;
        }

        public final LoggingConfiguration.Builder getLoggingConfiguration() {
            return loggingConfiguration != null ? loggingConfiguration.toBuilder() : null;
        }

        public final void setLoggingConfiguration(LoggingConfiguration.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        public final Builder loggingConfiguration(LoggingConfiguration loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final Boolean getEnableMonitoringDashboard() {
            return enableMonitoringDashboard;
        }

        public final void setEnableMonitoringDashboard(Boolean enableMonitoringDashboard) {
            this.enableMonitoringDashboard = enableMonitoringDashboard;
        }

        @Override
        public final Builder enableMonitoringDashboard(Boolean enableMonitoringDashboard) {
            this.enableMonitoringDashboard = enableMonitoringDashboard;
            return this;
        }

        @Override
        public UpdateLoggingConfigurationResponse build() {
            return new UpdateLoggingConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
