/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the synchronization state of a transit gateway attachment, including its current status
 * and any error messages. Network Firewall uses this to track the state of your transit gateway configuration changes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayAttachmentSyncState implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayAttachmentSyncState.Builder, TransitGatewayAttachmentSyncState> {
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttachmentId").getter(getter(TransitGatewayAttachmentSyncState::attachmentId))
            .setter(setter(Builder::attachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentId").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayAttachmentStatus")
            .getter(getter(TransitGatewayAttachmentSyncState::transitGatewayAttachmentStatusAsString))
            .setter(setter(Builder::transitGatewayAttachmentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentStatus")
                    .build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(TransitGatewayAttachmentSyncState::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ID_FIELD,
            TRANSIT_GATEWAY_ATTACHMENT_STATUS_FIELD, STATUS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attachmentId;

    private final String transitGatewayAttachmentStatus;

    private final String statusMessage;

    private TransitGatewayAttachmentSyncState(BuilderImpl builder) {
        this.attachmentId = builder.attachmentId;
        this.transitGatewayAttachmentStatus = builder.transitGatewayAttachmentStatus;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The unique identifier of the transit gateway attachment.
     * </p>
     * 
     * @return The unique identifier of the transit gateway attachment.
     */
    public final String attachmentId() {
        return attachmentId;
    }

    /**
     * <p>
     * The current status of the transit gateway attachment.
     * </p>
     * <p>
     * Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The attachment is being created
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The attachment is being deleted
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> - The attachment has been deleted
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The attachment creation has failed and cannot be recovered
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code> - The attachment is in an error state that might be recoverable
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code> - The attachment is active and processing traffic
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_ACCEPTANCE</code> - The attachment is waiting to be accepted
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REJECTING</code> - The attachment is in the process of being rejected
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REJECTED</code> - The attachment has been rejected
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transitGatewayAttachmentStatus} will return {@link TransitGatewayAttachmentStatus#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #transitGatewayAttachmentStatusAsString}.
     * </p>
     * 
     * @return The current status of the transit gateway attachment.</p>
     *         <p>
     *         Valid values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The attachment is being created
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The attachment is being deleted
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code> - The attachment has been deleted
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The attachment creation has failed and cannot be recovered
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code> - The attachment is in an error state that might be recoverable
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code> - The attachment is active and processing traffic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_ACCEPTANCE</code> - The attachment is waiting to be accepted
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REJECTING</code> - The attachment is in the process of being rejected
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REJECTED</code> - The attachment has been rejected
     *         </p>
     *         </li>
     * @see TransitGatewayAttachmentStatus
     */
    public final TransitGatewayAttachmentStatus transitGatewayAttachmentStatus() {
        return TransitGatewayAttachmentStatus.fromValue(transitGatewayAttachmentStatus);
    }

    /**
     * <p>
     * The current status of the transit gateway attachment.
     * </p>
     * <p>
     * Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The attachment is being created
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The attachment is being deleted
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> - The attachment has been deleted
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The attachment creation has failed and cannot be recovered
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code> - The attachment is in an error state that might be recoverable
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code> - The attachment is active and processing traffic
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_ACCEPTANCE</code> - The attachment is waiting to be accepted
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REJECTING</code> - The attachment is in the process of being rejected
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REJECTED</code> - The attachment has been rejected
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transitGatewayAttachmentStatus} will return {@link TransitGatewayAttachmentStatus#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #transitGatewayAttachmentStatusAsString}.
     * </p>
     * 
     * @return The current status of the transit gateway attachment.</p>
     *         <p>
     *         Valid values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The attachment is being created
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The attachment is being deleted
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code> - The attachment has been deleted
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The attachment creation has failed and cannot be recovered
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code> - The attachment is in an error state that might be recoverable
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code> - The attachment is active and processing traffic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_ACCEPTANCE</code> - The attachment is waiting to be accepted
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REJECTING</code> - The attachment is in the process of being rejected
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REJECTED</code> - The attachment has been rejected
     *         </p>
     *         </li>
     * @see TransitGatewayAttachmentStatus
     */
    public final String transitGatewayAttachmentStatusAsString() {
        return transitGatewayAttachmentStatus;
    }

    /**
     * <p>
     * A message providing additional information about the current status, particularly useful when the transit gateway
     * attachment is in a non-<code>READY</code> state.
     * </p>
     * <p>
     * Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The attachment is being created
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The attachment is being deleted
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> - The attachment has been deleted
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The attachment creation has failed and cannot be recovered
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code> - The attachment is in an error state that might be recoverable
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code> - The attachment is active and processing traffic
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_ACCEPTANCE</code> - The attachment is waiting to be accepted
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REJECTING</code> - The attachment is in the process of being rejected
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REJECTED</code> - The attachment has been rejected
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about troubleshooting endpoint failures, see <a href=
     * "https://docs.aws.amazon.com/network-firewall/latest/developerguide/firewall-troubleshooting-endpoint-failures.html"
     * >Troubleshooting firewall endpoint failures</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     * 
     * @return A message providing additional information about the current status, particularly useful when the transit
     *         gateway attachment is in a non-<code>READY</code> state.</p>
     *         <p>
     *         Valid values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The attachment is being created
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The attachment is being deleted
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code> - The attachment has been deleted
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The attachment creation has failed and cannot be recovered
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code> - The attachment is in an error state that might be recoverable
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code> - The attachment is active and processing traffic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_ACCEPTANCE</code> - The attachment is waiting to be accepted
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REJECTING</code> - The attachment is in the process of being rejected
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REJECTED</code> - The attachment has been rejected
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For information about troubleshooting endpoint failures, see <a href=
     *         "https://docs.aws.amazon.com/network-firewall/latest/developerguide/firewall-troubleshooting-endpoint-failures.html"
     *         >Troubleshooting firewall endpoint failures</a> in the <i>Network Firewall Developer Guide</i>.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayAttachmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayAttachmentSyncState)) {
            return false;
        }
        TransitGatewayAttachmentSyncState other = (TransitGatewayAttachmentSyncState) obj;
        return Objects.equals(attachmentId(), other.attachmentId())
                && Objects.equals(transitGatewayAttachmentStatusAsString(), other.transitGatewayAttachmentStatusAsString())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitGatewayAttachmentSyncState").add("AttachmentId", attachmentId())
                .add("TransitGatewayAttachmentStatus", transitGatewayAttachmentStatusAsString())
                .add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachmentId":
            return Optional.ofNullable(clazz.cast(attachmentId()));
        case "TransitGatewayAttachmentStatus":
            return Optional.ofNullable(clazz.cast(transitGatewayAttachmentStatusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttachmentId", ATTACHMENT_ID_FIELD);
        map.put("TransitGatewayAttachmentStatus", TRANSIT_GATEWAY_ATTACHMENT_STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayAttachmentSyncState, T> g) {
        return obj -> g.apply((TransitGatewayAttachmentSyncState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayAttachmentSyncState> {
        /**
         * <p>
         * The unique identifier of the transit gateway attachment.
         * </p>
         * 
         * @param attachmentId
         *        The unique identifier of the transit gateway attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        /**
         * <p>
         * The current status of the transit gateway attachment.
         * </p>
         * <p>
         * Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The attachment is being created
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The attachment is being deleted
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code> - The attachment has been deleted
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The attachment creation has failed and cannot be recovered
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code> - The attachment is in an error state that might be recoverable
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code> - The attachment is active and processing traffic
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_ACCEPTANCE</code> - The attachment is waiting to be accepted
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REJECTING</code> - The attachment is in the process of being rejected
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REJECTED</code> - The attachment has been rejected
         * </p>
         * </li>
         * </ul>
         * 
         * @param transitGatewayAttachmentStatus
         *        The current status of the transit gateway attachment.</p>
         *        <p>
         *        Valid values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The attachment is being created
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The attachment is being deleted
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code> - The attachment has been deleted
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The attachment creation has failed and cannot be recovered
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code> - The attachment is in an error state that might be recoverable
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code> - The attachment is active and processing traffic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_ACCEPTANCE</code> - The attachment is waiting to be accepted
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REJECTING</code> - The attachment is in the process of being rejected
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REJECTED</code> - The attachment has been rejected
         *        </p>
         *        </li>
         * @see TransitGatewayAttachmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentStatus
         */
        Builder transitGatewayAttachmentStatus(String transitGatewayAttachmentStatus);

        /**
         * <p>
         * The current status of the transit gateway attachment.
         * </p>
         * <p>
         * Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The attachment is being created
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The attachment is being deleted
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code> - The attachment has been deleted
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The attachment creation has failed and cannot be recovered
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code> - The attachment is in an error state that might be recoverable
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code> - The attachment is active and processing traffic
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_ACCEPTANCE</code> - The attachment is waiting to be accepted
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REJECTING</code> - The attachment is in the process of being rejected
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REJECTED</code> - The attachment has been rejected
         * </p>
         * </li>
         * </ul>
         * 
         * @param transitGatewayAttachmentStatus
         *        The current status of the transit gateway attachment.</p>
         *        <p>
         *        Valid values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The attachment is being created
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The attachment is being deleted
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code> - The attachment has been deleted
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The attachment creation has failed and cannot be recovered
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code> - The attachment is in an error state that might be recoverable
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code> - The attachment is active and processing traffic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_ACCEPTANCE</code> - The attachment is waiting to be accepted
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REJECTING</code> - The attachment is in the process of being rejected
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REJECTED</code> - The attachment has been rejected
         *        </p>
         *        </li>
         * @see TransitGatewayAttachmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentStatus
         */
        Builder transitGatewayAttachmentStatus(TransitGatewayAttachmentStatus transitGatewayAttachmentStatus);

        /**
         * <p>
         * A message providing additional information about the current status, particularly useful when the transit
         * gateway attachment is in a non-<code>READY</code> state.
         * </p>
         * <p>
         * Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The attachment is being created
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The attachment is being deleted
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code> - The attachment has been deleted
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The attachment creation has failed and cannot be recovered
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code> - The attachment is in an error state that might be recoverable
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code> - The attachment is active and processing traffic
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_ACCEPTANCE</code> - The attachment is waiting to be accepted
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REJECTING</code> - The attachment is in the process of being rejected
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REJECTED</code> - The attachment has been rejected
         * </p>
         * </li>
         * </ul>
         * <p>
         * For information about troubleshooting endpoint failures, see <a href=
         * "https://docs.aws.amazon.com/network-firewall/latest/developerguide/firewall-troubleshooting-endpoint-failures.html"
         * >Troubleshooting firewall endpoint failures</a> in the <i>Network Firewall Developer Guide</i>.
         * </p>
         * 
         * @param statusMessage
         *        A message providing additional information about the current status, particularly useful when the
         *        transit gateway attachment is in a non-<code>READY</code> state.</p>
         *        <p>
         *        Valid values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The attachment is being created
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The attachment is being deleted
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code> - The attachment has been deleted
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The attachment creation has failed and cannot be recovered
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code> - The attachment is in an error state that might be recoverable
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code> - The attachment is active and processing traffic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_ACCEPTANCE</code> - The attachment is waiting to be accepted
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REJECTING</code> - The attachment is in the process of being rejected
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REJECTED</code> - The attachment has been rejected
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For information about troubleshooting endpoint failures, see <a href=
         *        "https://docs.aws.amazon.com/network-firewall/latest/developerguide/firewall-troubleshooting-endpoint-failures.html"
         *        >Troubleshooting firewall endpoint failures</a> in the <i>Network Firewall Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String attachmentId;

        private String transitGatewayAttachmentStatus;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayAttachmentSyncState model) {
            attachmentId(model.attachmentId);
            transitGatewayAttachmentStatus(model.transitGatewayAttachmentStatus);
            statusMessage(model.statusMessage);
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final String getTransitGatewayAttachmentStatus() {
            return transitGatewayAttachmentStatus;
        }

        public final void setTransitGatewayAttachmentStatus(String transitGatewayAttachmentStatus) {
            this.transitGatewayAttachmentStatus = transitGatewayAttachmentStatus;
        }

        @Override
        public final Builder transitGatewayAttachmentStatus(String transitGatewayAttachmentStatus) {
            this.transitGatewayAttachmentStatus = transitGatewayAttachmentStatus;
            return this;
        }

        @Override
        public final Builder transitGatewayAttachmentStatus(TransitGatewayAttachmentStatus transitGatewayAttachmentStatus) {
            this.transitGatewayAttachmentStatus(transitGatewayAttachmentStatus == null ? null : transitGatewayAttachmentStatus
                    .toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public TransitGatewayAttachmentSyncState build() {
            return new TransitGatewayAttachmentSyncState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
