/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings that are available for use in the rules in the <a>RuleGroup</a> where this is defined. See
 * <a>CreateRuleGroup</a> or <a>UpdateRuleGroup</a> for usage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleVariables implements SdkPojo, Serializable, ToCopyableBuilder<RuleVariables.Builder, RuleVariables> {
    private static final SdkField<Map<String, IPSet>> IP_SETS_FIELD = SdkField
            .<Map<String, IPSet>> builder(MarshallingType.MAP)
            .memberName("IPSets")
            .getter(getter(RuleVariables::ipSets))
            .setter(setter(Builder::ipSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPSets").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<IPSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(IPSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, PortSet>> PORT_SETS_FIELD = SdkField
            .<Map<String, PortSet>> builder(MarshallingType.MAP)
            .memberName("PortSets")
            .getter(getter(RuleVariables::portSets))
            .setter(setter(Builder::portSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortSets").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<PortSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(PortSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IP_SETS_FIELD, PORT_SETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, IPSet> ipSets;

    private final Map<String, PortSet> portSets;

    private RuleVariables(BuilderImpl builder) {
        this.ipSets = builder.ipSets;
        this.portSets = builder.portSets;
    }

    /**
     * For responses, this returns true if the service returned a value for the IPSets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIpSets() {
        return ipSets != null && !(ipSets instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of IP addresses and address ranges, in CIDR notation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpSets} method.
     * </p>
     * 
     * @return A list of IP addresses and address ranges, in CIDR notation.
     */
    public final Map<String, IPSet> ipSets() {
        return ipSets;
    }

    /**
     * For responses, this returns true if the service returned a value for the PortSets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPortSets() {
        return portSets != null && !(portSets instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of port ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPortSets} method.
     * </p>
     * 
     * @return A list of port ranges.
     */
    public final Map<String, PortSet> portSets() {
        return portSets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIpSets() ? ipSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPortSets() ? portSets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleVariables)) {
            return false;
        }
        RuleVariables other = (RuleVariables) obj;
        return hasIpSets() == other.hasIpSets() && Objects.equals(ipSets(), other.ipSets())
                && hasPortSets() == other.hasPortSets() && Objects.equals(portSets(), other.portSets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleVariables").add("IPSets", hasIpSets() ? ipSets() : null)
                .add("PortSets", hasPortSets() ? portSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IPSets":
            return Optional.ofNullable(clazz.cast(ipSets()));
        case "PortSets":
            return Optional.ofNullable(clazz.cast(portSets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IPSets", IP_SETS_FIELD);
        map.put("PortSets", PORT_SETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleVariables, T> g) {
        return obj -> g.apply((RuleVariables) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleVariables> {
        /**
         * <p>
         * A list of IP addresses and address ranges, in CIDR notation.
         * </p>
         * 
         * @param ipSets
         *        A list of IP addresses and address ranges, in CIDR notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipSets(Map<String, IPSet> ipSets);

        /**
         * <p>
         * A list of port ranges.
         * </p>
         * 
         * @param portSets
         *        A list of port ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portSets(Map<String, PortSet> portSets);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, IPSet> ipSets = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, PortSet> portSets = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleVariables model) {
            ipSets(model.ipSets);
            portSets(model.portSets);
        }

        public final Map<String, IPSet.Builder> getIpSets() {
            Map<String, IPSet.Builder> result = IPSetsCopier.copyToBuilder(this.ipSets);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setIpSets(Map<String, IPSet.BuilderImpl> ipSets) {
            this.ipSets = IPSetsCopier.copyFromBuilder(ipSets);
        }

        @Override
        public final Builder ipSets(Map<String, IPSet> ipSets) {
            this.ipSets = IPSetsCopier.copy(ipSets);
            return this;
        }

        public final Map<String, PortSet.Builder> getPortSets() {
            Map<String, PortSet.Builder> result = PortSetsCopier.copyToBuilder(this.portSets);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPortSets(Map<String, PortSet.BuilderImpl> portSets) {
            this.portSets = PortSetsCopier.copyFromBuilder(portSets);
        }

        @Override
        public final Builder portSets(Map<String, PortSet> portSets) {
            this.portSets = PortSetsCopier.copy(portSets);
            return this;
        }

        @Override
        public RuleVariables build() {
            return new RuleVariables(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
