/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic where the rule
 * match is applied.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProxyRulesByRequestPhase implements SdkPojo, Serializable,
        ToCopyableBuilder<ProxyRulesByRequestPhase.Builder, ProxyRulesByRequestPhase> {
    private static final SdkField<List<ProxyRule>> PRE_DNS_FIELD = SdkField
            .<List<ProxyRule>> builder(MarshallingType.LIST)
            .memberName("PreDNS")
            .getter(getter(ProxyRulesByRequestPhase::preDNS))
            .setter(setter(Builder::preDNS))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreDNS").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProxyRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProxyRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ProxyRule>> PRE_REQUEST_FIELD = SdkField
            .<List<ProxyRule>> builder(MarshallingType.LIST)
            .memberName("PreREQUEST")
            .getter(getter(ProxyRulesByRequestPhase::preREQUEST))
            .setter(setter(Builder::preREQUEST))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreREQUEST").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProxyRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProxyRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ProxyRule>> POST_RESPONSE_FIELD = SdkField
            .<List<ProxyRule>> builder(MarshallingType.LIST)
            .memberName("PostRESPONSE")
            .getter(getter(ProxyRulesByRequestPhase::postRESPONSE))
            .setter(setter(Builder::postRESPONSE))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostRESPONSE").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProxyRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProxyRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRE_DNS_FIELD,
            PRE_REQUEST_FIELD, POST_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ProxyRule> preDNS;

    private final List<ProxyRule> preREQUEST;

    private final List<ProxyRule> postRESPONSE;

    private ProxyRulesByRequestPhase(BuilderImpl builder) {
        this.preDNS = builder.preDNS;
        this.preREQUEST = builder.preREQUEST;
        this.postRESPONSE = builder.postRESPONSE;
    }

    /**
     * For responses, this returns true if the service returned a value for the PreDNS property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPreDNS() {
        return preDNS != null && !(preDNS instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Before domain resolution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPreDNS} method.
     * </p>
     * 
     * @return Before domain resolution.
     */
    public final List<ProxyRule> preDNS() {
        return preDNS;
    }

    /**
     * For responses, this returns true if the service returned a value for the PreREQUEST property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPreREQUEST() {
        return preREQUEST != null && !(preREQUEST instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * After DNS, before request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPreREQUEST} method.
     * </p>
     * 
     * @return After DNS, before request.
     */
    public final List<ProxyRule> preREQUEST() {
        return preREQUEST;
    }

    /**
     * For responses, this returns true if the service returned a value for the PostRESPONSE property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPostRESPONSE() {
        return postRESPONSE != null && !(postRESPONSE instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * After receiving response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPostRESPONSE} method.
     * </p>
     * 
     * @return After receiving response.
     */
    public final List<ProxyRule> postRESPONSE() {
        return postRESPONSE;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPreDNS() ? preDNS() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPreREQUEST() ? preREQUEST() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPostRESPONSE() ? postRESPONSE() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProxyRulesByRequestPhase)) {
            return false;
        }
        ProxyRulesByRequestPhase other = (ProxyRulesByRequestPhase) obj;
        return hasPreDNS() == other.hasPreDNS() && Objects.equals(preDNS(), other.preDNS())
                && hasPreREQUEST() == other.hasPreREQUEST() && Objects.equals(preREQUEST(), other.preREQUEST())
                && hasPostRESPONSE() == other.hasPostRESPONSE() && Objects.equals(postRESPONSE(), other.postRESPONSE());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProxyRulesByRequestPhase").add("PreDNS", hasPreDNS() ? preDNS() : null)
                .add("PreREQUEST", hasPreREQUEST() ? preREQUEST() : null)
                .add("PostRESPONSE", hasPostRESPONSE() ? postRESPONSE() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PreDNS":
            return Optional.ofNullable(clazz.cast(preDNS()));
        case "PreREQUEST":
            return Optional.ofNullable(clazz.cast(preREQUEST()));
        case "PostRESPONSE":
            return Optional.ofNullable(clazz.cast(postRESPONSE()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PreDNS", PRE_DNS_FIELD);
        map.put("PreREQUEST", PRE_REQUEST_FIELD);
        map.put("PostRESPONSE", POST_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProxyRulesByRequestPhase, T> g) {
        return obj -> g.apply((ProxyRulesByRequestPhase) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProxyRulesByRequestPhase> {
        /**
         * <p>
         * Before domain resolution.
         * </p>
         * 
         * @param preDNS
         *        Before domain resolution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preDNS(Collection<ProxyRule> preDNS);

        /**
         * <p>
         * Before domain resolution.
         * </p>
         * 
         * @param preDNS
         *        Before domain resolution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preDNS(ProxyRule... preDNS);

        /**
         * <p>
         * Before domain resolution.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRule.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRule.Builder#build()} is called immediately
         * and its result is passed to {@link #preDNS(List<ProxyRule>)}.
         * 
         * @param preDNS
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preDNS(java.util.Collection<ProxyRule>)
         */
        Builder preDNS(Consumer<ProxyRule.Builder>... preDNS);

        /**
         * <p>
         * After DNS, before request.
         * </p>
         * 
         * @param preREQUEST
         *        After DNS, before request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preREQUEST(Collection<ProxyRule> preREQUEST);

        /**
         * <p>
         * After DNS, before request.
         * </p>
         * 
         * @param preREQUEST
         *        After DNS, before request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preREQUEST(ProxyRule... preREQUEST);

        /**
         * <p>
         * After DNS, before request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRule.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRule.Builder#build()} is called immediately
         * and its result is passed to {@link #preREQUEST(List<ProxyRule>)}.
         * 
         * @param preREQUEST
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preREQUEST(java.util.Collection<ProxyRule>)
         */
        Builder preREQUEST(Consumer<ProxyRule.Builder>... preREQUEST);

        /**
         * <p>
         * After receiving response.
         * </p>
         * 
         * @param postRESPONSE
         *        After receiving response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postRESPONSE(Collection<ProxyRule> postRESPONSE);

        /**
         * <p>
         * After receiving response.
         * </p>
         * 
         * @param postRESPONSE
         *        After receiving response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postRESPONSE(ProxyRule... postRESPONSE);

        /**
         * <p>
         * After receiving response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRule.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRule.Builder#build()} is called immediately
         * and its result is passed to {@link #postRESPONSE(List<ProxyRule>)}.
         * 
         * @param postRESPONSE
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postRESPONSE(java.util.Collection<ProxyRule>)
         */
        Builder postRESPONSE(Consumer<ProxyRule.Builder>... postRESPONSE);
    }

    static final class BuilderImpl implements Builder {
        private List<ProxyRule> preDNS = DefaultSdkAutoConstructList.getInstance();

        private List<ProxyRule> preREQUEST = DefaultSdkAutoConstructList.getInstance();

        private List<ProxyRule> postRESPONSE = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProxyRulesByRequestPhase model) {
            preDNS(model.preDNS);
            preREQUEST(model.preREQUEST);
            postRESPONSE(model.postRESPONSE);
        }

        public final List<ProxyRule.Builder> getPreDNS() {
            List<ProxyRule.Builder> result = ProxyRuleListCopier.copyToBuilder(this.preDNS);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPreDNS(Collection<ProxyRule.BuilderImpl> preDNS) {
            this.preDNS = ProxyRuleListCopier.copyFromBuilder(preDNS);
        }

        @Override
        public final Builder preDNS(Collection<ProxyRule> preDNS) {
            this.preDNS = ProxyRuleListCopier.copy(preDNS);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preDNS(ProxyRule... preDNS) {
            preDNS(Arrays.asList(preDNS));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preDNS(Consumer<ProxyRule.Builder>... preDNS) {
            preDNS(Stream.of(preDNS).map(c -> ProxyRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ProxyRule.Builder> getPreREQUEST() {
            List<ProxyRule.Builder> result = ProxyRuleListCopier.copyToBuilder(this.preREQUEST);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPreREQUEST(Collection<ProxyRule.BuilderImpl> preREQUEST) {
            this.preREQUEST = ProxyRuleListCopier.copyFromBuilder(preREQUEST);
        }

        @Override
        public final Builder preREQUEST(Collection<ProxyRule> preREQUEST) {
            this.preREQUEST = ProxyRuleListCopier.copy(preREQUEST);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preREQUEST(ProxyRule... preREQUEST) {
            preREQUEST(Arrays.asList(preREQUEST));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preREQUEST(Consumer<ProxyRule.Builder>... preREQUEST) {
            preREQUEST(Stream.of(preREQUEST).map(c -> ProxyRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ProxyRule.Builder> getPostRESPONSE() {
            List<ProxyRule.Builder> result = ProxyRuleListCopier.copyToBuilder(this.postRESPONSE);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPostRESPONSE(Collection<ProxyRule.BuilderImpl> postRESPONSE) {
            this.postRESPONSE = ProxyRuleListCopier.copyFromBuilder(postRESPONSE);
        }

        @Override
        public final Builder postRESPONSE(Collection<ProxyRule> postRESPONSE) {
            this.postRESPONSE = ProxyRuleListCopier.copy(postRESPONSE);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder postRESPONSE(ProxyRule... postRESPONSE) {
            postRESPONSE(Arrays.asList(postRESPONSE));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder postRESPONSE(Consumer<ProxyRule.Builder>... postRESPONSE) {
            postRESPONSE(Stream.of(postRESPONSE).map(c -> ProxyRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ProxyRulesByRequestPhase build() {
            return new ProxyRulesByRequestPhase(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
