/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Proxy rule name and new desired position.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProxyRulePriority implements SdkPojo, Serializable,
        ToCopyableBuilder<ProxyRulePriority.Builder, ProxyRulePriority> {
    private static final SdkField<String> PROXY_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyRuleName").getter(getter(ProxyRulePriority::proxyRuleName)).setter(setter(Builder::proxyRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleName").build()).build();

    private static final SdkField<Integer> NEW_POSITION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NewPosition").getter(getter(ProxyRulePriority::newPosition)).setter(setter(Builder::newPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewPosition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_RULE_NAME_FIELD,
            NEW_POSITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String proxyRuleName;

    private final Integer newPosition;

    private ProxyRulePriority(BuilderImpl builder) {
        this.proxyRuleName = builder.proxyRuleName;
        this.newPosition = builder.newPosition;
    }

    /**
     * <p>
     * The descriptive name of the proxy rule. You can't change the name of a proxy rule after you create it.
     * </p>
     * 
     * @return The descriptive name of the proxy rule. You can't change the name of a proxy rule after you create it.
     */
    public final String proxyRuleName() {
        return proxyRuleName;
    }

    /**
     * <p>
     * Where to move a proxy rule in a proxy rule group.
     * </p>
     * 
     * @return Where to move a proxy rule in a proxy rule group.
     */
    public final Integer newPosition() {
        return newPosition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(proxyRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(newPosition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProxyRulePriority)) {
            return false;
        }
        ProxyRulePriority other = (ProxyRulePriority) obj;
        return Objects.equals(proxyRuleName(), other.proxyRuleName()) && Objects.equals(newPosition(), other.newPosition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProxyRulePriority").add("ProxyRuleName", proxyRuleName()).add("NewPosition", newPosition())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProxyRuleName":
            return Optional.ofNullable(clazz.cast(proxyRuleName()));
        case "NewPosition":
            return Optional.ofNullable(clazz.cast(newPosition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProxyRuleName", PROXY_RULE_NAME_FIELD);
        map.put("NewPosition", NEW_POSITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProxyRulePriority, T> g) {
        return obj -> g.apply((ProxyRulePriority) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProxyRulePriority> {
        /**
         * <p>
         * The descriptive name of the proxy rule. You can't change the name of a proxy rule after you create it.
         * </p>
         * 
         * @param proxyRuleName
         *        The descriptive name of the proxy rule. You can't change the name of a proxy rule after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyRuleName(String proxyRuleName);

        /**
         * <p>
         * Where to move a proxy rule in a proxy rule group.
         * </p>
         * 
         * @param newPosition
         *        Where to move a proxy rule in a proxy rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newPosition(Integer newPosition);
    }

    static final class BuilderImpl implements Builder {
        private String proxyRuleName;

        private Integer newPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(ProxyRulePriority model) {
            proxyRuleName(model.proxyRuleName);
            newPosition(model.newPosition);
        }

        public final String getProxyRuleName() {
            return proxyRuleName;
        }

        public final void setProxyRuleName(String proxyRuleName) {
            this.proxyRuleName = proxyRuleName;
        }

        @Override
        public final Builder proxyRuleName(String proxyRuleName) {
            this.proxyRuleName = proxyRuleName;
            return this;
        }

        public final Integer getNewPosition() {
            return newPosition;
        }

        public final void setNewPosition(Integer newPosition) {
            this.newPosition = newPosition;
        }

        @Override
        public final Builder newPosition(Integer newPosition) {
            this.newPosition = newPosition;
            return this;
        }

        @Override
        public ProxyRulePriority build() {
            return new ProxyRulePriority(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
