/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic where the rule
 * match is applied.
 * </p>
 * <p>
 * This data type is used specifically for the <a>CreateProxyConfiguration</a> and <a>UpdateProxyConfiguration</a> APIs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProxyConfigDefaultRulePhaseActionsRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ProxyConfigDefaultRulePhaseActionsRequest.Builder, ProxyConfigDefaultRulePhaseActionsRequest> {
    private static final SdkField<String> PRE_DNS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PreDNS")
            .getter(getter(ProxyConfigDefaultRulePhaseActionsRequest::preDNSAsString)).setter(setter(Builder::preDNS))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreDNS").build()).build();

    private static final SdkField<String> PRE_REQUEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreREQUEST").getter(getter(ProxyConfigDefaultRulePhaseActionsRequest::preREQUESTAsString))
            .setter(setter(Builder::preREQUEST))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreREQUEST").build()).build();

    private static final SdkField<String> POST_RESPONSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PostRESPONSE").getter(getter(ProxyConfigDefaultRulePhaseActionsRequest::postRESPONSEAsString))
            .setter(setter(Builder::postRESPONSE))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostRESPONSE").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRE_DNS_FIELD,
            PRE_REQUEST_FIELD, POST_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String preDNS;

    private final String preREQUEST;

    private final String postRESPONSE;

    private ProxyConfigDefaultRulePhaseActionsRequest(BuilderImpl builder) {
        this.preDNS = builder.preDNS;
        this.preREQUEST = builder.preREQUEST;
        this.postRESPONSE = builder.postRESPONSE;
    }

    /**
     * <p>
     * Before domain resolution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #preDNS} will
     * return {@link ProxyRulePhaseAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #preDNSAsString}.
     * </p>
     * 
     * @return Before domain resolution.
     * @see ProxyRulePhaseAction
     */
    public final ProxyRulePhaseAction preDNS() {
        return ProxyRulePhaseAction.fromValue(preDNS);
    }

    /**
     * <p>
     * Before domain resolution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #preDNS} will
     * return {@link ProxyRulePhaseAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #preDNSAsString}.
     * </p>
     * 
     * @return Before domain resolution.
     * @see ProxyRulePhaseAction
     */
    public final String preDNSAsString() {
        return preDNS;
    }

    /**
     * <p>
     * After DNS, before request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #preREQUEST} will
     * return {@link ProxyRulePhaseAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #preREQUESTAsString}.
     * </p>
     * 
     * @return After DNS, before request.
     * @see ProxyRulePhaseAction
     */
    public final ProxyRulePhaseAction preREQUEST() {
        return ProxyRulePhaseAction.fromValue(preREQUEST);
    }

    /**
     * <p>
     * After DNS, before request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #preREQUEST} will
     * return {@link ProxyRulePhaseAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #preREQUESTAsString}.
     * </p>
     * 
     * @return After DNS, before request.
     * @see ProxyRulePhaseAction
     */
    public final String preREQUESTAsString() {
        return preREQUEST;
    }

    /**
     * <p>
     * After receiving response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #postRESPONSE} will
     * return {@link ProxyRulePhaseAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #postRESPONSEAsString}.
     * </p>
     * 
     * @return After receiving response.
     * @see ProxyRulePhaseAction
     */
    public final ProxyRulePhaseAction postRESPONSE() {
        return ProxyRulePhaseAction.fromValue(postRESPONSE);
    }

    /**
     * <p>
     * After receiving response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #postRESPONSE} will
     * return {@link ProxyRulePhaseAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #postRESPONSEAsString}.
     * </p>
     * 
     * @return After receiving response.
     * @see ProxyRulePhaseAction
     */
    public final String postRESPONSEAsString() {
        return postRESPONSE;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(preDNSAsString());
        hashCode = 31 * hashCode + Objects.hashCode(preREQUESTAsString());
        hashCode = 31 * hashCode + Objects.hashCode(postRESPONSEAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProxyConfigDefaultRulePhaseActionsRequest)) {
            return false;
        }
        ProxyConfigDefaultRulePhaseActionsRequest other = (ProxyConfigDefaultRulePhaseActionsRequest) obj;
        return Objects.equals(preDNSAsString(), other.preDNSAsString())
                && Objects.equals(preREQUESTAsString(), other.preREQUESTAsString())
                && Objects.equals(postRESPONSEAsString(), other.postRESPONSEAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProxyConfigDefaultRulePhaseActionsRequest").add("PreDNS", preDNSAsString())
                .add("PreREQUEST", preREQUESTAsString()).add("PostRESPONSE", postRESPONSEAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PreDNS":
            return Optional.ofNullable(clazz.cast(preDNSAsString()));
        case "PreREQUEST":
            return Optional.ofNullable(clazz.cast(preREQUESTAsString()));
        case "PostRESPONSE":
            return Optional.ofNullable(clazz.cast(postRESPONSEAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PreDNS", PRE_DNS_FIELD);
        map.put("PreREQUEST", PRE_REQUEST_FIELD);
        map.put("PostRESPONSE", POST_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProxyConfigDefaultRulePhaseActionsRequest, T> g) {
        return obj -> g.apply((ProxyConfigDefaultRulePhaseActionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProxyConfigDefaultRulePhaseActionsRequest> {
        /**
         * <p>
         * Before domain resolution.
         * </p>
         * 
         * @param preDNS
         *        Before domain resolution.
         * @see ProxyRulePhaseAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProxyRulePhaseAction
         */
        Builder preDNS(String preDNS);

        /**
         * <p>
         * Before domain resolution.
         * </p>
         * 
         * @param preDNS
         *        Before domain resolution.
         * @see ProxyRulePhaseAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProxyRulePhaseAction
         */
        Builder preDNS(ProxyRulePhaseAction preDNS);

        /**
         * <p>
         * After DNS, before request.
         * </p>
         * 
         * @param preREQUEST
         *        After DNS, before request.
         * @see ProxyRulePhaseAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProxyRulePhaseAction
         */
        Builder preREQUEST(String preREQUEST);

        /**
         * <p>
         * After DNS, before request.
         * </p>
         * 
         * @param preREQUEST
         *        After DNS, before request.
         * @see ProxyRulePhaseAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProxyRulePhaseAction
         */
        Builder preREQUEST(ProxyRulePhaseAction preREQUEST);

        /**
         * <p>
         * After receiving response.
         * </p>
         * 
         * @param postRESPONSE
         *        After receiving response.
         * @see ProxyRulePhaseAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProxyRulePhaseAction
         */
        Builder postRESPONSE(String postRESPONSE);

        /**
         * <p>
         * After receiving response.
         * </p>
         * 
         * @param postRESPONSE
         *        After receiving response.
         * @see ProxyRulePhaseAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProxyRulePhaseAction
         */
        Builder postRESPONSE(ProxyRulePhaseAction postRESPONSE);
    }

    static final class BuilderImpl implements Builder {
        private String preDNS;

        private String preREQUEST;

        private String postRESPONSE;

        private BuilderImpl() {
        }

        private BuilderImpl(ProxyConfigDefaultRulePhaseActionsRequest model) {
            preDNS(model.preDNS);
            preREQUEST(model.preREQUEST);
            postRESPONSE(model.postRESPONSE);
        }

        public final String getPreDNS() {
            return preDNS;
        }

        public final void setPreDNS(String preDNS) {
            this.preDNS = preDNS;
        }

        @Override
        public final Builder preDNS(String preDNS) {
            this.preDNS = preDNS;
            return this;
        }

        @Override
        public final Builder preDNS(ProxyRulePhaseAction preDNS) {
            this.preDNS(preDNS == null ? null : preDNS.toString());
            return this;
        }

        public final String getPreREQUEST() {
            return preREQUEST;
        }

        public final void setPreREQUEST(String preREQUEST) {
            this.preREQUEST = preREQUEST;
        }

        @Override
        public final Builder preREQUEST(String preREQUEST) {
            this.preREQUEST = preREQUEST;
            return this;
        }

        @Override
        public final Builder preREQUEST(ProxyRulePhaseAction preREQUEST) {
            this.preREQUEST(preREQUEST == null ? null : preREQUEST.toString());
            return this;
        }

        public final String getPostRESPONSE() {
            return postRESPONSE;
        }

        public final void setPostRESPONSE(String postRESPONSE) {
            this.postRESPONSE = postRESPONSE;
        }

        @Override
        public final Builder postRESPONSE(String postRESPONSE) {
            this.postRESPONSE = postRESPONSE;
            return this;
        }

        @Override
        public final Builder postRESPONSE(ProxyRulePhaseAction postRESPONSE) {
            this.postRESPONSE(postRESPONSE == null ? null : postRESPONSE.toString());
            return this;
        }

        @Override
        public ProxyConfigDefaultRulePhaseActionsRequest build() {
            return new ProxyConfigDefaultRulePhaseActionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
