/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Proxy attached to a NAT gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Proxy implements SdkPojo, Serializable, ToCopyableBuilder<Proxy.Builder, Proxy> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime").getter(getter(Proxy::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final SdkField<Instant> DELETE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeleteTime").getter(getter(Proxy::deleteTime)).setter(setter(Builder::deleteTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdateTime").getter(getter(Proxy::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureCode").getter(getter(Proxy::failureCode)).setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode").build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureMessage").getter(getter(Proxy::failureMessage)).setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()).build();

    private static final SdkField<String> PROXY_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyState").getter(getter(Proxy::proxyStateAsString)).setter(setter(Builder::proxyState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyState").build()).build();

    private static final SdkField<String> PROXY_MODIFY_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyModifyState").getter(getter(Proxy::proxyModifyStateAsString))
            .setter(setter(Builder::proxyModifyState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyModifyState").build()).build();

    private static final SdkField<String> NAT_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NatGatewayId").getter(getter(Proxy::natGatewayId)).setter(setter(Builder::natGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId").build()).build();

    private static final SdkField<String> PROXY_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyConfigurationName").getter(getter(Proxy::proxyConfigurationName))
            .setter(setter(Builder::proxyConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationName").build())
            .build();

    private static final SdkField<String> PROXY_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyConfigurationArn").getter(getter(Proxy::proxyConfigurationArn))
            .setter(setter(Builder::proxyConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationArn").build())
            .build();

    private static final SdkField<String> PROXY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyName").getter(getter(Proxy::proxyName)).setter(setter(Builder::proxyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyName").build()).build();

    private static final SdkField<String> PROXY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyArn").getter(getter(Proxy::proxyArn)).setter(setter(Builder::proxyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyArn").build()).build();

    private static final SdkField<List<ListenerProperty>> LISTENER_PROPERTIES_FIELD = SdkField
            .<List<ListenerProperty>> builder(MarshallingType.LIST)
            .memberName("ListenerProperties")
            .getter(getter(Proxy::listenerProperties))
            .setter(setter(Builder::listenerProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListenerProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListenerProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TlsInterceptProperties> TLS_INTERCEPT_PROPERTIES_FIELD = SdkField
            .<TlsInterceptProperties> builder(MarshallingType.SDK_POJO).memberName("TlsInterceptProperties")
            .getter(getter(Proxy::tlsInterceptProperties)).setter(setter(Builder::tlsInterceptProperties))
            .constructor(TlsInterceptProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsInterceptProperties").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(Proxy::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD,
            DELETE_TIME_FIELD, UPDATE_TIME_FIELD, FAILURE_CODE_FIELD, FAILURE_MESSAGE_FIELD, PROXY_STATE_FIELD,
            PROXY_MODIFY_STATE_FIELD, NAT_GATEWAY_ID_FIELD, PROXY_CONFIGURATION_NAME_FIELD, PROXY_CONFIGURATION_ARN_FIELD,
            PROXY_NAME_FIELD, PROXY_ARN_FIELD, LISTENER_PROPERTIES_FIELD, TLS_INTERCEPT_PROPERTIES_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createTime;

    private final Instant deleteTime;

    private final Instant updateTime;

    private final String failureCode;

    private final String failureMessage;

    private final String proxyState;

    private final String proxyModifyState;

    private final String natGatewayId;

    private final String proxyConfigurationName;

    private final String proxyConfigurationArn;

    private final String proxyName;

    private final String proxyArn;

    private final List<ListenerProperty> listenerProperties;

    private final TlsInterceptProperties tlsInterceptProperties;

    private final List<Tag> tags;

    private Proxy(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.deleteTime = builder.deleteTime;
        this.updateTime = builder.updateTime;
        this.failureCode = builder.failureCode;
        this.failureMessage = builder.failureMessage;
        this.proxyState = builder.proxyState;
        this.proxyModifyState = builder.proxyModifyState;
        this.natGatewayId = builder.natGatewayId;
        this.proxyConfigurationName = builder.proxyConfigurationName;
        this.proxyConfigurationArn = builder.proxyConfigurationArn;
        this.proxyName = builder.proxyName;
        this.proxyArn = builder.proxyArn;
        this.listenerProperties = builder.listenerProperties;
        this.tlsInterceptProperties = builder.tlsInterceptProperties;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Time the Proxy was created.
     * </p>
     * 
     * @return Time the Proxy was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * Time the Proxy was deleted.
     * </p>
     * 
     * @return Time the Proxy was deleted.
     */
    public final Instant deleteTime() {
        return deleteTime;
    }

    /**
     * <p>
     * Time the Proxy was updated.
     * </p>
     * 
     * @return Time the Proxy was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * Failure code for cases when the Proxy fails to attach or update.
     * </p>
     * 
     * @return Failure code for cases when the Proxy fails to attach or update.
     */
    public final String failureCode() {
        return failureCode;
    }

    /**
     * <p>
     * Failure message for cases when the Proxy fails to attach or update.
     * </p>
     * 
     * @return Failure message for cases when the Proxy fails to attach or update.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    /**
     * <p>
     * Current attachment/detachment status of the Proxy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #proxyState} will
     * return {@link ProxyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #proxyStateAsString}.
     * </p>
     * 
     * @return Current attachment/detachment status of the Proxy.
     * @see ProxyState
     */
    public final ProxyState proxyState() {
        return ProxyState.fromValue(proxyState);
    }

    /**
     * <p>
     * Current attachment/detachment status of the Proxy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #proxyState} will
     * return {@link ProxyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #proxyStateAsString}.
     * </p>
     * 
     * @return Current attachment/detachment status of the Proxy.
     * @see ProxyState
     */
    public final String proxyStateAsString() {
        return proxyState;
    }

    /**
     * <p>
     * Current modification status of the Proxy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #proxyModifyState}
     * will return {@link ProxyModifyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #proxyModifyStateAsString}.
     * </p>
     * 
     * @return Current modification status of the Proxy.
     * @see ProxyModifyState
     */
    public final ProxyModifyState proxyModifyState() {
        return ProxyModifyState.fromValue(proxyModifyState);
    }

    /**
     * <p>
     * Current modification status of the Proxy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #proxyModifyState}
     * will return {@link ProxyModifyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #proxyModifyStateAsString}.
     * </p>
     * 
     * @return Current modification status of the Proxy.
     * @see ProxyModifyState
     */
    public final String proxyModifyStateAsString() {
        return proxyModifyState;
    }

    /**
     * <p>
     * The NAT Gateway for the proxy.
     * </p>
     * 
     * @return The NAT Gateway for the proxy.
     */
    public final String natGatewayId() {
        return natGatewayId;
    }

    /**
     * <p>
     * The descriptive name of the proxy configuration. You can't change the name of a proxy configuration after you
     * create it.
     * </p>
     * 
     * @return The descriptive name of the proxy configuration. You can't change the name of a proxy configuration after
     *         you create it.
     */
    public final String proxyConfigurationName() {
        return proxyConfigurationName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a proxy configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a proxy configuration.
     */
    public final String proxyConfigurationArn() {
        return proxyConfigurationArn;
    }

    /**
     * <p>
     * The descriptive name of the proxy. You can't change the name of a proxy after you create it.
     * </p>
     * 
     * @return The descriptive name of the proxy. You can't change the name of a proxy after you create it.
     */
    public final String proxyName() {
        return proxyName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a proxy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a proxy.
     */
    public final String proxyArn() {
        return proxyArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ListenerProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasListenerProperties() {
        return listenerProperties != null && !(listenerProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Listener properties for HTTP and HTTPS traffic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListenerProperties} method.
     * </p>
     * 
     * @return Listener properties for HTTP and HTTPS traffic.
     */
    public final List<ListenerProperty> listenerProperties() {
        return listenerProperties;
    }

    /**
     * <p>
     * TLS decryption on traffic to filter on attributes in the HTTP header.
     * </p>
     * 
     * @return TLS decryption on traffic to filter on attributes in the HTTP header.
     */
    public final TlsInterceptProperties tlsInterceptProperties() {
        return tlsInterceptProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key:value pairs to associate with the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The key:value pairs to associate with the resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(deleteTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(proxyStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(proxyModifyStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(proxyConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(proxyConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(proxyName());
        hashCode = 31 * hashCode + Objects.hashCode(proxyArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasListenerProperties() ? listenerProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tlsInterceptProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Proxy)) {
            return false;
        }
        Proxy other = (Proxy) obj;
        return Objects.equals(createTime(), other.createTime()) && Objects.equals(deleteTime(), other.deleteTime())
                && Objects.equals(updateTime(), other.updateTime()) && Objects.equals(failureCode(), other.failureCode())
                && Objects.equals(failureMessage(), other.failureMessage())
                && Objects.equals(proxyStateAsString(), other.proxyStateAsString())
                && Objects.equals(proxyModifyStateAsString(), other.proxyModifyStateAsString())
                && Objects.equals(natGatewayId(), other.natGatewayId())
                && Objects.equals(proxyConfigurationName(), other.proxyConfigurationName())
                && Objects.equals(proxyConfigurationArn(), other.proxyConfigurationArn())
                && Objects.equals(proxyName(), other.proxyName()) && Objects.equals(proxyArn(), other.proxyArn())
                && hasListenerProperties() == other.hasListenerProperties()
                && Objects.equals(listenerProperties(), other.listenerProperties())
                && Objects.equals(tlsInterceptProperties(), other.tlsInterceptProperties()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Proxy").add("CreateTime", createTime()).add("DeleteTime", deleteTime())
                .add("UpdateTime", updateTime()).add("FailureCode", failureCode()).add("FailureMessage", failureMessage())
                .add("ProxyState", proxyStateAsString()).add("ProxyModifyState", proxyModifyStateAsString())
                .add("NatGatewayId", natGatewayId()).add("ProxyConfigurationName", proxyConfigurationName())
                .add("ProxyConfigurationArn", proxyConfigurationArn()).add("ProxyName", proxyName()).add("ProxyArn", proxyArn())
                .add("ListenerProperties", hasListenerProperties() ? listenerProperties() : null)
                .add("TlsInterceptProperties", tlsInterceptProperties()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "DeleteTime":
            return Optional.ofNullable(clazz.cast(deleteTime()));
        case "UpdateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "FailureCode":
            return Optional.ofNullable(clazz.cast(failureCode()));
        case "FailureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        case "ProxyState":
            return Optional.ofNullable(clazz.cast(proxyStateAsString()));
        case "ProxyModifyState":
            return Optional.ofNullable(clazz.cast(proxyModifyStateAsString()));
        case "NatGatewayId":
            return Optional.ofNullable(clazz.cast(natGatewayId()));
        case "ProxyConfigurationName":
            return Optional.ofNullable(clazz.cast(proxyConfigurationName()));
        case "ProxyConfigurationArn":
            return Optional.ofNullable(clazz.cast(proxyConfigurationArn()));
        case "ProxyName":
            return Optional.ofNullable(clazz.cast(proxyName()));
        case "ProxyArn":
            return Optional.ofNullable(clazz.cast(proxyArn()));
        case "ListenerProperties":
            return Optional.ofNullable(clazz.cast(listenerProperties()));
        case "TlsInterceptProperties":
            return Optional.ofNullable(clazz.cast(tlsInterceptProperties()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("DeleteTime", DELETE_TIME_FIELD);
        map.put("UpdateTime", UPDATE_TIME_FIELD);
        map.put("FailureCode", FAILURE_CODE_FIELD);
        map.put("FailureMessage", FAILURE_MESSAGE_FIELD);
        map.put("ProxyState", PROXY_STATE_FIELD);
        map.put("ProxyModifyState", PROXY_MODIFY_STATE_FIELD);
        map.put("NatGatewayId", NAT_GATEWAY_ID_FIELD);
        map.put("ProxyConfigurationName", PROXY_CONFIGURATION_NAME_FIELD);
        map.put("ProxyConfigurationArn", PROXY_CONFIGURATION_ARN_FIELD);
        map.put("ProxyName", PROXY_NAME_FIELD);
        map.put("ProxyArn", PROXY_ARN_FIELD);
        map.put("ListenerProperties", LISTENER_PROPERTIES_FIELD);
        map.put("TlsInterceptProperties", TLS_INTERCEPT_PROPERTIES_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Proxy, T> g) {
        return obj -> g.apply((Proxy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Proxy> {
        /**
         * <p>
         * Time the Proxy was created.
         * </p>
         * 
         * @param createTime
         *        Time the Proxy was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * Time the Proxy was deleted.
         * </p>
         * 
         * @param deleteTime
         *        Time the Proxy was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteTime(Instant deleteTime);

        /**
         * <p>
         * Time the Proxy was updated.
         * </p>
         * 
         * @param updateTime
         *        Time the Proxy was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * Failure code for cases when the Proxy fails to attach or update.
         * </p>
         * 
         * @param failureCode
         *        Failure code for cases when the Proxy fails to attach or update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * Failure message for cases when the Proxy fails to attach or update.
         * </p>
         * 
         * @param failureMessage
         *        Failure message for cases when the Proxy fails to attach or update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);

        /**
         * <p>
         * Current attachment/detachment status of the Proxy.
         * </p>
         * 
         * @param proxyState
         *        Current attachment/detachment status of the Proxy.
         * @see ProxyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProxyState
         */
        Builder proxyState(String proxyState);

        /**
         * <p>
         * Current attachment/detachment status of the Proxy.
         * </p>
         * 
         * @param proxyState
         *        Current attachment/detachment status of the Proxy.
         * @see ProxyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProxyState
         */
        Builder proxyState(ProxyState proxyState);

        /**
         * <p>
         * Current modification status of the Proxy.
         * </p>
         * 
         * @param proxyModifyState
         *        Current modification status of the Proxy.
         * @see ProxyModifyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProxyModifyState
         */
        Builder proxyModifyState(String proxyModifyState);

        /**
         * <p>
         * Current modification status of the Proxy.
         * </p>
         * 
         * @param proxyModifyState
         *        Current modification status of the Proxy.
         * @see ProxyModifyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProxyModifyState
         */
        Builder proxyModifyState(ProxyModifyState proxyModifyState);

        /**
         * <p>
         * The NAT Gateway for the proxy.
         * </p>
         * 
         * @param natGatewayId
         *        The NAT Gateway for the proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGatewayId(String natGatewayId);

        /**
         * <p>
         * The descriptive name of the proxy configuration. You can't change the name of a proxy configuration after you
         * create it.
         * </p>
         * 
         * @param proxyConfigurationName
         *        The descriptive name of the proxy configuration. You can't change the name of a proxy configuration
         *        after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyConfigurationName(String proxyConfigurationName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a proxy configuration.
         * </p>
         * 
         * @param proxyConfigurationArn
         *        The Amazon Resource Name (ARN) of a proxy configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyConfigurationArn(String proxyConfigurationArn);

        /**
         * <p>
         * The descriptive name of the proxy. You can't change the name of a proxy after you create it.
         * </p>
         * 
         * @param proxyName
         *        The descriptive name of the proxy. You can't change the name of a proxy after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyName(String proxyName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a proxy.
         * </p>
         * 
         * @param proxyArn
         *        The Amazon Resource Name (ARN) of a proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyArn(String proxyArn);

        /**
         * <p>
         * Listener properties for HTTP and HTTPS traffic.
         * </p>
         * 
         * @param listenerProperties
         *        Listener properties for HTTP and HTTPS traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerProperties(Collection<ListenerProperty> listenerProperties);

        /**
         * <p>
         * Listener properties for HTTP and HTTPS traffic.
         * </p>
         * 
         * @param listenerProperties
         *        Listener properties for HTTP and HTTPS traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerProperties(ListenerProperty... listenerProperties);

        /**
         * <p>
         * Listener properties for HTTP and HTTPS traffic.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.ListenerProperty.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.networkfirewall.model.ListenerProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.ListenerProperty.Builder#build()} is called
         * immediately and its result is passed to {@link #listenerProperties(List<ListenerProperty>)}.
         * 
         * @param listenerProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.ListenerProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listenerProperties(java.util.Collection<ListenerProperty>)
         */
        Builder listenerProperties(Consumer<ListenerProperty.Builder>... listenerProperties);

        /**
         * <p>
         * TLS decryption on traffic to filter on attributes in the HTTP header.
         * </p>
         * 
         * @param tlsInterceptProperties
         *        TLS decryption on traffic to filter on attributes in the HTTP header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsInterceptProperties(TlsInterceptProperties tlsInterceptProperties);

        /**
         * <p>
         * TLS decryption on traffic to filter on attributes in the HTTP header.
         * </p>
         * This is a convenience method that creates an instance of the {@link TlsInterceptProperties.Builder} avoiding
         * the need to create one manually via {@link TlsInterceptProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TlsInterceptProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #tlsInterceptProperties(TlsInterceptProperties)}.
         * 
         * @param tlsInterceptProperties
         *        a consumer that will call methods on {@link TlsInterceptProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tlsInterceptProperties(TlsInterceptProperties)
         */
        default Builder tlsInterceptProperties(Consumer<TlsInterceptProperties.Builder> tlsInterceptProperties) {
            return tlsInterceptProperties(TlsInterceptProperties.builder().applyMutation(tlsInterceptProperties).build());
        }

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        The key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        The key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.networkfirewall.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private Instant createTime;

        private Instant deleteTime;

        private Instant updateTime;

        private String failureCode;

        private String failureMessage;

        private String proxyState;

        private String proxyModifyState;

        private String natGatewayId;

        private String proxyConfigurationName;

        private String proxyConfigurationArn;

        private String proxyName;

        private String proxyArn;

        private List<ListenerProperty> listenerProperties = DefaultSdkAutoConstructList.getInstance();

        private TlsInterceptProperties tlsInterceptProperties;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Proxy model) {
            createTime(model.createTime);
            deleteTime(model.deleteTime);
            updateTime(model.updateTime);
            failureCode(model.failureCode);
            failureMessage(model.failureMessage);
            proxyState(model.proxyState);
            proxyModifyState(model.proxyModifyState);
            natGatewayId(model.natGatewayId);
            proxyConfigurationName(model.proxyConfigurationName);
            proxyConfigurationArn(model.proxyConfigurationArn);
            proxyName(model.proxyName);
            proxyArn(model.proxyArn);
            listenerProperties(model.listenerProperties);
            tlsInterceptProperties(model.tlsInterceptProperties);
            tags(model.tags);
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getDeleteTime() {
            return deleteTime;
        }

        public final void setDeleteTime(Instant deleteTime) {
            this.deleteTime = deleteTime;
        }

        @Override
        public final Builder deleteTime(Instant deleteTime) {
            this.deleteTime = deleteTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final String getProxyState() {
            return proxyState;
        }

        public final void setProxyState(String proxyState) {
            this.proxyState = proxyState;
        }

        @Override
        public final Builder proxyState(String proxyState) {
            this.proxyState = proxyState;
            return this;
        }

        @Override
        public final Builder proxyState(ProxyState proxyState) {
            this.proxyState(proxyState == null ? null : proxyState.toString());
            return this;
        }

        public final String getProxyModifyState() {
            return proxyModifyState;
        }

        public final void setProxyModifyState(String proxyModifyState) {
            this.proxyModifyState = proxyModifyState;
        }

        @Override
        public final Builder proxyModifyState(String proxyModifyState) {
            this.proxyModifyState = proxyModifyState;
            return this;
        }

        @Override
        public final Builder proxyModifyState(ProxyModifyState proxyModifyState) {
            this.proxyModifyState(proxyModifyState == null ? null : proxyModifyState.toString());
            return this;
        }

        public final String getNatGatewayId() {
            return natGatewayId;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final String getProxyConfigurationName() {
            return proxyConfigurationName;
        }

        public final void setProxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
        }

        @Override
        public final Builder proxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
            return this;
        }

        public final String getProxyConfigurationArn() {
            return proxyConfigurationArn;
        }

        public final void setProxyConfigurationArn(String proxyConfigurationArn) {
            this.proxyConfigurationArn = proxyConfigurationArn;
        }

        @Override
        public final Builder proxyConfigurationArn(String proxyConfigurationArn) {
            this.proxyConfigurationArn = proxyConfigurationArn;
            return this;
        }

        public final String getProxyName() {
            return proxyName;
        }

        public final void setProxyName(String proxyName) {
            this.proxyName = proxyName;
        }

        @Override
        public final Builder proxyName(String proxyName) {
            this.proxyName = proxyName;
            return this;
        }

        public final String getProxyArn() {
            return proxyArn;
        }

        public final void setProxyArn(String proxyArn) {
            this.proxyArn = proxyArn;
        }

        @Override
        public final Builder proxyArn(String proxyArn) {
            this.proxyArn = proxyArn;
            return this;
        }

        public final List<ListenerProperty.Builder> getListenerProperties() {
            List<ListenerProperty.Builder> result = ListenerPropertiesCopier.copyToBuilder(this.listenerProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListenerProperties(Collection<ListenerProperty.BuilderImpl> listenerProperties) {
            this.listenerProperties = ListenerPropertiesCopier.copyFromBuilder(listenerProperties);
        }

        @Override
        public final Builder listenerProperties(Collection<ListenerProperty> listenerProperties) {
            this.listenerProperties = ListenerPropertiesCopier.copy(listenerProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerProperties(ListenerProperty... listenerProperties) {
            listenerProperties(Arrays.asList(listenerProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerProperties(Consumer<ListenerProperty.Builder>... listenerProperties) {
            listenerProperties(Stream.of(listenerProperties).map(c -> ListenerProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final TlsInterceptProperties.Builder getTlsInterceptProperties() {
            return tlsInterceptProperties != null ? tlsInterceptProperties.toBuilder() : null;
        }

        public final void setTlsInterceptProperties(TlsInterceptProperties.BuilderImpl tlsInterceptProperties) {
            this.tlsInterceptProperties = tlsInterceptProperties != null ? tlsInterceptProperties.build() : null;
        }

        @Override
        public final Builder tlsInterceptProperties(TlsInterceptProperties tlsInterceptProperties) {
            this.tlsInterceptProperties = tlsInterceptProperties;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Proxy build() {
            return new Proxy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
