/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines how Network Firewall performs logging for a <a>Firewall</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoggingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LoggingConfiguration.Builder, LoggingConfiguration> {
    private static final SdkField<List<LogDestinationConfig>> LOG_DESTINATION_CONFIGS_FIELD = SdkField
            .<List<LogDestinationConfig>> builder(MarshallingType.LIST)
            .memberName("LogDestinationConfigs")
            .getter(getter(LoggingConfiguration::logDestinationConfigs))
            .setter(setter(Builder::logDestinationConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDestinationConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LogDestinationConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogDestinationConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(LOG_DESTINATION_CONFIGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<LogDestinationConfig> logDestinationConfigs;

    private LoggingConfiguration(BuilderImpl builder) {
        this.logDestinationConfigs = builder.logDestinationConfigs;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogDestinationConfigs property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLogDestinationConfigs() {
        return logDestinationConfigs != null && !(logDestinationConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines the logging destinations for the logs for a firewall. Network Firewall generates logs for stateful rule
     * groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogDestinationConfigs} method.
     * </p>
     * 
     * @return Defines the logging destinations for the logs for a firewall. Network Firewall generates logs for
     *         stateful rule groups.
     */
    public final List<LogDestinationConfig> logDestinationConfigs() {
        return logDestinationConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLogDestinationConfigs() ? logDestinationConfigs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfiguration)) {
            return false;
        }
        LoggingConfiguration other = (LoggingConfiguration) obj;
        return hasLogDestinationConfigs() == other.hasLogDestinationConfigs()
                && Objects.equals(logDestinationConfigs(), other.logDestinationConfigs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoggingConfiguration")
                .add("LogDestinationConfigs", hasLogDestinationConfigs() ? logDestinationConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogDestinationConfigs":
            return Optional.ofNullable(clazz.cast(logDestinationConfigs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LogDestinationConfigs", LOG_DESTINATION_CONFIGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoggingConfiguration, T> g) {
        return obj -> g.apply((LoggingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoggingConfiguration> {
        /**
         * <p>
         * Defines the logging destinations for the logs for a firewall. Network Firewall generates logs for stateful
         * rule groups.
         * </p>
         * 
         * @param logDestinationConfigs
         *        Defines the logging destinations for the logs for a firewall. Network Firewall generates logs for
         *        stateful rule groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDestinationConfigs(Collection<LogDestinationConfig> logDestinationConfigs);

        /**
         * <p>
         * Defines the logging destinations for the logs for a firewall. Network Firewall generates logs for stateful
         * rule groups.
         * </p>
         * 
         * @param logDestinationConfigs
         *        Defines the logging destinations for the logs for a firewall. Network Firewall generates logs for
         *        stateful rule groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDestinationConfigs(LogDestinationConfig... logDestinationConfigs);

        /**
         * <p>
         * Defines the logging destinations for the logs for a firewall. Network Firewall generates logs for stateful
         * rule groups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.LogDestinationConfig.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.networkfirewall.model.LogDestinationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.LogDestinationConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #logDestinationConfigs(List<LogDestinationConfig>)}.
         * 
         * @param logDestinationConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.LogDestinationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logDestinationConfigs(java.util.Collection<LogDestinationConfig>)
         */
        Builder logDestinationConfigs(Consumer<LogDestinationConfig.Builder>... logDestinationConfigs);
    }

    static final class BuilderImpl implements Builder {
        private List<LogDestinationConfig> logDestinationConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingConfiguration model) {
            logDestinationConfigs(model.logDestinationConfigs);
        }

        public final List<LogDestinationConfig.Builder> getLogDestinationConfigs() {
            List<LogDestinationConfig.Builder> result = LogDestinationConfigsCopier.copyToBuilder(this.logDestinationConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogDestinationConfigs(Collection<LogDestinationConfig.BuilderImpl> logDestinationConfigs) {
            this.logDestinationConfigs = LogDestinationConfigsCopier.copyFromBuilder(logDestinationConfigs);
        }

        @Override
        public final Builder logDestinationConfigs(Collection<LogDestinationConfig> logDestinationConfigs) {
            this.logDestinationConfigs = LogDestinationConfigsCopier.copy(logDestinationConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDestinationConfigs(LogDestinationConfig... logDestinationConfigs) {
            logDestinationConfigs(Arrays.asList(logDestinationConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDestinationConfigs(Consumer<LogDestinationConfig.Builder>... logDestinationConfigs) {
            logDestinationConfigs(Stream.of(logDestinationConfigs)
                    .map(c -> LogDestinationConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public LoggingConfiguration build() {
            return new LoggingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
