/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Any number of arrays, where each array is a single flow identified in the scope of the operation. If multiple flows
 * were in the scope of the operation, multiple <code>Flows</code> arrays are returned.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Flow implements SdkPojo, Serializable, ToCopyableBuilder<Flow.Builder, Flow> {
    private static final SdkField<Address> SOURCE_ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("SourceAddress").getter(getter(Flow::sourceAddress)).setter(setter(Builder::sourceAddress))
            .constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAddress").build()).build();

    private static final SdkField<Address> DESTINATION_ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("DestinationAddress").getter(getter(Flow::destinationAddress))
            .setter(setter(Builder::destinationAddress)).constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationAddress").build())
            .build();

    private static final SdkField<String> SOURCE_PORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourcePort").getter(getter(Flow::sourcePort)).setter(setter(Builder::sourcePort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePort").build()).build();

    private static final SdkField<String> DESTINATION_PORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationPort").getter(getter(Flow::destinationPort)).setter(setter(Builder::destinationPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPort").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(Flow::protocol)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<Integer> AGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Age")
            .getter(getter(Flow::age)).setter(setter(Builder::age))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Age").build()).build();

    private static final SdkField<Integer> PACKET_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PacketCount").getter(getter(Flow::packetCount)).setter(setter(Builder::packetCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PacketCount").build()).build();

    private static final SdkField<Long> BYTE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("ByteCount")
            .getter(getter(Flow::byteCount)).setter(setter(Builder::byteCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ByteCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ADDRESS_FIELD,
            DESTINATION_ADDRESS_FIELD, SOURCE_PORT_FIELD, DESTINATION_PORT_FIELD, PROTOCOL_FIELD, AGE_FIELD, PACKET_COUNT_FIELD,
            BYTE_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Address sourceAddress;

    private final Address destinationAddress;

    private final String sourcePort;

    private final String destinationPort;

    private final String protocol;

    private final Integer age;

    private final Integer packetCount;

    private final Long byteCount;

    private Flow(BuilderImpl builder) {
        this.sourceAddress = builder.sourceAddress;
        this.destinationAddress = builder.destinationAddress;
        this.sourcePort = builder.sourcePort;
        this.destinationPort = builder.destinationPort;
        this.protocol = builder.protocol;
        this.age = builder.age;
        this.packetCount = builder.packetCount;
        this.byteCount = builder.byteCount;
    }

    /**
     * Returns the value of the SourceAddress property for this object.
     * 
     * @return The value of the SourceAddress property for this object.
     */
    public final Address sourceAddress() {
        return sourceAddress;
    }

    /**
     * Returns the value of the DestinationAddress property for this object.
     * 
     * @return The value of the DestinationAddress property for this object.
     */
    public final Address destinationAddress() {
        return destinationAddress;
    }

    /**
     * <p>
     * The source port to inspect for. You can specify an individual port, for example <code>1994</code> and you can
     * specify a port range, for example <code>1990:1994</code>. To match with any port, specify <code>ANY</code>.
     * </p>
     * 
     * @return The source port to inspect for. You can specify an individual port, for example <code>1994</code> and you
     *         can specify a port range, for example <code>1990:1994</code>. To match with any port, specify
     *         <code>ANY</code>.
     */
    public final String sourcePort() {
        return sourcePort;
    }

    /**
     * <p>
     * The destination port to inspect for. You can specify an individual port, for example <code>1994</code> and you
     * can specify a port range, for example <code>1990:1994</code>. To match with any port, specify <code>ANY</code>.
     * </p>
     * 
     * @return The destination port to inspect for. You can specify an individual port, for example <code>1994</code>
     *         and you can specify a port range, for example <code>1990:1994</code>. To match with any port, specify
     *         <code>ANY</code>.
     */
    public final String destinationPort() {
        return destinationPort;
    }

    /**
     * <p>
     * The protocols to inspect for, specified using the assigned internet protocol number (IANA) for each protocol. If
     * not specified, this matches with any protocol.
     * </p>
     * 
     * @return The protocols to inspect for, specified using the assigned internet protocol number (IANA) for each
     *         protocol. If not specified, this matches with any protocol.
     */
    public final String protocol() {
        return protocol;
    }

    /**
     * <p>
     * Returned as info about age of the flows identified by the flow operation.
     * </p>
     * 
     * @return Returned as info about age of the flows identified by the flow operation.
     */
    public final Integer age() {
        return age;
    }

    /**
     * <p>
     * Returns the total number of data packets received or transmitted in a flow.
     * </p>
     * 
     * @return Returns the total number of data packets received or transmitted in a flow.
     */
    public final Integer packetCount() {
        return packetCount;
    }

    /**
     * <p>
     * Returns the number of bytes received or transmitted in a specific flow.
     * </p>
     * 
     * @return Returns the number of bytes received or transmitted in a specific flow.
     */
    public final Long byteCount() {
        return byteCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceAddress());
        hashCode = 31 * hashCode + Objects.hashCode(destinationAddress());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePort());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPort());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(age());
        hashCode = 31 * hashCode + Objects.hashCode(packetCount());
        hashCode = 31 * hashCode + Objects.hashCode(byteCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Flow)) {
            return false;
        }
        Flow other = (Flow) obj;
        return Objects.equals(sourceAddress(), other.sourceAddress())
                && Objects.equals(destinationAddress(), other.destinationAddress())
                && Objects.equals(sourcePort(), other.sourcePort()) && Objects.equals(destinationPort(), other.destinationPort())
                && Objects.equals(protocol(), other.protocol()) && Objects.equals(age(), other.age())
                && Objects.equals(packetCount(), other.packetCount()) && Objects.equals(byteCount(), other.byteCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Flow").add("SourceAddress", sourceAddress()).add("DestinationAddress", destinationAddress())
                .add("SourcePort", sourcePort()).add("DestinationPort", destinationPort()).add("Protocol", protocol())
                .add("Age", age()).add("PacketCount", packetCount()).add("ByteCount", byteCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceAddress":
            return Optional.ofNullable(clazz.cast(sourceAddress()));
        case "DestinationAddress":
            return Optional.ofNullable(clazz.cast(destinationAddress()));
        case "SourcePort":
            return Optional.ofNullable(clazz.cast(sourcePort()));
        case "DestinationPort":
            return Optional.ofNullable(clazz.cast(destinationPort()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "Age":
            return Optional.ofNullable(clazz.cast(age()));
        case "PacketCount":
            return Optional.ofNullable(clazz.cast(packetCount()));
        case "ByteCount":
            return Optional.ofNullable(clazz.cast(byteCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceAddress", SOURCE_ADDRESS_FIELD);
        map.put("DestinationAddress", DESTINATION_ADDRESS_FIELD);
        map.put("SourcePort", SOURCE_PORT_FIELD);
        map.put("DestinationPort", DESTINATION_PORT_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("Age", AGE_FIELD);
        map.put("PacketCount", PACKET_COUNT_FIELD);
        map.put("ByteCount", BYTE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Flow, T> g) {
        return obj -> g.apply((Flow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Flow> {
        /**
         * Sets the value of the SourceAddress property for this object.
         *
         * @param sourceAddress
         *        The new value for the SourceAddress property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAddress(Address sourceAddress);

        /**
         * Sets the value of the SourceAddress property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the need to
         * create one manually via {@link Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #sourceAddress(Address)}.
         * 
         * @param sourceAddress
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceAddress(Address)
         */
        default Builder sourceAddress(Consumer<Address.Builder> sourceAddress) {
            return sourceAddress(Address.builder().applyMutation(sourceAddress).build());
        }

        /**
         * Sets the value of the DestinationAddress property for this object.
         *
         * @param destinationAddress
         *        The new value for the DestinationAddress property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationAddress(Address destinationAddress);

        /**
         * Sets the value of the DestinationAddress property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the need to
         * create one manually via {@link Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #destinationAddress(Address)}.
         * 
         * @param destinationAddress
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationAddress(Address)
         */
        default Builder destinationAddress(Consumer<Address.Builder> destinationAddress) {
            return destinationAddress(Address.builder().applyMutation(destinationAddress).build());
        }

        /**
         * <p>
         * The source port to inspect for. You can specify an individual port, for example <code>1994</code> and you can
         * specify a port range, for example <code>1990:1994</code>. To match with any port, specify <code>ANY</code>.
         * </p>
         * 
         * @param sourcePort
         *        The source port to inspect for. You can specify an individual port, for example <code>1994</code> and
         *        you can specify a port range, for example <code>1990:1994</code>. To match with any port, specify
         *        <code>ANY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePort(String sourcePort);

        /**
         * <p>
         * The destination port to inspect for. You can specify an individual port, for example <code>1994</code> and
         * you can specify a port range, for example <code>1990:1994</code>. To match with any port, specify
         * <code>ANY</code>.
         * </p>
         * 
         * @param destinationPort
         *        The destination port to inspect for. You can specify an individual port, for example <code>1994</code>
         *        and you can specify a port range, for example <code>1990:1994</code>. To match with any port, specify
         *        <code>ANY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPort(String destinationPort);

        /**
         * <p>
         * The protocols to inspect for, specified using the assigned internet protocol number (IANA) for each protocol.
         * If not specified, this matches with any protocol.
         * </p>
         * 
         * @param protocol
         *        The protocols to inspect for, specified using the assigned internet protocol number (IANA) for each
         *        protocol. If not specified, this matches with any protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * Returned as info about age of the flows identified by the flow operation.
         * </p>
         * 
         * @param age
         *        Returned as info about age of the flows identified by the flow operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder age(Integer age);

        /**
         * <p>
         * Returns the total number of data packets received or transmitted in a flow.
         * </p>
         * 
         * @param packetCount
         *        Returns the total number of data packets received or transmitted in a flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packetCount(Integer packetCount);

        /**
         * <p>
         * Returns the number of bytes received or transmitted in a specific flow.
         * </p>
         * 
         * @param byteCount
         *        Returns the number of bytes received or transmitted in a specific flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byteCount(Long byteCount);
    }

    static final class BuilderImpl implements Builder {
        private Address sourceAddress;

        private Address destinationAddress;

        private String sourcePort;

        private String destinationPort;

        private String protocol;

        private Integer age;

        private Integer packetCount;

        private Long byteCount;

        private BuilderImpl() {
        }

        private BuilderImpl(Flow model) {
            sourceAddress(model.sourceAddress);
            destinationAddress(model.destinationAddress);
            sourcePort(model.sourcePort);
            destinationPort(model.destinationPort);
            protocol(model.protocol);
            age(model.age);
            packetCount(model.packetCount);
            byteCount(model.byteCount);
        }

        public final Address.Builder getSourceAddress() {
            return sourceAddress != null ? sourceAddress.toBuilder() : null;
        }

        public final void setSourceAddress(Address.BuilderImpl sourceAddress) {
            this.sourceAddress = sourceAddress != null ? sourceAddress.build() : null;
        }

        @Override
        public final Builder sourceAddress(Address sourceAddress) {
            this.sourceAddress = sourceAddress;
            return this;
        }

        public final Address.Builder getDestinationAddress() {
            return destinationAddress != null ? destinationAddress.toBuilder() : null;
        }

        public final void setDestinationAddress(Address.BuilderImpl destinationAddress) {
            this.destinationAddress = destinationAddress != null ? destinationAddress.build() : null;
        }

        @Override
        public final Builder destinationAddress(Address destinationAddress) {
            this.destinationAddress = destinationAddress;
            return this;
        }

        public final String getSourcePort() {
            return sourcePort;
        }

        public final void setSourcePort(String sourcePort) {
            this.sourcePort = sourcePort;
        }

        @Override
        public final Builder sourcePort(String sourcePort) {
            this.sourcePort = sourcePort;
            return this;
        }

        public final String getDestinationPort() {
            return destinationPort;
        }

        public final void setDestinationPort(String destinationPort) {
            this.destinationPort = destinationPort;
        }

        @Override
        public final Builder destinationPort(String destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final Integer getAge() {
            return age;
        }

        public final void setAge(Integer age) {
            this.age = age;
        }

        @Override
        public final Builder age(Integer age) {
            this.age = age;
            return this;
        }

        public final Integer getPacketCount() {
            return packetCount;
        }

        public final void setPacketCount(Integer packetCount) {
            this.packetCount = packetCount;
        }

        @Override
        public final Builder packetCount(Integer packetCount) {
            this.packetCount = packetCount;
            return this;
        }

        public final Long getByteCount() {
            return byteCount;
        }

        public final void setByteCount(Long byteCount) {
            this.byteCount = byteCount;
        }

        @Override
        public final Builder byteCount(Long byteCount) {
            this.byteCount = byteCount;
            return this;
        }

        @Override
        public Flow build() {
            return new Flow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
