/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetachRuleGroupsFromProxyConfigurationRequest extends NetworkFirewallRequest implements
        ToCopyableBuilder<DetachRuleGroupsFromProxyConfigurationRequest.Builder, DetachRuleGroupsFromProxyConfigurationRequest> {
    private static final SdkField<String> PROXY_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyConfigurationName")
            .getter(getter(DetachRuleGroupsFromProxyConfigurationRequest::proxyConfigurationName))
            .setter(setter(Builder::proxyConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationName").build())
            .build();

    private static final SdkField<String> PROXY_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyConfigurationArn")
            .getter(getter(DetachRuleGroupsFromProxyConfigurationRequest::proxyConfigurationArn))
            .setter(setter(Builder::proxyConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationArn").build())
            .build();

    private static final SdkField<List<String>> RULE_GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RuleGroupNames")
            .getter(getter(DetachRuleGroupsFromProxyConfigurationRequest::ruleGroupNames))
            .setter(setter(Builder::ruleGroupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RULE_GROUP_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RuleGroupArns")
            .getter(getter(DetachRuleGroupsFromProxyConfigurationRequest::ruleGroupArns))
            .setter(setter(Builder::ruleGroupArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateToken").getter(getter(DetachRuleGroupsFromProxyConfigurationRequest::updateToken))
            .setter(setter(Builder::updateToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROXY_CONFIGURATION_NAME_FIELD, PROXY_CONFIGURATION_ARN_FIELD, RULE_GROUP_NAMES_FIELD, RULE_GROUP_ARNS_FIELD,
            UPDATE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String proxyConfigurationName;

    private final String proxyConfigurationArn;

    private final List<String> ruleGroupNames;

    private final List<String> ruleGroupArns;

    private final String updateToken;

    private DetachRuleGroupsFromProxyConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.proxyConfigurationName = builder.proxyConfigurationName;
        this.proxyConfigurationArn = builder.proxyConfigurationArn;
        this.ruleGroupNames = builder.ruleGroupNames;
        this.ruleGroupArns = builder.ruleGroupArns;
        this.updateToken = builder.updateToken;
    }

    /**
     * <p>
     * The descriptive name of the proxy configuration. You can't change the name of a proxy configuration after you
     * create it.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The descriptive name of the proxy configuration. You can't change the name of a proxy configuration after
     *         you create it.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String proxyConfigurationName() {
        return proxyConfigurationName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a proxy configuration.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a proxy configuration.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String proxyConfigurationArn() {
        return proxyConfigurationArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleGroupNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRuleGroupNames() {
        return ruleGroupNames != null && !(ruleGroupNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The proxy rule group names to detach from the proxy configuration
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleGroupNames} method.
     * </p>
     * 
     * @return The proxy rule group names to detach from the proxy configuration
     */
    public final List<String> ruleGroupNames() {
        return ruleGroupNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleGroupArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRuleGroupArns() {
        return ruleGroupArns != null && !(ruleGroupArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The proxy rule group arns to detach from the proxy configuration
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleGroupArns} method.
     * </p>
     * 
     * @return The proxy rule group arns to detach from the proxy configuration
     */
    public final List<String> ruleGroupArns() {
        return ruleGroupArns;
    }

    /**
     * <p>
     * A token used for optimistic locking. Network Firewall returns a token to your requests that access the proxy
     * configuration. The token marks the state of the proxy configuration resource at the time of the request.
     * </p>
     * <p>
     * To make changes to the proxy configuration, you provide the token in your request. Network Firewall uses the
     * token to ensure that the proxy configuration hasn't changed since you last retrieved it. If it has changed, the
     * operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy configuration
     * again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation
     * again using the new token.
     * </p>
     * 
     * @return A token used for optimistic locking. Network Firewall returns a token to your requests that access the
     *         proxy configuration. The token marks the state of the proxy configuration resource at the time of the
     *         request. </p>
     *         <p>
     *         To make changes to the proxy configuration, you provide the token in your request. Network Firewall uses
     *         the token to ensure that the proxy configuration hasn't changed since you last retrieved it. If it has
     *         changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the
     *         proxy configuration again to get a current copy of it with a current token. Reapply your changes as
     *         needed, then try the operation again using the new token.
     */
    public final String updateToken() {
        return updateToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(proxyConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(proxyConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleGroupNames() ? ruleGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleGroupArns() ? ruleGroupArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updateToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachRuleGroupsFromProxyConfigurationRequest)) {
            return false;
        }
        DetachRuleGroupsFromProxyConfigurationRequest other = (DetachRuleGroupsFromProxyConfigurationRequest) obj;
        return Objects.equals(proxyConfigurationName(), other.proxyConfigurationName())
                && Objects.equals(proxyConfigurationArn(), other.proxyConfigurationArn())
                && hasRuleGroupNames() == other.hasRuleGroupNames() && Objects.equals(ruleGroupNames(), other.ruleGroupNames())
                && hasRuleGroupArns() == other.hasRuleGroupArns() && Objects.equals(ruleGroupArns(), other.ruleGroupArns())
                && Objects.equals(updateToken(), other.updateToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetachRuleGroupsFromProxyConfigurationRequest")
                .add("ProxyConfigurationName", proxyConfigurationName()).add("ProxyConfigurationArn", proxyConfigurationArn())
                .add("RuleGroupNames", hasRuleGroupNames() ? ruleGroupNames() : null)
                .add("RuleGroupArns", hasRuleGroupArns() ? ruleGroupArns() : null).add("UpdateToken", updateToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProxyConfigurationName":
            return Optional.ofNullable(clazz.cast(proxyConfigurationName()));
        case "ProxyConfigurationArn":
            return Optional.ofNullable(clazz.cast(proxyConfigurationArn()));
        case "RuleGroupNames":
            return Optional.ofNullable(clazz.cast(ruleGroupNames()));
        case "RuleGroupArns":
            return Optional.ofNullable(clazz.cast(ruleGroupArns()));
        case "UpdateToken":
            return Optional.ofNullable(clazz.cast(updateToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProxyConfigurationName", PROXY_CONFIGURATION_NAME_FIELD);
        map.put("ProxyConfigurationArn", PROXY_CONFIGURATION_ARN_FIELD);
        map.put("RuleGroupNames", RULE_GROUP_NAMES_FIELD);
        map.put("RuleGroupArns", RULE_GROUP_ARNS_FIELD);
        map.put("UpdateToken", UPDATE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetachRuleGroupsFromProxyConfigurationRequest, T> g) {
        return obj -> g.apply((DetachRuleGroupsFromProxyConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DetachRuleGroupsFromProxyConfigurationRequest> {
        /**
         * <p>
         * The descriptive name of the proxy configuration. You can't change the name of a proxy configuration after you
         * create it.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param proxyConfigurationName
         *        The descriptive name of the proxy configuration. You can't change the name of a proxy configuration
         *        after you create it.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyConfigurationName(String proxyConfigurationName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a proxy configuration.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param proxyConfigurationArn
         *        The Amazon Resource Name (ARN) of a proxy configuration.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyConfigurationArn(String proxyConfigurationArn);

        /**
         * <p>
         * The proxy rule group names to detach from the proxy configuration
         * </p>
         * 
         * @param ruleGroupNames
         *        The proxy rule group names to detach from the proxy configuration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupNames(Collection<String> ruleGroupNames);

        /**
         * <p>
         * The proxy rule group names to detach from the proxy configuration
         * </p>
         * 
         * @param ruleGroupNames
         *        The proxy rule group names to detach from the proxy configuration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupNames(String... ruleGroupNames);

        /**
         * <p>
         * The proxy rule group arns to detach from the proxy configuration
         * </p>
         * 
         * @param ruleGroupArns
         *        The proxy rule group arns to detach from the proxy configuration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupArns(Collection<String> ruleGroupArns);

        /**
         * <p>
         * The proxy rule group arns to detach from the proxy configuration
         * </p>
         * 
         * @param ruleGroupArns
         *        The proxy rule group arns to detach from the proxy configuration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupArns(String... ruleGroupArns);

        /**
         * <p>
         * A token used for optimistic locking. Network Firewall returns a token to your requests that access the proxy
         * configuration. The token marks the state of the proxy configuration resource at the time of the request.
         * </p>
         * <p>
         * To make changes to the proxy configuration, you provide the token in your request. Network Firewall uses the
         * token to ensure that the proxy configuration hasn't changed since you last retrieved it. If it has changed,
         * the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy
         * configuration again to get a current copy of it with a current token. Reapply your changes as needed, then
         * try the operation again using the new token.
         * </p>
         * 
         * @param updateToken
         *        A token used for optimistic locking. Network Firewall returns a token to your requests that access the
         *        proxy configuration. The token marks the state of the proxy configuration resource at the time of the
         *        request. </p>
         *        <p>
         *        To make changes to the proxy configuration, you provide the token in your request. Network Firewall
         *        uses the token to ensure that the proxy configuration hasn't changed since you last retrieved it. If
         *        it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens,
         *        retrieve the proxy configuration again to get a current copy of it with a current token. Reapply your
         *        changes as needed, then try the operation again using the new token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateToken(String updateToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFirewallRequest.BuilderImpl implements Builder {
        private String proxyConfigurationName;

        private String proxyConfigurationArn;

        private List<String> ruleGroupNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> ruleGroupArns = DefaultSdkAutoConstructList.getInstance();

        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachRuleGroupsFromProxyConfigurationRequest model) {
            super(model);
            proxyConfigurationName(model.proxyConfigurationName);
            proxyConfigurationArn(model.proxyConfigurationArn);
            ruleGroupNames(model.ruleGroupNames);
            ruleGroupArns(model.ruleGroupArns);
            updateToken(model.updateToken);
        }

        public final String getProxyConfigurationName() {
            return proxyConfigurationName;
        }

        public final void setProxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
        }

        @Override
        public final Builder proxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
            return this;
        }

        public final String getProxyConfigurationArn() {
            return proxyConfigurationArn;
        }

        public final void setProxyConfigurationArn(String proxyConfigurationArn) {
            this.proxyConfigurationArn = proxyConfigurationArn;
        }

        @Override
        public final Builder proxyConfigurationArn(String proxyConfigurationArn) {
            this.proxyConfigurationArn = proxyConfigurationArn;
            return this;
        }

        public final Collection<String> getRuleGroupNames() {
            if (ruleGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return ruleGroupNames;
        }

        public final void setRuleGroupNames(Collection<String> ruleGroupNames) {
            this.ruleGroupNames = ResourceNameListCopier.copy(ruleGroupNames);
        }

        @Override
        public final Builder ruleGroupNames(Collection<String> ruleGroupNames) {
            this.ruleGroupNames = ResourceNameListCopier.copy(ruleGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroupNames(String... ruleGroupNames) {
            ruleGroupNames(Arrays.asList(ruleGroupNames));
            return this;
        }

        public final Collection<String> getRuleGroupArns() {
            if (ruleGroupArns instanceof SdkAutoConstructList) {
                return null;
            }
            return ruleGroupArns;
        }

        public final void setRuleGroupArns(Collection<String> ruleGroupArns) {
            this.ruleGroupArns = ResourceArnListCopier.copy(ruleGroupArns);
        }

        @Override
        public final Builder ruleGroupArns(Collection<String> ruleGroupArns) {
            this.ruleGroupArns = ResourceArnListCopier.copy(ruleGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroupArns(String... ruleGroupArns) {
            ruleGroupArns(Arrays.asList(ruleGroupArns));
            return this;
        }

        public final String getUpdateToken() {
            return updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetachRuleGroupsFromProxyConfigurationRequest build() {
            return new DetachRuleGroupsFromProxyConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
