/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProxyRuleRequest extends NetworkFirewallRequest implements
        ToCopyableBuilder<DescribeProxyRuleRequest.Builder, DescribeProxyRuleRequest> {
    private static final SdkField<String> PROXY_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyRuleName").getter(getter(DescribeProxyRuleRequest::proxyRuleName))
            .setter(setter(Builder::proxyRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleName").build()).build();

    private static final SdkField<String> PROXY_RULE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyRuleGroupName").getter(getter(DescribeProxyRuleRequest::proxyRuleGroupName))
            .setter(setter(Builder::proxyRuleGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleGroupName").build())
            .build();

    private static final SdkField<String> PROXY_RULE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyRuleGroupArn").getter(getter(DescribeProxyRuleRequest::proxyRuleGroupArn))
            .setter(setter(Builder::proxyRuleGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleGroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_RULE_NAME_FIELD,
            PROXY_RULE_GROUP_NAME_FIELD, PROXY_RULE_GROUP_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String proxyRuleName;

    private final String proxyRuleGroupName;

    private final String proxyRuleGroupArn;

    private DescribeProxyRuleRequest(BuilderImpl builder) {
        super(builder);
        this.proxyRuleName = builder.proxyRuleName;
        this.proxyRuleGroupName = builder.proxyRuleGroupName;
        this.proxyRuleGroupArn = builder.proxyRuleGroupArn;
    }

    /**
     * <p>
     * The descriptive name of the proxy rule. You can't change the name of a proxy rule after you create it.
     * </p>
     * 
     * @return The descriptive name of the proxy rule. You can't change the name of a proxy rule after you create it.
     */
    public final String proxyRuleName() {
        return proxyRuleName;
    }

    /**
     * <p>
     * The descriptive name of the proxy rule group. You can't change the name of a proxy rule group after you create
     * it.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The descriptive name of the proxy rule group. You can't change the name of a proxy rule group after you
     *         create it.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String proxyRuleGroupName() {
        return proxyRuleGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a proxy rule group.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a proxy rule group.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String proxyRuleGroupArn() {
        return proxyRuleGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(proxyRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(proxyRuleGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(proxyRuleGroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProxyRuleRequest)) {
            return false;
        }
        DescribeProxyRuleRequest other = (DescribeProxyRuleRequest) obj;
        return Objects.equals(proxyRuleName(), other.proxyRuleName())
                && Objects.equals(proxyRuleGroupName(), other.proxyRuleGroupName())
                && Objects.equals(proxyRuleGroupArn(), other.proxyRuleGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeProxyRuleRequest").add("ProxyRuleName", proxyRuleName())
                .add("ProxyRuleGroupName", proxyRuleGroupName()).add("ProxyRuleGroupArn", proxyRuleGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProxyRuleName":
            return Optional.ofNullable(clazz.cast(proxyRuleName()));
        case "ProxyRuleGroupName":
            return Optional.ofNullable(clazz.cast(proxyRuleGroupName()));
        case "ProxyRuleGroupArn":
            return Optional.ofNullable(clazz.cast(proxyRuleGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProxyRuleName", PROXY_RULE_NAME_FIELD);
        map.put("ProxyRuleGroupName", PROXY_RULE_GROUP_NAME_FIELD);
        map.put("ProxyRuleGroupArn", PROXY_RULE_GROUP_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeProxyRuleRequest, T> g) {
        return obj -> g.apply((DescribeProxyRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeProxyRuleRequest> {
        /**
         * <p>
         * The descriptive name of the proxy rule. You can't change the name of a proxy rule after you create it.
         * </p>
         * 
         * @param proxyRuleName
         *        The descriptive name of the proxy rule. You can't change the name of a proxy rule after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyRuleName(String proxyRuleName);

        /**
         * <p>
         * The descriptive name of the proxy rule group. You can't change the name of a proxy rule group after you
         * create it.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param proxyRuleGroupName
         *        The descriptive name of the proxy rule group. You can't change the name of a proxy rule group after
         *        you create it.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyRuleGroupName(String proxyRuleGroupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a proxy rule group.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param proxyRuleGroupArn
         *        The Amazon Resource Name (ARN) of a proxy rule group.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyRuleGroupArn(String proxyRuleGroupArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFirewallRequest.BuilderImpl implements Builder {
        private String proxyRuleName;

        private String proxyRuleGroupName;

        private String proxyRuleGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProxyRuleRequest model) {
            super(model);
            proxyRuleName(model.proxyRuleName);
            proxyRuleGroupName(model.proxyRuleGroupName);
            proxyRuleGroupArn(model.proxyRuleGroupArn);
        }

        public final String getProxyRuleName() {
            return proxyRuleName;
        }

        public final void setProxyRuleName(String proxyRuleName) {
            this.proxyRuleName = proxyRuleName;
        }

        @Override
        public final Builder proxyRuleName(String proxyRuleName) {
            this.proxyRuleName = proxyRuleName;
            return this;
        }

        public final String getProxyRuleGroupName() {
            return proxyRuleGroupName;
        }

        public final void setProxyRuleGroupName(String proxyRuleGroupName) {
            this.proxyRuleGroupName = proxyRuleGroupName;
        }

        @Override
        public final Builder proxyRuleGroupName(String proxyRuleGroupName) {
            this.proxyRuleGroupName = proxyRuleGroupName;
            return this;
        }

        public final String getProxyRuleGroupArn() {
            return proxyRuleGroupArn;
        }

        public final void setProxyRuleGroupArn(String proxyRuleGroupArn) {
            this.proxyRuleGroupArn = proxyRuleGroupArn;
        }

        @Override
        public final Builder proxyRuleGroupArn(String proxyRuleGroupArn) {
            this.proxyRuleGroupArn = proxyRuleGroupArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeProxyRuleRequest build() {
            return new DescribeProxyRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
