/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProxyResponse extends NetworkFirewallResponse implements
        ToCopyableBuilder<DescribeProxyResponse.Builder, DescribeProxyResponse> {
    private static final SdkField<DescribeProxyResource> PROXY_FIELD = SdkField
            .<DescribeProxyResource> builder(MarshallingType.SDK_POJO).memberName("Proxy")
            .getter(getter(DescribeProxyResponse::proxy)).setter(setter(Builder::proxy))
            .constructor(DescribeProxyResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Proxy").build()).build();

    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateToken").getter(getter(DescribeProxyResponse::updateToken)).setter(setter(Builder::updateToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_FIELD,
            UPDATE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DescribeProxyResource proxy;

    private final String updateToken;

    private DescribeProxyResponse(BuilderImpl builder) {
        super(builder);
        this.proxy = builder.proxy;
        this.updateToken = builder.updateToken;
    }

    /**
     * <p>
     * Proxy attached to a NAT gateway.
     * </p>
     * 
     * @return Proxy attached to a NAT gateway.
     */
    public final DescribeProxyResource proxy() {
        return proxy;
    }

    /**
     * <p>
     * A token used for optimistic locking. Network Firewall returns a token to your requests that access the proxy. The
     * token marks the state of the proxy resource at the time of the request.
     * </p>
     * <p>
     * To make changes to the proxy, you provide the token in your request. Network Firewall uses the token to ensure
     * that the proxy hasn't changed since you last retrieved it. If it has changed, the operation fails with an
     * <code>InvalidTokenException</code>. If this happens, retrieve the proxy again to get a current copy of it with a
     * current token. Reapply your changes as needed, then try the operation again using the new token.
     * </p>
     * 
     * @return A token used for optimistic locking. Network Firewall returns a token to your requests that access the
     *         proxy. The token marks the state of the proxy resource at the time of the request. </p>
     *         <p>
     *         To make changes to the proxy, you provide the token in your request. Network Firewall uses the token to
     *         ensure that the proxy hasn't changed since you last retrieved it. If it has changed, the operation fails
     *         with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy again to get a current
     *         copy of it with a current token. Reapply your changes as needed, then try the operation again using the
     *         new token.
     */
    public final String updateToken() {
        return updateToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(proxy());
        hashCode = 31 * hashCode + Objects.hashCode(updateToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProxyResponse)) {
            return false;
        }
        DescribeProxyResponse other = (DescribeProxyResponse) obj;
        return Objects.equals(proxy(), other.proxy()) && Objects.equals(updateToken(), other.updateToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeProxyResponse").add("Proxy", proxy()).add("UpdateToken", updateToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Proxy":
            return Optional.ofNullable(clazz.cast(proxy()));
        case "UpdateToken":
            return Optional.ofNullable(clazz.cast(updateToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Proxy", PROXY_FIELD);
        map.put("UpdateToken", UPDATE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeProxyResponse, T> g) {
        return obj -> g.apply((DescribeProxyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeProxyResponse> {
        /**
         * <p>
         * Proxy attached to a NAT gateway.
         * </p>
         * 
         * @param proxy
         *        Proxy attached to a NAT gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxy(DescribeProxyResource proxy);

        /**
         * <p>
         * Proxy attached to a NAT gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link DescribeProxyResource.Builder} avoiding
         * the need to create one manually via {@link DescribeProxyResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DescribeProxyResource.Builder#build()} is called immediately and
         * its result is passed to {@link #proxy(DescribeProxyResource)}.
         * 
         * @param proxy
         *        a consumer that will call methods on {@link DescribeProxyResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proxy(DescribeProxyResource)
         */
        default Builder proxy(Consumer<DescribeProxyResource.Builder> proxy) {
            return proxy(DescribeProxyResource.builder().applyMutation(proxy).build());
        }

        /**
         * <p>
         * A token used for optimistic locking. Network Firewall returns a token to your requests that access the proxy.
         * The token marks the state of the proxy resource at the time of the request.
         * </p>
         * <p>
         * To make changes to the proxy, you provide the token in your request. Network Firewall uses the token to
         * ensure that the proxy hasn't changed since you last retrieved it. If it has changed, the operation fails with
         * an <code>InvalidTokenException</code>. If this happens, retrieve the proxy again to get a current copy of it
         * with a current token. Reapply your changes as needed, then try the operation again using the new token.
         * </p>
         * 
         * @param updateToken
         *        A token used for optimistic locking. Network Firewall returns a token to your requests that access the
         *        proxy. The token marks the state of the proxy resource at the time of the request. </p>
         *        <p>
         *        To make changes to the proxy, you provide the token in your request. Network Firewall uses the token
         *        to ensure that the proxy hasn't changed since you last retrieved it. If it has changed, the operation
         *        fails with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy again to get a
         *        current copy of it with a current token. Reapply your changes as needed, then try the operation again
         *        using the new token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateToken(String updateToken);
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private DescribeProxyResource proxy;

        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProxyResponse model) {
            super(model);
            proxy(model.proxy);
            updateToken(model.updateToken);
        }

        public final DescribeProxyResource.Builder getProxy() {
            return proxy != null ? proxy.toBuilder() : null;
        }

        public final void setProxy(DescribeProxyResource.BuilderImpl proxy) {
            this.proxy = proxy != null ? proxy.build() : null;
        }

        @Override
        public final Builder proxy(DescribeProxyResource proxy) {
            this.proxy = proxy;
            return this;
        }

        public final String getUpdateToken() {
            return updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        @Override
        public DescribeProxyResponse build() {
            return new DescribeProxyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
