/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFirewallMetadataResponse extends NetworkFirewallResponse implements
        ToCopyableBuilder<DescribeFirewallMetadataResponse.Builder, DescribeFirewallMetadataResponse> {
    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallArn").getter(getter(DescribeFirewallMetadataResponse::firewallArn))
            .setter(setter(Builder::firewallArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()).build();

    private static final SdkField<String> FIREWALL_POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallPolicyArn").getter(getter(DescribeFirewallMetadataResponse::firewallPolicyArn))
            .setter(setter(Builder::firewallPolicyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeFirewallMetadataResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeFirewallMetadataResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Map<String, AvailabilityZoneMetadata>> SUPPORTED_AVAILABILITY_ZONES_FIELD = SdkField
            .<Map<String, AvailabilityZoneMetadata>> builder(MarshallingType.MAP)
            .memberName("SupportedAvailabilityZones")
            .getter(getter(DescribeFirewallMetadataResponse::supportedAvailabilityZones))
            .setter(setter(Builder::supportedAvailabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedAvailabilityZones").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AvailabilityZoneMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(AvailabilityZoneMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayAttachmentId")
            .getter(getter(DescribeFirewallMetadataResponse::transitGatewayAttachmentId))
            .setter(setter(Builder::transitGatewayAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_ARN_FIELD,
            FIREWALL_POLICY_ARN_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, SUPPORTED_AVAILABILITY_ZONES_FIELD,
            TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String firewallArn;

    private final String firewallPolicyArn;

    private final String description;

    private final String status;

    private final Map<String, AvailabilityZoneMetadata> supportedAvailabilityZones;

    private final String transitGatewayAttachmentId;

    private DescribeFirewallMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.firewallArn = builder.firewallArn;
        this.firewallPolicyArn = builder.firewallPolicyArn;
        this.description = builder.description;
        this.status = builder.status;
        this.supportedAvailabilityZones = builder.supportedAvailabilityZones;
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the firewall.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the firewall.
     */
    public final String firewallArn() {
        return firewallArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the firewall policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the firewall policy.
     */
    public final String firewallPolicyArn() {
        return firewallPolicyArn;
    }

    /**
     * <p>
     * A description of the firewall.
     * </p>
     * 
     * @return A description of the firewall.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The readiness of the configured firewall to handle network traffic across all of the Availability Zones where you
     * have it configured. This setting is <code>READY</code> only when the <code>ConfigurationSyncStateSummary</code>
     * value is <code>IN_SYNC</code> and the <code>Attachment</code> <code>Status</code> values for all of the
     * configured subnets are <code>READY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FirewallStatusValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The readiness of the configured firewall to handle network traffic across all of the Availability Zones
     *         where you have it configured. This setting is <code>READY</code> only when the
     *         <code>ConfigurationSyncStateSummary</code> value is <code>IN_SYNC</code> and the <code>Attachment</code>
     *         <code>Status</code> values for all of the configured subnets are <code>READY</code>.
     * @see FirewallStatusValue
     */
    public final FirewallStatusValue status() {
        return FirewallStatusValue.fromValue(status);
    }

    /**
     * <p>
     * The readiness of the configured firewall to handle network traffic across all of the Availability Zones where you
     * have it configured. This setting is <code>READY</code> only when the <code>ConfigurationSyncStateSummary</code>
     * value is <code>IN_SYNC</code> and the <code>Attachment</code> <code>Status</code> values for all of the
     * configured subnets are <code>READY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FirewallStatusValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The readiness of the configured firewall to handle network traffic across all of the Availability Zones
     *         where you have it configured. This setting is <code>READY</code> only when the
     *         <code>ConfigurationSyncStateSummary</code> value is <code>IN_SYNC</code> and the <code>Attachment</code>
     *         <code>Status</code> values for all of the configured subnets are <code>READY</code>.
     * @see FirewallStatusValue
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedAvailabilityZones property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedAvailabilityZones() {
        return supportedAvailabilityZones != null && !(supportedAvailabilityZones instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The Availability Zones that the firewall currently supports. This includes all Availability Zones for which the
     * firewall has a subnet defined.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedAvailabilityZones} method.
     * </p>
     * 
     * @return The Availability Zones that the firewall currently supports. This includes all Availability Zones for
     *         which the firewall has a subnet defined.
     */
    public final Map<String, AvailabilityZoneMetadata> supportedAvailabilityZones() {
        return supportedAvailabilityZones;
    }

    /**
     * <p>
     * The unique identifier of the transit gateway attachment associated with this firewall. This field is only present
     * for transit gateway-attached firewalls.
     * </p>
     * 
     * @return The unique identifier of the transit gateway attachment associated with this firewall. This field is only
     *         present for transit gateway-attached firewalls.
     */
    public final String transitGatewayAttachmentId() {
        return transitGatewayAttachmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(firewallArn());
        hashCode = 31 * hashCode + Objects.hashCode(firewallPolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedAvailabilityZones() ? supportedAvailabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayAttachmentId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFirewallMetadataResponse)) {
            return false;
        }
        DescribeFirewallMetadataResponse other = (DescribeFirewallMetadataResponse) obj;
        return Objects.equals(firewallArn(), other.firewallArn())
                && Objects.equals(firewallPolicyArn(), other.firewallPolicyArn())
                && Objects.equals(description(), other.description()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasSupportedAvailabilityZones() == other.hasSupportedAvailabilityZones()
                && Objects.equals(supportedAvailabilityZones(), other.supportedAvailabilityZones())
                && Objects.equals(transitGatewayAttachmentId(), other.transitGatewayAttachmentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFirewallMetadataResponse").add("FirewallArn", firewallArn())
                .add("FirewallPolicyArn", firewallPolicyArn()).add("Description", description()).add("Status", statusAsString())
                .add("SupportedAvailabilityZones", hasSupportedAvailabilityZones() ? supportedAvailabilityZones() : null)
                .add("TransitGatewayAttachmentId", transitGatewayAttachmentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallArn":
            return Optional.ofNullable(clazz.cast(firewallArn()));
        case "FirewallPolicyArn":
            return Optional.ofNullable(clazz.cast(firewallPolicyArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "SupportedAvailabilityZones":
            return Optional.ofNullable(clazz.cast(supportedAvailabilityZones()));
        case "TransitGatewayAttachmentId":
            return Optional.ofNullable(clazz.cast(transitGatewayAttachmentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FirewallArn", FIREWALL_ARN_FIELD);
        map.put("FirewallPolicyArn", FIREWALL_POLICY_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("SupportedAvailabilityZones", SUPPORTED_AVAILABILITY_ZONES_FIELD);
        map.put("TransitGatewayAttachmentId", TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFirewallMetadataResponse, T> g) {
        return obj -> g.apply((DescribeFirewallMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeFirewallMetadataResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the firewall.
         * </p>
         * 
         * @param firewallArn
         *        The Amazon Resource Name (ARN) of the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallArn(String firewallArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the firewall policy.
         * </p>
         * 
         * @param firewallPolicyArn
         *        The Amazon Resource Name (ARN) of the firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallPolicyArn(String firewallPolicyArn);

        /**
         * <p>
         * A description of the firewall.
         * </p>
         * 
         * @param description
         *        A description of the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The readiness of the configured firewall to handle network traffic across all of the Availability Zones where
         * you have it configured. This setting is <code>READY</code> only when the
         * <code>ConfigurationSyncStateSummary</code> value is <code>IN_SYNC</code> and the <code>Attachment</code>
         * <code>Status</code> values for all of the configured subnets are <code>READY</code>.
         * </p>
         * 
         * @param status
         *        The readiness of the configured firewall to handle network traffic across all of the Availability
         *        Zones where you have it configured. This setting is <code>READY</code> only when the
         *        <code>ConfigurationSyncStateSummary</code> value is <code>IN_SYNC</code> and the
         *        <code>Attachment</code> <code>Status</code> values for all of the configured subnets are
         *        <code>READY</code>.
         * @see FirewallStatusValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallStatusValue
         */
        Builder status(String status);

        /**
         * <p>
         * The readiness of the configured firewall to handle network traffic across all of the Availability Zones where
         * you have it configured. This setting is <code>READY</code> only when the
         * <code>ConfigurationSyncStateSummary</code> value is <code>IN_SYNC</code> and the <code>Attachment</code>
         * <code>Status</code> values for all of the configured subnets are <code>READY</code>.
         * </p>
         * 
         * @param status
         *        The readiness of the configured firewall to handle network traffic across all of the Availability
         *        Zones where you have it configured. This setting is <code>READY</code> only when the
         *        <code>ConfigurationSyncStateSummary</code> value is <code>IN_SYNC</code> and the
         *        <code>Attachment</code> <code>Status</code> values for all of the configured subnets are
         *        <code>READY</code>.
         * @see FirewallStatusValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallStatusValue
         */
        Builder status(FirewallStatusValue status);

        /**
         * <p>
         * The Availability Zones that the firewall currently supports. This includes all Availability Zones for which
         * the firewall has a subnet defined.
         * </p>
         * 
         * @param supportedAvailabilityZones
         *        The Availability Zones that the firewall currently supports. This includes all Availability Zones for
         *        which the firewall has a subnet defined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedAvailabilityZones(Map<String, AvailabilityZoneMetadata> supportedAvailabilityZones);

        /**
         * <p>
         * The unique identifier of the transit gateway attachment associated with this firewall. This field is only
         * present for transit gateway-attached firewalls.
         * </p>
         * 
         * @param transitGatewayAttachmentId
         *        The unique identifier of the transit gateway attachment associated with this firewall. This field is
         *        only present for transit gateway-attached firewalls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAttachmentId(String transitGatewayAttachmentId);
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private String firewallArn;

        private String firewallPolicyArn;

        private String description;

        private String status;

        private Map<String, AvailabilityZoneMetadata> supportedAvailabilityZones = DefaultSdkAutoConstructMap.getInstance();

        private String transitGatewayAttachmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFirewallMetadataResponse model) {
            super(model);
            firewallArn(model.firewallArn);
            firewallPolicyArn(model.firewallPolicyArn);
            description(model.description);
            status(model.status);
            supportedAvailabilityZones(model.supportedAvailabilityZones);
            transitGatewayAttachmentId(model.transitGatewayAttachmentId);
        }

        public final String getFirewallArn() {
            return firewallArn;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        @Override
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        public final String getFirewallPolicyArn() {
            return firewallPolicyArn;
        }

        public final void setFirewallPolicyArn(String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
        }

        @Override
        public final Builder firewallPolicyArn(String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FirewallStatusValue status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, AvailabilityZoneMetadata.Builder> getSupportedAvailabilityZones() {
            Map<String, AvailabilityZoneMetadata.Builder> result = SupportedAvailabilityZonesCopier
                    .copyToBuilder(this.supportedAvailabilityZones);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSupportedAvailabilityZones(
                Map<String, AvailabilityZoneMetadata.BuilderImpl> supportedAvailabilityZones) {
            this.supportedAvailabilityZones = SupportedAvailabilityZonesCopier.copyFromBuilder(supportedAvailabilityZones);
        }

        @Override
        public final Builder supportedAvailabilityZones(Map<String, AvailabilityZoneMetadata> supportedAvailabilityZones) {
            this.supportedAvailabilityZones = SupportedAvailabilityZonesCopier.copy(supportedAvailabilityZones);
            return this;
        }

        public final String getTransitGatewayAttachmentId() {
            return transitGatewayAttachmentId;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        @Override
        public DescribeFirewallMetadataResponse build() {
            return new DescribeFirewallMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
