/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteProxyRequest extends NetworkFirewallRequest implements
        ToCopyableBuilder<DeleteProxyRequest.Builder, DeleteProxyRequest> {
    private static final SdkField<String> NAT_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NatGatewayId").getter(getter(DeleteProxyRequest::natGatewayId)).setter(setter(Builder::natGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId").build()).build();

    private static final SdkField<String> PROXY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyName").getter(getter(DeleteProxyRequest::proxyName)).setter(setter(Builder::proxyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyName").build()).build();

    private static final SdkField<String> PROXY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyArn").getter(getter(DeleteProxyRequest::proxyArn)).setter(setter(Builder::proxyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAT_GATEWAY_ID_FIELD,
            PROXY_NAME_FIELD, PROXY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String natGatewayId;

    private final String proxyName;

    private final String proxyArn;

    private DeleteProxyRequest(BuilderImpl builder) {
        super(builder);
        this.natGatewayId = builder.natGatewayId;
        this.proxyName = builder.proxyName;
        this.proxyArn = builder.proxyArn;
    }

    /**
     * <p>
     * The NAT Gateway the proxy is attached to.
     * </p>
     * 
     * @return The NAT Gateway the proxy is attached to.
     */
    public final String natGatewayId() {
        return natGatewayId;
    }

    /**
     * <p>
     * The descriptive name of the proxy. You can't change the name of a proxy after you create it.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The descriptive name of the proxy. You can't change the name of a proxy after you create it.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String proxyName() {
        return proxyName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a proxy.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a proxy.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String proxyArn() {
        return proxyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(proxyName());
        hashCode = 31 * hashCode + Objects.hashCode(proxyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteProxyRequest)) {
            return false;
        }
        DeleteProxyRequest other = (DeleteProxyRequest) obj;
        return Objects.equals(natGatewayId(), other.natGatewayId()) && Objects.equals(proxyName(), other.proxyName())
                && Objects.equals(proxyArn(), other.proxyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteProxyRequest").add("NatGatewayId", natGatewayId()).add("ProxyName", proxyName())
                .add("ProxyArn", proxyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NatGatewayId":
            return Optional.ofNullable(clazz.cast(natGatewayId()));
        case "ProxyName":
            return Optional.ofNullable(clazz.cast(proxyName()));
        case "ProxyArn":
            return Optional.ofNullable(clazz.cast(proxyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NatGatewayId", NAT_GATEWAY_ID_FIELD);
        map.put("ProxyName", PROXY_NAME_FIELD);
        map.put("ProxyArn", PROXY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteProxyRequest, T> g) {
        return obj -> g.apply((DeleteProxyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteProxyRequest> {
        /**
         * <p>
         * The NAT Gateway the proxy is attached to.
         * </p>
         * 
         * @param natGatewayId
         *        The NAT Gateway the proxy is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGatewayId(String natGatewayId);

        /**
         * <p>
         * The descriptive name of the proxy. You can't change the name of a proxy after you create it.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param proxyName
         *        The descriptive name of the proxy. You can't change the name of a proxy after you create it.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyName(String proxyName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a proxy.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param proxyArn
         *        The Amazon Resource Name (ARN) of a proxy.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyArn(String proxyArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFirewallRequest.BuilderImpl implements Builder {
        private String natGatewayId;

        private String proxyName;

        private String proxyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteProxyRequest model) {
            super(model);
            natGatewayId(model.natGatewayId);
            proxyName(model.proxyName);
            proxyArn(model.proxyArn);
        }

        public final String getNatGatewayId() {
            return natGatewayId;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final String getProxyName() {
            return proxyName;
        }

        public final void setProxyName(String proxyName) {
            this.proxyName = proxyName;
        }

        @Override
        public final Builder proxyName(String proxyName) {
            this.proxyName = proxyName;
            return this;
        }

        public final String getProxyArn() {
            return proxyArn;
        }

        public final void setProxyArn(String proxyArn) {
            this.proxyArn = proxyArn;
        }

        @Override
        public final Builder proxyArn(String proxyArn) {
            this.proxyArn = proxyArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteProxyRequest build() {
            return new DeleteProxyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
