/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRuleGroupRequest extends NetworkFirewallRequest implements
        ToCopyableBuilder<CreateRuleGroupRequest.Builder, CreateRuleGroupRequest> {
    private static final SdkField<String> RULE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleGroupName").getter(getter(CreateRuleGroupRequest::ruleGroupName))
            .setter(setter(Builder::ruleGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupName").build()).build();

    private static final SdkField<RuleGroup> RULE_GROUP_FIELD = SdkField.<RuleGroup> builder(MarshallingType.SDK_POJO)
            .memberName("RuleGroup").getter(getter(CreateRuleGroupRequest::ruleGroup)).setter(setter(Builder::ruleGroup))
            .constructor(RuleGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroup").build()).build();

    private static final SdkField<String> RULES_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Rules")
            .getter(getter(CreateRuleGroupRequest::rules)).setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CreateRuleGroupRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateRuleGroupRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Capacity").getter(getter(CreateRuleGroupRequest::capacity)).setter(setter(Builder::capacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateRuleGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun").getter(getter(CreateRuleGroupRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("EncryptionConfiguration")
            .getter(getter(CreateRuleGroupRequest::encryptionConfiguration)).setter(setter(Builder::encryptionConfiguration))
            .constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build())
            .build();

    private static final SdkField<SourceMetadata> SOURCE_METADATA_FIELD = SdkField
            .<SourceMetadata> builder(MarshallingType.SDK_POJO).memberName("SourceMetadata")
            .getter(getter(CreateRuleGroupRequest::sourceMetadata)).setter(setter(Builder::sourceMetadata))
            .constructor(SourceMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceMetadata").build()).build();

    private static final SdkField<Boolean> ANALYZE_RULE_GROUP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AnalyzeRuleGroup").getter(getter(CreateRuleGroupRequest::analyzeRuleGroup))
            .setter(setter(Builder::analyzeRuleGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyzeRuleGroup").build()).build();

    private static final SdkField<SummaryConfiguration> SUMMARY_CONFIGURATION_FIELD = SdkField
            .<SummaryConfiguration> builder(MarshallingType.SDK_POJO).memberName("SummaryConfiguration")
            .getter(getter(CreateRuleGroupRequest::summaryConfiguration)).setter(setter(Builder::summaryConfiguration))
            .constructor(SummaryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SummaryConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_GROUP_NAME_FIELD,
            RULE_GROUP_FIELD, RULES_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, CAPACITY_FIELD, TAGS_FIELD, DRY_RUN_FIELD,
            ENCRYPTION_CONFIGURATION_FIELD, SOURCE_METADATA_FIELD, ANALYZE_RULE_GROUP_FIELD, SUMMARY_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String ruleGroupName;

    private final RuleGroup ruleGroup;

    private final String rules;

    private final String type;

    private final String description;

    private final Integer capacity;

    private final List<Tag> tags;

    private final Boolean dryRun;

    private final EncryptionConfiguration encryptionConfiguration;

    private final SourceMetadata sourceMetadata;

    private final Boolean analyzeRuleGroup;

    private final SummaryConfiguration summaryConfiguration;

    private CreateRuleGroupRequest(BuilderImpl builder) {
        super(builder);
        this.ruleGroupName = builder.ruleGroupName;
        this.ruleGroup = builder.ruleGroup;
        this.rules = builder.rules;
        this.type = builder.type;
        this.description = builder.description;
        this.capacity = builder.capacity;
        this.tags = builder.tags;
        this.dryRun = builder.dryRun;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.sourceMetadata = builder.sourceMetadata;
        this.analyzeRuleGroup = builder.analyzeRuleGroup;
        this.summaryConfiguration = builder.summaryConfiguration;
    }

    /**
     * <p>
     * The descriptive name of the rule group. You can't change the name of a rule group after you create it.
     * </p>
     * 
     * @return The descriptive name of the rule group. You can't change the name of a rule group after you create it.
     */
    public final String ruleGroupName() {
        return ruleGroupName;
    }

    /**
     * <p>
     * An object that defines the rule group rules.
     * </p>
     * <note>
     * <p>
     * You must provide either this rule group setting or a <code>Rules</code> setting, but not both.
     * </p>
     * </note>
     * 
     * @return An object that defines the rule group rules. </p> <note>
     *         <p>
     *         You must provide either this rule group setting or a <code>Rules</code> setting, but not both.
     *         </p>
     */
    public final RuleGroup ruleGroup() {
        return ruleGroup;
    }

    /**
     * <p>
     * A string containing stateful rule group rules specifications in Suricata flat format, with one rule per line. Use
     * this to import your existing Suricata compatible rule groups.
     * </p>
     * <note>
     * <p>
     * You must provide either this rules setting or a populated <code>RuleGroup</code> setting, but not both.
     * </p>
     * </note>
     * <p>
     * You can provide your rule group specification in Suricata flat format through this setting when you create or
     * update your rule group. The call response returns a <a>RuleGroup</a> object that Network Firewall has populated
     * from your string.
     * </p>
     * 
     * @return A string containing stateful rule group rules specifications in Suricata flat format, with one rule per
     *         line. Use this to import your existing Suricata compatible rule groups. </p> <note>
     *         <p>
     *         You must provide either this rules setting or a populated <code>RuleGroup</code> setting, but not both.
     *         </p>
     *         </note>
     *         <p>
     *         You can provide your rule group specification in Suricata flat format through this setting when you
     *         create or update your rule group. The call response returns a <a>RuleGroup</a> object that Network
     *         Firewall has populated from your string.
     */
    public final String rules() {
        return rules;
    }

    /**
     * <p>
     * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless
     * rules. If it is stateful, it contains stateful rules.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RuleGroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
     *         stateless rules. If it is stateful, it contains stateful rules.
     * @see RuleGroupType
     */
    public final RuleGroupType type() {
        return RuleGroupType.fromValue(type);
    }

    /**
     * <p>
     * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless
     * rules. If it is stateful, it contains stateful rules.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RuleGroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
     *         stateless rules. If it is stateful, it contains stateful rules.
     * @see RuleGroupType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A description of the rule group.
     * </p>
     * 
     * @return A description of the rule group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation. When you
     * update a rule group, you are limited to this capacity. When you reference a rule group from a firewall policy,
     * Network Firewall reserves this capacity for the rule group.
     * </p>
     * <p>
     * You can retrieve the capacity that would be required for a rule group before you create the rule group by calling
     * <a>CreateRuleGroup</a> with <code>DryRun</code> set to <code>TRUE</code>.
     * </p>
     * <note>
     * <p>
     * You can't change or exceed this capacity when you update the rule group, so leave room for your rule group to
     * grow.
     * </p>
     * </note>
     * <p>
     * <b>Capacity for a stateless rule group</b>
     * </p>
     * <p>
     * For a stateless rule group, the capacity required is the sum of the capacity requirements of the individual rules
     * that you expect to have in the rule group.
     * </p>
     * <p>
     * To calculate the capacity requirement of a single rule, multiply the capacity requirement values of each of the
     * rule's match settings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A match setting with no criteria specified has a value of 1.
     * </p>
     * </li>
     * <li>
     * <p>
     * A match setting with <code>Any</code> specified has a value of 1.
     * </p>
     * </li>
     * <li>
     * <p>
     * All other match settings have a value equal to the number of elements provided in the setting. For example, a
     * protocol setting ["UDP"] and a source setting ["10.0.0.0/24"] each have a value of 1. A protocol setting
     * ["UDP","TCP"] has a value of 2. A source setting ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"] has a value of 3.
     * </p>
     * </li>
     * </ul>
     * <p>
     * A rule with no criteria specified in any of its match settings has a capacity requirement of 1. A rule with
     * protocol setting ["UDP","TCP"], source setting ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"], and a single
     * specification or no specification for each of the other match settings has a capacity requirement of 6.
     * </p>
     * <p>
     * <b>Capacity for a stateful rule group</b>
     * </p>
     * <p>
     * For a stateful rule group, the minimum capacity required is the number of individual rules that you expect to
     * have in the rule group.
     * </p>
     * 
     * @return The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation.
     *         When you update a rule group, you are limited to this capacity. When you reference a rule group from a
     *         firewall policy, Network Firewall reserves this capacity for the rule group. </p>
     *         <p>
     *         You can retrieve the capacity that would be required for a rule group before you create the rule group by
     *         calling <a>CreateRuleGroup</a> with <code>DryRun</code> set to <code>TRUE</code>.
     *         </p>
     *         <note>
     *         <p>
     *         You can't change or exceed this capacity when you update the rule group, so leave room for your rule
     *         group to grow.
     *         </p>
     *         </note>
     *         <p>
     *         <b>Capacity for a stateless rule group</b>
     *         </p>
     *         <p>
     *         For a stateless rule group, the capacity required is the sum of the capacity requirements of the
     *         individual rules that you expect to have in the rule group.
     *         </p>
     *         <p>
     *         To calculate the capacity requirement of a single rule, multiply the capacity requirement values of each
     *         of the rule's match settings:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A match setting with no criteria specified has a value of 1.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A match setting with <code>Any</code> specified has a value of 1.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         All other match settings have a value equal to the number of elements provided in the setting. For
     *         example, a protocol setting ["UDP"] and a source setting ["10.0.0.0/24"] each have a value of 1. A
     *         protocol setting ["UDP","TCP"] has a value of 2. A source setting
     *         ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"] has a value of 3.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         A rule with no criteria specified in any of its match settings has a capacity requirement of 1. A rule
     *         with protocol setting ["UDP","TCP"], source setting ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"], and a
     *         single specification or no specification for each of the other match settings has a capacity requirement
     *         of 6.
     *         </p>
     *         <p>
     *         <b>Capacity for a stateful rule group</b>
     *         </p>
     *         <p>
     *         For a stateful rule group, the minimum capacity required is the number of individual rules that you
     *         expect to have in the rule group.
     */
    public final Integer capacity() {
        return capacity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key:value pairs to associate with the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The key:value pairs to associate with the resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Indicates whether you want Network Firewall to just check the validity of the request, rather than run the
     * request.
     * </p>
     * <p>
     * If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but doesn't
     * actually make the requested changes. The call returns the value that the request would return if you ran it with
     * dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option allows
     * you to make sure that you have the required permissions to run the request and that your request parameters are
     * valid.
     * </p>
     * <p>
     * If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources.
     * </p>
     * 
     * @return Indicates whether you want Network Firewall to just check the validity of the request, rather than run
     *         the request. </p>
     *         <p>
     *         If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but
     *         doesn't actually make the requested changes. The call returns the value that the request would return if
     *         you ran it with dry run set to <code>FALSE</code>, but doesn't make additions or changes to your
     *         resources. This option allows you to make sure that you have the required permissions to run the request
     *         and that your request parameters are valid.
     *         </p>
     *         <p>
     *         If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * A complex type that contains settings for encryption of your rule group resources.
     * </p>
     * 
     * @return A complex type that contains settings for encryption of your rule group resources.
     */
    public final EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    /**
     * <p>
     * A complex type that contains metadata about the rule group that your own rule group is copied from. You can use
     * the metadata to keep track of updates made to the originating rule group.
     * </p>
     * 
     * @return A complex type that contains metadata about the rule group that your own rule group is copied from. You
     *         can use the metadata to keep track of updates made to the originating rule group.
     */
    public final SourceMetadata sourceMetadata() {
        return sourceMetadata;
    }

    /**
     * <p>
     * Indicates whether you want Network Firewall to analyze the stateless rules in the rule group for rule behavior
     * such as asymmetric routing. If set to <code>TRUE</code>, Network Firewall runs the analysis and then creates the
     * rule group for you. To run the stateless rule group analyzer without creating the rule group, set
     * <code>DryRun</code> to <code>TRUE</code>.
     * </p>
     * 
     * @return Indicates whether you want Network Firewall to analyze the stateless rules in the rule group for rule
     *         behavior such as asymmetric routing. If set to <code>TRUE</code>, Network Firewall runs the analysis and
     *         then creates the rule group for you. To run the stateless rule group analyzer without creating the rule
     *         group, set <code>DryRun</code> to <code>TRUE</code>.
     */
    public final Boolean analyzeRuleGroup() {
        return analyzeRuleGroup;
    }

    /**
     * <p>
     * An object that contains a <code>RuleOptions</code> array of strings. You use <code>RuleOptions</code> to
     * determine which of the following <a>RuleSummary</a> values are returned in response to
     * <code>DescribeRuleGroupSummary</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Metadata</code> - returns
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Msg</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SID</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return An object that contains a <code>RuleOptions</code> array of strings. You use <code>RuleOptions</code> to
     *         determine which of the following <a>RuleSummary</a> values are returned in response to
     *         <code>DescribeRuleGroupSummary</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Metadata</code> - returns
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Msg</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SID</code>
     *         </p>
     *         </li>
     */
    public final SummaryConfiguration summaryConfiguration() {
        return summaryConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroup());
        hashCode = 31 * hashCode + Objects.hashCode(rules());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(capacity());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(sourceMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(analyzeRuleGroup());
        hashCode = 31 * hashCode + Objects.hashCode(summaryConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleGroupRequest)) {
            return false;
        }
        CreateRuleGroupRequest other = (CreateRuleGroupRequest) obj;
        return Objects.equals(ruleGroupName(), other.ruleGroupName()) && Objects.equals(ruleGroup(), other.ruleGroup())
                && Objects.equals(rules(), other.rules()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(capacity(), other.capacity())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration())
                && Objects.equals(sourceMetadata(), other.sourceMetadata())
                && Objects.equals(analyzeRuleGroup(), other.analyzeRuleGroup())
                && Objects.equals(summaryConfiguration(), other.summaryConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRuleGroupRequest").add("RuleGroupName", ruleGroupName()).add("RuleGroup", ruleGroup())
                .add("Rules", rules()).add("Type", typeAsString()).add("Description", description()).add("Capacity", capacity())
                .add("Tags", hasTags() ? tags() : null).add("DryRun", dryRun())
                .add("EncryptionConfiguration", encryptionConfiguration()).add("SourceMetadata", sourceMetadata())
                .add("AnalyzeRuleGroup", analyzeRuleGroup()).add("SummaryConfiguration", summaryConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleGroupName":
            return Optional.ofNullable(clazz.cast(ruleGroupName()));
        case "RuleGroup":
            return Optional.ofNullable(clazz.cast(ruleGroup()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Capacity":
            return Optional.ofNullable(clazz.cast(capacity()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "EncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        case "SourceMetadata":
            return Optional.ofNullable(clazz.cast(sourceMetadata()));
        case "AnalyzeRuleGroup":
            return Optional.ofNullable(clazz.cast(analyzeRuleGroup()));
        case "SummaryConfiguration":
            return Optional.ofNullable(clazz.cast(summaryConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RuleGroupName", RULE_GROUP_NAME_FIELD);
        map.put("RuleGroup", RULE_GROUP_FIELD);
        map.put("Rules", RULES_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Capacity", CAPACITY_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("EncryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("SourceMetadata", SOURCE_METADATA_FIELD);
        map.put("AnalyzeRuleGroup", ANALYZE_RULE_GROUP_FIELD);
        map.put("SummaryConfiguration", SUMMARY_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRuleGroupRequest, T> g) {
        return obj -> g.apply((CreateRuleGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRuleGroupRequest> {
        /**
         * <p>
         * The descriptive name of the rule group. You can't change the name of a rule group after you create it.
         * </p>
         * 
         * @param ruleGroupName
         *        The descriptive name of the rule group. You can't change the name of a rule group after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupName(String ruleGroupName);

        /**
         * <p>
         * An object that defines the rule group rules.
         * </p>
         * <note>
         * <p>
         * You must provide either this rule group setting or a <code>Rules</code> setting, but not both.
         * </p>
         * </note>
         * 
         * @param ruleGroup
         *        An object that defines the rule group rules. </p> <note>
         *        <p>
         *        You must provide either this rule group setting or a <code>Rules</code> setting, but not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroup(RuleGroup ruleGroup);

        /**
         * <p>
         * An object that defines the rule group rules.
         * </p>
         * <note>
         * <p>
         * You must provide either this rule group setting or a <code>Rules</code> setting, but not both.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link RuleGroup.Builder} avoiding the
         * need to create one manually via {@link RuleGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleGroup.Builder#build()} is called immediately and its result
         * is passed to {@link #ruleGroup(RuleGroup)}.
         * 
         * @param ruleGroup
         *        a consumer that will call methods on {@link RuleGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleGroup(RuleGroup)
         */
        default Builder ruleGroup(Consumer<RuleGroup.Builder> ruleGroup) {
            return ruleGroup(RuleGroup.builder().applyMutation(ruleGroup).build());
        }

        /**
         * <p>
         * A string containing stateful rule group rules specifications in Suricata flat format, with one rule per line.
         * Use this to import your existing Suricata compatible rule groups.
         * </p>
         * <note>
         * <p>
         * You must provide either this rules setting or a populated <code>RuleGroup</code> setting, but not both.
         * </p>
         * </note>
         * <p>
         * You can provide your rule group specification in Suricata flat format through this setting when you create or
         * update your rule group. The call response returns a <a>RuleGroup</a> object that Network Firewall has
         * populated from your string.
         * </p>
         * 
         * @param rules
         *        A string containing stateful rule group rules specifications in Suricata flat format, with one rule
         *        per line. Use this to import your existing Suricata compatible rule groups. </p> <note>
         *        <p>
         *        You must provide either this rules setting or a populated <code>RuleGroup</code> setting, but not
         *        both.
         *        </p>
         *        </note>
         *        <p>
         *        You can provide your rule group specification in Suricata flat format through this setting when you
         *        create or update your rule group. The call response returns a <a>RuleGroup</a> object that Network
         *        Firewall has populated from your string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(String rules);

        /**
         * <p>
         * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
         * stateless rules. If it is stateful, it contains stateful rules.
         * </p>
         * 
         * @param type
         *        Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
         *        stateless rules. If it is stateful, it contains stateful rules.
         * @see RuleGroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleGroupType
         */
        Builder type(String type);

        /**
         * <p>
         * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
         * stateless rules. If it is stateful, it contains stateful rules.
         * </p>
         * 
         * @param type
         *        Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
         *        stateless rules. If it is stateful, it contains stateful rules.
         * @see RuleGroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleGroupType
         */
        Builder type(RuleGroupType type);

        /**
         * <p>
         * A description of the rule group.
         * </p>
         * 
         * @param description
         *        A description of the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation. When
         * you update a rule group, you are limited to this capacity. When you reference a rule group from a firewall
         * policy, Network Firewall reserves this capacity for the rule group.
         * </p>
         * <p>
         * You can retrieve the capacity that would be required for a rule group before you create the rule group by
         * calling <a>CreateRuleGroup</a> with <code>DryRun</code> set to <code>TRUE</code>.
         * </p>
         * <note>
         * <p>
         * You can't change or exceed this capacity when you update the rule group, so leave room for your rule group to
         * grow.
         * </p>
         * </note>
         * <p>
         * <b>Capacity for a stateless rule group</b>
         * </p>
         * <p>
         * For a stateless rule group, the capacity required is the sum of the capacity requirements of the individual
         * rules that you expect to have in the rule group.
         * </p>
         * <p>
         * To calculate the capacity requirement of a single rule, multiply the capacity requirement values of each of
         * the rule's match settings:
         * </p>
         * <ul>
         * <li>
         * <p>
         * A match setting with no criteria specified has a value of 1.
         * </p>
         * </li>
         * <li>
         * <p>
         * A match setting with <code>Any</code> specified has a value of 1.
         * </p>
         * </li>
         * <li>
         * <p>
         * All other match settings have a value equal to the number of elements provided in the setting. For example, a
         * protocol setting ["UDP"] and a source setting ["10.0.0.0/24"] each have a value of 1. A protocol setting
         * ["UDP","TCP"] has a value of 2. A source setting ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"] has a value of
         * 3.
         * </p>
         * </li>
         * </ul>
         * <p>
         * A rule with no criteria specified in any of its match settings has a capacity requirement of 1. A rule with
         * protocol setting ["UDP","TCP"], source setting ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"], and a single
         * specification or no specification for each of the other match settings has a capacity requirement of 6.
         * </p>
         * <p>
         * <b>Capacity for a stateful rule group</b>
         * </p>
         * <p>
         * For a stateful rule group, the minimum capacity required is the number of individual rules that you expect to
         * have in the rule group.
         * </p>
         * 
         * @param capacity
         *        The maximum operating resources that this rule group can use. Rule group capacity is fixed at
         *        creation. When you update a rule group, you are limited to this capacity. When you reference a rule
         *        group from a firewall policy, Network Firewall reserves this capacity for the rule group. </p>
         *        <p>
         *        You can retrieve the capacity that would be required for a rule group before you create the rule group
         *        by calling <a>CreateRuleGroup</a> with <code>DryRun</code> set to <code>TRUE</code>.
         *        </p>
         *        <note>
         *        <p>
         *        You can't change or exceed this capacity when you update the rule group, so leave room for your rule
         *        group to grow.
         *        </p>
         *        </note>
         *        <p>
         *        <b>Capacity for a stateless rule group</b>
         *        </p>
         *        <p>
         *        For a stateless rule group, the capacity required is the sum of the capacity requirements of the
         *        individual rules that you expect to have in the rule group.
         *        </p>
         *        <p>
         *        To calculate the capacity requirement of a single rule, multiply the capacity requirement values of
         *        each of the rule's match settings:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A match setting with no criteria specified has a value of 1.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A match setting with <code>Any</code> specified has a value of 1.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        All other match settings have a value equal to the number of elements provided in the setting. For
         *        example, a protocol setting ["UDP"] and a source setting ["10.0.0.0/24"] each have a value of 1. A
         *        protocol setting ["UDP","TCP"] has a value of 2. A source setting
         *        ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"] has a value of 3.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        A rule with no criteria specified in any of its match settings has a capacity requirement of 1. A rule
         *        with protocol setting ["UDP","TCP"], source setting ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"], and a
         *        single specification or no specification for each of the other match settings has a capacity
         *        requirement of 6.
         *        </p>
         *        <p>
         *        <b>Capacity for a stateful rule group</b>
         *        </p>
         *        <p>
         *        For a stateful rule group, the minimum capacity required is the number of individual rules that you
         *        expect to have in the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacity(Integer capacity);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        The key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        The key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.networkfirewall.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Indicates whether you want Network Firewall to just check the validity of the request, rather than run the
         * request.
         * </p>
         * <p>
         * If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but doesn't
         * actually make the requested changes. The call returns the value that the request would return if you ran it
         * with dry run set to <code>FALSE</code>, but doesn't make additions or changes to your resources. This option
         * allows you to make sure that you have the required permissions to run the request and that your request
         * parameters are valid.
         * </p>
         * <p>
         * If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources.
         * </p>
         * 
         * @param dryRun
         *        Indicates whether you want Network Firewall to just check the validity of the request, rather than run
         *        the request. </p>
         *        <p>
         *        If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but
         *        doesn't actually make the requested changes. The call returns the value that the request would return
         *        if you ran it with dry run set to <code>FALSE</code>, but doesn't make additions or changes to your
         *        resources. This option allows you to make sure that you have the required permissions to run the
         *        request and that your request parameters are valid.
         *        </p>
         *        <p>
         *        If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * A complex type that contains settings for encryption of your rule group resources.
         * </p>
         * 
         * @param encryptionConfiguration
         *        A complex type that contains settings for encryption of your rule group resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * A complex type that contains settings for encryption of your rule group resources.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding
         * the need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }

        /**
         * <p>
         * A complex type that contains metadata about the rule group that your own rule group is copied from. You can
         * use the metadata to keep track of updates made to the originating rule group.
         * </p>
         * 
         * @param sourceMetadata
         *        A complex type that contains metadata about the rule group that your own rule group is copied from.
         *        You can use the metadata to keep track of updates made to the originating rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceMetadata(SourceMetadata sourceMetadata);

        /**
         * <p>
         * A complex type that contains metadata about the rule group that your own rule group is copied from. You can
         * use the metadata to keep track of updates made to the originating rule group.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceMetadata.Builder} avoiding the need
         * to create one manually via {@link SourceMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceMetadata(SourceMetadata)}.
         * 
         * @param sourceMetadata
         *        a consumer that will call methods on {@link SourceMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceMetadata(SourceMetadata)
         */
        default Builder sourceMetadata(Consumer<SourceMetadata.Builder> sourceMetadata) {
            return sourceMetadata(SourceMetadata.builder().applyMutation(sourceMetadata).build());
        }

        /**
         * <p>
         * Indicates whether you want Network Firewall to analyze the stateless rules in the rule group for rule
         * behavior such as asymmetric routing. If set to <code>TRUE</code>, Network Firewall runs the analysis and then
         * creates the rule group for you. To run the stateless rule group analyzer without creating the rule group, set
         * <code>DryRun</code> to <code>TRUE</code>.
         * </p>
         * 
         * @param analyzeRuleGroup
         *        Indicates whether you want Network Firewall to analyze the stateless rules in the rule group for rule
         *        behavior such as asymmetric routing. If set to <code>TRUE</code>, Network Firewall runs the analysis
         *        and then creates the rule group for you. To run the stateless rule group analyzer without creating the
         *        rule group, set <code>DryRun</code> to <code>TRUE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzeRuleGroup(Boolean analyzeRuleGroup);

        /**
         * <p>
         * An object that contains a <code>RuleOptions</code> array of strings. You use <code>RuleOptions</code> to
         * determine which of the following <a>RuleSummary</a> values are returned in response to
         * <code>DescribeRuleGroupSummary</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Metadata</code> - returns
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Msg</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SID</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param summaryConfiguration
         *        An object that contains a <code>RuleOptions</code> array of strings. You use <code>RuleOptions</code>
         *        to determine which of the following <a>RuleSummary</a> values are returned in response to
         *        <code>DescribeRuleGroupSummary</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Metadata</code> - returns
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Msg</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SID</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaryConfiguration(SummaryConfiguration summaryConfiguration);

        /**
         * <p>
         * An object that contains a <code>RuleOptions</code> array of strings. You use <code>RuleOptions</code> to
         * determine which of the following <a>RuleSummary</a> values are returned in response to
         * <code>DescribeRuleGroupSummary</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Metadata</code> - returns
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Msg</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SID</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link SummaryConfiguration.Builder} avoiding
         * the need to create one manually via {@link SummaryConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SummaryConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #summaryConfiguration(SummaryConfiguration)}.
         * 
         * @param summaryConfiguration
         *        a consumer that will call methods on {@link SummaryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summaryConfiguration(SummaryConfiguration)
         */
        default Builder summaryConfiguration(Consumer<SummaryConfiguration.Builder> summaryConfiguration) {
            return summaryConfiguration(SummaryConfiguration.builder().applyMutation(summaryConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFirewallRequest.BuilderImpl implements Builder {
        private String ruleGroupName;

        private RuleGroup ruleGroup;

        private String rules;

        private String type;

        private String description;

        private Integer capacity;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private EncryptionConfiguration encryptionConfiguration;

        private SourceMetadata sourceMetadata;

        private Boolean analyzeRuleGroup;

        private SummaryConfiguration summaryConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRuleGroupRequest model) {
            super(model);
            ruleGroupName(model.ruleGroupName);
            ruleGroup(model.ruleGroup);
            rules(model.rules);
            type(model.type);
            description(model.description);
            capacity(model.capacity);
            tags(model.tags);
            dryRun(model.dryRun);
            encryptionConfiguration(model.encryptionConfiguration);
            sourceMetadata(model.sourceMetadata);
            analyzeRuleGroup(model.analyzeRuleGroup);
            summaryConfiguration(model.summaryConfiguration);
        }

        public final String getRuleGroupName() {
            return ruleGroupName;
        }

        public final void setRuleGroupName(String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
        }

        @Override
        public final Builder ruleGroupName(String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
            return this;
        }

        public final RuleGroup.Builder getRuleGroup() {
            return ruleGroup != null ? ruleGroup.toBuilder() : null;
        }

        public final void setRuleGroup(RuleGroup.BuilderImpl ruleGroup) {
            this.ruleGroup = ruleGroup != null ? ruleGroup.build() : null;
        }

        @Override
        public final Builder ruleGroup(RuleGroup ruleGroup) {
            this.ruleGroup = ruleGroup;
            return this;
        }

        public final String getRules() {
            return rules;
        }

        public final void setRules(String rules) {
            this.rules = rules;
        }

        @Override
        public final Builder rules(String rules) {
            this.rules = rules;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RuleGroupType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getCapacity() {
            return capacity;
        }

        public final void setCapacity(Integer capacity) {
            this.capacity = capacity;
        }

        @Override
        public final Builder capacity(Integer capacity) {
            this.capacity = capacity;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final SourceMetadata.Builder getSourceMetadata() {
            return sourceMetadata != null ? sourceMetadata.toBuilder() : null;
        }

        public final void setSourceMetadata(SourceMetadata.BuilderImpl sourceMetadata) {
            this.sourceMetadata = sourceMetadata != null ? sourceMetadata.build() : null;
        }

        @Override
        public final Builder sourceMetadata(SourceMetadata sourceMetadata) {
            this.sourceMetadata = sourceMetadata;
            return this;
        }

        public final Boolean getAnalyzeRuleGroup() {
            return analyzeRuleGroup;
        }

        public final void setAnalyzeRuleGroup(Boolean analyzeRuleGroup) {
            this.analyzeRuleGroup = analyzeRuleGroup;
        }

        @Override
        public final Builder analyzeRuleGroup(Boolean analyzeRuleGroup) {
            this.analyzeRuleGroup = analyzeRuleGroup;
            return this;
        }

        public final SummaryConfiguration.Builder getSummaryConfiguration() {
            return summaryConfiguration != null ? summaryConfiguration.toBuilder() : null;
        }

        public final void setSummaryConfiguration(SummaryConfiguration.BuilderImpl summaryConfiguration) {
            this.summaryConfiguration = summaryConfiguration != null ? summaryConfiguration.build() : null;
        }

        @Override
        public final Builder summaryConfiguration(SummaryConfiguration summaryConfiguration) {
            this.summaryConfiguration = summaryConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRuleGroupRequest build() {
            return new CreateRuleGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
