/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProxyRequest extends NetworkFirewallRequest implements
        ToCopyableBuilder<CreateProxyRequest.Builder, CreateProxyRequest> {
    private static final SdkField<String> PROXY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyName").getter(getter(CreateProxyRequest::proxyName)).setter(setter(Builder::proxyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyName").build()).build();

    private static final SdkField<String> NAT_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NatGatewayId").getter(getter(CreateProxyRequest::natGatewayId)).setter(setter(Builder::natGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId").build()).build();

    private static final SdkField<String> PROXY_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyConfigurationName").getter(getter(CreateProxyRequest::proxyConfigurationName))
            .setter(setter(Builder::proxyConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationName").build())
            .build();

    private static final SdkField<String> PROXY_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyConfigurationArn").getter(getter(CreateProxyRequest::proxyConfigurationArn))
            .setter(setter(Builder::proxyConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationArn").build())
            .build();

    private static final SdkField<List<ListenerPropertyRequest>> LISTENER_PROPERTIES_FIELD = SdkField
            .<List<ListenerPropertyRequest>> builder(MarshallingType.LIST)
            .memberName("ListenerProperties")
            .getter(getter(CreateProxyRequest::listenerProperties))
            .setter(setter(Builder::listenerProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListenerPropertyRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListenerPropertyRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TlsInterceptPropertiesRequest> TLS_INTERCEPT_PROPERTIES_FIELD = SdkField
            .<TlsInterceptPropertiesRequest> builder(MarshallingType.SDK_POJO).memberName("TlsInterceptProperties")
            .getter(getter(CreateProxyRequest::tlsInterceptProperties)).setter(setter(Builder::tlsInterceptProperties))
            .constructor(TlsInterceptPropertiesRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsInterceptProperties").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateProxyRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_NAME_FIELD,
            NAT_GATEWAY_ID_FIELD, PROXY_CONFIGURATION_NAME_FIELD, PROXY_CONFIGURATION_ARN_FIELD, LISTENER_PROPERTIES_FIELD,
            TLS_INTERCEPT_PROPERTIES_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String proxyName;

    private final String natGatewayId;

    private final String proxyConfigurationName;

    private final String proxyConfigurationArn;

    private final List<ListenerPropertyRequest> listenerProperties;

    private final TlsInterceptPropertiesRequest tlsInterceptProperties;

    private final List<Tag> tags;

    private CreateProxyRequest(BuilderImpl builder) {
        super(builder);
        this.proxyName = builder.proxyName;
        this.natGatewayId = builder.natGatewayId;
        this.proxyConfigurationName = builder.proxyConfigurationName;
        this.proxyConfigurationArn = builder.proxyConfigurationArn;
        this.listenerProperties = builder.listenerProperties;
        this.tlsInterceptProperties = builder.tlsInterceptProperties;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The descriptive name of the proxy. You can't change the name of a proxy after you create it.
     * </p>
     * 
     * @return The descriptive name of the proxy. You can't change the name of a proxy after you create it.
     */
    public final String proxyName() {
        return proxyName;
    }

    /**
     * <p>
     * A unique identifier for the NAT gateway to use with proxy resources.
     * </p>
     * 
     * @return A unique identifier for the NAT gateway to use with proxy resources.
     */
    public final String natGatewayId() {
        return natGatewayId;
    }

    /**
     * <p>
     * The descriptive name of the proxy configuration. You can't change the name of a proxy configuration after you
     * create it.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The descriptive name of the proxy configuration. You can't change the name of a proxy configuration after
     *         you create it.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String proxyConfigurationName() {
        return proxyConfigurationName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a proxy configuration.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a proxy configuration.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String proxyConfigurationArn() {
        return proxyConfigurationArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ListenerProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasListenerProperties() {
        return listenerProperties != null && !(listenerProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Listener properties for HTTP and HTTPS traffic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListenerProperties} method.
     * </p>
     * 
     * @return Listener properties for HTTP and HTTPS traffic.
     */
    public final List<ListenerPropertyRequest> listenerProperties() {
        return listenerProperties;
    }

    /**
     * <p>
     * TLS decryption on traffic to filter on attributes in the HTTP header.
     * </p>
     * 
     * @return TLS decryption on traffic to filter on attributes in the HTTP header.
     */
    public final TlsInterceptPropertiesRequest tlsInterceptProperties() {
        return tlsInterceptProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key:value pairs to associate with the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The key:value pairs to associate with the resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(proxyName());
        hashCode = 31 * hashCode + Objects.hashCode(natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(proxyConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(proxyConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasListenerProperties() ? listenerProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tlsInterceptProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProxyRequest)) {
            return false;
        }
        CreateProxyRequest other = (CreateProxyRequest) obj;
        return Objects.equals(proxyName(), other.proxyName()) && Objects.equals(natGatewayId(), other.natGatewayId())
                && Objects.equals(proxyConfigurationName(), other.proxyConfigurationName())
                && Objects.equals(proxyConfigurationArn(), other.proxyConfigurationArn())
                && hasListenerProperties() == other.hasListenerProperties()
                && Objects.equals(listenerProperties(), other.listenerProperties())
                && Objects.equals(tlsInterceptProperties(), other.tlsInterceptProperties()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProxyRequest").add("ProxyName", proxyName()).add("NatGatewayId", natGatewayId())
                .add("ProxyConfigurationName", proxyConfigurationName()).add("ProxyConfigurationArn", proxyConfigurationArn())
                .add("ListenerProperties", hasListenerProperties() ? listenerProperties() : null)
                .add("TlsInterceptProperties", tlsInterceptProperties()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProxyName":
            return Optional.ofNullable(clazz.cast(proxyName()));
        case "NatGatewayId":
            return Optional.ofNullable(clazz.cast(natGatewayId()));
        case "ProxyConfigurationName":
            return Optional.ofNullable(clazz.cast(proxyConfigurationName()));
        case "ProxyConfigurationArn":
            return Optional.ofNullable(clazz.cast(proxyConfigurationArn()));
        case "ListenerProperties":
            return Optional.ofNullable(clazz.cast(listenerProperties()));
        case "TlsInterceptProperties":
            return Optional.ofNullable(clazz.cast(tlsInterceptProperties()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProxyName", PROXY_NAME_FIELD);
        map.put("NatGatewayId", NAT_GATEWAY_ID_FIELD);
        map.put("ProxyConfigurationName", PROXY_CONFIGURATION_NAME_FIELD);
        map.put("ProxyConfigurationArn", PROXY_CONFIGURATION_ARN_FIELD);
        map.put("ListenerProperties", LISTENER_PROPERTIES_FIELD);
        map.put("TlsInterceptProperties", TLS_INTERCEPT_PROPERTIES_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProxyRequest, T> g) {
        return obj -> g.apply((CreateProxyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateProxyRequest> {
        /**
         * <p>
         * The descriptive name of the proxy. You can't change the name of a proxy after you create it.
         * </p>
         * 
         * @param proxyName
         *        The descriptive name of the proxy. You can't change the name of a proxy after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyName(String proxyName);

        /**
         * <p>
         * A unique identifier for the NAT gateway to use with proxy resources.
         * </p>
         * 
         * @param natGatewayId
         *        A unique identifier for the NAT gateway to use with proxy resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGatewayId(String natGatewayId);

        /**
         * <p>
         * The descriptive name of the proxy configuration. You can't change the name of a proxy configuration after you
         * create it.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param proxyConfigurationName
         *        The descriptive name of the proxy configuration. You can't change the name of a proxy configuration
         *        after you create it.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyConfigurationName(String proxyConfigurationName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a proxy configuration.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param proxyConfigurationArn
         *        The Amazon Resource Name (ARN) of a proxy configuration.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyConfigurationArn(String proxyConfigurationArn);

        /**
         * <p>
         * Listener properties for HTTP and HTTPS traffic.
         * </p>
         * 
         * @param listenerProperties
         *        Listener properties for HTTP and HTTPS traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerProperties(Collection<ListenerPropertyRequest> listenerProperties);

        /**
         * <p>
         * Listener properties for HTTP and HTTPS traffic.
         * </p>
         * 
         * @param listenerProperties
         *        Listener properties for HTTP and HTTPS traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerProperties(ListenerPropertyRequest... listenerProperties);

        /**
         * <p>
         * Listener properties for HTTP and HTTPS traffic.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.ListenerPropertyRequest.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.networkfirewall.model.ListenerPropertyRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.ListenerPropertyRequest.Builder#build()} is
         * called immediately and its result is passed to {@link #listenerProperties(List<ListenerPropertyRequest>)}.
         * 
         * @param listenerProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.ListenerPropertyRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listenerProperties(java.util.Collection<ListenerPropertyRequest>)
         */
        Builder listenerProperties(Consumer<ListenerPropertyRequest.Builder>... listenerProperties);

        /**
         * <p>
         * TLS decryption on traffic to filter on attributes in the HTTP header.
         * </p>
         * 
         * @param tlsInterceptProperties
         *        TLS decryption on traffic to filter on attributes in the HTTP header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsInterceptProperties(TlsInterceptPropertiesRequest tlsInterceptProperties);

        /**
         * <p>
         * TLS decryption on traffic to filter on attributes in the HTTP header.
         * </p>
         * This is a convenience method that creates an instance of the {@link TlsInterceptPropertiesRequest.Builder}
         * avoiding the need to create one manually via {@link TlsInterceptPropertiesRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TlsInterceptPropertiesRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #tlsInterceptProperties(TlsInterceptPropertiesRequest)}.
         * 
         * @param tlsInterceptProperties
         *        a consumer that will call methods on {@link TlsInterceptPropertiesRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tlsInterceptProperties(TlsInterceptPropertiesRequest)
         */
        default Builder tlsInterceptProperties(Consumer<TlsInterceptPropertiesRequest.Builder> tlsInterceptProperties) {
            return tlsInterceptProperties(TlsInterceptPropertiesRequest.builder().applyMutation(tlsInterceptProperties).build());
        }

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        The key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        The key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.networkfirewall.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFirewallRequest.BuilderImpl implements Builder {
        private String proxyName;

        private String natGatewayId;

        private String proxyConfigurationName;

        private String proxyConfigurationArn;

        private List<ListenerPropertyRequest> listenerProperties = DefaultSdkAutoConstructList.getInstance();

        private TlsInterceptPropertiesRequest tlsInterceptProperties;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProxyRequest model) {
            super(model);
            proxyName(model.proxyName);
            natGatewayId(model.natGatewayId);
            proxyConfigurationName(model.proxyConfigurationName);
            proxyConfigurationArn(model.proxyConfigurationArn);
            listenerProperties(model.listenerProperties);
            tlsInterceptProperties(model.tlsInterceptProperties);
            tags(model.tags);
        }

        public final String getProxyName() {
            return proxyName;
        }

        public final void setProxyName(String proxyName) {
            this.proxyName = proxyName;
        }

        @Override
        public final Builder proxyName(String proxyName) {
            this.proxyName = proxyName;
            return this;
        }

        public final String getNatGatewayId() {
            return natGatewayId;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final String getProxyConfigurationName() {
            return proxyConfigurationName;
        }

        public final void setProxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
        }

        @Override
        public final Builder proxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
            return this;
        }

        public final String getProxyConfigurationArn() {
            return proxyConfigurationArn;
        }

        public final void setProxyConfigurationArn(String proxyConfigurationArn) {
            this.proxyConfigurationArn = proxyConfigurationArn;
        }

        @Override
        public final Builder proxyConfigurationArn(String proxyConfigurationArn) {
            this.proxyConfigurationArn = proxyConfigurationArn;
            return this;
        }

        public final List<ListenerPropertyRequest.Builder> getListenerProperties() {
            List<ListenerPropertyRequest.Builder> result = ListenerPropertiesRequestCopier.copyToBuilder(this.listenerProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListenerProperties(Collection<ListenerPropertyRequest.BuilderImpl> listenerProperties) {
            this.listenerProperties = ListenerPropertiesRequestCopier.copyFromBuilder(listenerProperties);
        }

        @Override
        public final Builder listenerProperties(Collection<ListenerPropertyRequest> listenerProperties) {
            this.listenerProperties = ListenerPropertiesRequestCopier.copy(listenerProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerProperties(ListenerPropertyRequest... listenerProperties) {
            listenerProperties(Arrays.asList(listenerProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerProperties(Consumer<ListenerPropertyRequest.Builder>... listenerProperties) {
            listenerProperties(Stream.of(listenerProperties).map(c -> ListenerPropertyRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final TlsInterceptPropertiesRequest.Builder getTlsInterceptProperties() {
            return tlsInterceptProperties != null ? tlsInterceptProperties.toBuilder() : null;
        }

        public final void setTlsInterceptProperties(TlsInterceptPropertiesRequest.BuilderImpl tlsInterceptProperties) {
            this.tlsInterceptProperties = tlsInterceptProperties != null ? tlsInterceptProperties.build() : null;
        }

        @Override
        public final Builder tlsInterceptProperties(TlsInterceptPropertiesRequest tlsInterceptProperties) {
            this.tlsInterceptProperties = tlsInterceptProperties;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProxyRequest build() {
            return new CreateProxyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
