/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFirewallRequest extends NetworkFirewallRequest implements
        ToCopyableBuilder<CreateFirewallRequest.Builder, CreateFirewallRequest> {
    private static final SdkField<String> FIREWALL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallName").getter(getter(CreateFirewallRequest::firewallName)).setter(setter(Builder::firewallName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallName").build()).build();

    private static final SdkField<String> FIREWALL_POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallPolicyArn").getter(getter(CreateFirewallRequest::firewallPolicyArn))
            .setter(setter(Builder::firewallPolicyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyArn").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(CreateFirewallRequest::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<List<SubnetMapping>> SUBNET_MAPPINGS_FIELD = SdkField
            .<List<SubnetMapping>> builder(MarshallingType.LIST)
            .memberName("SubnetMappings")
            .getter(getter(CreateFirewallRequest::subnetMappings))
            .setter(setter(Builder::subnetMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubnetMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubnetMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DELETE_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteProtection").getter(getter(CreateFirewallRequest::deleteProtection))
            .setter(setter(Builder::deleteProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteProtection").build()).build();

    private static final SdkField<Boolean> SUBNET_CHANGE_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SubnetChangeProtection").getter(getter(CreateFirewallRequest::subnetChangeProtection))
            .setter(setter(Builder::subnetChangeProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetChangeProtection").build())
            .build();

    private static final SdkField<Boolean> FIREWALL_POLICY_CHANGE_PROTECTION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FirewallPolicyChangeProtection")
            .getter(getter(CreateFirewallRequest::firewallPolicyChangeProtection))
            .setter(setter(Builder::firewallPolicyChangeProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyChangeProtection")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateFirewallRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateFirewallRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("EncryptionConfiguration")
            .getter(getter(CreateFirewallRequest::encryptionConfiguration)).setter(setter(Builder::encryptionConfiguration))
            .constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build())
            .build();

    private static final SdkField<List<String>> ENABLED_ANALYSIS_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnabledAnalysisTypes")
            .getter(getter(CreateFirewallRequest::enabledAnalysisTypesAsStrings))
            .setter(setter(Builder::enabledAnalysisTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledAnalysisTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayId").getter(getter(CreateFirewallRequest::transitGatewayId))
            .setter(setter(Builder::transitGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId").build()).build();

    private static final SdkField<List<AvailabilityZoneMapping>> AVAILABILITY_ZONE_MAPPINGS_FIELD = SdkField
            .<List<AvailabilityZoneMapping>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZoneMappings")
            .getter(getter(CreateFirewallRequest::availabilityZoneMappings))
            .setter(setter(Builder::availabilityZoneMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AvailabilityZoneMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(AvailabilityZoneMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> AVAILABILITY_ZONE_CHANGE_PROTECTION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AvailabilityZoneChangeProtection")
            .getter(getter(CreateFirewallRequest::availabilityZoneChangeProtection))
            .setter(setter(Builder::availabilityZoneChangeProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneChangeProtection")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_NAME_FIELD,
            FIREWALL_POLICY_ARN_FIELD, VPC_ID_FIELD, SUBNET_MAPPINGS_FIELD, DELETE_PROTECTION_FIELD,
            SUBNET_CHANGE_PROTECTION_FIELD, FIREWALL_POLICY_CHANGE_PROTECTION_FIELD, DESCRIPTION_FIELD, TAGS_FIELD,
            ENCRYPTION_CONFIGURATION_FIELD, ENABLED_ANALYSIS_TYPES_FIELD, TRANSIT_GATEWAY_ID_FIELD,
            AVAILABILITY_ZONE_MAPPINGS_FIELD, AVAILABILITY_ZONE_CHANGE_PROTECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String firewallName;

    private final String firewallPolicyArn;

    private final String vpcId;

    private final List<SubnetMapping> subnetMappings;

    private final Boolean deleteProtection;

    private final Boolean subnetChangeProtection;

    private final Boolean firewallPolicyChangeProtection;

    private final String description;

    private final List<Tag> tags;

    private final EncryptionConfiguration encryptionConfiguration;

    private final List<String> enabledAnalysisTypes;

    private final String transitGatewayId;

    private final List<AvailabilityZoneMapping> availabilityZoneMappings;

    private final Boolean availabilityZoneChangeProtection;

    private CreateFirewallRequest(BuilderImpl builder) {
        super(builder);
        this.firewallName = builder.firewallName;
        this.firewallPolicyArn = builder.firewallPolicyArn;
        this.vpcId = builder.vpcId;
        this.subnetMappings = builder.subnetMappings;
        this.deleteProtection = builder.deleteProtection;
        this.subnetChangeProtection = builder.subnetChangeProtection;
        this.firewallPolicyChangeProtection = builder.firewallPolicyChangeProtection;
        this.description = builder.description;
        this.tags = builder.tags;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.enabledAnalysisTypes = builder.enabledAnalysisTypes;
        this.transitGatewayId = builder.transitGatewayId;
        this.availabilityZoneMappings = builder.availabilityZoneMappings;
        this.availabilityZoneChangeProtection = builder.availabilityZoneChangeProtection;
    }

    /**
     * <p>
     * The descriptive name of the firewall. You can't change the name of a firewall after you create it.
     * </p>
     * 
     * @return The descriptive name of the firewall. You can't change the name of a firewall after you create it.
     */
    public final String firewallName() {
        return firewallName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the <a>FirewallPolicy</a> that you want to use for the firewall.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the <a>FirewallPolicy</a> that you want to use for the firewall.
     */
    public final String firewallPolicyArn() {
        return firewallPolicyArn;
    }

    /**
     * <p>
     * The unique identifier of the VPC where Network Firewall should create the firewall.
     * </p>
     * <p>
     * You can't change this setting after you create the firewall.
     * </p>
     * 
     * @return The unique identifier of the VPC where Network Firewall should create the firewall. </p>
     *         <p>
     *         You can't change this setting after you create the firewall.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetMappings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubnetMappings() {
        return subnetMappings != null && !(subnetMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The public subnets to use for your Network Firewall firewalls. Each subnet must belong to a different
     * Availability Zone in the VPC. Network Firewall creates a firewall endpoint in each subnet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetMappings} method.
     * </p>
     * 
     * @return The public subnets to use for your Network Firewall firewalls. Each subnet must belong to a different
     *         Availability Zone in the VPC. Network Firewall creates a firewall endpoint in each subnet.
     */
    public final List<SubnetMapping> subnetMappings() {
        return subnetMappings;
    }

    /**
     * <p>
     * A flag indicating whether it is possible to delete the firewall. A setting of <code>TRUE</code> indicates that
     * the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall
     * that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code>.
     * </p>
     * 
     * @return A flag indicating whether it is possible to delete the firewall. A setting of <code>TRUE</code> indicates
     *         that the firewall is protected against deletion. Use this setting to protect against accidentally
     *         deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to
     *         <code>TRUE</code>.
     */
    public final Boolean deleteProtection() {
        return deleteProtection;
    }

    /**
     * <p>
     * A setting indicating whether the firewall is protected against changes to the subnet associations. Use this
     * setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When you
     * create a firewall, the operation initializes this setting to <code>TRUE</code>.
     * </p>
     * 
     * @return A setting indicating whether the firewall is protected against changes to the subnet associations. Use
     *         this setting to protect against accidentally modifying the subnet associations for a firewall that is in
     *         use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.
     */
    public final Boolean subnetChangeProtection() {
        return subnetChangeProtection;
    }

    /**
     * <p>
     * A setting indicating whether the firewall is protected against a change to the firewall policy association. Use
     * this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When
     * you create a firewall, the operation initializes this setting to <code>TRUE</code>.
     * </p>
     * 
     * @return A setting indicating whether the firewall is protected against a change to the firewall policy
     *         association. Use this setting to protect against accidentally modifying the firewall policy for a
     *         firewall that is in use. When you create a firewall, the operation initializes this setting to
     *         <code>TRUE</code>.
     */
    public final Boolean firewallPolicyChangeProtection() {
        return firewallPolicyChangeProtection;
    }

    /**
     * <p>
     * A description of the firewall.
     * </p>
     * 
     * @return A description of the firewall.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key:value pairs to associate with the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The key:value pairs to associate with the resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A complex type that contains settings for encryption of your firewall resources.
     * </p>
     * 
     * @return A complex type that contains settings for encryption of your firewall resources.
     */
    public final EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    /**
     * <p>
     * An optional setting indicating the specific traffic analysis types to enable on the firewall.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledAnalysisTypes} method.
     * </p>
     * 
     * @return An optional setting indicating the specific traffic analysis types to enable on the firewall.
     */
    public final List<EnabledAnalysisType> enabledAnalysisTypes() {
        return EnabledAnalysisTypesCopier.copyStringToEnum(enabledAnalysisTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the EnabledAnalysisTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnabledAnalysisTypes() {
        return enabledAnalysisTypes != null && !(enabledAnalysisTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional setting indicating the specific traffic analysis types to enable on the firewall.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledAnalysisTypes} method.
     * </p>
     * 
     * @return An optional setting indicating the specific traffic analysis types to enable on the firewall.
     */
    public final List<String> enabledAnalysisTypesAsStrings() {
        return enabledAnalysisTypes;
    }

    /**
     * <p>
     * Required when creating a transit gateway-attached firewall. The unique identifier of the transit gateway to
     * attach to this firewall. You can provide either a transit gateway from your account or one that has been shared
     * with you through Resource Access Manager.
     * </p>
     * <important>
     * <p>
     * After creating the firewall, you cannot change the transit gateway association. To use a different transit
     * gateway, you must create a new firewall.
     * </p>
     * </important>
     * <p>
     * For information about creating firewalls, see <a>CreateFirewall</a>. For specific guidance about transit
     * gateway-attached firewalls, see <a
     * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tgw-firewall-considerations.html"
     * >Considerations for transit gateway-attached firewalls</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     * 
     * @return Required when creating a transit gateway-attached firewall. The unique identifier of the transit gateway
     *         to attach to this firewall. You can provide either a transit gateway from your account or one that has
     *         been shared with you through Resource Access Manager.</p> <important>
     *         <p>
     *         After creating the firewall, you cannot change the transit gateway association. To use a different
     *         transit gateway, you must create a new firewall.
     *         </p>
     *         </important>
     *         <p>
     *         For information about creating firewalls, see <a>CreateFirewall</a>. For specific guidance about transit
     *         gateway-attached firewalls, see <a href=
     *         "https://docs.aws.amazon.com/network-firewall/latest/developerguide/tgw-firewall-considerations.html"
     *         >Considerations for transit gateway-attached firewalls</a> in the <i>Network Firewall Developer
     *         Guide</i>.
     */
    public final String transitGatewayId() {
        return transitGatewayId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZoneMappings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAvailabilityZoneMappings() {
        return availabilityZoneMappings != null && !(availabilityZoneMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Required. The Availability Zones where you want to create firewall endpoints for a transit gateway-attached
     * firewall. You must specify at least one Availability Zone. Consider enabling the firewall in every Availability
     * Zone where you have workloads to maintain Availability Zone isolation.
     * </p>
     * <p>
     * You can modify Availability Zones later using <a>AssociateAvailabilityZones</a> or
     * <a>DisassociateAvailabilityZones</a>, but this may briefly disrupt traffic. The
     * <code>AvailabilityZoneChangeProtection</code> setting controls whether you can make these modifications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZoneMappings} method.
     * </p>
     * 
     * @return Required. The Availability Zones where you want to create firewall endpoints for a transit
     *         gateway-attached firewall. You must specify at least one Availability Zone. Consider enabling the
     *         firewall in every Availability Zone where you have workloads to maintain Availability Zone isolation.</p>
     *         <p>
     *         You can modify Availability Zones later using <a>AssociateAvailabilityZones</a> or
     *         <a>DisassociateAvailabilityZones</a>, but this may briefly disrupt traffic. The
     *         <code>AvailabilityZoneChangeProtection</code> setting controls whether you can make these modifications.
     */
    public final List<AvailabilityZoneMapping> availabilityZoneMappings() {
        return availabilityZoneMappings;
    }

    /**
     * <p>
     * Optional. A setting indicating whether the firewall is protected against changes to its Availability Zone
     * configuration. When set to <code>TRUE</code>, you cannot add or remove Availability Zones without first disabling
     * this protection using <a>UpdateAvailabilityZoneChangeProtection</a>.
     * </p>
     * <p>
     * Default value: <code>FALSE</code>
     * </p>
     * 
     * @return Optional. A setting indicating whether the firewall is protected against changes to its Availability Zone
     *         configuration. When set to <code>TRUE</code>, you cannot add or remove Availability Zones without first
     *         disabling this protection using <a>UpdateAvailabilityZoneChangeProtection</a>.</p>
     *         <p>
     *         Default value: <code>FALSE</code>
     */
    public final Boolean availabilityZoneChangeProtection() {
        return availabilityZoneChangeProtection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(firewallName());
        hashCode = 31 * hashCode + Objects.hashCode(firewallPolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetMappings() ? subnetMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deleteProtection());
        hashCode = 31 * hashCode + Objects.hashCode(subnetChangeProtection());
        hashCode = 31 * hashCode + Objects.hashCode(firewallPolicyChangeProtection());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnabledAnalysisTypes() ? enabledAnalysisTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZoneMappings() ? availabilityZoneMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneChangeProtection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFirewallRequest)) {
            return false;
        }
        CreateFirewallRequest other = (CreateFirewallRequest) obj;
        return Objects.equals(firewallName(), other.firewallName())
                && Objects.equals(firewallPolicyArn(), other.firewallPolicyArn()) && Objects.equals(vpcId(), other.vpcId())
                && hasSubnetMappings() == other.hasSubnetMappings() && Objects.equals(subnetMappings(), other.subnetMappings())
                && Objects.equals(deleteProtection(), other.deleteProtection())
                && Objects.equals(subnetChangeProtection(), other.subnetChangeProtection())
                && Objects.equals(firewallPolicyChangeProtection(), other.firewallPolicyChangeProtection())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration())
                && hasEnabledAnalysisTypes() == other.hasEnabledAnalysisTypes()
                && Objects.equals(enabledAnalysisTypesAsStrings(), other.enabledAnalysisTypesAsStrings())
                && Objects.equals(transitGatewayId(), other.transitGatewayId())
                && hasAvailabilityZoneMappings() == other.hasAvailabilityZoneMappings()
                && Objects.equals(availabilityZoneMappings(), other.availabilityZoneMappings())
                && Objects.equals(availabilityZoneChangeProtection(), other.availabilityZoneChangeProtection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFirewallRequest").add("FirewallName", firewallName())
                .add("FirewallPolicyArn", firewallPolicyArn()).add("VpcId", vpcId())
                .add("SubnetMappings", hasSubnetMappings() ? subnetMappings() : null).add("DeleteProtection", deleteProtection())
                .add("SubnetChangeProtection", subnetChangeProtection())
                .add("FirewallPolicyChangeProtection", firewallPolicyChangeProtection()).add("Description", description())
                .add("Tags", hasTags() ? tags() : null).add("EncryptionConfiguration", encryptionConfiguration())
                .add("EnabledAnalysisTypes", hasEnabledAnalysisTypes() ? enabledAnalysisTypesAsStrings() : null)
                .add("TransitGatewayId", transitGatewayId())
                .add("AvailabilityZoneMappings", hasAvailabilityZoneMappings() ? availabilityZoneMappings() : null)
                .add("AvailabilityZoneChangeProtection", availabilityZoneChangeProtection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallName":
            return Optional.ofNullable(clazz.cast(firewallName()));
        case "FirewallPolicyArn":
            return Optional.ofNullable(clazz.cast(firewallPolicyArn()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "SubnetMappings":
            return Optional.ofNullable(clazz.cast(subnetMappings()));
        case "DeleteProtection":
            return Optional.ofNullable(clazz.cast(deleteProtection()));
        case "SubnetChangeProtection":
            return Optional.ofNullable(clazz.cast(subnetChangeProtection()));
        case "FirewallPolicyChangeProtection":
            return Optional.ofNullable(clazz.cast(firewallPolicyChangeProtection()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "EncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        case "EnabledAnalysisTypes":
            return Optional.ofNullable(clazz.cast(enabledAnalysisTypesAsStrings()));
        case "TransitGatewayId":
            return Optional.ofNullable(clazz.cast(transitGatewayId()));
        case "AvailabilityZoneMappings":
            return Optional.ofNullable(clazz.cast(availabilityZoneMappings()));
        case "AvailabilityZoneChangeProtection":
            return Optional.ofNullable(clazz.cast(availabilityZoneChangeProtection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FirewallName", FIREWALL_NAME_FIELD);
        map.put("FirewallPolicyArn", FIREWALL_POLICY_ARN_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("SubnetMappings", SUBNET_MAPPINGS_FIELD);
        map.put("DeleteProtection", DELETE_PROTECTION_FIELD);
        map.put("SubnetChangeProtection", SUBNET_CHANGE_PROTECTION_FIELD);
        map.put("FirewallPolicyChangeProtection", FIREWALL_POLICY_CHANGE_PROTECTION_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("EncryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("EnabledAnalysisTypes", ENABLED_ANALYSIS_TYPES_FIELD);
        map.put("TransitGatewayId", TRANSIT_GATEWAY_ID_FIELD);
        map.put("AvailabilityZoneMappings", AVAILABILITY_ZONE_MAPPINGS_FIELD);
        map.put("AvailabilityZoneChangeProtection", AVAILABILITY_ZONE_CHANGE_PROTECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFirewallRequest, T> g) {
        return obj -> g.apply((CreateFirewallRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFirewallRequest> {
        /**
         * <p>
         * The descriptive name of the firewall. You can't change the name of a firewall after you create it.
         * </p>
         * 
         * @param firewallName
         *        The descriptive name of the firewall. You can't change the name of a firewall after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallName(String firewallName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the <a>FirewallPolicy</a> that you want to use for the firewall.
         * </p>
         * 
         * @param firewallPolicyArn
         *        The Amazon Resource Name (ARN) of the <a>FirewallPolicy</a> that you want to use for the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallPolicyArn(String firewallPolicyArn);

        /**
         * <p>
         * The unique identifier of the VPC where Network Firewall should create the firewall.
         * </p>
         * <p>
         * You can't change this setting after you create the firewall.
         * </p>
         * 
         * @param vpcId
         *        The unique identifier of the VPC where Network Firewall should create the firewall. </p>
         *        <p>
         *        You can't change this setting after you create the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The public subnets to use for your Network Firewall firewalls. Each subnet must belong to a different
         * Availability Zone in the VPC. Network Firewall creates a firewall endpoint in each subnet.
         * </p>
         * 
         * @param subnetMappings
         *        The public subnets to use for your Network Firewall firewalls. Each subnet must belong to a different
         *        Availability Zone in the VPC. Network Firewall creates a firewall endpoint in each subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetMappings(Collection<SubnetMapping> subnetMappings);

        /**
         * <p>
         * The public subnets to use for your Network Firewall firewalls. Each subnet must belong to a different
         * Availability Zone in the VPC. Network Firewall creates a firewall endpoint in each subnet.
         * </p>
         * 
         * @param subnetMappings
         *        The public subnets to use for your Network Firewall firewalls. Each subnet must belong to a different
         *        Availability Zone in the VPC. Network Firewall creates a firewall endpoint in each subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetMappings(SubnetMapping... subnetMappings);

        /**
         * <p>
         * The public subnets to use for your Network Firewall firewalls. Each subnet must belong to a different
         * Availability Zone in the VPC. Network Firewall creates a firewall endpoint in each subnet.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.SubnetMapping.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.networkfirewall.model.SubnetMapping#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.SubnetMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #subnetMappings(List<SubnetMapping>)}.
         * 
         * @param subnetMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.SubnetMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnetMappings(java.util.Collection<SubnetMapping>)
         */
        Builder subnetMappings(Consumer<SubnetMapping.Builder>... subnetMappings);

        /**
         * <p>
         * A flag indicating whether it is possible to delete the firewall. A setting of <code>TRUE</code> indicates
         * that the firewall is protected against deletion. Use this setting to protect against accidentally deleting a
         * firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code>
         * .
         * </p>
         * 
         * @param deleteProtection
         *        A flag indicating whether it is possible to delete the firewall. A setting of <code>TRUE</code>
         *        indicates that the firewall is protected against deletion. Use this setting to protect against
         *        accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes
         *        this flag to <code>TRUE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteProtection(Boolean deleteProtection);

        /**
         * <p>
         * A setting indicating whether the firewall is protected against changes to the subnet associations. Use this
         * setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When
         * you create a firewall, the operation initializes this setting to <code>TRUE</code>.
         * </p>
         * 
         * @param subnetChangeProtection
         *        A setting indicating whether the firewall is protected against changes to the subnet associations. Use
         *        this setting to protect against accidentally modifying the subnet associations for a firewall that is
         *        in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetChangeProtection(Boolean subnetChangeProtection);

        /**
         * <p>
         * A setting indicating whether the firewall is protected against a change to the firewall policy association.
         * Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use.
         * When you create a firewall, the operation initializes this setting to <code>TRUE</code>.
         * </p>
         * 
         * @param firewallPolicyChangeProtection
         *        A setting indicating whether the firewall is protected against a change to the firewall policy
         *        association. Use this setting to protect against accidentally modifying the firewall policy for a
         *        firewall that is in use. When you create a firewall, the operation initializes this setting to
         *        <code>TRUE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallPolicyChangeProtection(Boolean firewallPolicyChangeProtection);

        /**
         * <p>
         * A description of the firewall.
         * </p>
         * 
         * @param description
         *        A description of the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        The key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        The key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.networkfirewall.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A complex type that contains settings for encryption of your firewall resources.
         * </p>
         * 
         * @param encryptionConfiguration
         *        A complex type that contains settings for encryption of your firewall resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * A complex type that contains settings for encryption of your firewall resources.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding
         * the need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }

        /**
         * <p>
         * An optional setting indicating the specific traffic analysis types to enable on the firewall.
         * </p>
         * 
         * @param enabledAnalysisTypes
         *        An optional setting indicating the specific traffic analysis types to enable on the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledAnalysisTypesWithStrings(Collection<String> enabledAnalysisTypes);

        /**
         * <p>
         * An optional setting indicating the specific traffic analysis types to enable on the firewall.
         * </p>
         * 
         * @param enabledAnalysisTypes
         *        An optional setting indicating the specific traffic analysis types to enable on the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledAnalysisTypesWithStrings(String... enabledAnalysisTypes);

        /**
         * <p>
         * An optional setting indicating the specific traffic analysis types to enable on the firewall.
         * </p>
         * 
         * @param enabledAnalysisTypes
         *        An optional setting indicating the specific traffic analysis types to enable on the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledAnalysisTypes(Collection<EnabledAnalysisType> enabledAnalysisTypes);

        /**
         * <p>
         * An optional setting indicating the specific traffic analysis types to enable on the firewall.
         * </p>
         * 
         * @param enabledAnalysisTypes
         *        An optional setting indicating the specific traffic analysis types to enable on the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledAnalysisTypes(EnabledAnalysisType... enabledAnalysisTypes);

        /**
         * <p>
         * Required when creating a transit gateway-attached firewall. The unique identifier of the transit gateway to
         * attach to this firewall. You can provide either a transit gateway from your account or one that has been
         * shared with you through Resource Access Manager.
         * </p>
         * <important>
         * <p>
         * After creating the firewall, you cannot change the transit gateway association. To use a different transit
         * gateway, you must create a new firewall.
         * </p>
         * </important>
         * <p>
         * For information about creating firewalls, see <a>CreateFirewall</a>. For specific guidance about transit
         * gateway-attached firewalls, see <a
         * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tgw-firewall-considerations.html"
         * >Considerations for transit gateway-attached firewalls</a> in the <i>Network Firewall Developer Guide</i>.
         * </p>
         * 
         * @param transitGatewayId
         *        Required when creating a transit gateway-attached firewall. The unique identifier of the transit
         *        gateway to attach to this firewall. You can provide either a transit gateway from your account or one
         *        that has been shared with you through Resource Access Manager.</p> <important>
         *        <p>
         *        After creating the firewall, you cannot change the transit gateway association. To use a different
         *        transit gateway, you must create a new firewall.
         *        </p>
         *        </important>
         *        <p>
         *        For information about creating firewalls, see <a>CreateFirewall</a>. For specific guidance about
         *        transit gateway-attached firewalls, see <a href=
         *        "https://docs.aws.amazon.com/network-firewall/latest/developerguide/tgw-firewall-considerations.html"
         *        >Considerations for transit gateway-attached firewalls</a> in the <i>Network Firewall Developer
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayId(String transitGatewayId);

        /**
         * <p>
         * Required. The Availability Zones where you want to create firewall endpoints for a transit gateway-attached
         * firewall. You must specify at least one Availability Zone. Consider enabling the firewall in every
         * Availability Zone where you have workloads to maintain Availability Zone isolation.
         * </p>
         * <p>
         * You can modify Availability Zones later using <a>AssociateAvailabilityZones</a> or
         * <a>DisassociateAvailabilityZones</a>, but this may briefly disrupt traffic. The
         * <code>AvailabilityZoneChangeProtection</code> setting controls whether you can make these modifications.
         * </p>
         * 
         * @param availabilityZoneMappings
         *        Required. The Availability Zones where you want to create firewall endpoints for a transit
         *        gateway-attached firewall. You must specify at least one Availability Zone. Consider enabling the
         *        firewall in every Availability Zone where you have workloads to maintain Availability Zone
         *        isolation.</p>
         *        <p>
         *        You can modify Availability Zones later using <a>AssociateAvailabilityZones</a> or
         *        <a>DisassociateAvailabilityZones</a>, but this may briefly disrupt traffic. The
         *        <code>AvailabilityZoneChangeProtection</code> setting controls whether you can make these
         *        modifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneMappings(Collection<AvailabilityZoneMapping> availabilityZoneMappings);

        /**
         * <p>
         * Required. The Availability Zones where you want to create firewall endpoints for a transit gateway-attached
         * firewall. You must specify at least one Availability Zone. Consider enabling the firewall in every
         * Availability Zone where you have workloads to maintain Availability Zone isolation.
         * </p>
         * <p>
         * You can modify Availability Zones later using <a>AssociateAvailabilityZones</a> or
         * <a>DisassociateAvailabilityZones</a>, but this may briefly disrupt traffic. The
         * <code>AvailabilityZoneChangeProtection</code> setting controls whether you can make these modifications.
         * </p>
         * 
         * @param availabilityZoneMappings
         *        Required. The Availability Zones where you want to create firewall endpoints for a transit
         *        gateway-attached firewall. You must specify at least one Availability Zone. Consider enabling the
         *        firewall in every Availability Zone where you have workloads to maintain Availability Zone
         *        isolation.</p>
         *        <p>
         *        You can modify Availability Zones later using <a>AssociateAvailabilityZones</a> or
         *        <a>DisassociateAvailabilityZones</a>, but this may briefly disrupt traffic. The
         *        <code>AvailabilityZoneChangeProtection</code> setting controls whether you can make these
         *        modifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneMappings(AvailabilityZoneMapping... availabilityZoneMappings);

        /**
         * <p>
         * Required. The Availability Zones where you want to create firewall endpoints for a transit gateway-attached
         * firewall. You must specify at least one Availability Zone. Consider enabling the firewall in every
         * Availability Zone where you have workloads to maintain Availability Zone isolation.
         * </p>
         * <p>
         * You can modify Availability Zones later using <a>AssociateAvailabilityZones</a> or
         * <a>DisassociateAvailabilityZones</a>, but this may briefly disrupt traffic. The
         * <code>AvailabilityZoneChangeProtection</code> setting controls whether you can make these modifications.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.AvailabilityZoneMapping.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.networkfirewall.model.AvailabilityZoneMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.AvailabilityZoneMapping.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #availabilityZoneMappings(List<AvailabilityZoneMapping>)}.
         * 
         * @param availabilityZoneMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.AvailabilityZoneMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availabilityZoneMappings(java.util.Collection<AvailabilityZoneMapping>)
         */
        Builder availabilityZoneMappings(Consumer<AvailabilityZoneMapping.Builder>... availabilityZoneMappings);

        /**
         * <p>
         * Optional. A setting indicating whether the firewall is protected against changes to its Availability Zone
         * configuration. When set to <code>TRUE</code>, you cannot add or remove Availability Zones without first
         * disabling this protection using <a>UpdateAvailabilityZoneChangeProtection</a>.
         * </p>
         * <p>
         * Default value: <code>FALSE</code>
         * </p>
         * 
         * @param availabilityZoneChangeProtection
         *        Optional. A setting indicating whether the firewall is protected against changes to its Availability
         *        Zone configuration. When set to <code>TRUE</code>, you cannot add or remove Availability Zones without
         *        first disabling this protection using <a>UpdateAvailabilityZoneChangeProtection</a>.</p>
         *        <p>
         *        Default value: <code>FALSE</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneChangeProtection(Boolean availabilityZoneChangeProtection);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFirewallRequest.BuilderImpl implements Builder {
        private String firewallName;

        private String firewallPolicyArn;

        private String vpcId;

        private List<SubnetMapping> subnetMappings = DefaultSdkAutoConstructList.getInstance();

        private Boolean deleteProtection;

        private Boolean subnetChangeProtection;

        private Boolean firewallPolicyChangeProtection;

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private EncryptionConfiguration encryptionConfiguration;

        private List<String> enabledAnalysisTypes = DefaultSdkAutoConstructList.getInstance();

        private String transitGatewayId;

        private List<AvailabilityZoneMapping> availabilityZoneMappings = DefaultSdkAutoConstructList.getInstance();

        private Boolean availabilityZoneChangeProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFirewallRequest model) {
            super(model);
            firewallName(model.firewallName);
            firewallPolicyArn(model.firewallPolicyArn);
            vpcId(model.vpcId);
            subnetMappings(model.subnetMappings);
            deleteProtection(model.deleteProtection);
            subnetChangeProtection(model.subnetChangeProtection);
            firewallPolicyChangeProtection(model.firewallPolicyChangeProtection);
            description(model.description);
            tags(model.tags);
            encryptionConfiguration(model.encryptionConfiguration);
            enabledAnalysisTypesWithStrings(model.enabledAnalysisTypes);
            transitGatewayId(model.transitGatewayId);
            availabilityZoneMappings(model.availabilityZoneMappings);
            availabilityZoneChangeProtection(model.availabilityZoneChangeProtection);
        }

        public final String getFirewallName() {
            return firewallName;
        }

        public final void setFirewallName(String firewallName) {
            this.firewallName = firewallName;
        }

        @Override
        public final Builder firewallName(String firewallName) {
            this.firewallName = firewallName;
            return this;
        }

        public final String getFirewallPolicyArn() {
            return firewallPolicyArn;
        }

        public final void setFirewallPolicyArn(String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
        }

        @Override
        public final Builder firewallPolicyArn(String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final List<SubnetMapping.Builder> getSubnetMappings() {
            List<SubnetMapping.Builder> result = SubnetMappingsCopier.copyToBuilder(this.subnetMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubnetMappings(Collection<SubnetMapping.BuilderImpl> subnetMappings) {
            this.subnetMappings = SubnetMappingsCopier.copyFromBuilder(subnetMappings);
        }

        @Override
        public final Builder subnetMappings(Collection<SubnetMapping> subnetMappings) {
            this.subnetMappings = SubnetMappingsCopier.copy(subnetMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetMappings(SubnetMapping... subnetMappings) {
            subnetMappings(Arrays.asList(subnetMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetMappings(Consumer<SubnetMapping.Builder>... subnetMappings) {
            subnetMappings(Stream.of(subnetMappings).map(c -> SubnetMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDeleteProtection() {
            return deleteProtection;
        }

        public final void setDeleteProtection(Boolean deleteProtection) {
            this.deleteProtection = deleteProtection;
        }

        @Override
        public final Builder deleteProtection(Boolean deleteProtection) {
            this.deleteProtection = deleteProtection;
            return this;
        }

        public final Boolean getSubnetChangeProtection() {
            return subnetChangeProtection;
        }

        public final void setSubnetChangeProtection(Boolean subnetChangeProtection) {
            this.subnetChangeProtection = subnetChangeProtection;
        }

        @Override
        public final Builder subnetChangeProtection(Boolean subnetChangeProtection) {
            this.subnetChangeProtection = subnetChangeProtection;
            return this;
        }

        public final Boolean getFirewallPolicyChangeProtection() {
            return firewallPolicyChangeProtection;
        }

        public final void setFirewallPolicyChangeProtection(Boolean firewallPolicyChangeProtection) {
            this.firewallPolicyChangeProtection = firewallPolicyChangeProtection;
        }

        @Override
        public final Builder firewallPolicyChangeProtection(Boolean firewallPolicyChangeProtection) {
            this.firewallPolicyChangeProtection = firewallPolicyChangeProtection;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final Collection<String> getEnabledAnalysisTypes() {
            if (enabledAnalysisTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return enabledAnalysisTypes;
        }

        public final void setEnabledAnalysisTypes(Collection<String> enabledAnalysisTypes) {
            this.enabledAnalysisTypes = EnabledAnalysisTypesCopier.copy(enabledAnalysisTypes);
        }

        @Override
        public final Builder enabledAnalysisTypesWithStrings(Collection<String> enabledAnalysisTypes) {
            this.enabledAnalysisTypes = EnabledAnalysisTypesCopier.copy(enabledAnalysisTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledAnalysisTypesWithStrings(String... enabledAnalysisTypes) {
            enabledAnalysisTypesWithStrings(Arrays.asList(enabledAnalysisTypes));
            return this;
        }

        @Override
        public final Builder enabledAnalysisTypes(Collection<EnabledAnalysisType> enabledAnalysisTypes) {
            this.enabledAnalysisTypes = EnabledAnalysisTypesCopier.copyEnumToString(enabledAnalysisTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledAnalysisTypes(EnabledAnalysisType... enabledAnalysisTypes) {
            enabledAnalysisTypes(Arrays.asList(enabledAnalysisTypes));
            return this;
        }

        public final String getTransitGatewayId() {
            return transitGatewayId;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final List<AvailabilityZoneMapping.Builder> getAvailabilityZoneMappings() {
            List<AvailabilityZoneMapping.Builder> result = AvailabilityZoneMappingsCopier
                    .copyToBuilder(this.availabilityZoneMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailabilityZoneMappings(Collection<AvailabilityZoneMapping.BuilderImpl> availabilityZoneMappings) {
            this.availabilityZoneMappings = AvailabilityZoneMappingsCopier.copyFromBuilder(availabilityZoneMappings);
        }

        @Override
        public final Builder availabilityZoneMappings(Collection<AvailabilityZoneMapping> availabilityZoneMappings) {
            this.availabilityZoneMappings = AvailabilityZoneMappingsCopier.copy(availabilityZoneMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZoneMappings(AvailabilityZoneMapping... availabilityZoneMappings) {
            availabilityZoneMappings(Arrays.asList(availabilityZoneMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZoneMappings(Consumer<AvailabilityZoneMapping.Builder>... availabilityZoneMappings) {
            availabilityZoneMappings(Stream.of(availabilityZoneMappings)
                    .map(c -> AvailabilityZoneMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAvailabilityZoneChangeProtection() {
            return availabilityZoneChangeProtection;
        }

        public final void setAvailabilityZoneChangeProtection(Boolean availabilityZoneChangeProtection) {
            this.availabilityZoneChangeProtection = availabilityZoneChangeProtection;
        }

        @Override
        public final Builder availabilityZoneChangeProtection(Boolean availabilityZoneChangeProtection) {
            this.availabilityZoneChangeProtection = availabilityZoneChangeProtection;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFirewallRequest build() {
            return new CreateFirewallRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
