/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single IP address specification. This is used in the <a>MatchAttributes</a> source and destination specifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Address implements SdkPojo, Serializable, ToCopyableBuilder<Address.Builder, Address> {
    private static final SdkField<String> ADDRESS_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressDefinition").getter(getter(Address::addressDefinition))
            .setter(setter(Builder::addressDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_DEFINITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String addressDefinition;

    private Address(BuilderImpl builder) {
        this.addressDefinition = builder.addressDefinition;
    }

    /**
     * <p>
     * Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network
     * Firewall supports all address ranges for IPv4 and IPv6.
     * </p>
     * <p>
     * Examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify
     * <code>192.0.2.0/24</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify
     * <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to
     * 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about CIDR notation, see the Wikipedia entry <a
     * href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
     * </p>
     * 
     * @return Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation.
     *         Network Firewall supports all address ranges for IPv4 and IPv6. </p>
     *         <p>
     *         Examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To configure Network Firewall to inspect for the IP address 192.0.2.44, specify
     *         <code>192.0.2.44/32</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify
     *         <code>192.0.2.0/24</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111,
     *         specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to
     *         1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about CIDR notation, see the Wikipedia entry <a
     *         href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
     */
    public final String addressDefinition() {
        return addressDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addressDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address other = (Address) obj;
        return Objects.equals(addressDefinition(), other.addressDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Address").add("AddressDefinition", addressDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddressDefinition":
            return Optional.ofNullable(clazz.cast(addressDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AddressDefinition", ADDRESS_DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Address, T> g) {
        return obj -> g.apply((Address) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Address> {
        /**
         * <p>
         * Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network
         * Firewall supports all address ranges for IPv4 and IPv6.
         * </p>
         * <p>
         * Examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify
         * <code>192.0.2.0/24</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify
         * <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to
         * 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about CIDR notation, see the Wikipedia entry <a
         * href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
         * </p>
         * 
         * @param addressDefinition
         *        Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation.
         *        Network Firewall supports all address ranges for IPv4 and IPv6. </p>
         *        <p>
         *        Examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        To configure Network Firewall to inspect for the IP address 192.0.2.44, specify
         *        <code>192.0.2.44/32</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify
         *        <code>192.0.2.0/24</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111,
         *        specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000
         *        to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify
         *        <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about CIDR notation, see the Wikipedia entry <a
         *        href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain
         *        Routing</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressDefinition(String addressDefinition);
    }

    static final class BuilderImpl implements Builder {
        private String addressDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(Address model) {
            addressDefinition(model.addressDefinition);
        }

        public final String getAddressDefinition() {
            return addressDefinition;
        }

        public final void setAddressDefinition(String addressDefinition) {
            this.addressDefinition = addressDefinition;
        }

        @Override
        public final Builder addressDefinition(String addressDefinition) {
            this.addressDefinition = addressDefinition;
            return this;
        }

        @Override
        public Address build() {
            return new Address(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
