/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A custom action to use in stateless rule actions settings. This is used in <a>CustomAction</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionDefinition.Builder, ActionDefinition> {
    private static final SdkField<PublishMetricAction> PUBLISH_METRIC_ACTION_FIELD = SdkField
            .<PublishMetricAction> builder(MarshallingType.SDK_POJO).memberName("PublishMetricAction")
            .getter(getter(ActionDefinition::publishMetricAction)).setter(setter(Builder::publishMetricAction))
            .constructor(PublishMetricAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishMetricAction").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLISH_METRIC_ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PublishMetricAction publishMetricAction;

    private ActionDefinition(BuilderImpl builder) {
        this.publishMetricAction = builder.publishMetricAction;
    }

    /**
     * <p>
     * Stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the matching packet.
     * This setting defines a CloudWatch dimension value to be published.
     * </p>
     * <p>
     * You can pair this custom action with any of the standard stateless rule actions. For example, you could pair this
     * in a rule action with the standard action that forwards the packet for stateful inspection. Then, when a packet
     * matches the rule, Network Firewall publishes metrics for the packet and forwards it.
     * </p>
     * 
     * @return Stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the matching
     *         packet. This setting defines a CloudWatch dimension value to be published.</p>
     *         <p>
     *         You can pair this custom action with any of the standard stateless rule actions. For example, you could
     *         pair this in a rule action with the standard action that forwards the packet for stateful inspection.
     *         Then, when a packet matches the rule, Network Firewall publishes metrics for the packet and forwards it.
     */
    public final PublishMetricAction publishMetricAction() {
        return publishMetricAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(publishMetricAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionDefinition)) {
            return false;
        }
        ActionDefinition other = (ActionDefinition) obj;
        return Objects.equals(publishMetricAction(), other.publishMetricAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionDefinition").add("PublishMetricAction", publishMetricAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublishMetricAction":
            return Optional.ofNullable(clazz.cast(publishMetricAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PublishMetricAction", PUBLISH_METRIC_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionDefinition, T> g) {
        return obj -> g.apply((ActionDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionDefinition> {
        /**
         * <p>
         * Stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the matching
         * packet. This setting defines a CloudWatch dimension value to be published.
         * </p>
         * <p>
         * You can pair this custom action with any of the standard stateless rule actions. For example, you could pair
         * this in a rule action with the standard action that forwards the packet for stateful inspection. Then, when a
         * packet matches the rule, Network Firewall publishes metrics for the packet and forwards it.
         * </p>
         * 
         * @param publishMetricAction
         *        Stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the
         *        matching packet. This setting defines a CloudWatch dimension value to be published.</p>
         *        <p>
         *        You can pair this custom action with any of the standard stateless rule actions. For example, you
         *        could pair this in a rule action with the standard action that forwards the packet for stateful
         *        inspection. Then, when a packet matches the rule, Network Firewall publishes metrics for the packet
         *        and forwards it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publishMetricAction(PublishMetricAction publishMetricAction);

        /**
         * <p>
         * Stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the matching
         * packet. This setting defines a CloudWatch dimension value to be published.
         * </p>
         * <p>
         * You can pair this custom action with any of the standard stateless rule actions. For example, you could pair
         * this in a rule action with the standard action that forwards the packet for stateful inspection. Then, when a
         * packet matches the rule, Network Firewall publishes metrics for the packet and forwards it.
         * </p>
         * This is a convenience method that creates an instance of the {@link PublishMetricAction.Builder} avoiding the
         * need to create one manually via {@link PublishMetricAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PublishMetricAction.Builder#build()} is called immediately and
         * its result is passed to {@link #publishMetricAction(PublishMetricAction)}.
         * 
         * @param publishMetricAction
         *        a consumer that will call methods on {@link PublishMetricAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publishMetricAction(PublishMetricAction)
         */
        default Builder publishMetricAction(Consumer<PublishMetricAction.Builder> publishMetricAction) {
            return publishMetricAction(PublishMetricAction.builder().applyMutation(publishMetricAction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PublishMetricAction publishMetricAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionDefinition model) {
            publishMetricAction(model.publishMetricAction);
        }

        public final PublishMetricAction.Builder getPublishMetricAction() {
            return publishMetricAction != null ? publishMetricAction.toBuilder() : null;
        }

        public final void setPublishMetricAction(PublishMetricAction.BuilderImpl publishMetricAction) {
            this.publishMetricAction = publishMetricAction != null ? publishMetricAction.build() : null;
        }

        @Override
        public final Builder publishMetricAction(PublishMetricAction publishMetricAction) {
            this.publishMetricAction = publishMetricAction;
            return this;
        }

        @Override
        public ActionDefinition build() {
            return new ActionDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
