/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.networkfirewall.model.AcceptNetworkFirewallTransitGatewayAttachmentRequest;
import software.amazon.awssdk.services.networkfirewall.model.AcceptNetworkFirewallTransitGatewayAttachmentResponse;
import software.amazon.awssdk.services.networkfirewall.model.AssociateAvailabilityZonesRequest;
import software.amazon.awssdk.services.networkfirewall.model.AssociateAvailabilityZonesResponse;
import software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsRequest;
import software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsResponse;
import software.amazon.awssdk.services.networkfirewall.model.AttachRuleGroupsToProxyConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.AttachRuleGroupsToProxyConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateProxyConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateProxyConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateProxyRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateProxyResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateProxyRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateProxyRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateProxyRulesRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateProxyRulesResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateTlsInspectionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateTlsInspectionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateVpcEndpointAssociationRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateVpcEndpointAssociationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteNetworkFirewallTransitGatewayAttachmentRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteNetworkFirewallTransitGatewayAttachmentResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteProxyConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteProxyConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteProxyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteProxyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteProxyRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteProxyRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteProxyRulesRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteProxyRulesResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteTlsInspectionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteTlsInspectionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteVpcEndpointAssociationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteVpcEndpointAssociationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallMetadataRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallMetadataResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFlowOperationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFlowOperationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeProxyConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeProxyConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeProxyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeProxyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeProxyRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeProxyRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeProxyRuleRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeProxyRuleResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupSummaryRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupSummaryResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeTlsInspectionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeTlsInspectionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeVpcEndpointAssociationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeVpcEndpointAssociationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DetachRuleGroupsFromProxyConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DetachRuleGroupsFromProxyConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DisassociateAvailabilityZonesRequest;
import software.amazon.awssdk.services.networkfirewall.model.DisassociateAvailabilityZonesResponse;
import software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsRequest;
import software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsResponse;
import software.amazon.awssdk.services.networkfirewall.model.GetAnalysisReportResultsRequest;
import software.amazon.awssdk.services.networkfirewall.model.GetAnalysisReportResultsResponse;
import software.amazon.awssdk.services.networkfirewall.model.InsufficientCapacityException;
import software.amazon.awssdk.services.networkfirewall.model.InternalServerErrorException;
import software.amazon.awssdk.services.networkfirewall.model.InvalidOperationException;
import software.amazon.awssdk.services.networkfirewall.model.InvalidRequestException;
import software.amazon.awssdk.services.networkfirewall.model.InvalidResourcePolicyException;
import software.amazon.awssdk.services.networkfirewall.model.InvalidTokenException;
import software.amazon.awssdk.services.networkfirewall.model.LimitExceededException;
import software.amazon.awssdk.services.networkfirewall.model.ListAnalysisReportsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListAnalysisReportsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationResultsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationResultsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListProxiesRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListProxiesResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListProxyConfigurationsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListProxyConfigurationsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListProxyRuleGroupsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListProxyRuleGroupsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListVpcEndpointAssociationsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListVpcEndpointAssociationsResponse;
import software.amazon.awssdk.services.networkfirewall.model.LogDestinationPermissionException;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallException;
import software.amazon.awssdk.services.networkfirewall.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.RejectNetworkFirewallTransitGatewayAttachmentRequest;
import software.amazon.awssdk.services.networkfirewall.model.RejectNetworkFirewallTransitGatewayAttachmentResponse;
import software.amazon.awssdk.services.networkfirewall.model.ResourceNotFoundException;
import software.amazon.awssdk.services.networkfirewall.model.ResourceOwnerCheckException;
import software.amazon.awssdk.services.networkfirewall.model.StartAnalysisReportRequest;
import software.amazon.awssdk.services.networkfirewall.model.StartAnalysisReportResponse;
import software.amazon.awssdk.services.networkfirewall.model.StartFlowCaptureRequest;
import software.amazon.awssdk.services.networkfirewall.model.StartFlowCaptureResponse;
import software.amazon.awssdk.services.networkfirewall.model.StartFlowFlushRequest;
import software.amazon.awssdk.services.networkfirewall.model.StartFlowFlushResponse;
import software.amazon.awssdk.services.networkfirewall.model.TagResourceRequest;
import software.amazon.awssdk.services.networkfirewall.model.TagResourceResponse;
import software.amazon.awssdk.services.networkfirewall.model.ThrottlingException;
import software.amazon.awssdk.services.networkfirewall.model.UntagResourceRequest;
import software.amazon.awssdk.services.networkfirewall.model.UntagResourceResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateAvailabilityZoneChangeProtectionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateAvailabilityZoneChangeProtectionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallAnalysisSettingsRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallAnalysisSettingsResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDescriptionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDescriptionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallEncryptionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallEncryptionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateProxyConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateProxyConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateProxyRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateProxyResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateProxyRuleGroupPrioritiesRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateProxyRuleGroupPrioritiesResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateProxyRulePrioritiesRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateProxyRulePrioritiesResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateProxyRuleRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateProxyRuleResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateTlsInspectionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateTlsInspectionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.paginators.GetAnalysisReportResultsIterable;
import software.amazon.awssdk.services.networkfirewall.paginators.ListAnalysisReportsIterable;
import software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallPoliciesIterable;
import software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallsIterable;
import software.amazon.awssdk.services.networkfirewall.paginators.ListFlowOperationResultsIterable;
import software.amazon.awssdk.services.networkfirewall.paginators.ListFlowOperationsIterable;
import software.amazon.awssdk.services.networkfirewall.paginators.ListProxiesIterable;
import software.amazon.awssdk.services.networkfirewall.paginators.ListProxyConfigurationsIterable;
import software.amazon.awssdk.services.networkfirewall.paginators.ListProxyRuleGroupsIterable;
import software.amazon.awssdk.services.networkfirewall.paginators.ListRuleGroupsIterable;
import software.amazon.awssdk.services.networkfirewall.paginators.ListTLSInspectionConfigurationsIterable;
import software.amazon.awssdk.services.networkfirewall.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.networkfirewall.paginators.ListVpcEndpointAssociationsIterable;

/**
 * Service client for accessing Network Firewall. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * This is the API Reference for Network Firewall. This guide is for developers who need detailed information about the
 * Network Firewall API actions, data types, and errors.
 * </p>
 * <p>
 * The REST API requires you to handle connection details, such as calculating signatures, handling request retries, and
 * error handling. For general information about using the Amazon Web Services REST APIs, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/aws-apis.html">Amazon Web Services APIs</a>.
 * </p>
 * <p>
 * To view the complete list of Amazon Web Services Regions where Network Firewall is available, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/network-firewall.html">Service endpoints and quotas</a> in the
 * <i>Amazon Web Services General Reference</i>.
 * </p>
 * <p>
 * To access Network Firewall using the IPv4 REST API endpoint:
 * <code>https://network-firewall.&lt;region&gt;.amazonaws.com </code>
 * </p>
 * <p>
 * To access Network Firewall using the Dualstack (IPv4 and IPv6) REST API endpoint:
 * <code>https://network-firewall.&lt;region&gt;.aws.api </code>
 * </p>
 * <p>
 * Alternatively, you can use one of the Amazon Web Services SDKs to access an API that's tailored to the programming
 * language or platform that you're using. For more information, see <a href="http://aws.amazon.com/tools/#SDKs">Amazon
 * Web Services SDKs</a>.
 * </p>
 * <p>
 * For descriptions of Network Firewall features, including and step-by-step instructions on how to use them through the
 * Network Firewall console, see the <a
 * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/">Network Firewall Developer Guide</a>.
 * </p>
 * <p>
 * Network Firewall is a stateful, managed, network firewall and intrusion detection and prevention service for Amazon
 * Virtual Private Cloud (Amazon VPC). With Network Firewall, you can filter traffic at the perimeter of your VPC. This
 * includes filtering traffic going to and coming from an internet gateway, NAT gateway, or over VPN or Direct Connect.
 * Network Firewall uses rules that are compatible with Suricata, a free, open source network analysis and threat
 * detection engine. Network Firewall supports Suricata version 7.0.3. For information about Suricata, see the <a
 * href="https://suricata.io/">Suricata website</a> and the <a
 * href="https://suricata.readthedocs.io/en/suricata-7.0.3/">Suricata User Guide</a>.
 * </p>
 * <p>
 * You can use Network Firewall to monitor and protect your VPC traffic in a number of ways. The following are just a
 * few examples:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Allow domains or IP addresses for known Amazon Web Services service endpoints, such as Amazon S3, and block all other
 * forms of traffic.
 * </p>
 * </li>
 * <li>
 * <p>
 * Use custom lists of known bad domains to limit the types of domain names that your applications can access.
 * </p>
 * </li>
 * <li>
 * <p>
 * Perform deep packet inspection on traffic entering or leaving your VPC.
 * </p>
 * </li>
 * <li>
 * <p>
 * Use stateful protocol detection to filter protocols like HTTPS, regardless of the port used.
 * </p>
 * </li>
 * </ul>
 * <p>
 * To enable Network Firewall for your VPCs, you perform steps in both Amazon VPC and in Network Firewall. For
 * information about using Amazon VPC, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/">Amazon VPC User
 * Guide</a>.
 * </p>
 * <p>
 * To start using Network Firewall, do the following:
 * </p>
 * <ol>
 * <li>
 * <p>
 * (Optional) If you don't already have a VPC that you want to protect, create it in Amazon VPC.
 * </p>
 * </li>
 * <li>
 * <p>
 * In Amazon VPC, in each Availability Zone where you want to have a firewall endpoint, create a subnet for the sole use
 * of Network Firewall.
 * </p>
 * </li>
 * <li>
 * <p>
 * In Network Firewall, define the firewall behavior as follows:
 * </p>
 * <ol>
 * <li>
 * <p>
 * Create stateless and stateful rule groups, to define the components of the network traffic filtering behavior that
 * you want your firewall to have.
 * </p>
 * </li>
 * <li>
 * <p>
 * Create a firewall policy that uses your rule groups and specifies additional default traffic filtering behavior.
 * </p>
 * </li>
 * </ol>
 * </li>
 * <li>
 * <p>
 * In Network Firewall, create a firewall and specify your new firewall policy and VPC subnets. Network Firewall creates
 * a firewall endpoint in each subnet that you specify, with the behavior that's defined in the firewall policy.
 * </p>
 * </li>
 * <li>
 * <p>
 * In Amazon VPC, use ingress routing enhancements to route traffic through the new firewall endpoints.
 * </p>
 * </li>
 * </ol>
 * <p>
 * After your firewall is established, you can add firewall endpoints for new Availability Zones by following the prior
 * steps for the Amazon VPC setup and firewall subnet definitions. You can also add endpoints to Availability Zones that
 * you're using in the firewall, either for the same VPC or for another VPC, by following the prior steps for the Amazon
 * VPC setup, and defining the new VPC subnets as VPC endpoint associations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface NetworkFirewallClient extends AwsClient {
    String SERVICE_NAME = "network-firewall";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "network-firewall";

    /**
     * <p>
     * Accepts a transit gateway attachment request for Network Firewall. When you accept the attachment request,
     * Network Firewall creates the necessary routing components to enable traffic flow between the transit gateway and
     * firewall endpoints.
     * </p>
     * <p>
     * You must accept a transit gateway attachment to complete the creation of a transit gateway-attached firewall,
     * unless auto-accept is enabled on the transit gateway. After acceptance, use <a>DescribeFirewall</a> to verify the
     * firewall status.
     * </p>
     * <p>
     * To reject an attachment instead of accepting it, use <a>RejectNetworkFirewallTransitGatewayAttachment</a>.
     * </p>
     * <note>
     * <p>
     * It can take several minutes for the attachment acceptance to complete and the firewall to become available.
     * </p>
     * </note>
     *
     * @param acceptNetworkFirewallTransitGatewayAttachmentRequest
     * @return Result of the AcceptNetworkFirewallTransitGatewayAttachment operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.AcceptNetworkFirewallTransitGatewayAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AcceptNetworkFirewallTransitGatewayAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptNetworkFirewallTransitGatewayAttachmentResponse acceptNetworkFirewallTransitGatewayAttachment(
            AcceptNetworkFirewallTransitGatewayAttachmentRequest acceptNetworkFirewallTransitGatewayAttachmentRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a transit gateway attachment request for Network Firewall. When you accept the attachment request,
     * Network Firewall creates the necessary routing components to enable traffic flow between the transit gateway and
     * firewall endpoints.
     * </p>
     * <p>
     * You must accept a transit gateway attachment to complete the creation of a transit gateway-attached firewall,
     * unless auto-accept is enabled on the transit gateway. After acceptance, use <a>DescribeFirewall</a> to verify the
     * firewall status.
     * </p>
     * <p>
     * To reject an attachment instead of accepting it, use <a>RejectNetworkFirewallTransitGatewayAttachment</a>.
     * </p>
     * <note>
     * <p>
     * It can take several minutes for the attachment acceptance to complete and the firewall to become available.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AcceptNetworkFirewallTransitGatewayAttachmentRequest.Builder} avoiding the need to create one manually via
     * {@link AcceptNetworkFirewallTransitGatewayAttachmentRequest#builder()}
     * </p>
     *
     * @param acceptNetworkFirewallTransitGatewayAttachmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.AcceptNetworkFirewallTransitGatewayAttachmentRequest.Builder}
     *        to create a request.
     * @return Result of the AcceptNetworkFirewallTransitGatewayAttachment operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.AcceptNetworkFirewallTransitGatewayAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AcceptNetworkFirewallTransitGatewayAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptNetworkFirewallTransitGatewayAttachmentResponse acceptNetworkFirewallTransitGatewayAttachment(
            Consumer<AcceptNetworkFirewallTransitGatewayAttachmentRequest.Builder> acceptNetworkFirewallTransitGatewayAttachmentRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return acceptNetworkFirewallTransitGatewayAttachment(AcceptNetworkFirewallTransitGatewayAttachmentRequest.builder()
                .applyMutation(acceptNetworkFirewallTransitGatewayAttachmentRequest).build());
    }

    /**
     * <p>
     * Associates the specified Availability Zones with a transit gateway-attached firewall. For each Availability Zone,
     * Network Firewall creates a firewall endpoint to process traffic. You can specify one or more Availability Zones
     * where you want to deploy the firewall.
     * </p>
     * <p>
     * After adding Availability Zones, you must update your transit gateway route tables to direct traffic through the
     * new firewall endpoints. Use <a>DescribeFirewall</a> to monitor the status of the new endpoints.
     * </p>
     *
     * @param associateAvailabilityZonesRequest
     * @return Result of the AssociateAvailabilityZones operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.AssociateAvailabilityZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AssociateAvailabilityZones"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateAvailabilityZonesResponse associateAvailabilityZones(
            AssociateAvailabilityZonesRequest associateAvailabilityZonesRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException,
            InvalidOperationException, InsufficientCapacityException, AwsServiceException, SdkClientException,
            NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified Availability Zones with a transit gateway-attached firewall. For each Availability Zone,
     * Network Firewall creates a firewall endpoint to process traffic. You can specify one or more Availability Zones
     * where you want to deploy the firewall.
     * </p>
     * <p>
     * After adding Availability Zones, you must update your transit gateway route tables to direct traffic through the
     * new firewall endpoints. Use <a>DescribeFirewall</a> to monitor the status of the new endpoints.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateAvailabilityZonesRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateAvailabilityZonesRequest#builder()}
     * </p>
     *
     * @param associateAvailabilityZonesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.AssociateAvailabilityZonesRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateAvailabilityZones operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.AssociateAvailabilityZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AssociateAvailabilityZones"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateAvailabilityZonesResponse associateAvailabilityZones(
            Consumer<AssociateAvailabilityZonesRequest.Builder> associateAvailabilityZonesRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, InvalidOperationException, InsufficientCapacityException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return associateAvailabilityZones(AssociateAvailabilityZonesRequest.builder()
                .applyMutation(associateAvailabilityZonesRequest).build());
    }

    /**
     * <p>
     * Associates a <a>FirewallPolicy</a> to a <a>Firewall</a>.
     * </p>
     * <p>
     * A firewall policy defines how to monitor and manage your VPC network traffic, using a collection of inspection
     * rule groups and other settings. Each firewall requires one firewall policy association, and you can use the same
     * firewall policy for multiple firewalls.
     * </p>
     *
     * @param associateFirewallPolicyRequest
     * @return Result of the AssociateFirewallPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.AssociateFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AssociateFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateFirewallPolicyResponse associateFirewallPolicy(AssociateFirewallPolicyRequest associateFirewallPolicyRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a <a>FirewallPolicy</a> to a <a>Firewall</a>.
     * </p>
     * <p>
     * A firewall policy defines how to monitor and manage your VPC network traffic, using a collection of inspection
     * rule groups and other settings. Each firewall requires one firewall policy association, and you can use the same
     * firewall policy for multiple firewalls.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateFirewallPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateFirewallPolicyRequest#builder()}
     * </p>
     *
     * @param associateFirewallPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateFirewallPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.AssociateFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AssociateFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateFirewallPolicyResponse associateFirewallPolicy(
            Consumer<AssociateFirewallPolicyRequest.Builder> associateFirewallPolicyRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException,
            InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return associateFirewallPolicy(AssociateFirewallPolicyRequest.builder().applyMutation(associateFirewallPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Associates the specified subnets in the Amazon VPC to the firewall. You can specify one subnet for each of the
     * Availability Zones that the VPC spans.
     * </p>
     * <p>
     * This request creates an Network Firewall firewall endpoint in each of the subnets. To enable the firewall's
     * protections, you must also modify the VPC's route tables for each subnet's Availability Zone, to redirect the
     * traffic that's coming into and going out of the zone through the firewall endpoint.
     * </p>
     *
     * @param associateSubnetsRequest
     * @return Result of the AssociateSubnets operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.AssociateSubnets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AssociateSubnets"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateSubnetsResponse associateSubnets(AssociateSubnetsRequest associateSubnetsRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, InvalidOperationException, InsufficientCapacityException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified subnets in the Amazon VPC to the firewall. You can specify one subnet for each of the
     * Availability Zones that the VPC spans.
     * </p>
     * <p>
     * This request creates an Network Firewall firewall endpoint in each of the subnets. To enable the firewall's
     * protections, you must also modify the VPC's route tables for each subnet's Availability Zone, to redirect the
     * traffic that's coming into and going out of the zone through the firewall endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateSubnetsRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateSubnetsRequest#builder()}
     * </p>
     *
     * @param associateSubnetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateSubnets operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.AssociateSubnets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AssociateSubnets"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateSubnetsResponse associateSubnets(Consumer<AssociateSubnetsRequest.Builder> associateSubnetsRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, InvalidOperationException, InsufficientCapacityException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return associateSubnets(AssociateSubnetsRequest.builder().applyMutation(associateSubnetsRequest).build());
    }

    /**
     * <p>
     * Attaches <a>ProxyRuleGroup</a> resources to a <a>ProxyConfiguration</a>
     * </p>
     * <p>
     * A Proxy Configuration defines the monitoring and protection behavior for a Proxy. The details of the behavior are
     * defined in the rule groups that you add to your configuration.
     * </p>
     *
     * @param attachRuleGroupsToProxyConfigurationRequest
     * @return Result of the AttachRuleGroupsToProxyConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.AttachRuleGroupsToProxyConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AttachRuleGroupsToProxyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default AttachRuleGroupsToProxyConfigurationResponse attachRuleGroupsToProxyConfiguration(
            AttachRuleGroupsToProxyConfigurationRequest attachRuleGroupsToProxyConfigurationRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches <a>ProxyRuleGroup</a> resources to a <a>ProxyConfiguration</a>
     * </p>
     * <p>
     * A Proxy Configuration defines the monitoring and protection behavior for a Proxy. The details of the behavior are
     * defined in the rule groups that you add to your configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AttachRuleGroupsToProxyConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link AttachRuleGroupsToProxyConfigurationRequest#builder()}
     * </p>
     *
     * @param attachRuleGroupsToProxyConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.AttachRuleGroupsToProxyConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the AttachRuleGroupsToProxyConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.AttachRuleGroupsToProxyConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AttachRuleGroupsToProxyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default AttachRuleGroupsToProxyConfigurationResponse attachRuleGroupsToProxyConfiguration(
            Consumer<AttachRuleGroupsToProxyConfigurationRequest.Builder> attachRuleGroupsToProxyConfigurationRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return attachRuleGroupsToProxyConfiguration(AttachRuleGroupsToProxyConfigurationRequest.builder()
                .applyMutation(attachRuleGroupsToProxyConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates an Network Firewall <a>Firewall</a> and accompanying <a>FirewallStatus</a> for a VPC.
     * </p>
     * <p>
     * The firewall defines the configuration settings for an Network Firewall firewall. The settings that you can
     * define at creation include the firewall policy, the subnets in your VPC to use for the firewall endpoints, and
     * any tags that are attached to the firewall Amazon Web Services resource.
     * </p>
     * <p>
     * After you create a firewall, you can provide additional settings, like the logging configuration.
     * </p>
     * <p>
     * To update the settings for a firewall, you use the operations that apply to the settings themselves, for example
     * <a>UpdateLoggingConfiguration</a>, <a>AssociateSubnets</a>, and <a>UpdateFirewallDeleteProtection</a>.
     * </p>
     * <p>
     * To manage a firewall's tags, use the standard Amazon Web Services resource tagging operations,
     * <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about firewalls, use <a>ListFirewalls</a> and <a>DescribeFirewall</a>.
     * </p>
     * <p>
     * To generate a report on the last 30 days of traffic monitored by a firewall, use <a>StartAnalysisReport</a>.
     * </p>
     *
     * @param createFirewallRequest
     * @return Result of the CreateFirewall operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFirewallResponse createFirewall(CreateFirewallRequest createFirewallRequest) throws InvalidRequestException,
            LimitExceededException, InternalServerErrorException, ThrottlingException, InsufficientCapacityException,
            InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Network Firewall <a>Firewall</a> and accompanying <a>FirewallStatus</a> for a VPC.
     * </p>
     * <p>
     * The firewall defines the configuration settings for an Network Firewall firewall. The settings that you can
     * define at creation include the firewall policy, the subnets in your VPC to use for the firewall endpoints, and
     * any tags that are attached to the firewall Amazon Web Services resource.
     * </p>
     * <p>
     * After you create a firewall, you can provide additional settings, like the logging configuration.
     * </p>
     * <p>
     * To update the settings for a firewall, you use the operations that apply to the settings themselves, for example
     * <a>UpdateLoggingConfiguration</a>, <a>AssociateSubnets</a>, and <a>UpdateFirewallDeleteProtection</a>.
     * </p>
     * <p>
     * To manage a firewall's tags, use the standard Amazon Web Services resource tagging operations,
     * <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about firewalls, use <a>ListFirewalls</a> and <a>DescribeFirewall</a>.
     * </p>
     * <p>
     * To generate a report on the last 30 days of traffic monitored by a firewall, use <a>StartAnalysisReport</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFirewallRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFirewallRequest#builder()}
     * </p>
     *
     * @param createFirewallRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.CreateFirewallRequest.Builder} to create a
     *        request.
     * @return Result of the CreateFirewall operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFirewallResponse createFirewall(Consumer<CreateFirewallRequest.Builder> createFirewallRequest)
            throws InvalidRequestException, LimitExceededException, InternalServerErrorException, ThrottlingException,
            InsufficientCapacityException, InvalidOperationException, AwsServiceException, SdkClientException,
            NetworkFirewallException {
        return createFirewall(CreateFirewallRequest.builder().applyMutation(createFirewallRequest).build());
    }

    /**
     * <p>
     * Creates the firewall policy for the firewall according to the specifications.
     * </p>
     * <p>
     * An Network Firewall firewall policy defines the behavior of a firewall, in a collection of stateless and stateful
     * rule groups and other settings. You can use one firewall policy for multiple firewalls.
     * </p>
     *
     * @param createFirewallPolicyRequest
     * @return Result of the CreateFirewallPolicy operation returned by the service.
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFirewallPolicyResponse createFirewallPolicy(CreateFirewallPolicyRequest createFirewallPolicyRequest)
            throws LimitExceededException, InvalidRequestException, ThrottlingException, InternalServerErrorException,
            InsufficientCapacityException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the firewall policy for the firewall according to the specifications.
     * </p>
     * <p>
     * An Network Firewall firewall policy defines the behavior of a firewall, in a collection of stateless and stateful
     * rule groups and other settings. You can use one firewall policy for multiple firewalls.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFirewallPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link CreateFirewallPolicyRequest#builder()}
     * </p>
     *
     * @param createFirewallPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.CreateFirewallPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the CreateFirewallPolicy operation returned by the service.
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFirewallPolicyResponse createFirewallPolicy(
            Consumer<CreateFirewallPolicyRequest.Builder> createFirewallPolicyRequest) throws LimitExceededException,
            InvalidRequestException, ThrottlingException, InternalServerErrorException, InsufficientCapacityException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return createFirewallPolicy(CreateFirewallPolicyRequest.builder().applyMutation(createFirewallPolicyRequest).build());
    }

    /**
     * <p>
     * Creates an Network Firewall <a>Proxy</a>
     * </p>
     * <p>
     * Attaches a Proxy configuration to a NAT Gateway.
     * </p>
     * <p>
     * To manage a proxy's tags, use the standard Amazon Web Services resource tagging operations,
     * <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about proxies, use <a>ListProxies</a> and <a>DescribeProxy</a>.
     * </p>
     *
     * @param createProxyRequest
     * @return Result of the CreateProxy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws UnsupportedOperationException
     *         The operation you requested isn't supported by Network Firewall.
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateProxy" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateProxyResponse createProxy(CreateProxyRequest createProxyRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException,
            software.amazon.awssdk.services.networkfirewall.model.UnsupportedOperationException, LimitExceededException,
            ThrottlingException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Network Firewall <a>Proxy</a>
     * </p>
     * <p>
     * Attaches a Proxy configuration to a NAT Gateway.
     * </p>
     * <p>
     * To manage a proxy's tags, use the standard Amazon Web Services resource tagging operations,
     * <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about proxies, use <a>ListProxies</a> and <a>DescribeProxy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProxyRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProxyRequest#builder()}
     * </p>
     *
     * @param createProxyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.CreateProxyRequest.Builder} to create a
     *        request.
     * @return Result of the CreateProxy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws UnsupportedOperationException
     *         The operation you requested isn't supported by Network Firewall.
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateProxy" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateProxyResponse createProxy(Consumer<CreateProxyRequest.Builder> createProxyRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException,
            software.amazon.awssdk.services.networkfirewall.model.UnsupportedOperationException, LimitExceededException,
            ThrottlingException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return createProxy(CreateProxyRequest.builder().applyMutation(createProxyRequest).build());
    }

    /**
     * <p>
     * Creates an Network Firewall <a>ProxyConfiguration</a>
     * </p>
     * <p>
     * A Proxy Configuration defines the monitoring and protection behavior for a Proxy. The details of the behavior are
     * defined in the rule groups that you add to your configuration.
     * </p>
     * <p>
     * To manage a proxy configuration's tags, use the standard Amazon Web Services resource tagging operations,
     * <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about proxies, use <a>ListProxyConfigurations</a> and <a>DescribeProxyConfiguration</a>.
     * </p>
     *
     * @param createProxyConfigurationRequest
     * @return Result of the CreateProxyConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateProxyConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateProxyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProxyConfigurationResponse createProxyConfiguration(
            CreateProxyConfigurationRequest createProxyConfigurationRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, LimitExceededException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Network Firewall <a>ProxyConfiguration</a>
     * </p>
     * <p>
     * A Proxy Configuration defines the monitoring and protection behavior for a Proxy. The details of the behavior are
     * defined in the rule groups that you add to your configuration.
     * </p>
     * <p>
     * To manage a proxy configuration's tags, use the standard Amazon Web Services resource tagging operations,
     * <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about proxies, use <a>ListProxyConfigurations</a> and <a>DescribeProxyConfiguration</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProxyConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateProxyConfigurationRequest#builder()}
     * </p>
     *
     * @param createProxyConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.CreateProxyConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateProxyConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateProxyConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateProxyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProxyConfigurationResponse createProxyConfiguration(
            Consumer<CreateProxyConfigurationRequest.Builder> createProxyConfigurationRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, LimitExceededException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return createProxyConfiguration(CreateProxyConfigurationRequest.builder().applyMutation(createProxyConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Creates an Network Firewall <a>ProxyRuleGroup</a>
     * </p>
     * <p>
     * Collections of related proxy filtering rules. Rule groups help you manage and reuse sets of rules across multiple
     * proxy configurations.
     * </p>
     * <p>
     * To manage a proxy rule group's tags, use the standard Amazon Web Services resource tagging operations,
     * <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about proxy rule groups, use <a>ListProxyRuleGroups</a> and
     * <a>DescribeProxyRuleGroup</a>.
     * </p>
     * <p>
     * To retrieve information about individual proxy rules, use <a>DescribeProxyRuleGroup</a> and
     * <a>DescribeProxyRule</a>.
     * </p>
     *
     * @param createProxyRuleGroupRequest
     * @return Result of the CreateProxyRuleGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateProxyRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateProxyRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProxyRuleGroupResponse createProxyRuleGroup(CreateProxyRuleGroupRequest createProxyRuleGroupRequest)
            throws InvalidRequestException, InternalServerErrorException, LimitExceededException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Network Firewall <a>ProxyRuleGroup</a>
     * </p>
     * <p>
     * Collections of related proxy filtering rules. Rule groups help you manage and reuse sets of rules across multiple
     * proxy configurations.
     * </p>
     * <p>
     * To manage a proxy rule group's tags, use the standard Amazon Web Services resource tagging operations,
     * <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about proxy rule groups, use <a>ListProxyRuleGroups</a> and
     * <a>DescribeProxyRuleGroup</a>.
     * </p>
     * <p>
     * To retrieve information about individual proxy rules, use <a>DescribeProxyRuleGroup</a> and
     * <a>DescribeProxyRule</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProxyRuleGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateProxyRuleGroupRequest#builder()}
     * </p>
     *
     * @param createProxyRuleGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.CreateProxyRuleGroupRequest.Builder} to
     *        create a request.
     * @return Result of the CreateProxyRuleGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateProxyRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateProxyRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProxyRuleGroupResponse createProxyRuleGroup(
            Consumer<CreateProxyRuleGroupRequest.Builder> createProxyRuleGroupRequest) throws InvalidRequestException,
            InternalServerErrorException, LimitExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            NetworkFirewallException {
        return createProxyRuleGroup(CreateProxyRuleGroupRequest.builder().applyMutation(createProxyRuleGroupRequest).build());
    }

    /**
     * <p>
     * Creates Network Firewall <a>ProxyRule</a> resources.
     * </p>
     * <p>
     * Attaches new proxy rule(s) to an existing proxy rule group.
     * </p>
     * <p>
     * To retrieve information about individual proxy rules, use <a>DescribeProxyRuleGroup</a> and
     * <a>DescribeProxyRule</a>.
     * </p>
     *
     * @param createProxyRulesRequest
     * @return Result of the CreateProxyRules operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateProxyRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateProxyRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProxyRulesResponse createProxyRules(CreateProxyRulesRequest createProxyRulesRequest)
            throws InvalidRequestException, InternalServerErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates Network Firewall <a>ProxyRule</a> resources.
     * </p>
     * <p>
     * Attaches new proxy rule(s) to an existing proxy rule group.
     * </p>
     * <p>
     * To retrieve information about individual proxy rules, use <a>DescribeProxyRuleGroup</a> and
     * <a>DescribeProxyRule</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProxyRulesRequest.Builder} avoiding the need
     * to create one manually via {@link CreateProxyRulesRequest#builder()}
     * </p>
     *
     * @param createProxyRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.CreateProxyRulesRequest.Builder} to create a
     *        request.
     * @return Result of the CreateProxyRules operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateProxyRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateProxyRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProxyRulesResponse createProxyRules(Consumer<CreateProxyRulesRequest.Builder> createProxyRulesRequest)
            throws InvalidRequestException, InternalServerErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return createProxyRules(CreateProxyRulesRequest.builder().applyMutation(createProxyRulesRequest).build());
    }

    /**
     * <p>
     * Creates the specified stateless or stateful rule group, which includes the rules for network traffic inspection,
     * a capacity setting, and tags.
     * </p>
     * <p>
     * You provide your rule group specification in your request using either <code>RuleGroup</code> or
     * <code>Rules</code>.
     * </p>
     *
     * @param createRuleGroupRequest
     * @return Result of the CreateRuleGroup operation returned by the service.
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRuleGroupResponse createRuleGroup(CreateRuleGroupRequest createRuleGroupRequest) throws LimitExceededException,
            InvalidRequestException, ThrottlingException, InternalServerErrorException, InsufficientCapacityException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the specified stateless or stateful rule group, which includes the rules for network traffic inspection,
     * a capacity setting, and tags.
     * </p>
     * <p>
     * You provide your rule group specification in your request using either <code>RuleGroup</code> or
     * <code>Rules</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRuleGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateRuleGroupRequest#builder()}
     * </p>
     *
     * @param createRuleGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.CreateRuleGroupRequest.Builder} to create a
     *        request.
     * @return Result of the CreateRuleGroup operation returned by the service.
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRuleGroupResponse createRuleGroup(Consumer<CreateRuleGroupRequest.Builder> createRuleGroupRequest)
            throws LimitExceededException, InvalidRequestException, ThrottlingException, InternalServerErrorException,
            InsufficientCapacityException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return createRuleGroup(CreateRuleGroupRequest.builder().applyMutation(createRuleGroupRequest).build());
    }

    /**
     * <p>
     * Creates an Network Firewall TLS inspection configuration. Network Firewall uses TLS inspection configurations to
     * decrypt your firewall's inbound and outbound SSL/TLS traffic. After decryption, Network Firewall inspects the
     * traffic according to your firewall policy's stateful rules, and then re-encrypts it before sending it to its
     * destination. You can enable inspection of your firewall's inbound traffic, outbound traffic, or both. To use TLS
     * inspection with your firewall, you must first import or provision certificates using ACM, create a TLS inspection
     * configuration, add that configuration to a new firewall policy, and then associate that policy with your
     * firewall.
     * </p>
     * <p>
     * To update the settings for a TLS inspection configuration, use <a>UpdateTLSInspectionConfiguration</a>.
     * </p>
     * <p>
     * To manage a TLS inspection configuration's tags, use the standard Amazon Web Services resource tagging
     * operations, <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about TLS inspection configurations, use <a>ListTLSInspectionConfigurations</a> and
     * <a>DescribeTLSInspectionConfiguration</a>.
     * </p>
     * <p>
     * For more information about TLS inspection configurations, see <a
     * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Inspecting SSL/TLS
     * traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     *
     * @param createTlsInspectionConfigurationRequest
     * @return Result of the CreateTLSInspectionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTlsInspectionConfigurationResponse createTLSInspectionConfiguration(
            CreateTlsInspectionConfigurationRequest createTlsInspectionConfigurationRequest) throws InvalidRequestException,
            ThrottlingException, InternalServerErrorException, LimitExceededException, InsufficientCapacityException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Network Firewall TLS inspection configuration. Network Firewall uses TLS inspection configurations to
     * decrypt your firewall's inbound and outbound SSL/TLS traffic. After decryption, Network Firewall inspects the
     * traffic according to your firewall policy's stateful rules, and then re-encrypts it before sending it to its
     * destination. You can enable inspection of your firewall's inbound traffic, outbound traffic, or both. To use TLS
     * inspection with your firewall, you must first import or provision certificates using ACM, create a TLS inspection
     * configuration, add that configuration to a new firewall policy, and then associate that policy with your
     * firewall.
     * </p>
     * <p>
     * To update the settings for a TLS inspection configuration, use <a>UpdateTLSInspectionConfiguration</a>.
     * </p>
     * <p>
     * To manage a TLS inspection configuration's tags, use the standard Amazon Web Services resource tagging
     * operations, <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about TLS inspection configurations, use <a>ListTLSInspectionConfigurations</a> and
     * <a>DescribeTLSInspectionConfiguration</a>.
     * </p>
     * <p>
     * For more information about TLS inspection configurations, see <a
     * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Inspecting SSL/TLS
     * traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTlsInspectionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTlsInspectionConfigurationRequest#builder()}
     * </p>
     *
     * @param createTlsInspectionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.CreateTlsInspectionConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateTLSInspectionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTlsInspectionConfigurationResponse createTLSInspectionConfiguration(
            Consumer<CreateTlsInspectionConfigurationRequest.Builder> createTlsInspectionConfigurationRequest)
            throws InvalidRequestException, ThrottlingException, InternalServerErrorException, LimitExceededException,
            InsufficientCapacityException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return createTLSInspectionConfiguration(CreateTlsInspectionConfigurationRequest.builder()
                .applyMutation(createTlsInspectionConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a firewall endpoint for an Network Firewall firewall. This type of firewall endpoint is independent of
     * the firewall endpoints that you specify in the <code>Firewall</code> itself, and you define it in addition to
     * those endpoints after the firewall has been created. You can define a VPC endpoint association using a different
     * VPC than the one you used in the firewall specifications.
     * </p>
     *
     * @param createVpcEndpointAssociationRequest
     * @return Result of the CreateVpcEndpointAssociation operation returned by the service.
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateVpcEndpointAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateVpcEndpointAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVpcEndpointAssociationResponse createVpcEndpointAssociation(
            CreateVpcEndpointAssociationRequest createVpcEndpointAssociationRequest) throws LimitExceededException,
            InvalidRequestException, ThrottlingException, InternalServerErrorException, InsufficientCapacityException,
            ResourceNotFoundException, InvalidOperationException, AwsServiceException, SdkClientException,
            NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a firewall endpoint for an Network Firewall firewall. This type of firewall endpoint is independent of
     * the firewall endpoints that you specify in the <code>Firewall</code> itself, and you define it in addition to
     * those endpoints after the firewall has been created. You can define a VPC endpoint association using a different
     * VPC than the one you used in the firewall specifications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcEndpointAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateVpcEndpointAssociationRequest#builder()}
     * </p>
     *
     * @param createVpcEndpointAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.CreateVpcEndpointAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateVpcEndpointAssociation operation returned by the service.
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateVpcEndpointAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateVpcEndpointAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVpcEndpointAssociationResponse createVpcEndpointAssociation(
            Consumer<CreateVpcEndpointAssociationRequest.Builder> createVpcEndpointAssociationRequest)
            throws LimitExceededException, InvalidRequestException, ThrottlingException, InternalServerErrorException,
            InsufficientCapacityException, ResourceNotFoundException, InvalidOperationException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return createVpcEndpointAssociation(CreateVpcEndpointAssociationRequest.builder()
                .applyMutation(createVpcEndpointAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified <a>Firewall</a> and its <a>FirewallStatus</a>. This operation requires the firewall's
     * <code>DeleteProtection</code> flag to be <code>FALSE</code>. You can't revert this operation.
     * </p>
     * <p>
     * You can check whether a firewall is in use by reviewing the route tables for the Availability Zones where you
     * have firewall subnet mappings. Retrieve the subnet mappings by calling <a>DescribeFirewall</a>. You define and
     * update the route tables through Amazon VPC. As needed, update the route tables for the zones to remove the
     * firewall endpoints. When the route tables no longer use the firewall endpoints, you can remove the firewall
     * safely.
     * </p>
     * <p>
     * To delete a firewall, remove the delete protection if you need to using <a>UpdateFirewallDeleteProtection</a>,
     * then delete the firewall by calling <a>DeleteFirewall</a>.
     * </p>
     *
     * @param deleteFirewallRequest
     * @return Result of the DeleteFirewall operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws UnsupportedOperationException
     *         The operation you requested isn't supported by Network Firewall.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFirewallResponse deleteFirewall(DeleteFirewallRequest deleteFirewallRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            software.amazon.awssdk.services.networkfirewall.model.UnsupportedOperationException, InvalidOperationException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>Firewall</a> and its <a>FirewallStatus</a>. This operation requires the firewall's
     * <code>DeleteProtection</code> flag to be <code>FALSE</code>. You can't revert this operation.
     * </p>
     * <p>
     * You can check whether a firewall is in use by reviewing the route tables for the Availability Zones where you
     * have firewall subnet mappings. Retrieve the subnet mappings by calling <a>DescribeFirewall</a>. You define and
     * update the route tables through Amazon VPC. As needed, update the route tables for the zones to remove the
     * firewall endpoints. When the route tables no longer use the firewall endpoints, you can remove the firewall
     * safely.
     * </p>
     * <p>
     * To delete a firewall, remove the delete protection if you need to using <a>UpdateFirewallDeleteProtection</a>,
     * then delete the firewall by calling <a>DeleteFirewall</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFirewallRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFirewallRequest#builder()}
     * </p>
     *
     * @param deleteFirewallRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteFirewall operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws UnsupportedOperationException
     *         The operation you requested isn't supported by Network Firewall.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFirewallResponse deleteFirewall(Consumer<DeleteFirewallRequest.Builder> deleteFirewallRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            software.amazon.awssdk.services.networkfirewall.model.UnsupportedOperationException, InvalidOperationException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return deleteFirewall(DeleteFirewallRequest.builder().applyMutation(deleteFirewallRequest).build());
    }

    /**
     * <p>
     * Deletes the specified <a>FirewallPolicy</a>.
     * </p>
     *
     * @param deleteFirewallPolicyRequest
     * @return Result of the DeleteFirewallPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws UnsupportedOperationException
     *         The operation you requested isn't supported by Network Firewall.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFirewallPolicyResponse deleteFirewallPolicy(DeleteFirewallPolicyRequest deleteFirewallPolicyRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException,
            software.amazon.awssdk.services.networkfirewall.model.UnsupportedOperationException, InvalidOperationException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>FirewallPolicy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFirewallPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteFirewallPolicyRequest#builder()}
     * </p>
     *
     * @param deleteFirewallPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteFirewallPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws UnsupportedOperationException
     *         The operation you requested isn't supported by Network Firewall.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFirewallPolicyResponse deleteFirewallPolicy(
            Consumer<DeleteFirewallPolicyRequest.Builder> deleteFirewallPolicyRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalServerErrorException,
            software.amazon.awssdk.services.networkfirewall.model.UnsupportedOperationException, InvalidOperationException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return deleteFirewallPolicy(DeleteFirewallPolicyRequest.builder().applyMutation(deleteFirewallPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a transit gateway attachment from a Network Firewall. Either the firewall owner or the transit gateway
     * owner can delete the attachment.
     * </p>
     * <important>
     * <p>
     * After you delete a transit gateway attachment, traffic will no longer flow through the firewall endpoints.
     * </p>
     * </important>
     * <p>
     * After you initiate the delete operation, use <a>DescribeFirewall</a> to monitor the deletion status.
     * </p>
     *
     * @param deleteNetworkFirewallTransitGatewayAttachmentRequest
     * @return Result of the DeleteNetworkFirewallTransitGatewayAttachment operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteNetworkFirewallTransitGatewayAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteNetworkFirewallTransitGatewayAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNetworkFirewallTransitGatewayAttachmentResponse deleteNetworkFirewallTransitGatewayAttachment(
            DeleteNetworkFirewallTransitGatewayAttachmentRequest deleteNetworkFirewallTransitGatewayAttachmentRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a transit gateway attachment from a Network Firewall. Either the firewall owner or the transit gateway
     * owner can delete the attachment.
     * </p>
     * <important>
     * <p>
     * After you delete a transit gateway attachment, traffic will no longer flow through the firewall endpoints.
     * </p>
     * </important>
     * <p>
     * After you initiate the delete operation, use <a>DescribeFirewall</a> to monitor the deletion status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteNetworkFirewallTransitGatewayAttachmentRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteNetworkFirewallTransitGatewayAttachmentRequest#builder()}
     * </p>
     *
     * @param deleteNetworkFirewallTransitGatewayAttachmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DeleteNetworkFirewallTransitGatewayAttachmentRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteNetworkFirewallTransitGatewayAttachment operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteNetworkFirewallTransitGatewayAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteNetworkFirewallTransitGatewayAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNetworkFirewallTransitGatewayAttachmentResponse deleteNetworkFirewallTransitGatewayAttachment(
            Consumer<DeleteNetworkFirewallTransitGatewayAttachmentRequest.Builder> deleteNetworkFirewallTransitGatewayAttachmentRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return deleteNetworkFirewallTransitGatewayAttachment(DeleteNetworkFirewallTransitGatewayAttachmentRequest.builder()
                .applyMutation(deleteNetworkFirewallTransitGatewayAttachmentRequest).build());
    }

    /**
     * <p>
     * Deletes the specified <a>Proxy</a>.
     * </p>
     * <p>
     * Detaches a Proxy configuration from a NAT Gateway.
     * </p>
     *
     * @param deleteProxyRequest
     * @return Result of the DeleteProxy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws UnsupportedOperationException
     *         The operation you requested isn't supported by Network Firewall.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteProxy" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteProxyResponse deleteProxy(DeleteProxyRequest deleteProxyRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException,
            software.amazon.awssdk.services.networkfirewall.model.UnsupportedOperationException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>Proxy</a>.
     * </p>
     * <p>
     * Detaches a Proxy configuration from a NAT Gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProxyRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProxyRequest#builder()}
     * </p>
     *
     * @param deleteProxyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DeleteProxyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteProxy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws UnsupportedOperationException
     *         The operation you requested isn't supported by Network Firewall.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteProxy" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteProxyResponse deleteProxy(Consumer<DeleteProxyRequest.Builder> deleteProxyRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException,
            software.amazon.awssdk.services.networkfirewall.model.UnsupportedOperationException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return deleteProxy(DeleteProxyRequest.builder().applyMutation(deleteProxyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified <a>ProxyConfiguration</a>.
     * </p>
     *
     * @param deleteProxyConfigurationRequest
     * @return Result of the DeleteProxyConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteProxyConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteProxyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProxyConfigurationResponse deleteProxyConfiguration(
            DeleteProxyConfigurationRequest deleteProxyConfigurationRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>ProxyConfiguration</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProxyConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteProxyConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteProxyConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DeleteProxyConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteProxyConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteProxyConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteProxyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProxyConfigurationResponse deleteProxyConfiguration(
            Consumer<DeleteProxyConfigurationRequest.Builder> deleteProxyConfigurationRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return deleteProxyConfiguration(DeleteProxyConfigurationRequest.builder().applyMutation(deleteProxyConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified <a>ProxyRuleGroup</a>.
     * </p>
     *
     * @param deleteProxyRuleGroupRequest
     * @return Result of the DeleteProxyRuleGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteProxyRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteProxyRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProxyRuleGroupResponse deleteProxyRuleGroup(DeleteProxyRuleGroupRequest deleteProxyRuleGroupRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>ProxyRuleGroup</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProxyRuleGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteProxyRuleGroupRequest#builder()}
     * </p>
     *
     * @param deleteProxyRuleGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DeleteProxyRuleGroupRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteProxyRuleGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteProxyRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteProxyRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProxyRuleGroupResponse deleteProxyRuleGroup(
            Consumer<DeleteProxyRuleGroupRequest.Builder> deleteProxyRuleGroupRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return deleteProxyRuleGroup(DeleteProxyRuleGroupRequest.builder().applyMutation(deleteProxyRuleGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified <a>ProxyRule</a>(s). currently attached to a <a>ProxyRuleGroup</a>
     * </p>
     *
     * @param deleteProxyRulesRequest
     * @return Result of the DeleteProxyRules operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteProxyRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteProxyRules"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProxyRulesResponse deleteProxyRules(DeleteProxyRulesRequest deleteProxyRulesRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>ProxyRule</a>(s). currently attached to a <a>ProxyRuleGroup</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProxyRulesRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteProxyRulesRequest#builder()}
     * </p>
     *
     * @param deleteProxyRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DeleteProxyRulesRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteProxyRules operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteProxyRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteProxyRules"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProxyRulesResponse deleteProxyRules(Consumer<DeleteProxyRulesRequest.Builder> deleteProxyRulesRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return deleteProxyRules(DeleteProxyRulesRequest.builder().applyMutation(deleteProxyRulesRequest).build());
    }

    /**
     * <p>
     * Deletes a resource policy that you created in a <a>PutResourcePolicy</a> request.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidResourcePolicyException
     *         The policy statement failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidResourcePolicyException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a resource policy that you created in a <a>PutResourcePolicy</a> request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DeleteResourcePolicyRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidResourcePolicyException
     *         The policy statement failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidResourcePolicyException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified <a>RuleGroup</a>.
     * </p>
     *
     * @param deleteRuleGroupRequest
     * @return Result of the DeleteRuleGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws UnsupportedOperationException
     *         The operation you requested isn't supported by Network Firewall.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRuleGroupResponse deleteRuleGroup(DeleteRuleGroupRequest deleteRuleGroupRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException,
            software.amazon.awssdk.services.networkfirewall.model.UnsupportedOperationException, InvalidOperationException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>RuleGroup</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRuleGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteRuleGroupRequest#builder()}
     * </p>
     *
     * @param deleteRuleGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DeleteRuleGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteRuleGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws UnsupportedOperationException
     *         The operation you requested isn't supported by Network Firewall.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRuleGroupResponse deleteRuleGroup(Consumer<DeleteRuleGroupRequest.Builder> deleteRuleGroupRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException,
            software.amazon.awssdk.services.networkfirewall.model.UnsupportedOperationException, InvalidOperationException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return deleteRuleGroup(DeleteRuleGroupRequest.builder().applyMutation(deleteRuleGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified <a>TLSInspectionConfiguration</a>.
     * </p>
     *
     * @param deleteTlsInspectionConfigurationRequest
     * @return Result of the DeleteTLSInspectionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTlsInspectionConfigurationResponse deleteTLSInspectionConfiguration(
            DeleteTlsInspectionConfigurationRequest deleteTlsInspectionConfigurationRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidOperationException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>TLSInspectionConfiguration</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTlsInspectionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteTlsInspectionConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteTlsInspectionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DeleteTlsInspectionConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteTLSInspectionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTlsInspectionConfigurationResponse deleteTLSInspectionConfiguration(
            Consumer<DeleteTlsInspectionConfigurationRequest.Builder> deleteTlsInspectionConfigurationRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return deleteTLSInspectionConfiguration(DeleteTlsInspectionConfigurationRequest.builder()
                .applyMutation(deleteTlsInspectionConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified <a>VpcEndpointAssociation</a>.
     * </p>
     * <p>
     * You can check whether an endpoint association is in use by reviewing the route tables for the Availability Zones
     * where you have the endpoint subnet mapping. You can retrieve the subnet mapping by calling
     * <a>DescribeVpcEndpointAssociation</a>. You define and update the route tables through Amazon VPC. As needed,
     * update the route tables for the Availability Zone to remove the firewall endpoint for the association. When the
     * route tables no longer use the firewall endpoint, you can remove the endpoint association safely.
     * </p>
     *
     * @param deleteVpcEndpointAssociationRequest
     * @return Result of the DeleteVpcEndpointAssociation operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteVpcEndpointAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteVpcEndpointAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVpcEndpointAssociationResponse deleteVpcEndpointAssociation(
            DeleteVpcEndpointAssociationRequest deleteVpcEndpointAssociationRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidOperationException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>VpcEndpointAssociation</a>.
     * </p>
     * <p>
     * You can check whether an endpoint association is in use by reviewing the route tables for the Availability Zones
     * where you have the endpoint subnet mapping. You can retrieve the subnet mapping by calling
     * <a>DescribeVpcEndpointAssociation</a>. You define and update the route tables through Amazon VPC. As needed,
     * update the route tables for the Availability Zone to remove the firewall endpoint for the association. When the
     * route tables no longer use the firewall endpoint, you can remove the endpoint association safely.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpcEndpointAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteVpcEndpointAssociationRequest#builder()}
     * </p>
     *
     * @param deleteVpcEndpointAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DeleteVpcEndpointAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteVpcEndpointAssociation operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteVpcEndpointAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteVpcEndpointAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVpcEndpointAssociationResponse deleteVpcEndpointAssociation(
            Consumer<DeleteVpcEndpointAssociationRequest.Builder> deleteVpcEndpointAssociationRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return deleteVpcEndpointAssociation(DeleteVpcEndpointAssociationRequest.builder()
                .applyMutation(deleteVpcEndpointAssociationRequest).build());
    }

    /**
     * <p>
     * Returns the data objects for the specified firewall.
     * </p>
     *
     * @param describeFirewallRequest
     * @return Result of the DescribeFirewall operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFirewallResponse describeFirewall(DescribeFirewallRequest describeFirewallRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data objects for the specified firewall.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFirewallRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeFirewallRequest#builder()}
     * </p>
     *
     * @param describeFirewallRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeFirewall operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFirewallResponse describeFirewall(Consumer<DescribeFirewallRequest.Builder> describeFirewallRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return describeFirewall(DescribeFirewallRequest.builder().applyMutation(describeFirewallRequest).build());
    }

    /**
     * <p>
     * Returns the high-level information about a firewall, including the Availability Zones where the Firewall is
     * currently in use.
     * </p>
     *
     * @param describeFirewallMetadataRequest
     * @return Result of the DescribeFirewallMetadata operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeFirewallMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFirewallMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFirewallMetadataResponse describeFirewallMetadata(
            DescribeFirewallMetadataRequest describeFirewallMetadataRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the high-level information about a firewall, including the Availability Zones where the Firewall is
     * currently in use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFirewallMetadataRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeFirewallMetadataRequest#builder()}
     * </p>
     *
     * @param describeFirewallMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallMetadataRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeFirewallMetadata operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeFirewallMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFirewallMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFirewallMetadataResponse describeFirewallMetadata(
            Consumer<DescribeFirewallMetadataRequest.Builder> describeFirewallMetadataRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return describeFirewallMetadata(DescribeFirewallMetadataRequest.builder().applyMutation(describeFirewallMetadataRequest)
                .build());
    }

    /**
     * <p>
     * Returns the data objects for the specified firewall policy.
     * </p>
     *
     * @param describeFirewallPolicyRequest
     * @return Result of the DescribeFirewallPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFirewallPolicyResponse describeFirewallPolicy(DescribeFirewallPolicyRequest describeFirewallPolicyRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data objects for the specified firewall policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFirewallPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFirewallPolicyRequest#builder()}
     * </p>
     *
     * @param describeFirewallPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeFirewallPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFirewallPolicyResponse describeFirewallPolicy(
            Consumer<DescribeFirewallPolicyRequest.Builder> describeFirewallPolicyRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalServerErrorException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return describeFirewallPolicy(DescribeFirewallPolicyRequest.builder().applyMutation(describeFirewallPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Returns key information about a specific flow operation.
     * </p>
     *
     * @param describeFlowOperationRequest
     * @return Result of the DescribeFlowOperation operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeFlowOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFlowOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFlowOperationResponse describeFlowOperation(DescribeFlowOperationRequest describeFlowOperationRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns key information about a specific flow operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFlowOperationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFlowOperationRequest#builder()}
     * </p>
     *
     * @param describeFlowOperationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DescribeFlowOperationRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeFlowOperation operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeFlowOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFlowOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFlowOperationResponse describeFlowOperation(
            Consumer<DescribeFlowOperationRequest.Builder> describeFlowOperationRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return describeFlowOperation(DescribeFlowOperationRequest.builder().applyMutation(describeFlowOperationRequest).build());
    }

    /**
     * <p>
     * Returns the logging configuration for the specified firewall.
     * </p>
     *
     * @param describeLoggingConfigurationRequest
     * @return Result of the DescribeLoggingConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoggingConfigurationResponse describeLoggingConfiguration(
            DescribeLoggingConfigurationRequest describeLoggingConfigurationRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the logging configuration for the specified firewall.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoggingConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param describeLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeLoggingConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoggingConfigurationResponse describeLoggingConfiguration(
            Consumer<DescribeLoggingConfigurationRequest.Builder> describeLoggingConfigurationRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return describeLoggingConfiguration(DescribeLoggingConfigurationRequest.builder()
                .applyMutation(describeLoggingConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns the data objects for the specified proxy.
     * </p>
     *
     * @param describeProxyRequest
     * @return Result of the DescribeProxy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeProxy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProxyResponse describeProxy(DescribeProxyRequest describeProxyRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data objects for the specified proxy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProxyRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeProxyRequest#builder()}
     * </p>
     *
     * @param describeProxyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DescribeProxyRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeProxy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeProxy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProxyResponse describeProxy(Consumer<DescribeProxyRequest.Builder> describeProxyRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return describeProxy(DescribeProxyRequest.builder().applyMutation(describeProxyRequest).build());
    }

    /**
     * <p>
     * Returns the data objects for the specified proxy configuration.
     * </p>
     *
     * @param describeProxyConfigurationRequest
     * @return Result of the DescribeProxyConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeProxyConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeProxyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProxyConfigurationResponse describeProxyConfiguration(
            DescribeProxyConfigurationRequest describeProxyConfigurationRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data objects for the specified proxy configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProxyConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeProxyConfigurationRequest#builder()}
     * </p>
     *
     * @param describeProxyConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DescribeProxyConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeProxyConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeProxyConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeProxyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProxyConfigurationResponse describeProxyConfiguration(
            Consumer<DescribeProxyConfigurationRequest.Builder> describeProxyConfigurationRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return describeProxyConfiguration(DescribeProxyConfigurationRequest.builder()
                .applyMutation(describeProxyConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns the data objects for the specified proxy configuration for the specified proxy rule group.
     * </p>
     *
     * @param describeProxyRuleRequest
     * @return Result of the DescribeProxyRule operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeProxyRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeProxyRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProxyRuleResponse describeProxyRule(DescribeProxyRuleRequest describeProxyRuleRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data objects for the specified proxy configuration for the specified proxy rule group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProxyRuleRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProxyRuleRequest#builder()}
     * </p>
     *
     * @param describeProxyRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DescribeProxyRuleRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeProxyRule operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeProxyRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeProxyRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProxyRuleResponse describeProxyRule(Consumer<DescribeProxyRuleRequest.Builder> describeProxyRuleRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return describeProxyRule(DescribeProxyRuleRequest.builder().applyMutation(describeProxyRuleRequest).build());
    }

    /**
     * <p>
     * Returns the data objects for the specified proxy rule group.
     * </p>
     *
     * @param describeProxyRuleGroupRequest
     * @return Result of the DescribeProxyRuleGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeProxyRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeProxyRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProxyRuleGroupResponse describeProxyRuleGroup(DescribeProxyRuleGroupRequest describeProxyRuleGroupRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data objects for the specified proxy rule group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProxyRuleGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeProxyRuleGroupRequest#builder()}
     * </p>
     *
     * @param describeProxyRuleGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DescribeProxyRuleGroupRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeProxyRuleGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeProxyRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeProxyRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProxyRuleGroupResponse describeProxyRuleGroup(
            Consumer<DescribeProxyRuleGroupRequest.Builder> describeProxyRuleGroupRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return describeProxyRuleGroup(DescribeProxyRuleGroupRequest.builder().applyMutation(describeProxyRuleGroupRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a resource policy that you created in a <a>PutResourcePolicy</a> request.
     * </p>
     *
     * @param describeResourcePolicyRequest
     * @return Result of the DescribeResourcePolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourcePolicyResponse describeResourcePolicy(DescribeResourcePolicyRequest describeResourcePolicyRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a resource policy that you created in a <a>PutResourcePolicy</a> request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeResourcePolicyRequest#builder()}
     * </p>
     *
     * @param describeResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeResourcePolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourcePolicyResponse describeResourcePolicy(
            Consumer<DescribeResourcePolicyRequest.Builder> describeResourcePolicyRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return describeResourcePolicy(DescribeResourcePolicyRequest.builder().applyMutation(describeResourcePolicyRequest)
                .build());
    }

    /**
     * <p>
     * Returns the data objects for the specified rule group.
     * </p>
     *
     * @param describeRuleGroupRequest
     * @return Result of the DescribeRuleGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRuleGroupResponse describeRuleGroup(DescribeRuleGroupRequest describeRuleGroupRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data objects for the specified rule group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRuleGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeRuleGroupRequest#builder()}
     * </p>
     *
     * @param describeRuleGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeRuleGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRuleGroupResponse describeRuleGroup(Consumer<DescribeRuleGroupRequest.Builder> describeRuleGroupRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return describeRuleGroup(DescribeRuleGroupRequest.builder().applyMutation(describeRuleGroupRequest).build());
    }

    /**
     * <p>
     * High-level information about a rule group, returned by operations like create and describe. You can use the
     * information provided in the metadata to retrieve and manage a rule group. You can retrieve all objects for a rule
     * group by calling <a>DescribeRuleGroup</a>.
     * </p>
     *
     * @param describeRuleGroupMetadataRequest
     * @return Result of the DescribeRuleGroupMetadata operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeRuleGroupMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeRuleGroupMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRuleGroupMetadataResponse describeRuleGroupMetadata(
            DescribeRuleGroupMetadataRequest describeRuleGroupMetadataRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalServerErrorException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * High-level information about a rule group, returned by operations like create and describe. You can use the
     * information provided in the metadata to retrieve and manage a rule group. You can retrieve all objects for a rule
     * group by calling <a>DescribeRuleGroup</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRuleGroupMetadataRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeRuleGroupMetadataRequest#builder()}
     * </p>
     *
     * @param describeRuleGroupMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeRuleGroupMetadata operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeRuleGroupMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeRuleGroupMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRuleGroupMetadataResponse describeRuleGroupMetadata(
            Consumer<DescribeRuleGroupMetadataRequest.Builder> describeRuleGroupMetadataRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalServerErrorException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return describeRuleGroupMetadata(DescribeRuleGroupMetadataRequest.builder()
                .applyMutation(describeRuleGroupMetadataRequest).build());
    }

    /**
     * <p>
     * Returns detailed information for a stateful rule group.
     * </p>
     * <p>
     * For active threat defense Amazon Web Services managed rule groups, this operation provides insight into the
     * protections enabled by the rule group, based on Suricata rule metadata fields. Summaries are available for rule
     * groups you manage and for active threat defense Amazon Web Services managed rule groups.
     * </p>
     * <p>
     * To modify how threat information appears in summaries, use the <code>SummaryConfiguration</code> parameter in
     * <a>UpdateRuleGroup</a>.
     * </p>
     *
     * @param describeRuleGroupSummaryRequest
     * @return Result of the DescribeRuleGroupSummary operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeRuleGroupSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeRuleGroupSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRuleGroupSummaryResponse describeRuleGroupSummary(
            DescribeRuleGroupSummaryRequest describeRuleGroupSummaryRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalServerErrorException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information for a stateful rule group.
     * </p>
     * <p>
     * For active threat defense Amazon Web Services managed rule groups, this operation provides insight into the
     * protections enabled by the rule group, based on Suricata rule metadata fields. Summaries are available for rule
     * groups you manage and for active threat defense Amazon Web Services managed rule groups.
     * </p>
     * <p>
     * To modify how threat information appears in summaries, use the <code>SummaryConfiguration</code> parameter in
     * <a>UpdateRuleGroup</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRuleGroupSummaryRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeRuleGroupSummaryRequest#builder()}
     * </p>
     *
     * @param describeRuleGroupSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupSummaryRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeRuleGroupSummary operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeRuleGroupSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeRuleGroupSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRuleGroupSummaryResponse describeRuleGroupSummary(
            Consumer<DescribeRuleGroupSummaryRequest.Builder> describeRuleGroupSummaryRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalServerErrorException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return describeRuleGroupSummary(DescribeRuleGroupSummaryRequest.builder().applyMutation(describeRuleGroupSummaryRequest)
                .build());
    }

    /**
     * <p>
     * Returns the data objects for the specified TLS inspection configuration.
     * </p>
     *
     * @param describeTlsInspectionConfigurationRequest
     * @return Result of the DescribeTLSInspectionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTlsInspectionConfigurationResponse describeTLSInspectionConfiguration(
            DescribeTlsInspectionConfigurationRequest describeTlsInspectionConfigurationRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data objects for the specified TLS inspection configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTlsInspectionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeTlsInspectionConfigurationRequest#builder()}
     * </p>
     *
     * @param describeTlsInspectionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DescribeTlsInspectionConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeTLSInspectionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTlsInspectionConfigurationResponse describeTLSInspectionConfiguration(
            Consumer<DescribeTlsInspectionConfigurationRequest.Builder> describeTlsInspectionConfigurationRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return describeTLSInspectionConfiguration(DescribeTlsInspectionConfigurationRequest.builder()
                .applyMutation(describeTlsInspectionConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns the data object for the specified VPC endpoint association.
     * </p>
     *
     * @param describeVpcEndpointAssociationRequest
     * @return Result of the DescribeVpcEndpointAssociation operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeVpcEndpointAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeVpcEndpointAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeVpcEndpointAssociationResponse describeVpcEndpointAssociation(
            DescribeVpcEndpointAssociationRequest describeVpcEndpointAssociationRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data object for the specified VPC endpoint association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVpcEndpointAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeVpcEndpointAssociationRequest#builder()}
     * </p>
     *
     * @param describeVpcEndpointAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DescribeVpcEndpointAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeVpcEndpointAssociation operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeVpcEndpointAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeVpcEndpointAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeVpcEndpointAssociationResponse describeVpcEndpointAssociation(
            Consumer<DescribeVpcEndpointAssociationRequest.Builder> describeVpcEndpointAssociationRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return describeVpcEndpointAssociation(DescribeVpcEndpointAssociationRequest.builder()
                .applyMutation(describeVpcEndpointAssociationRequest).build());
    }

    /**
     * <p>
     * Detaches <a>ProxyRuleGroup</a> resources from a <a>ProxyConfiguration</a>
     * </p>
     * <p>
     * A Proxy Configuration defines the monitoring and protection behavior for a Proxy. The details of the behavior are
     * defined in the rule groups that you add to your configuration.
     * </p>
     *
     * @param detachRuleGroupsFromProxyConfigurationRequest
     * @return Result of the DetachRuleGroupsFromProxyConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DetachRuleGroupsFromProxyConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DetachRuleGroupsFromProxyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DetachRuleGroupsFromProxyConfigurationResponse detachRuleGroupsFromProxyConfiguration(
            DetachRuleGroupsFromProxyConfigurationRequest detachRuleGroupsFromProxyConfigurationRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches <a>ProxyRuleGroup</a> resources from a <a>ProxyConfiguration</a>
     * </p>
     * <p>
     * A Proxy Configuration defines the monitoring and protection behavior for a Proxy. The details of the behavior are
     * defined in the rule groups that you add to your configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DetachRuleGroupsFromProxyConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link DetachRuleGroupsFromProxyConfigurationRequest#builder()}
     * </p>
     *
     * @param detachRuleGroupsFromProxyConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DetachRuleGroupsFromProxyConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DetachRuleGroupsFromProxyConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DetachRuleGroupsFromProxyConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DetachRuleGroupsFromProxyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DetachRuleGroupsFromProxyConfigurationResponse detachRuleGroupsFromProxyConfiguration(
            Consumer<DetachRuleGroupsFromProxyConfigurationRequest.Builder> detachRuleGroupsFromProxyConfigurationRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return detachRuleGroupsFromProxyConfiguration(DetachRuleGroupsFromProxyConfigurationRequest.builder()
                .applyMutation(detachRuleGroupsFromProxyConfigurationRequest).build());
    }

    /**
     * <p>
     * Removes the specified Availability Zone associations from a transit gateway-attached firewall. This removes the
     * firewall endpoints from these Availability Zones and stops traffic filtering in those zones. Before removing an
     * Availability Zone, ensure you've updated your transit gateway route tables to redirect traffic appropriately.
     * </p>
     * <note>
     * <p>
     * If <code>AvailabilityZoneChangeProtection</code> is enabled, you must first disable it using
     * <a>UpdateAvailabilityZoneChangeProtection</a>.
     * </p>
     * </note>
     * <p>
     * To verify the status of your Availability Zone changes, use <a>DescribeFirewall</a>.
     * </p>
     *
     * @param disassociateAvailabilityZonesRequest
     * @return Result of the DisassociateAvailabilityZones operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DisassociateAvailabilityZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DisassociateAvailabilityZones"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateAvailabilityZonesResponse disassociateAvailabilityZones(
            DisassociateAvailabilityZonesRequest disassociateAvailabilityZonesRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException,
            InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified Availability Zone associations from a transit gateway-attached firewall. This removes the
     * firewall endpoints from these Availability Zones and stops traffic filtering in those zones. Before removing an
     * Availability Zone, ensure you've updated your transit gateway route tables to redirect traffic appropriately.
     * </p>
     * <note>
     * <p>
     * If <code>AvailabilityZoneChangeProtection</code> is enabled, you must first disable it using
     * <a>UpdateAvailabilityZoneChangeProtection</a>.
     * </p>
     * </note>
     * <p>
     * To verify the status of your Availability Zone changes, use <a>DescribeFirewall</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateAvailabilityZonesRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateAvailabilityZonesRequest#builder()}
     * </p>
     *
     * @param disassociateAvailabilityZonesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DisassociateAvailabilityZonesRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateAvailabilityZones operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DisassociateAvailabilityZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DisassociateAvailabilityZones"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateAvailabilityZonesResponse disassociateAvailabilityZones(
            Consumer<DisassociateAvailabilityZonesRequest.Builder> disassociateAvailabilityZonesRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return disassociateAvailabilityZones(DisassociateAvailabilityZonesRequest.builder()
                .applyMutation(disassociateAvailabilityZonesRequest).build());
    }

    /**
     * <p>
     * Removes the specified subnet associations from the firewall. This removes the firewall endpoints from the subnets
     * and removes any network filtering protections that the endpoints were providing.
     * </p>
     *
     * @param disassociateSubnetsRequest
     * @return Result of the DisassociateSubnets operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DisassociateSubnets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DisassociateSubnets"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateSubnetsResponse disassociateSubnets(DisassociateSubnetsRequest disassociateSubnetsRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified subnet associations from the firewall. This removes the firewall endpoints from the subnets
     * and removes any network filtering protections that the endpoints were providing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateSubnetsRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateSubnetsRequest#builder()}
     * </p>
     *
     * @param disassociateSubnetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsRequest.Builder} to create
     *        a request.
     * @return Result of the DisassociateSubnets operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DisassociateSubnets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DisassociateSubnets"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateSubnetsResponse disassociateSubnets(
            Consumer<DisassociateSubnetsRequest.Builder> disassociateSubnetsRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException,
            InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return disassociateSubnets(DisassociateSubnetsRequest.builder().applyMutation(disassociateSubnetsRequest).build());
    }

    /**
     * <p>
     * The results of a <code>COMPLETED</code> analysis report generated with <a>StartAnalysisReport</a>.
     * </p>
     * <p>
     * For more information, see <a>AnalysisTypeReportResult</a>.
     * </p>
     *
     * @param getAnalysisReportResultsRequest
     * @return Result of the GetAnalysisReportResults operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.GetAnalysisReportResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/GetAnalysisReportResults"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAnalysisReportResultsResponse getAnalysisReportResults(
            GetAnalysisReportResultsRequest getAnalysisReportResultsRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The results of a <code>COMPLETED</code> analysis report generated with <a>StartAnalysisReport</a>.
     * </p>
     * <p>
     * For more information, see <a>AnalysisTypeReportResult</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAnalysisReportResultsRequest.Builder} avoiding
     * the need to create one manually via {@link GetAnalysisReportResultsRequest#builder()}
     * </p>
     *
     * @param getAnalysisReportResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.GetAnalysisReportResultsRequest.Builder} to
     *        create a request.
     * @return Result of the GetAnalysisReportResults operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.GetAnalysisReportResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/GetAnalysisReportResults"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAnalysisReportResultsResponse getAnalysisReportResults(
            Consumer<GetAnalysisReportResultsRequest.Builder> getAnalysisReportResultsRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return getAnalysisReportResults(GetAnalysisReportResultsRequest.builder().applyMutation(getAnalysisReportResultsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getAnalysisReportResults(software.amazon.awssdk.services.networkfirewall.model.GetAnalysisReportResultsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.GetAnalysisReportResultsIterable responses = client.getAnalysisReportResultsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.GetAnalysisReportResultsIterable responses = client
     *             .getAnalysisReportResultsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.GetAnalysisReportResultsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.GetAnalysisReportResultsIterable responses = client.getAnalysisReportResultsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAnalysisReportResults(software.amazon.awssdk.services.networkfirewall.model.GetAnalysisReportResultsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getAnalysisReportResultsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.GetAnalysisReportResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/GetAnalysisReportResults"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAnalysisReportResultsIterable getAnalysisReportResultsPaginator(
            GetAnalysisReportResultsRequest getAnalysisReportResultsRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return new GetAnalysisReportResultsIterable(this, getAnalysisReportResultsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getAnalysisReportResults(software.amazon.awssdk.services.networkfirewall.model.GetAnalysisReportResultsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.GetAnalysisReportResultsIterable responses = client.getAnalysisReportResultsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.GetAnalysisReportResultsIterable responses = client
     *             .getAnalysisReportResultsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.GetAnalysisReportResultsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.GetAnalysisReportResultsIterable responses = client.getAnalysisReportResultsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAnalysisReportResults(software.amazon.awssdk.services.networkfirewall.model.GetAnalysisReportResultsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAnalysisReportResultsRequest.Builder} avoiding
     * the need to create one manually via {@link GetAnalysisReportResultsRequest#builder()}
     * </p>
     *
     * @param getAnalysisReportResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.GetAnalysisReportResultsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.GetAnalysisReportResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/GetAnalysisReportResults"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAnalysisReportResultsIterable getAnalysisReportResultsPaginator(
            Consumer<GetAnalysisReportResultsRequest.Builder> getAnalysisReportResultsRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return getAnalysisReportResultsPaginator(GetAnalysisReportResultsRequest.builder()
                .applyMutation(getAnalysisReportResultsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all traffic analysis reports generated within the last 30 days.
     * </p>
     *
     * @param listAnalysisReportsRequest
     * @return Result of the ListAnalysisReports operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListAnalysisReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListAnalysisReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnalysisReportsResponse listAnalysisReports(ListAnalysisReportsRequest listAnalysisReportsRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all traffic analysis reports generated within the last 30 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnalysisReportsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAnalysisReportsRequest#builder()}
     * </p>
     *
     * @param listAnalysisReportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListAnalysisReportsRequest.Builder} to create
     *        a request.
     * @return Result of the ListAnalysisReports operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListAnalysisReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListAnalysisReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnalysisReportsResponse listAnalysisReports(
            Consumer<ListAnalysisReportsRequest.Builder> listAnalysisReportsRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listAnalysisReports(ListAnalysisReportsRequest.builder().applyMutation(listAnalysisReportsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnalysisReports(software.amazon.awssdk.services.networkfirewall.model.ListAnalysisReportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListAnalysisReportsIterable responses = client.listAnalysisReportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListAnalysisReportsIterable responses = client
     *             .listAnalysisReportsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListAnalysisReportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListAnalysisReportsIterable responses = client.listAnalysisReportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnalysisReports(software.amazon.awssdk.services.networkfirewall.model.ListAnalysisReportsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAnalysisReportsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListAnalysisReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListAnalysisReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnalysisReportsIterable listAnalysisReportsPaginator(ListAnalysisReportsRequest listAnalysisReportsRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return new ListAnalysisReportsIterable(this, listAnalysisReportsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnalysisReports(software.amazon.awssdk.services.networkfirewall.model.ListAnalysisReportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListAnalysisReportsIterable responses = client.listAnalysisReportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListAnalysisReportsIterable responses = client
     *             .listAnalysisReportsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListAnalysisReportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListAnalysisReportsIterable responses = client.listAnalysisReportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnalysisReports(software.amazon.awssdk.services.networkfirewall.model.ListAnalysisReportsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnalysisReportsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAnalysisReportsRequest#builder()}
     * </p>
     *
     * @param listAnalysisReportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListAnalysisReportsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListAnalysisReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListAnalysisReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnalysisReportsIterable listAnalysisReportsPaginator(
            Consumer<ListAnalysisReportsRequest.Builder> listAnalysisReportsRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listAnalysisReportsPaginator(ListAnalysisReportsRequest.builder().applyMutation(listAnalysisReportsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the metadata for the firewall policies that you have defined. Depending on your setting for max results
     * and the number of firewall policies, a single call might not return the full list.
     * </p>
     *
     * @param listFirewallPoliciesRequest
     * @return Result of the ListFirewallPolicies operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFirewallPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewallPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallPoliciesResponse listFirewallPolicies(ListFirewallPoliciesRequest listFirewallPoliciesRequest)
            throws InvalidRequestException, ThrottlingException, InternalServerErrorException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for the firewall policies that you have defined. Depending on your setting for max results
     * and the number of firewall policies, a single call might not return the full list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListFirewallPoliciesRequest#builder()}
     * </p>
     *
     * @param listFirewallPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest.Builder} to
     *        create a request.
     * @return Result of the ListFirewallPolicies operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFirewallPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewallPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallPoliciesResponse listFirewallPolicies(
            Consumer<ListFirewallPoliciesRequest.Builder> listFirewallPoliciesRequest) throws InvalidRequestException,
            ThrottlingException, InternalServerErrorException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return listFirewallPolicies(ListFirewallPoliciesRequest.builder().applyMutation(listFirewallPoliciesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFirewallPolicies(software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallPoliciesIterable responses = client.listFirewallPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallPoliciesIterable responses = client
     *             .listFirewallPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallPoliciesIterable responses = client.listFirewallPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallPolicies(software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFirewallPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFirewallPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewallPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallPoliciesIterable listFirewallPoliciesPaginator(ListFirewallPoliciesRequest listFirewallPoliciesRequest)
            throws InvalidRequestException, ThrottlingException, InternalServerErrorException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return new ListFirewallPoliciesIterable(this, listFirewallPoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFirewallPolicies(software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallPoliciesIterable responses = client.listFirewallPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallPoliciesIterable responses = client
     *             .listFirewallPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallPoliciesIterable responses = client.listFirewallPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallPolicies(software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListFirewallPoliciesRequest#builder()}
     * </p>
     *
     * @param listFirewallPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFirewallPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewallPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallPoliciesIterable listFirewallPoliciesPaginator(
            Consumer<ListFirewallPoliciesRequest.Builder> listFirewallPoliciesRequest) throws InvalidRequestException,
            ThrottlingException, InternalServerErrorException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return listFirewallPoliciesPaginator(ListFirewallPoliciesRequest.builder().applyMutation(listFirewallPoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the metadata for the firewalls that you have defined. If you provide VPC identifiers in your request,
     * this returns only the firewalls for those VPCs.
     * </p>
     * <p>
     * Depending on your setting for max results and the number of firewalls, a single call might not return the full
     * list.
     * </p>
     *
     * @param listFirewallsRequest
     * @return Result of the ListFirewalls operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFirewalls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewalls"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallsResponse listFirewalls(ListFirewallsRequest listFirewallsRequest) throws InvalidRequestException,
            InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for the firewalls that you have defined. If you provide VPC identifiers in your request,
     * this returns only the firewalls for those VPCs.
     * </p>
     * <p>
     * Depending on your setting for max results and the number of firewalls, a single call might not return the full
     * list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFirewallsRequest#builder()}
     * </p>
     *
     * @param listFirewallsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest.Builder} to create a
     *        request.
     * @return Result of the ListFirewalls operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFirewalls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewalls"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallsResponse listFirewalls(Consumer<ListFirewallsRequest.Builder> listFirewallsRequest)
            throws InvalidRequestException, InternalServerErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listFirewalls(ListFirewallsRequest.builder().applyMutation(listFirewallsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFirewalls(software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallsIterable responses = client.listFirewallsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallsIterable responses = client
     *             .listFirewallsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListFirewallsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallsIterable responses = client.listFirewallsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewalls(software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest)} operation.</b>
     * </p>
     *
     * @param listFirewallsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFirewalls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewalls"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallsIterable listFirewallsPaginator(ListFirewallsRequest listFirewallsRequest)
            throws InvalidRequestException, InternalServerErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return new ListFirewallsIterable(this, listFirewallsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFirewalls(software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallsIterable responses = client.listFirewallsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallsIterable responses = client
     *             .listFirewallsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListFirewallsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallsIterable responses = client.listFirewallsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewalls(software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFirewallsRequest#builder()}
     * </p>
     *
     * @param listFirewallsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFirewalls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewalls"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallsIterable listFirewallsPaginator(Consumer<ListFirewallsRequest.Builder> listFirewallsRequest)
            throws InvalidRequestException, InternalServerErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listFirewallsPaginator(ListFirewallsRequest.builder().applyMutation(listFirewallsRequest).build());
    }

    /**
     * <p>
     * Returns the results of a specific flow operation.
     * </p>
     * <p>
     * Flow operations let you manage the flows tracked in the flow table, also known as the firewall table.
     * </p>
     * <p>
     * A flow is network traffic that is monitored by a firewall, either by stateful or stateless rules. For traffic to
     * be considered part of a flow, it must share Destination, DestinationPort, Direction, Protocol, Source, and
     * SourcePort.
     * </p>
     *
     * @param listFlowOperationResultsRequest
     * @return Result of the ListFlowOperationResults operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFlowOperationResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFlowOperationResults"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFlowOperationResultsResponse listFlowOperationResults(
            ListFlowOperationResultsRequest listFlowOperationResultsRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the results of a specific flow operation.
     * </p>
     * <p>
     * Flow operations let you manage the flows tracked in the flow table, also known as the firewall table.
     * </p>
     * <p>
     * A flow is network traffic that is monitored by a firewall, either by stateful or stateless rules. For traffic to
     * be considered part of a flow, it must share Destination, DestinationPort, Direction, Protocol, Source, and
     * SourcePort.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlowOperationResultsRequest.Builder} avoiding
     * the need to create one manually via {@link ListFlowOperationResultsRequest#builder()}
     * </p>
     *
     * @param listFlowOperationResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationResultsRequest.Builder} to
     *        create a request.
     * @return Result of the ListFlowOperationResults operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFlowOperationResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFlowOperationResults"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFlowOperationResultsResponse listFlowOperationResults(
            Consumer<ListFlowOperationResultsRequest.Builder> listFlowOperationResultsRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listFlowOperationResults(ListFlowOperationResultsRequest.builder().applyMutation(listFlowOperationResultsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFlowOperationResults(software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationResultsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFlowOperationResultsIterable responses = client.listFlowOperationResultsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListFlowOperationResultsIterable responses = client
     *             .listFlowOperationResultsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationResultsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFlowOperationResultsIterable responses = client.listFlowOperationResultsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlowOperationResults(software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationResultsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFlowOperationResultsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFlowOperationResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFlowOperationResults"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFlowOperationResultsIterable listFlowOperationResultsPaginator(
            ListFlowOperationResultsRequest listFlowOperationResultsRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return new ListFlowOperationResultsIterable(this, listFlowOperationResultsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFlowOperationResults(software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationResultsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFlowOperationResultsIterable responses = client.listFlowOperationResultsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListFlowOperationResultsIterable responses = client
     *             .listFlowOperationResultsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationResultsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFlowOperationResultsIterable responses = client.listFlowOperationResultsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlowOperationResults(software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationResultsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlowOperationResultsRequest.Builder} avoiding
     * the need to create one manually via {@link ListFlowOperationResultsRequest#builder()}
     * </p>
     *
     * @param listFlowOperationResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationResultsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFlowOperationResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFlowOperationResults"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFlowOperationResultsIterable listFlowOperationResultsPaginator(
            Consumer<ListFlowOperationResultsRequest.Builder> listFlowOperationResultsRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listFlowOperationResultsPaginator(ListFlowOperationResultsRequest.builder()
                .applyMutation(listFlowOperationResultsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all flow operations ran in a specific firewall. You can optionally narrow the request scope by
     * specifying the operation type or Availability Zone associated with a firewall's flow operations.
     * </p>
     * <p>
     * Flow operations let you manage the flows tracked in the flow table, also known as the firewall table.
     * </p>
     * <p>
     * A flow is network traffic that is monitored by a firewall, either by stateful or stateless rules. For traffic to
     * be considered part of a flow, it must share Destination, DestinationPort, Direction, Protocol, Source, and
     * SourcePort.
     * </p>
     *
     * @param listFlowOperationsRequest
     * @return Result of the ListFlowOperations operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFlowOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFlowOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFlowOperationsResponse listFlowOperations(ListFlowOperationsRequest listFlowOperationsRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all flow operations ran in a specific firewall. You can optionally narrow the request scope by
     * specifying the operation type or Availability Zone associated with a firewall's flow operations.
     * </p>
     * <p>
     * Flow operations let you manage the flows tracked in the flow table, also known as the firewall table.
     * </p>
     * <p>
     * A flow is network traffic that is monitored by a firewall, either by stateful or stateless rules. For traffic to
     * be considered part of a flow, it must share Destination, DestinationPort, Direction, Protocol, Source, and
     * SourcePort.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlowOperationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFlowOperationsRequest#builder()}
     * </p>
     *
     * @param listFlowOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationsRequest.Builder} to create
     *        a request.
     * @return Result of the ListFlowOperations operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFlowOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFlowOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFlowOperationsResponse listFlowOperations(Consumer<ListFlowOperationsRequest.Builder> listFlowOperationsRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return listFlowOperations(ListFlowOperationsRequest.builder().applyMutation(listFlowOperationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFlowOperations(software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFlowOperationsIterable responses = client.listFlowOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListFlowOperationsIterable responses = client
     *             .listFlowOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFlowOperationsIterable responses = client.listFlowOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlowOperations(software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFlowOperationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFlowOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFlowOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFlowOperationsIterable listFlowOperationsPaginator(ListFlowOperationsRequest listFlowOperationsRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return new ListFlowOperationsIterable(this, listFlowOperationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFlowOperations(software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFlowOperationsIterable responses = client.listFlowOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListFlowOperationsIterable responses = client
     *             .listFlowOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFlowOperationsIterable responses = client.listFlowOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlowOperations(software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlowOperationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFlowOperationsRequest#builder()}
     * </p>
     *
     * @param listFlowOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFlowOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFlowOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFlowOperationsIterable listFlowOperationsPaginator(
            Consumer<ListFlowOperationsRequest.Builder> listFlowOperationsRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listFlowOperationsPaginator(ListFlowOperationsRequest.builder().applyMutation(listFlowOperationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for the proxies that you have defined. Depending on your setting for max results and the
     * number of proxies, a single call might not return the full list.
     * </p>
     *
     * @param listProxiesRequest
     * @return Result of the ListProxies operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListProxies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListProxies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProxiesResponse listProxies(ListProxiesRequest listProxiesRequest) throws InvalidRequestException,
            InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for the proxies that you have defined. Depending on your setting for max results and the
     * number of proxies, a single call might not return the full list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProxiesRequest.Builder} avoiding the need to
     * create one manually via {@link ListProxiesRequest#builder()}
     * </p>
     *
     * @param listProxiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListProxiesRequest.Builder} to create a
     *        request.
     * @return Result of the ListProxies operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListProxies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListProxies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProxiesResponse listProxies(Consumer<ListProxiesRequest.Builder> listProxiesRequest)
            throws InvalidRequestException, InternalServerErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listProxies(ListProxiesRequest.builder().applyMutation(listProxiesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProxies(software.amazon.awssdk.services.networkfirewall.model.ListProxiesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListProxiesIterable responses = client.listProxiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListProxiesIterable responses = client
     *             .listProxiesPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListProxiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListProxiesIterable responses = client.listProxiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProxies(software.amazon.awssdk.services.networkfirewall.model.ListProxiesRequest)} operation.</b>
     * </p>
     *
     * @param listProxiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListProxies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListProxies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProxiesIterable listProxiesPaginator(ListProxiesRequest listProxiesRequest) throws InvalidRequestException,
            InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return new ListProxiesIterable(this, listProxiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProxies(software.amazon.awssdk.services.networkfirewall.model.ListProxiesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListProxiesIterable responses = client.listProxiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListProxiesIterable responses = client
     *             .listProxiesPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListProxiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListProxiesIterable responses = client.listProxiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProxies(software.amazon.awssdk.services.networkfirewall.model.ListProxiesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProxiesRequest.Builder} avoiding the need to
     * create one manually via {@link ListProxiesRequest#builder()}
     * </p>
     *
     * @param listProxiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListProxiesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListProxies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListProxies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProxiesIterable listProxiesPaginator(Consumer<ListProxiesRequest.Builder> listProxiesRequest)
            throws InvalidRequestException, InternalServerErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listProxiesPaginator(ListProxiesRequest.builder().applyMutation(listProxiesRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for the proxy configuration that you have defined. Depending on your setting for max
     * results and the number of proxy configurations, a single call might not return the full list.
     * </p>
     *
     * @param listProxyConfigurationsRequest
     * @return Result of the ListProxyConfigurations operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListProxyConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListProxyConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProxyConfigurationsResponse listProxyConfigurations(ListProxyConfigurationsRequest listProxyConfigurationsRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for the proxy configuration that you have defined. Depending on your setting for max
     * results and the number of proxy configurations, a single call might not return the full list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProxyConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListProxyConfigurationsRequest#builder()}
     * </p>
     *
     * @param listProxyConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListProxyConfigurationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListProxyConfigurations operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListProxyConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListProxyConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProxyConfigurationsResponse listProxyConfigurations(
            Consumer<ListProxyConfigurationsRequest.Builder> listProxyConfigurationsRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listProxyConfigurations(ListProxyConfigurationsRequest.builder().applyMutation(listProxyConfigurationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProxyConfigurations(software.amazon.awssdk.services.networkfirewall.model.ListProxyConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListProxyConfigurationsIterable responses = client.listProxyConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListProxyConfigurationsIterable responses = client
     *             .listProxyConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListProxyConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListProxyConfigurationsIterable responses = client.listProxyConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProxyConfigurations(software.amazon.awssdk.services.networkfirewall.model.ListProxyConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProxyConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListProxyConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListProxyConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProxyConfigurationsIterable listProxyConfigurationsPaginator(
            ListProxyConfigurationsRequest listProxyConfigurationsRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return new ListProxyConfigurationsIterable(this, listProxyConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProxyConfigurations(software.amazon.awssdk.services.networkfirewall.model.ListProxyConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListProxyConfigurationsIterable responses = client.listProxyConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListProxyConfigurationsIterable responses = client
     *             .listProxyConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListProxyConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListProxyConfigurationsIterable responses = client.listProxyConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProxyConfigurations(software.amazon.awssdk.services.networkfirewall.model.ListProxyConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProxyConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListProxyConfigurationsRequest#builder()}
     * </p>
     *
     * @param listProxyConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListProxyConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListProxyConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListProxyConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProxyConfigurationsIterable listProxyConfigurationsPaginator(
            Consumer<ListProxyConfigurationsRequest.Builder> listProxyConfigurationsRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listProxyConfigurationsPaginator(ListProxyConfigurationsRequest.builder()
                .applyMutation(listProxyConfigurationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for the proxy rule groups that you have defined. Depending on your setting for max results
     * and the number of proxy rule groups, a single call might not return the full list.
     * </p>
     *
     * @param listProxyRuleGroupsRequest
     * @return Result of the ListProxyRuleGroups operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListProxyRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListProxyRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProxyRuleGroupsResponse listProxyRuleGroups(ListProxyRuleGroupsRequest listProxyRuleGroupsRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for the proxy rule groups that you have defined. Depending on your setting for max results
     * and the number of proxy rule groups, a single call might not return the full list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProxyRuleGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListProxyRuleGroupsRequest#builder()}
     * </p>
     *
     * @param listProxyRuleGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListProxyRuleGroupsRequest.Builder} to create
     *        a request.
     * @return Result of the ListProxyRuleGroups operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListProxyRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListProxyRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProxyRuleGroupsResponse listProxyRuleGroups(
            Consumer<ListProxyRuleGroupsRequest.Builder> listProxyRuleGroupsRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listProxyRuleGroups(ListProxyRuleGroupsRequest.builder().applyMutation(listProxyRuleGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProxyRuleGroups(software.amazon.awssdk.services.networkfirewall.model.ListProxyRuleGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListProxyRuleGroupsIterable responses = client.listProxyRuleGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListProxyRuleGroupsIterable responses = client
     *             .listProxyRuleGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListProxyRuleGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListProxyRuleGroupsIterable responses = client.listProxyRuleGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProxyRuleGroups(software.amazon.awssdk.services.networkfirewall.model.ListProxyRuleGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProxyRuleGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListProxyRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListProxyRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProxyRuleGroupsIterable listProxyRuleGroupsPaginator(ListProxyRuleGroupsRequest listProxyRuleGroupsRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return new ListProxyRuleGroupsIterable(this, listProxyRuleGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProxyRuleGroups(software.amazon.awssdk.services.networkfirewall.model.ListProxyRuleGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListProxyRuleGroupsIterable responses = client.listProxyRuleGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListProxyRuleGroupsIterable responses = client
     *             .listProxyRuleGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListProxyRuleGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListProxyRuleGroupsIterable responses = client.listProxyRuleGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProxyRuleGroups(software.amazon.awssdk.services.networkfirewall.model.ListProxyRuleGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProxyRuleGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListProxyRuleGroupsRequest#builder()}
     * </p>
     *
     * @param listProxyRuleGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListProxyRuleGroupsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListProxyRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListProxyRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProxyRuleGroupsIterable listProxyRuleGroupsPaginator(
            Consumer<ListProxyRuleGroupsRequest.Builder> listProxyRuleGroupsRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listProxyRuleGroupsPaginator(ListProxyRuleGroupsRequest.builder().applyMutation(listProxyRuleGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the metadata for the rule groups that you have defined. Depending on your setting for max results and
     * the number of rule groups, a single call might not return the full list.
     * </p>
     *
     * @param listRuleGroupsRequest
     * @return Result of the ListRuleGroups operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRuleGroupsResponse listRuleGroups(ListRuleGroupsRequest listRuleGroupsRequest) throws InvalidRequestException,
            ThrottlingException, InternalServerErrorException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for the rule groups that you have defined. Depending on your setting for max results and
     * the number of rule groups, a single call might not return the full list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRuleGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRuleGroupsRequest#builder()}
     * </p>
     *
     * @param listRuleGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest.Builder} to create a
     *        request.
     * @return Result of the ListRuleGroups operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRuleGroupsResponse listRuleGroups(Consumer<ListRuleGroupsRequest.Builder> listRuleGroupsRequest)
            throws InvalidRequestException, ThrottlingException, InternalServerErrorException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listRuleGroups(ListRuleGroupsRequest.builder().applyMutation(listRuleGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRuleGroups(software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListRuleGroupsIterable responses = client.listRuleGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListRuleGroupsIterable responses = client
     *             .listRuleGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListRuleGroupsIterable responses = client.listRuleGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRuleGroups(software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRuleGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRuleGroupsIterable listRuleGroupsPaginator(ListRuleGroupsRequest listRuleGroupsRequest)
            throws InvalidRequestException, ThrottlingException, InternalServerErrorException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return new ListRuleGroupsIterable(this, listRuleGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRuleGroups(software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListRuleGroupsIterable responses = client.listRuleGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListRuleGroupsIterable responses = client
     *             .listRuleGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListRuleGroupsIterable responses = client.listRuleGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRuleGroups(software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRuleGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRuleGroupsRequest#builder()}
     * </p>
     *
     * @param listRuleGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRuleGroupsIterable listRuleGroupsPaginator(Consumer<ListRuleGroupsRequest.Builder> listRuleGroupsRequest)
            throws InvalidRequestException, ThrottlingException, InternalServerErrorException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listRuleGroupsPaginator(ListRuleGroupsRequest.builder().applyMutation(listRuleGroupsRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for the TLS inspection configurations that you have defined. Depending on your setting for
     * max results and the number of TLS inspection configurations, a single call might not return the full list.
     * </p>
     *
     * @param listTlsInspectionConfigurationsRequest
     * @return Result of the ListTLSInspectionConfigurations operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListTLSInspectionConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTLSInspectionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTlsInspectionConfigurationsResponse listTLSInspectionConfigurations(
            ListTlsInspectionConfigurationsRequest listTlsInspectionConfigurationsRequest) throws InvalidRequestException,
            InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for the TLS inspection configurations that you have defined. Depending on your setting for
     * max results and the number of TLS inspection configurations, a single call might not return the full list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTlsInspectionConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListTlsInspectionConfigurationsRequest#builder()}
     * </p>
     *
     * @param listTlsInspectionConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListTLSInspectionConfigurations operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListTLSInspectionConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTLSInspectionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTlsInspectionConfigurationsResponse listTLSInspectionConfigurations(
            Consumer<ListTlsInspectionConfigurationsRequest.Builder> listTlsInspectionConfigurationsRequest)
            throws InvalidRequestException, InternalServerErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listTLSInspectionConfigurations(ListTlsInspectionConfigurationsRequest.builder()
                .applyMutation(listTlsInspectionConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTLSInspectionConfigurations(software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListTLSInspectionConfigurationsIterable responses = client.listTLSInspectionConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListTLSInspectionConfigurationsIterable responses = client
     *             .listTLSInspectionConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListTLSInspectionConfigurationsIterable responses = client.listTLSInspectionConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTLSInspectionConfigurations(software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTlsInspectionConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListTLSInspectionConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTLSInspectionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTLSInspectionConfigurationsIterable listTLSInspectionConfigurationsPaginator(
            ListTlsInspectionConfigurationsRequest listTlsInspectionConfigurationsRequest) throws InvalidRequestException,
            InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return new ListTLSInspectionConfigurationsIterable(this, listTlsInspectionConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTLSInspectionConfigurations(software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListTLSInspectionConfigurationsIterable responses = client.listTLSInspectionConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListTLSInspectionConfigurationsIterable responses = client
     *             .listTLSInspectionConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListTLSInspectionConfigurationsIterable responses = client.listTLSInspectionConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTLSInspectionConfigurations(software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTlsInspectionConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListTlsInspectionConfigurationsRequest#builder()}
     * </p>
     *
     * @param listTlsInspectionConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListTLSInspectionConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTLSInspectionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTLSInspectionConfigurationsIterable listTLSInspectionConfigurationsPaginator(
            Consumer<ListTlsInspectionConfigurationsRequest.Builder> listTlsInspectionConfigurationsRequest)
            throws InvalidRequestException, InternalServerErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listTLSInspectionConfigurationsPaginator(ListTlsInspectionConfigurationsRequest.builder()
                .applyMutation(listTlsInspectionConfigurationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the tags associated with the specified resource. Tags are key:value pairs that you can use to
     * categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall
     * policies, and rule groups.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ThrottlingException, InternalServerErrorException, ResourceNotFoundException, InvalidRequestException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the tags associated with the specified resource. Tags are key:value pairs that you can use to
     * categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall
     * policies, and rule groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest.Builder} to create
     *        a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ThrottlingException,
            InternalServerErrorException, ResourceNotFoundException, InvalidRequestException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ThrottlingException, InternalServerErrorException, ResourceNotFoundException, InvalidRequestException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return new ListTagsForResourceIterable(this, listTagsForResourceRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceIterable listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ThrottlingException,
            InternalServerErrorException, ResourceNotFoundException, InvalidRequestException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the metadata for the VPC endpoint associations that you have defined. If you specify a fireawll, this
     * returns only the endpoint associations for that firewall.
     * </p>
     * <p>
     * Depending on your setting for max results and the number of associations, a single call might not return the full
     * list.
     * </p>
     *
     * @param listVpcEndpointAssociationsRequest
     * @return Result of the ListVpcEndpointAssociations operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListVpcEndpointAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListVpcEndpointAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVpcEndpointAssociationsResponse listVpcEndpointAssociations(
            ListVpcEndpointAssociationsRequest listVpcEndpointAssociationsRequest) throws InvalidRequestException,
            ThrottlingException, InternalServerErrorException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for the VPC endpoint associations that you have defined. If you specify a fireawll, this
     * returns only the endpoint associations for that firewall.
     * </p>
     * <p>
     * Depending on your setting for max results and the number of associations, a single call might not return the full
     * list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVpcEndpointAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListVpcEndpointAssociationsRequest#builder()}
     * </p>
     *
     * @param listVpcEndpointAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListVpcEndpointAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListVpcEndpointAssociations operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListVpcEndpointAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListVpcEndpointAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVpcEndpointAssociationsResponse listVpcEndpointAssociations(
            Consumer<ListVpcEndpointAssociationsRequest.Builder> listVpcEndpointAssociationsRequest)
            throws InvalidRequestException, ThrottlingException, InternalServerErrorException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listVpcEndpointAssociations(ListVpcEndpointAssociationsRequest.builder()
                .applyMutation(listVpcEndpointAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVpcEndpointAssociations(software.amazon.awssdk.services.networkfirewall.model.ListVpcEndpointAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListVpcEndpointAssociationsIterable responses = client.listVpcEndpointAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListVpcEndpointAssociationsIterable responses = client
     *             .listVpcEndpointAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListVpcEndpointAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListVpcEndpointAssociationsIterable responses = client.listVpcEndpointAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVpcEndpointAssociations(software.amazon.awssdk.services.networkfirewall.model.ListVpcEndpointAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVpcEndpointAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListVpcEndpointAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListVpcEndpointAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVpcEndpointAssociationsIterable listVpcEndpointAssociationsPaginator(
            ListVpcEndpointAssociationsRequest listVpcEndpointAssociationsRequest) throws InvalidRequestException,
            ThrottlingException, InternalServerErrorException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return new ListVpcEndpointAssociationsIterable(this, listVpcEndpointAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVpcEndpointAssociations(software.amazon.awssdk.services.networkfirewall.model.ListVpcEndpointAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListVpcEndpointAssociationsIterable responses = client.listVpcEndpointAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListVpcEndpointAssociationsIterable responses = client
     *             .listVpcEndpointAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListVpcEndpointAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListVpcEndpointAssociationsIterable responses = client.listVpcEndpointAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVpcEndpointAssociations(software.amazon.awssdk.services.networkfirewall.model.ListVpcEndpointAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVpcEndpointAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListVpcEndpointAssociationsRequest#builder()}
     * </p>
     *
     * @param listVpcEndpointAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListVpcEndpointAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListVpcEndpointAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListVpcEndpointAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVpcEndpointAssociationsIterable listVpcEndpointAssociationsPaginator(
            Consumer<ListVpcEndpointAssociationsRequest.Builder> listVpcEndpointAssociationsRequest)
            throws InvalidRequestException, ThrottlingException, InternalServerErrorException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listVpcEndpointAssociationsPaginator(ListVpcEndpointAssociationsRequest.builder()
                .applyMutation(listVpcEndpointAssociationsRequest).build());
    }

    /**
     * <p>
     * Creates or updates an IAM policy for your rule group, firewall policy, or firewall. Use this to share these
     * resources between accounts. This operation works in conjunction with the Amazon Web Services Resource Access
     * Manager (RAM) service to manage resource sharing for Network Firewall.
     * </p>
     * <p>
     * For information about using sharing with Network Firewall resources, see <a
     * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/sharing.html">Sharing Network Firewall
     * resources</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     * <p>
     * Use this operation to create or update a resource policy for your Network Firewall rule group, firewall policy,
     * or firewall. In the resource policy, you specify the accounts that you want to share the Network Firewall
     * resource with and the operations that you want the accounts to be able to perform.
     * </p>
     * <p>
     * When you add an account in the resource policy, you then run the following Resource Access Manager (RAM)
     * operations to access and accept the shared resource.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourceShareInvitations.html">
     * GetResourceShareInvitations</a> - Returns the Amazon Resource Names (ARNs) of the resource share invitations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_AcceptResourceShareInvitation.html">
     * AcceptResourceShareInvitation</a> - Accepts the share invitation for a specified resource share.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For additional information about resource sharing using RAM, see <a
     * href="https://docs.aws.amazon.com/ram/latest/userguide/what-is.html">Resource Access Manager User Guide</a>.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidResourcePolicyException
     *         The policy statement failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidResourcePolicyException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates an IAM policy for your rule group, firewall policy, or firewall. Use this to share these
     * resources between accounts. This operation works in conjunction with the Amazon Web Services Resource Access
     * Manager (RAM) service to manage resource sharing for Network Firewall.
     * </p>
     * <p>
     * For information about using sharing with Network Firewall resources, see <a
     * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/sharing.html">Sharing Network Firewall
     * resources</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     * <p>
     * Use this operation to create or update a resource policy for your Network Firewall rule group, firewall policy,
     * or firewall. In the resource policy, you specify the accounts that you want to share the Network Firewall
     * resource with and the operations that you want the accounts to be able to perform.
     * </p>
     * <p>
     * When you add an account in the resource policy, you then run the following Resource Access Manager (RAM)
     * operations to access and accept the shared resource.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourceShareInvitations.html">
     * GetResourceShareInvitations</a> - Returns the Amazon Resource Names (ARNs) of the resource share invitations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_AcceptResourceShareInvitation.html">
     * AcceptResourceShareInvitation</a> - Accepts the share invitation for a specified resource share.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For additional information about resource sharing using RAM, see <a
     * href="https://docs.aws.amazon.com/ram/latest/userguide/what-is.html">Resource Access Manager User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.PutResourcePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidResourcePolicyException
     *         The policy statement failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidResourcePolicyException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Rejects a transit gateway attachment request for Network Firewall. When you reject the attachment request,
     * Network Firewall cancels the creation of routing components between the transit gateway and firewall endpoints.
     * </p>
     * <p>
     * Only the transit gateway owner can reject the attachment. After rejection, no traffic will flow through the
     * firewall endpoints for this attachment.
     * </p>
     * <p>
     * Use <a>DescribeFirewall</a> to monitor the rejection status. To accept the attachment instead of rejecting it,
     * use <a>AcceptNetworkFirewallTransitGatewayAttachment</a>.
     * </p>
     * <note>
     * <p>
     * Once rejected, you cannot reverse this action. To establish connectivity, you must create a new transit
     * gateway-attached firewall.
     * </p>
     * </note>
     *
     * @param rejectNetworkFirewallTransitGatewayAttachmentRequest
     * @return Result of the RejectNetworkFirewallTransitGatewayAttachment operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.RejectNetworkFirewallTransitGatewayAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/RejectNetworkFirewallTransitGatewayAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default RejectNetworkFirewallTransitGatewayAttachmentResponse rejectNetworkFirewallTransitGatewayAttachment(
            RejectNetworkFirewallTransitGatewayAttachmentRequest rejectNetworkFirewallTransitGatewayAttachmentRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rejects a transit gateway attachment request for Network Firewall. When you reject the attachment request,
     * Network Firewall cancels the creation of routing components between the transit gateway and firewall endpoints.
     * </p>
     * <p>
     * Only the transit gateway owner can reject the attachment. After rejection, no traffic will flow through the
     * firewall endpoints for this attachment.
     * </p>
     * <p>
     * Use <a>DescribeFirewall</a> to monitor the rejection status. To accept the attachment instead of rejecting it,
     * use <a>AcceptNetworkFirewallTransitGatewayAttachment</a>.
     * </p>
     * <note>
     * <p>
     * Once rejected, you cannot reverse this action. To establish connectivity, you must create a new transit
     * gateway-attached firewall.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link RejectNetworkFirewallTransitGatewayAttachmentRequest.Builder} avoiding the need to create one manually via
     * {@link RejectNetworkFirewallTransitGatewayAttachmentRequest#builder()}
     * </p>
     *
     * @param rejectNetworkFirewallTransitGatewayAttachmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.RejectNetworkFirewallTransitGatewayAttachmentRequest.Builder}
     *        to create a request.
     * @return Result of the RejectNetworkFirewallTransitGatewayAttachment operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.RejectNetworkFirewallTransitGatewayAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/RejectNetworkFirewallTransitGatewayAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default RejectNetworkFirewallTransitGatewayAttachmentResponse rejectNetworkFirewallTransitGatewayAttachment(
            Consumer<RejectNetworkFirewallTransitGatewayAttachmentRequest.Builder> rejectNetworkFirewallTransitGatewayAttachmentRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return rejectNetworkFirewallTransitGatewayAttachment(RejectNetworkFirewallTransitGatewayAttachmentRequest.builder()
                .applyMutation(rejectNetworkFirewallTransitGatewayAttachmentRequest).build());
    }

    /**
     * <p>
     * Generates a traffic analysis report for the timeframe and traffic type you specify.
     * </p>
     * <p>
     * For information on the contents of a traffic analysis report, see <a>AnalysisReport</a>.
     * </p>
     *
     * @param startAnalysisReportRequest
     * @return Result of the StartAnalysisReport operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.StartAnalysisReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/StartAnalysisReport"
     *      target="_top">AWS API Documentation</a>
     */
    default StartAnalysisReportResponse startAnalysisReport(StartAnalysisReportRequest startAnalysisReportRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a traffic analysis report for the timeframe and traffic type you specify.
     * </p>
     * <p>
     * For information on the contents of a traffic analysis report, see <a>AnalysisReport</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAnalysisReportRequest.Builder} avoiding the
     * need to create one manually via {@link StartAnalysisReportRequest#builder()}
     * </p>
     *
     * @param startAnalysisReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.StartAnalysisReportRequest.Builder} to create
     *        a request.
     * @return Result of the StartAnalysisReport operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.StartAnalysisReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/StartAnalysisReport"
     *      target="_top">AWS API Documentation</a>
     */
    default StartAnalysisReportResponse startAnalysisReport(
            Consumer<StartAnalysisReportRequest.Builder> startAnalysisReportRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return startAnalysisReport(StartAnalysisReportRequest.builder().applyMutation(startAnalysisReportRequest).build());
    }

    /**
     * <p>
     * Begins capturing the flows in a firewall, according to the filters you define. Captures are similar, but not
     * identical to snapshots. Capture operations provide visibility into flows that are not closed and are tracked by a
     * firewall's flow table. Unlike snapshots, captures are a time-boxed view.
     * </p>
     * <p>
     * A flow is network traffic that is monitored by a firewall, either by stateful or stateless rules. For traffic to
     * be considered part of a flow, it must share Destination, DestinationPort, Direction, Protocol, Source, and
     * SourcePort.
     * </p>
     * <note>
     * <p>
     * To avoid encountering operation limits, you should avoid starting captures with broad filters, like wide IP
     * ranges. Instead, we recommend you define more specific criteria with <code>FlowFilters</code>, like narrow IP
     * ranges, ports, or protocols.
     * </p>
     * </note>
     *
     * @param startFlowCaptureRequest
     * @return Result of the StartFlowCapture operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.StartFlowCapture
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/StartFlowCapture"
     *      target="_top">AWS API Documentation</a>
     */
    default StartFlowCaptureResponse startFlowCapture(StartFlowCaptureRequest startFlowCaptureRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Begins capturing the flows in a firewall, according to the filters you define. Captures are similar, but not
     * identical to snapshots. Capture operations provide visibility into flows that are not closed and are tracked by a
     * firewall's flow table. Unlike snapshots, captures are a time-boxed view.
     * </p>
     * <p>
     * A flow is network traffic that is monitored by a firewall, either by stateful or stateless rules. For traffic to
     * be considered part of a flow, it must share Destination, DestinationPort, Direction, Protocol, Source, and
     * SourcePort.
     * </p>
     * <note>
     * <p>
     * To avoid encountering operation limits, you should avoid starting captures with broad filters, like wide IP
     * ranges. Instead, we recommend you define more specific criteria with <code>FlowFilters</code>, like narrow IP
     * ranges, ports, or protocols.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFlowCaptureRequest.Builder} avoiding the need
     * to create one manually via {@link StartFlowCaptureRequest#builder()}
     * </p>
     *
     * @param startFlowCaptureRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.StartFlowCaptureRequest.Builder} to create a
     *        request.
     * @return Result of the StartFlowCapture operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.StartFlowCapture
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/StartFlowCapture"
     *      target="_top">AWS API Documentation</a>
     */
    default StartFlowCaptureResponse startFlowCapture(Consumer<StartFlowCaptureRequest.Builder> startFlowCaptureRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return startFlowCapture(StartFlowCaptureRequest.builder().applyMutation(startFlowCaptureRequest).build());
    }

    /**
     * <p>
     * Begins the flushing of traffic from the firewall, according to the filters you define. When the operation starts,
     * impacted flows are temporarily marked as timed out before the Suricata engine prunes, or flushes, the flows from
     * the firewall table.
     * </p>
     * <important>
     * <p>
     * While the flush completes, impacted flows are processed as midstream traffic. This may result in a temporary
     * increase in midstream traffic metrics. We recommend that you double check your stream exception policy before you
     * perform a flush operation.
     * </p>
     * </important>
     *
     * @param startFlowFlushRequest
     * @return Result of the StartFlowFlush operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.StartFlowFlush
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/StartFlowFlush"
     *      target="_top">AWS API Documentation</a>
     */
    default StartFlowFlushResponse startFlowFlush(StartFlowFlushRequest startFlowFlushRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Begins the flushing of traffic from the firewall, according to the filters you define. When the operation starts,
     * impacted flows are temporarily marked as timed out before the Suricata engine prunes, or flushes, the flows from
     * the firewall table.
     * </p>
     * <important>
     * <p>
     * While the flush completes, impacted flows are processed as midstream traffic. This may result in a temporary
     * increase in midstream traffic metrics. We recommend that you double check your stream exception policy before you
     * perform a flush operation.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFlowFlushRequest.Builder} avoiding the need to
     * create one manually via {@link StartFlowFlushRequest#builder()}
     * </p>
     *
     * @param startFlowFlushRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.StartFlowFlushRequest.Builder} to create a
     *        request.
     * @return Result of the StartFlowFlush operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.StartFlowFlush
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/StartFlowFlush"
     *      target="_top">AWS API Documentation</a>
     */
    default StartFlowFlushResponse startFlowFlush(Consumer<StartFlowFlushRequest.Builder> startFlowFlushRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return startFlowFlush(StartFlowFlushRequest.builder().applyMutation(startFlowFlushRequest).build());
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource. Tags are key:value pairs that you can use to categorize and
     * manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the
     * value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource,
     * up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall
     * policies, and rule groups.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ThrottlingException,
            InternalServerErrorException, ResourceNotFoundException, InvalidRequestException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource. Tags are key:value pairs that you can use to categorize and
     * manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the
     * value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource,
     * up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall
     * policies, and rule groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ThrottlingException,
            InternalServerErrorException, ResourceNotFoundException, InvalidRequestException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the tags with the specified keys from the specified resource. Tags are key:value pairs that you can use
     * to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can manage tags for the Amazon Web Services resources that you manage through Network Firewall: firewalls,
     * firewall policies, and rule groups.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ThrottlingException,
            InternalServerErrorException, ResourceNotFoundException, InvalidRequestException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the tags with the specified keys from the specified resource. Tags are key:value pairs that you can use
     * to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can manage tags for the Amazon Web Services resources that you manage through Network Firewall: firewalls,
     * firewall policies, and rule groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ThrottlingException, InternalServerErrorException, ResourceNotFoundException, InvalidRequestException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Modifies the <code>AvailabilityZoneChangeProtection</code> setting for a transit gateway-attached firewall. When
     * enabled, this setting prevents accidental changes to the firewall's Availability Zone configuration. This helps
     * protect against disrupting traffic flow in production environments.
     * </p>
     * <p>
     * When enabled, you must disable this protection before using <a>AssociateAvailabilityZones</a> or
     * <a>DisassociateAvailabilityZones</a> to modify the firewall's Availability Zone configuration.
     * </p>
     *
     * @param updateAvailabilityZoneChangeProtectionRequest
     * @return Result of the UpdateAvailabilityZoneChangeProtection operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws ResourceOwnerCheckException
     *         Unable to change the resource because your account doesn't own it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateAvailabilityZoneChangeProtection
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateAvailabilityZoneChangeProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAvailabilityZoneChangeProtectionResponse updateAvailabilityZoneChangeProtection(
            UpdateAvailabilityZoneChangeProtectionRequest updateAvailabilityZoneChangeProtectionRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the <code>AvailabilityZoneChangeProtection</code> setting for a transit gateway-attached firewall. When
     * enabled, this setting prevents accidental changes to the firewall's Availability Zone configuration. This helps
     * protect against disrupting traffic flow in production environments.
     * </p>
     * <p>
     * When enabled, you must disable this protection before using <a>AssociateAvailabilityZones</a> or
     * <a>DisassociateAvailabilityZones</a> to modify the firewall's Availability Zone configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateAvailabilityZoneChangeProtectionRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateAvailabilityZoneChangeProtectionRequest#builder()}
     * </p>
     *
     * @param updateAvailabilityZoneChangeProtectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateAvailabilityZoneChangeProtectionRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateAvailabilityZoneChangeProtection operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws ResourceOwnerCheckException
     *         Unable to change the resource because your account doesn't own it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateAvailabilityZoneChangeProtection
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateAvailabilityZoneChangeProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAvailabilityZoneChangeProtectionResponse updateAvailabilityZoneChangeProtection(
            Consumer<UpdateAvailabilityZoneChangeProtectionRequest.Builder> updateAvailabilityZoneChangeProtectionRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return updateAvailabilityZoneChangeProtection(UpdateAvailabilityZoneChangeProtectionRequest.builder()
                .applyMutation(updateAvailabilityZoneChangeProtectionRequest).build());
    }

    /**
     * <p>
     * Enables specific types of firewall analysis on a specific firewall you define.
     * </p>
     *
     * @param updateFirewallAnalysisSettingsRequest
     * @return Result of the UpdateFirewallAnalysisSettings operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallAnalysisSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallAnalysisSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallAnalysisSettingsResponse updateFirewallAnalysisSettings(
            UpdateFirewallAnalysisSettingsRequest updateFirewallAnalysisSettingsRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables specific types of firewall analysis on a specific firewall you define.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFirewallAnalysisSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateFirewallAnalysisSettingsRequest#builder()}
     * </p>
     *
     * @param updateFirewallAnalysisSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallAnalysisSettingsRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateFirewallAnalysisSettings operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallAnalysisSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallAnalysisSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallAnalysisSettingsResponse updateFirewallAnalysisSettings(
            Consumer<UpdateFirewallAnalysisSettingsRequest.Builder> updateFirewallAnalysisSettingsRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return updateFirewallAnalysisSettings(UpdateFirewallAnalysisSettingsRequest.builder()
                .applyMutation(updateFirewallAnalysisSettingsRequest).build());
    }

    /**
     * <p>
     * Modifies the flag, <code>DeleteProtection</code>, which indicates whether it is possible to delete the firewall.
     * If the flag is set to <code>TRUE</code>, the firewall is protected against deletion. This setting helps protect
     * against accidentally deleting a firewall that's in use.
     * </p>
     *
     * @param updateFirewallDeleteProtectionRequest
     * @return Result of the UpdateFirewallDeleteProtection operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws ResourceOwnerCheckException
     *         Unable to change the resource because your account doesn't own it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallDeleteProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallDeleteProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallDeleteProtectionResponse updateFirewallDeleteProtection(
            UpdateFirewallDeleteProtectionRequest updateFirewallDeleteProtectionRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException,
            ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the flag, <code>DeleteProtection</code>, which indicates whether it is possible to delete the firewall.
     * If the flag is set to <code>TRUE</code>, the firewall is protected against deletion. This setting helps protect
     * against accidentally deleting a firewall that's in use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFirewallDeleteProtectionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateFirewallDeleteProtectionRequest#builder()}
     * </p>
     *
     * @param updateFirewallDeleteProtectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateFirewallDeleteProtection operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws ResourceOwnerCheckException
     *         Unable to change the resource because your account doesn't own it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallDeleteProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallDeleteProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallDeleteProtectionResponse updateFirewallDeleteProtection(
            Consumer<UpdateFirewallDeleteProtectionRequest.Builder> updateFirewallDeleteProtectionRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return updateFirewallDeleteProtection(UpdateFirewallDeleteProtectionRequest.builder()
                .applyMutation(updateFirewallDeleteProtectionRequest).build());
    }

    /**
     * <p>
     * Modifies the description for the specified firewall. Use the description to help you identify the firewall when
     * you're working with it.
     * </p>
     *
     * @param updateFirewallDescriptionRequest
     * @return Result of the UpdateFirewallDescription operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallDescription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallDescription"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallDescriptionResponse updateFirewallDescription(
            UpdateFirewallDescriptionRequest updateFirewallDescriptionRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the description for the specified firewall. Use the description to help you identify the firewall when
     * you're working with it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFirewallDescriptionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateFirewallDescriptionRequest#builder()}
     * </p>
     *
     * @param updateFirewallDescriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDescriptionRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateFirewallDescription operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallDescription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallDescription"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallDescriptionResponse updateFirewallDescription(
            Consumer<UpdateFirewallDescriptionRequest.Builder> updateFirewallDescriptionRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return updateFirewallDescription(UpdateFirewallDescriptionRequest.builder()
                .applyMutation(updateFirewallDescriptionRequest).build());
    }

    /**
     * <p>
     * A complex type that contains settings for encryption of your firewall resources.
     * </p>
     *
     * @param updateFirewallEncryptionConfigurationRequest
     * @return Result of the UpdateFirewallEncryptionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws ResourceOwnerCheckException
     *         Unable to change the resource because your account doesn't own it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallEncryptionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallEncryptionConfigurationResponse updateFirewallEncryptionConfiguration(
            UpdateFirewallEncryptionConfigurationRequest updateFirewallEncryptionConfigurationRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A complex type that contains settings for encryption of your firewall resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateFirewallEncryptionConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateFirewallEncryptionConfigurationRequest#builder()}
     * </p>
     *
     * @param updateFirewallEncryptionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallEncryptionConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateFirewallEncryptionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws ResourceOwnerCheckException
     *         Unable to change the resource because your account doesn't own it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallEncryptionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallEncryptionConfigurationResponse updateFirewallEncryptionConfiguration(
            Consumer<UpdateFirewallEncryptionConfigurationRequest.Builder> updateFirewallEncryptionConfigurationRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return updateFirewallEncryptionConfiguration(UpdateFirewallEncryptionConfigurationRequest.builder()
                .applyMutation(updateFirewallEncryptionConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the properties of the specified firewall policy.
     * </p>
     *
     * @param updateFirewallPolicyRequest
     * @return Result of the UpdateFirewallPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallPolicyResponse updateFirewallPolicy(UpdateFirewallPolicyRequest updateFirewallPolicyRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException,
            InvalidTokenException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the properties of the specified firewall policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFirewallPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFirewallPolicyRequest#builder()}
     * </p>
     *
     * @param updateFirewallPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateFirewallPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallPolicyResponse updateFirewallPolicy(
            Consumer<UpdateFirewallPolicyRequest.Builder> updateFirewallPolicyRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalServerErrorException, InvalidTokenException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return updateFirewallPolicy(UpdateFirewallPolicyRequest.builder().applyMutation(updateFirewallPolicyRequest).build());
    }

    /**
     * <p>
     * Modifies the flag, <code>ChangeProtection</code>, which indicates whether it is possible to change the firewall.
     * If the flag is set to <code>TRUE</code>, the firewall is protected from changes. This setting helps protect
     * against accidentally changing a firewall that's in use.
     * </p>
     *
     * @param updateFirewallPolicyChangeProtectionRequest
     * @return Result of the UpdateFirewallPolicyChangeProtection operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws ResourceOwnerCheckException
     *         Unable to change the resource because your account doesn't own it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallPolicyChangeProtection
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallPolicyChangeProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallPolicyChangeProtectionResponse updateFirewallPolicyChangeProtection(
            UpdateFirewallPolicyChangeProtectionRequest updateFirewallPolicyChangeProtectionRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the flag, <code>ChangeProtection</code>, which indicates whether it is possible to change the firewall.
     * If the flag is set to <code>TRUE</code>, the firewall is protected from changes. This setting helps protect
     * against accidentally changing a firewall that's in use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateFirewallPolicyChangeProtectionRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateFirewallPolicyChangeProtectionRequest#builder()}
     * </p>
     *
     * @param updateFirewallPolicyChangeProtectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateFirewallPolicyChangeProtection operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws ResourceOwnerCheckException
     *         Unable to change the resource because your account doesn't own it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallPolicyChangeProtection
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallPolicyChangeProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallPolicyChangeProtectionResponse updateFirewallPolicyChangeProtection(
            Consumer<UpdateFirewallPolicyChangeProtectionRequest.Builder> updateFirewallPolicyChangeProtectionRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return updateFirewallPolicyChangeProtection(UpdateFirewallPolicyChangeProtectionRequest.builder()
                .applyMutation(updateFirewallPolicyChangeProtectionRequest).build());
    }

    /**
     * <p>
     * Sets the logging configuration for the specified firewall.
     * </p>
     * <p>
     * To change the logging configuration, retrieve the <a>LoggingConfiguration</a> by calling
     * <a>DescribeLoggingConfiguration</a>, then change it and provide the modified object to this update call. You must
     * change the logging configuration one <a>LogDestinationConfig</a> at a time inside the retrieved
     * <a>LoggingConfiguration</a> object.
     * </p>
     * <p>
     * You can perform only one of the following actions in any call to <code>UpdateLoggingConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a new log destination object by adding a single <code>LogDestinationConfig</code> array element to
     * <code>LogDestinationConfigs</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delete a log destination object by removing a single <code>LogDestinationConfig</code> array element from
     * <code>LogDestinationConfigs</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change the <code>LogDestination</code> setting in a single <code>LogDestinationConfig</code> array element.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't change the <code>LogDestinationType</code> or <code>LogType</code> in a
     * <code>LogDestinationConfig</code>. To change these settings, delete the existing
     * <code>LogDestinationConfig</code> object and create a new one, using two separate calls to this update operation.
     * </p>
     *
     * @param updateLoggingConfigurationRequest
     * @return Result of the UpdateLoggingConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws LogDestinationPermissionException
     *         Unable to send logs to a configured logging destination.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLoggingConfigurationResponse updateLoggingConfiguration(
            UpdateLoggingConfigurationRequest updateLoggingConfigurationRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException,
            LogDestinationPermissionException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the logging configuration for the specified firewall.
     * </p>
     * <p>
     * To change the logging configuration, retrieve the <a>LoggingConfiguration</a> by calling
     * <a>DescribeLoggingConfiguration</a>, then change it and provide the modified object to this update call. You must
     * change the logging configuration one <a>LogDestinationConfig</a> at a time inside the retrieved
     * <a>LoggingConfiguration</a> object.
     * </p>
     * <p>
     * You can perform only one of the following actions in any call to <code>UpdateLoggingConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a new log destination object by adding a single <code>LogDestinationConfig</code> array element to
     * <code>LogDestinationConfigs</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delete a log destination object by removing a single <code>LogDestinationConfig</code> array element from
     * <code>LogDestinationConfigs</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change the <code>LogDestination</code> setting in a single <code>LogDestinationConfig</code> array element.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't change the <code>LogDestinationType</code> or <code>LogType</code> in a
     * <code>LogDestinationConfig</code>. To change these settings, delete the existing
     * <code>LogDestinationConfig</code> object and create a new one, using two separate calls to this update operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLoggingConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param updateLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateLoggingConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws LogDestinationPermissionException
     *         Unable to send logs to a configured logging destination.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLoggingConfigurationResponse updateLoggingConfiguration(
            Consumer<UpdateLoggingConfigurationRequest.Builder> updateLoggingConfigurationRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, LogDestinationPermissionException, AwsServiceException, SdkClientException,
            NetworkFirewallException {
        return updateLoggingConfiguration(UpdateLoggingConfigurationRequest.builder()
                .applyMutation(updateLoggingConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the properties of the specified proxy.
     * </p>
     *
     * @param updateProxyRequest
     * @return Result of the UpdateProxy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws UnsupportedOperationException
     *         The operation you requested isn't supported by Network Firewall.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateProxy" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateProxyResponse updateProxy(UpdateProxyRequest updateProxyRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException,
            software.amazon.awssdk.services.networkfirewall.model.UnsupportedOperationException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the properties of the specified proxy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProxyRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProxyRequest#builder()}
     * </p>
     *
     * @param updateProxyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateProxyRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateProxy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws UnsupportedOperationException
     *         The operation you requested isn't supported by Network Firewall.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateProxy" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateProxyResponse updateProxy(Consumer<UpdateProxyRequest.Builder> updateProxyRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException,
            software.amazon.awssdk.services.networkfirewall.model.UnsupportedOperationException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return updateProxy(UpdateProxyRequest.builder().applyMutation(updateProxyRequest).build());
    }

    /**
     * <p>
     * Updates the properties of the specified proxy configuration.
     * </p>
     *
     * @param updateProxyConfigurationRequest
     * @return Result of the UpdateProxyConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateProxyConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateProxyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProxyConfigurationResponse updateProxyConfiguration(
            UpdateProxyConfigurationRequest updateProxyConfigurationRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the properties of the specified proxy configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProxyConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateProxyConfigurationRequest#builder()}
     * </p>
     *
     * @param updateProxyConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateProxyConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateProxyConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateProxyConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateProxyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProxyConfigurationResponse updateProxyConfiguration(
            Consumer<UpdateProxyConfigurationRequest.Builder> updateProxyConfigurationRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return updateProxyConfiguration(UpdateProxyConfigurationRequest.builder().applyMutation(updateProxyConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Updates the properties of the specified proxy rule.
     * </p>
     *
     * @param updateProxyRuleRequest
     * @return Result of the UpdateProxyRule operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateProxyRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateProxyRule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProxyRuleResponse updateProxyRule(UpdateProxyRuleRequest updateProxyRuleRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the properties of the specified proxy rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProxyRuleRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateProxyRuleRequest#builder()}
     * </p>
     *
     * @param updateProxyRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateProxyRuleRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateProxyRule operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateProxyRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateProxyRule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProxyRuleResponse updateProxyRule(Consumer<UpdateProxyRuleRequest.Builder> updateProxyRuleRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return updateProxyRule(UpdateProxyRuleRequest.builder().applyMutation(updateProxyRuleRequest).build());
    }

    /**
     * <p>
     * Updates proxy rule group priorities within a proxy configuration.
     * </p>
     *
     * @param updateProxyRuleGroupPrioritiesRequest
     * @return Result of the UpdateProxyRuleGroupPriorities operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateProxyRuleGroupPriorities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateProxyRuleGroupPriorities"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProxyRuleGroupPrioritiesResponse updateProxyRuleGroupPriorities(
            UpdateProxyRuleGroupPrioritiesRequest updateProxyRuleGroupPrioritiesRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates proxy rule group priorities within a proxy configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProxyRuleGroupPrioritiesRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateProxyRuleGroupPrioritiesRequest#builder()}
     * </p>
     *
     * @param updateProxyRuleGroupPrioritiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateProxyRuleGroupPrioritiesRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateProxyRuleGroupPriorities operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateProxyRuleGroupPriorities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateProxyRuleGroupPriorities"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProxyRuleGroupPrioritiesResponse updateProxyRuleGroupPriorities(
            Consumer<UpdateProxyRuleGroupPrioritiesRequest.Builder> updateProxyRuleGroupPrioritiesRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return updateProxyRuleGroupPriorities(UpdateProxyRuleGroupPrioritiesRequest.builder()
                .applyMutation(updateProxyRuleGroupPrioritiesRequest).build());
    }

    /**
     * <p>
     * Updates proxy rule priorities within a proxy rule group.
     * </p>
     *
     * @param updateProxyRulePrioritiesRequest
     * @return Result of the UpdateProxyRulePriorities operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateProxyRulePriorities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateProxyRulePriorities"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProxyRulePrioritiesResponse updateProxyRulePriorities(
            UpdateProxyRulePrioritiesRequest updateProxyRulePrioritiesRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates proxy rule priorities within a proxy rule group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProxyRulePrioritiesRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateProxyRulePrioritiesRequest#builder()}
     * </p>
     *
     * @param updateProxyRulePrioritiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateProxyRulePrioritiesRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateProxyRulePriorities operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateProxyRulePriorities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateProxyRulePriorities"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProxyRulePrioritiesResponse updateProxyRulePriorities(
            Consumer<UpdateProxyRulePrioritiesRequest.Builder> updateProxyRulePrioritiesRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return updateProxyRulePriorities(UpdateProxyRulePrioritiesRequest.builder()
                .applyMutation(updateProxyRulePrioritiesRequest).build());
    }

    /**
     * <p>
     * Updates the rule settings for the specified rule group. You use a rule group by reference in one or more firewall
     * policies. When you modify a rule group, you modify all firewall policies that use the rule group.
     * </p>
     * <p>
     * To update a rule group, first call <a>DescribeRuleGroup</a> to retrieve the current <a>RuleGroup</a> object,
     * update the object as needed, and then provide the updated object to this call.
     * </p>
     *
     * @param updateRuleGroupRequest
     * @return Result of the UpdateRuleGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRuleGroupResponse updateRuleGroup(UpdateRuleGroupRequest updateRuleGroupRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, InternalServerErrorException,
            InvalidTokenException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the rule settings for the specified rule group. You use a rule group by reference in one or more firewall
     * policies. When you modify a rule group, you modify all firewall policies that use the rule group.
     * </p>
     * <p>
     * To update a rule group, first call <a>DescribeRuleGroup</a> to retrieve the current <a>RuleGroup</a> object,
     * update the object as needed, and then provide the updated object to this call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRuleGroupRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateRuleGroupRequest#builder()}
     * </p>
     *
     * @param updateRuleGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateRuleGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRuleGroupResponse updateRuleGroup(Consumer<UpdateRuleGroupRequest.Builder> updateRuleGroupRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, InternalServerErrorException,
            InvalidTokenException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return updateRuleGroup(UpdateRuleGroupRequest.builder().applyMutation(updateRuleGroupRequest).build());
    }

    /**
     * <p/>
     *
     * @param updateSubnetChangeProtectionRequest
     * @return Result of the UpdateSubnetChangeProtection operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws ResourceOwnerCheckException
     *         Unable to change the resource because your account doesn't own it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateSubnetChangeProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateSubnetChangeProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSubnetChangeProtectionResponse updateSubnetChangeProtection(
            UpdateSubnetChangeProtectionRequest updateSubnetChangeProtectionRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException,
            ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSubnetChangeProtectionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSubnetChangeProtectionRequest#builder()}
     * </p>
     *
     * @param updateSubnetChangeProtectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateSubnetChangeProtection operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws ResourceOwnerCheckException
     *         Unable to change the resource because your account doesn't own it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateSubnetChangeProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateSubnetChangeProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSubnetChangeProtectionResponse updateSubnetChangeProtection(
            Consumer<UpdateSubnetChangeProtectionRequest.Builder> updateSubnetChangeProtectionRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return updateSubnetChangeProtection(UpdateSubnetChangeProtectionRequest.builder()
                .applyMutation(updateSubnetChangeProtectionRequest).build());
    }

    /**
     * <p>
     * Updates the TLS inspection configuration settings for the specified TLS inspection configuration. You use a TLS
     * inspection configuration by referencing it in one or more firewall policies. When you modify a TLS inspection
     * configuration, you modify all firewall policies that use the TLS inspection configuration.
     * </p>
     * <p>
     * To update a TLS inspection configuration, first call <a>DescribeTLSInspectionConfiguration</a> to retrieve the
     * current <a>TLSInspectionConfiguration</a> object, update the object as needed, and then provide the updated
     * object to this call.
     * </p>
     *
     * @param updateTlsInspectionConfigurationRequest
     * @return Result of the UpdateTLSInspectionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTlsInspectionConfigurationResponse updateTLSInspectionConfiguration(
            UpdateTlsInspectionConfigurationRequest updateTlsInspectionConfigurationRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalServerErrorException, InvalidTokenException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the TLS inspection configuration settings for the specified TLS inspection configuration. You use a TLS
     * inspection configuration by referencing it in one or more firewall policies. When you modify a TLS inspection
     * configuration, you modify all firewall policies that use the TLS inspection configuration.
     * </p>
     * <p>
     * To update a TLS inspection configuration, first call <a>DescribeTLSInspectionConfiguration</a> to retrieve the
     * current <a>TLSInspectionConfiguration</a> object, update the object as needed, and then provide the updated
     * object to this call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTlsInspectionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateTlsInspectionConfigurationRequest#builder()}
     * </p>
     *
     * @param updateTlsInspectionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateTlsInspectionConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateTLSInspectionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTlsInspectionConfigurationResponse updateTLSInspectionConfiguration(
            Consumer<UpdateTlsInspectionConfigurationRequest.Builder> updateTlsInspectionConfigurationRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException,
            InvalidTokenException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return updateTLSInspectionConfiguration(UpdateTlsInspectionConfigurationRequest.builder()
                .applyMutation(updateTlsInspectionConfigurationRequest).build());
    }

    /**
     * Create a {@link NetworkFirewallClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static NetworkFirewallClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link NetworkFirewallClient}.
     */
    static NetworkFirewallClientBuilder builder() {
        return new DefaultNetworkFirewallClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default NetworkFirewallServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
