/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.networkfirewall.internal.NetworkFirewallServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.networkfirewall.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.networkfirewall.model.AcceptNetworkFirewallTransitGatewayAttachmentRequest;
import software.amazon.awssdk.services.networkfirewall.model.AcceptNetworkFirewallTransitGatewayAttachmentResponse;
import software.amazon.awssdk.services.networkfirewall.model.AssociateAvailabilityZonesRequest;
import software.amazon.awssdk.services.networkfirewall.model.AssociateAvailabilityZonesResponse;
import software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsRequest;
import software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsResponse;
import software.amazon.awssdk.services.networkfirewall.model.AttachRuleGroupsToProxyConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.AttachRuleGroupsToProxyConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateProxyConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateProxyConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateProxyRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateProxyResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateProxyRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateProxyRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateProxyRulesRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateProxyRulesResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateTlsInspectionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateTlsInspectionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateVpcEndpointAssociationRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateVpcEndpointAssociationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteNetworkFirewallTransitGatewayAttachmentRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteNetworkFirewallTransitGatewayAttachmentResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteProxyConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteProxyConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteProxyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteProxyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteProxyRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteProxyRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteProxyRulesRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteProxyRulesResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteTlsInspectionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteTlsInspectionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteVpcEndpointAssociationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteVpcEndpointAssociationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallMetadataRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallMetadataResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFlowOperationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFlowOperationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeProxyConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeProxyConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeProxyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeProxyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeProxyRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeProxyRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeProxyRuleRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeProxyRuleResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupSummaryRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupSummaryResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeTlsInspectionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeTlsInspectionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeVpcEndpointAssociationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeVpcEndpointAssociationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DetachRuleGroupsFromProxyConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DetachRuleGroupsFromProxyConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DisassociateAvailabilityZonesRequest;
import software.amazon.awssdk.services.networkfirewall.model.DisassociateAvailabilityZonesResponse;
import software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsRequest;
import software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsResponse;
import software.amazon.awssdk.services.networkfirewall.model.GetAnalysisReportResultsRequest;
import software.amazon.awssdk.services.networkfirewall.model.GetAnalysisReportResultsResponse;
import software.amazon.awssdk.services.networkfirewall.model.InsufficientCapacityException;
import software.amazon.awssdk.services.networkfirewall.model.InternalServerErrorException;
import software.amazon.awssdk.services.networkfirewall.model.InvalidOperationException;
import software.amazon.awssdk.services.networkfirewall.model.InvalidRequestException;
import software.amazon.awssdk.services.networkfirewall.model.InvalidResourcePolicyException;
import software.amazon.awssdk.services.networkfirewall.model.InvalidTokenException;
import software.amazon.awssdk.services.networkfirewall.model.LimitExceededException;
import software.amazon.awssdk.services.networkfirewall.model.ListAnalysisReportsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListAnalysisReportsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationResultsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationResultsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListProxiesRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListProxiesResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListProxyConfigurationsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListProxyConfigurationsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListProxyRuleGroupsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListProxyRuleGroupsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListVpcEndpointAssociationsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListVpcEndpointAssociationsResponse;
import software.amazon.awssdk.services.networkfirewall.model.LogDestinationPermissionException;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallException;
import software.amazon.awssdk.services.networkfirewall.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.RejectNetworkFirewallTransitGatewayAttachmentRequest;
import software.amazon.awssdk.services.networkfirewall.model.RejectNetworkFirewallTransitGatewayAttachmentResponse;
import software.amazon.awssdk.services.networkfirewall.model.ResourceNotFoundException;
import software.amazon.awssdk.services.networkfirewall.model.ResourceOwnerCheckException;
import software.amazon.awssdk.services.networkfirewall.model.StartAnalysisReportRequest;
import software.amazon.awssdk.services.networkfirewall.model.StartAnalysisReportResponse;
import software.amazon.awssdk.services.networkfirewall.model.StartFlowCaptureRequest;
import software.amazon.awssdk.services.networkfirewall.model.StartFlowCaptureResponse;
import software.amazon.awssdk.services.networkfirewall.model.StartFlowFlushRequest;
import software.amazon.awssdk.services.networkfirewall.model.StartFlowFlushResponse;
import software.amazon.awssdk.services.networkfirewall.model.TagResourceRequest;
import software.amazon.awssdk.services.networkfirewall.model.TagResourceResponse;
import software.amazon.awssdk.services.networkfirewall.model.ThrottlingException;
import software.amazon.awssdk.services.networkfirewall.model.UnsupportedOperationException;
import software.amazon.awssdk.services.networkfirewall.model.UntagResourceRequest;
import software.amazon.awssdk.services.networkfirewall.model.UntagResourceResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateAvailabilityZoneChangeProtectionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateAvailabilityZoneChangeProtectionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallAnalysisSettingsRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallAnalysisSettingsResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDescriptionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDescriptionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallEncryptionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallEncryptionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateProxyConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateProxyConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateProxyRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateProxyResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateProxyRuleGroupPrioritiesRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateProxyRuleGroupPrioritiesResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateProxyRulePrioritiesRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateProxyRulePrioritiesResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateProxyRuleRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateProxyRuleResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateTlsInspectionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateTlsInspectionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.transform.AcceptNetworkFirewallTransitGatewayAttachmentRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.AssociateAvailabilityZonesRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.AssociateFirewallPolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.AssociateSubnetsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.AttachRuleGroupsToProxyConfigurationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.CreateFirewallPolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.CreateFirewallRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.CreateProxyConfigurationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.CreateProxyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.CreateProxyRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.CreateProxyRulesRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.CreateRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.CreateTlsInspectionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.CreateVpcEndpointAssociationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteFirewallPolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteFirewallRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteNetworkFirewallTransitGatewayAttachmentRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteProxyConfigurationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteProxyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteProxyRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteProxyRulesRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteTlsInspectionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteVpcEndpointAssociationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeFirewallMetadataRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeFirewallPolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeFirewallRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeFlowOperationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeProxyConfigurationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeProxyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeProxyRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeProxyRuleRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeRuleGroupMetadataRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeRuleGroupSummaryRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeTlsInspectionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeVpcEndpointAssociationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DetachRuleGroupsFromProxyConfigurationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DisassociateAvailabilityZonesRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DisassociateSubnetsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.GetAnalysisReportResultsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListAnalysisReportsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListFirewallPoliciesRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListFirewallsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListFlowOperationResultsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListFlowOperationsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListProxiesRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListProxyConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListProxyRuleGroupsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListRuleGroupsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListTlsInspectionConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListVpcEndpointAssociationsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.RejectNetworkFirewallTransitGatewayAttachmentRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.StartAnalysisReportRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.StartFlowCaptureRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.StartFlowFlushRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateAvailabilityZoneChangeProtectionRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateFirewallAnalysisSettingsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateFirewallDeleteProtectionRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateFirewallDescriptionRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateFirewallEncryptionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateFirewallPolicyChangeProtectionRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateFirewallPolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateProxyConfigurationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateProxyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateProxyRuleGroupPrioritiesRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateProxyRulePrioritiesRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateProxyRuleRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateSubnetChangeProtectionRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateTlsInspectionConfigurationRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link NetworkFirewallAsyncClient}.
 *
 * @see NetworkFirewallAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultNetworkFirewallAsyncClient implements NetworkFirewallAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultNetworkFirewallAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultNetworkFirewallAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "Network_Firewall" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Accepts a transit gateway attachment request for Network Firewall. When you accept the attachment request,
     * Network Firewall creates the necessary routing components to enable traffic flow between the transit gateway and
     * firewall endpoints.
     * </p>
     * <p>
     * You must accept a transit gateway attachment to complete the creation of a transit gateway-attached firewall,
     * unless auto-accept is enabled on the transit gateway. After acceptance, use <a>DescribeFirewall</a> to verify the
     * firewall status.
     * </p>
     * <p>
     * To reject an attachment instead of accepting it, use <a>RejectNetworkFirewallTransitGatewayAttachment</a>.
     * </p>
     * <note>
     * <p>
     * It can take several minutes for the attachment acceptance to complete and the firewall to become available.
     * </p>
     * </note>
     *
     * @param acceptNetworkFirewallTransitGatewayAttachmentRequest
     * @return A Java Future containing the result of the AcceptNetworkFirewallTransitGatewayAttachment operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.AcceptNetworkFirewallTransitGatewayAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AcceptNetworkFirewallTransitGatewayAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptNetworkFirewallTransitGatewayAttachmentResponse> acceptNetworkFirewallTransitGatewayAttachment(
            AcceptNetworkFirewallTransitGatewayAttachmentRequest acceptNetworkFirewallTransitGatewayAttachmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                acceptNetworkFirewallTransitGatewayAttachmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                acceptNetworkFirewallTransitGatewayAttachmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptNetworkFirewallTransitGatewayAttachment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AcceptNetworkFirewallTransitGatewayAttachmentResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AcceptNetworkFirewallTransitGatewayAttachmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AcceptNetworkFirewallTransitGatewayAttachmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptNetworkFirewallTransitGatewayAttachmentRequest, AcceptNetworkFirewallTransitGatewayAttachmentResponse>()
                            .withOperationName("AcceptNetworkFirewallTransitGatewayAttachment")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AcceptNetworkFirewallTransitGatewayAttachmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(acceptNetworkFirewallTransitGatewayAttachmentRequest));
            CompletableFuture<AcceptNetworkFirewallTransitGatewayAttachmentResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates the specified Availability Zones with a transit gateway-attached firewall. For each Availability Zone,
     * Network Firewall creates a firewall endpoint to process traffic. You can specify one or more Availability Zones
     * where you want to deploy the firewall.
     * </p>
     * <p>
     * After adding Availability Zones, you must update your transit gateway route tables to direct traffic through the
     * new firewall endpoints. Use <a>DescribeFirewall</a> to monitor the status of the new endpoints.
     * </p>
     *
     * @param associateAvailabilityZonesRequest
     * @return A Java Future containing the result of the AssociateAvailabilityZones operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>InsufficientCapacityException Amazon Web Services doesn't currently have enough available capacity to
     *         fulfill your request. Try your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.AssociateAvailabilityZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AssociateAvailabilityZones"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateAvailabilityZonesResponse> associateAvailabilityZones(
            AssociateAvailabilityZonesRequest associateAvailabilityZonesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateAvailabilityZonesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateAvailabilityZonesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateAvailabilityZones");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateAvailabilityZonesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateAvailabilityZonesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AssociateAvailabilityZonesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateAvailabilityZonesRequest, AssociateAvailabilityZonesResponse>()
                            .withOperationName("AssociateAvailabilityZones").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateAvailabilityZonesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateAvailabilityZonesRequest));
            CompletableFuture<AssociateAvailabilityZonesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a <a>FirewallPolicy</a> to a <a>Firewall</a>.
     * </p>
     * <p>
     * A firewall policy defines how to monitor and manage your VPC network traffic, using a collection of inspection
     * rule groups and other settings. Each firewall requires one firewall policy association, and you can use the same
     * firewall policy for multiple firewalls.
     * </p>
     *
     * @param associateFirewallPolicyRequest
     * @return A Java Future containing the result of the AssociateFirewallPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.AssociateFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AssociateFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateFirewallPolicyResponse> associateFirewallPolicy(
            AssociateFirewallPolicyRequest associateFirewallPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateFirewallPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateFirewallPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateFirewallPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateFirewallPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateFirewallPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AssociateFirewallPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateFirewallPolicyRequest, AssociateFirewallPolicyResponse>()
                            .withOperationName("AssociateFirewallPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateFirewallPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateFirewallPolicyRequest));
            CompletableFuture<AssociateFirewallPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates the specified subnets in the Amazon VPC to the firewall. You can specify one subnet for each of the
     * Availability Zones that the VPC spans.
     * </p>
     * <p>
     * This request creates an Network Firewall firewall endpoint in each of the subnets. To enable the firewall's
     * protections, you must also modify the VPC's route tables for each subnet's Availability Zone, to redirect the
     * traffic that's coming into and going out of the zone through the firewall endpoint.
     * </p>
     *
     * @param associateSubnetsRequest
     * @return A Java Future containing the result of the AssociateSubnets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>InsufficientCapacityException Amazon Web Services doesn't currently have enough available capacity to
     *         fulfill your request. Try your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.AssociateSubnets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AssociateSubnets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateSubnetsResponse> associateSubnets(AssociateSubnetsRequest associateSubnetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateSubnetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateSubnetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateSubnets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateSubnetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateSubnetsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AssociateSubnetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateSubnetsRequest, AssociateSubnetsResponse>()
                            .withOperationName("AssociateSubnets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateSubnetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateSubnetsRequest));
            CompletableFuture<AssociateSubnetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches <a>ProxyRuleGroup</a> resources to a <a>ProxyConfiguration</a>
     * </p>
     * <p>
     * A Proxy Configuration defines the monitoring and protection behavior for a Proxy. The details of the behavior are
     * defined in the rule groups that you add to your configuration.
     * </p>
     *
     * @param attachRuleGroupsToProxyConfigurationRequest
     * @return A Java Future containing the result of the AttachRuleGroupsToProxyConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.AttachRuleGroupsToProxyConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AttachRuleGroupsToProxyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AttachRuleGroupsToProxyConfigurationResponse> attachRuleGroupsToProxyConfiguration(
            AttachRuleGroupsToProxyConfigurationRequest attachRuleGroupsToProxyConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachRuleGroupsToProxyConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                attachRuleGroupsToProxyConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachRuleGroupsToProxyConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AttachRuleGroupsToProxyConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AttachRuleGroupsToProxyConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AttachRuleGroupsToProxyConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachRuleGroupsToProxyConfigurationRequest, AttachRuleGroupsToProxyConfigurationResponse>()
                            .withOperationName("AttachRuleGroupsToProxyConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AttachRuleGroupsToProxyConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(attachRuleGroupsToProxyConfigurationRequest));
            CompletableFuture<AttachRuleGroupsToProxyConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Network Firewall <a>Firewall</a> and accompanying <a>FirewallStatus</a> for a VPC.
     * </p>
     * <p>
     * The firewall defines the configuration settings for an Network Firewall firewall. The settings that you can
     * define at creation include the firewall policy, the subnets in your VPC to use for the firewall endpoints, and
     * any tags that are attached to the firewall Amazon Web Services resource.
     * </p>
     * <p>
     * After you create a firewall, you can provide additional settings, like the logging configuration.
     * </p>
     * <p>
     * To update the settings for a firewall, you use the operations that apply to the settings themselves, for example
     * <a>UpdateLoggingConfiguration</a>, <a>AssociateSubnets</a>, and <a>UpdateFirewallDeleteProtection</a>.
     * </p>
     * <p>
     * To manage a firewall's tags, use the standard Amazon Web Services resource tagging operations,
     * <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about firewalls, use <a>ListFirewalls</a> and <a>DescribeFirewall</a>.
     * </p>
     * <p>
     * To generate a report on the last 30 days of traffic monitored by a firewall, use <a>StartAnalysisReport</a>.
     * </p>
     *
     * @param createFirewallRequest
     * @return A Java Future containing the result of the CreateFirewall operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>LimitExceededException Unable to perform the operation because doing so would violate a limit
     *         setting.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InsufficientCapacityException Amazon Web Services doesn't currently have enough available capacity to
     *         fulfill your request. Try your request later.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.CreateFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFirewallResponse> createFirewall(CreateFirewallRequest createFirewallRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFirewallRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFirewallRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFirewall");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFirewallResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFirewallResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateFirewallResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFirewallRequest, CreateFirewallResponse>()
                            .withOperationName("CreateFirewall").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFirewallRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFirewallRequest));
            CompletableFuture<CreateFirewallResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates the firewall policy for the firewall according to the specifications.
     * </p>
     * <p>
     * An Network Firewall firewall policy defines the behavior of a firewall, in a collection of stateless and stateful
     * rule groups and other settings. You can use one firewall policy for multiple firewalls.
     * </p>
     *
     * @param createFirewallPolicyRequest
     * @return A Java Future containing the result of the CreateFirewallPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException Unable to perform the operation because doing so would violate a limit
     *         setting.</li>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>InsufficientCapacityException Amazon Web Services doesn't currently have enough available capacity to
     *         fulfill your request. Try your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.CreateFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFirewallPolicyResponse> createFirewallPolicy(
            CreateFirewallPolicyRequest createFirewallPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFirewallPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFirewallPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFirewallPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFirewallPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFirewallPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateFirewallPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFirewallPolicyRequest, CreateFirewallPolicyResponse>()
                            .withOperationName("CreateFirewallPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFirewallPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFirewallPolicyRequest));
            CompletableFuture<CreateFirewallPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Network Firewall <a>Proxy</a>
     * </p>
     * <p>
     * Attaches a Proxy configuration to a NAT Gateway.
     * </p>
     * <p>
     * To manage a proxy's tags, use the standard Amazon Web Services resource tagging operations,
     * <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about proxies, use <a>ListProxies</a> and <a>DescribeProxy</a>.
     * </p>
     *
     * @param createProxyRequest
     * @return A Java Future containing the result of the CreateProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>UnsupportedOperationException The operation you requested isn't supported by Network Firewall.</li>
     *         <li>LimitExceededException Unable to perform the operation because doing so would violate a limit
     *         setting.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.CreateProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateProxy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateProxyResponse> createProxy(CreateProxyRequest createProxyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createProxyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProxyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProxy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateProxyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateProxyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateProxyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateProxyRequest, CreateProxyResponse>()
                            .withOperationName("CreateProxy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateProxyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createProxyRequest));
            CompletableFuture<CreateProxyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Network Firewall <a>ProxyConfiguration</a>
     * </p>
     * <p>
     * A Proxy Configuration defines the monitoring and protection behavior for a Proxy. The details of the behavior are
     * defined in the rule groups that you add to your configuration.
     * </p>
     * <p>
     * To manage a proxy configuration's tags, use the standard Amazon Web Services resource tagging operations,
     * <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about proxies, use <a>ListProxyConfigurations</a> and <a>DescribeProxyConfiguration</a>.
     * </p>
     *
     * @param createProxyConfigurationRequest
     * @return A Java Future containing the result of the CreateProxyConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>LimitExceededException Unable to perform the operation because doing so would violate a limit
     *         setting.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.CreateProxyConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateProxyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateProxyConfigurationResponse> createProxyConfiguration(
            CreateProxyConfigurationRequest createProxyConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createProxyConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProxyConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProxyConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateProxyConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateProxyConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateProxyConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateProxyConfigurationRequest, CreateProxyConfigurationResponse>()
                            .withOperationName("CreateProxyConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateProxyConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createProxyConfigurationRequest));
            CompletableFuture<CreateProxyConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Network Firewall <a>ProxyRuleGroup</a>
     * </p>
     * <p>
     * Collections of related proxy filtering rules. Rule groups help you manage and reuse sets of rules across multiple
     * proxy configurations.
     * </p>
     * <p>
     * To manage a proxy rule group's tags, use the standard Amazon Web Services resource tagging operations,
     * <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about proxy rule groups, use <a>ListProxyRuleGroups</a> and
     * <a>DescribeProxyRuleGroup</a>.
     * </p>
     * <p>
     * To retrieve information about individual proxy rules, use <a>DescribeProxyRuleGroup</a> and
     * <a>DescribeProxyRule</a>.
     * </p>
     *
     * @param createProxyRuleGroupRequest
     * @return A Java Future containing the result of the CreateProxyRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>LimitExceededException Unable to perform the operation because doing so would violate a limit
     *         setting.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.CreateProxyRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateProxyRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateProxyRuleGroupResponse> createProxyRuleGroup(
            CreateProxyRuleGroupRequest createProxyRuleGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createProxyRuleGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProxyRuleGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProxyRuleGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateProxyRuleGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateProxyRuleGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateProxyRuleGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateProxyRuleGroupRequest, CreateProxyRuleGroupResponse>()
                            .withOperationName("CreateProxyRuleGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateProxyRuleGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createProxyRuleGroupRequest));
            CompletableFuture<CreateProxyRuleGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates Network Firewall <a>ProxyRule</a> resources.
     * </p>
     * <p>
     * Attaches new proxy rule(s) to an existing proxy rule group.
     * </p>
     * <p>
     * To retrieve information about individual proxy rules, use <a>DescribeProxyRuleGroup</a> and
     * <a>DescribeProxyRule</a>.
     * </p>
     *
     * @param createProxyRulesRequest
     * @return A Java Future containing the result of the CreateProxyRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.CreateProxyRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateProxyRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateProxyRulesResponse> createProxyRules(CreateProxyRulesRequest createProxyRulesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createProxyRulesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProxyRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProxyRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateProxyRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateProxyRulesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateProxyRulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateProxyRulesRequest, CreateProxyRulesResponse>()
                            .withOperationName("CreateProxyRules").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateProxyRulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createProxyRulesRequest));
            CompletableFuture<CreateProxyRulesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates the specified stateless or stateful rule group, which includes the rules for network traffic inspection,
     * a capacity setting, and tags.
     * </p>
     * <p>
     * You provide your rule group specification in your request using either <code>RuleGroup</code> or
     * <code>Rules</code>.
     * </p>
     *
     * @param createRuleGroupRequest
     * @return A Java Future containing the result of the CreateRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException Unable to perform the operation because doing so would violate a limit
     *         setting.</li>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>InsufficientCapacityException Amazon Web Services doesn't currently have enough available capacity to
     *         fulfill your request. Try your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.CreateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRuleGroupResponse> createRuleGroup(CreateRuleGroupRequest createRuleGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRuleGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRuleGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRuleGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRuleGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRuleGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateRuleGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRuleGroupRequest, CreateRuleGroupResponse>()
                            .withOperationName("CreateRuleGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRuleGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRuleGroupRequest));
            CompletableFuture<CreateRuleGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Network Firewall TLS inspection configuration. Network Firewall uses TLS inspection configurations to
     * decrypt your firewall's inbound and outbound SSL/TLS traffic. After decryption, Network Firewall inspects the
     * traffic according to your firewall policy's stateful rules, and then re-encrypts it before sending it to its
     * destination. You can enable inspection of your firewall's inbound traffic, outbound traffic, or both. To use TLS
     * inspection with your firewall, you must first import or provision certificates using ACM, create a TLS inspection
     * configuration, add that configuration to a new firewall policy, and then associate that policy with your
     * firewall.
     * </p>
     * <p>
     * To update the settings for a TLS inspection configuration, use <a>UpdateTLSInspectionConfiguration</a>.
     * </p>
     * <p>
     * To manage a TLS inspection configuration's tags, use the standard Amazon Web Services resource tagging
     * operations, <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about TLS inspection configurations, use <a>ListTLSInspectionConfigurations</a> and
     * <a>DescribeTLSInspectionConfiguration</a>.
     * </p>
     * <p>
     * For more information about TLS inspection configurations, see <a
     * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Inspecting SSL/TLS
     * traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     *
     * @param createTlsInspectionConfigurationRequest
     * @return A Java Future containing the result of the CreateTLSInspectionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>LimitExceededException Unable to perform the operation because doing so would violate a limit
     *         setting.</li>
     *         <li>InsufficientCapacityException Amazon Web Services doesn't currently have enough available capacity to
     *         fulfill your request. Try your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.CreateTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTlsInspectionConfigurationResponse> createTLSInspectionConfiguration(
            CreateTlsInspectionConfigurationRequest createTlsInspectionConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTlsInspectionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTlsInspectionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTLSInspectionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTlsInspectionConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateTlsInspectionConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateTlsInspectionConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTlsInspectionConfigurationRequest, CreateTlsInspectionConfigurationResponse>()
                            .withOperationName("CreateTLSInspectionConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTlsInspectionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTlsInspectionConfigurationRequest));
            CompletableFuture<CreateTlsInspectionConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a firewall endpoint for an Network Firewall firewall. This type of firewall endpoint is independent of
     * the firewall endpoints that you specify in the <code>Firewall</code> itself, and you define it in addition to
     * those endpoints after the firewall has been created. You can define a VPC endpoint association using a different
     * VPC than the one you used in the firewall specifications.
     * </p>
     *
     * @param createVpcEndpointAssociationRequest
     * @return A Java Future containing the result of the CreateVpcEndpointAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException Unable to perform the operation because doing so would violate a limit
     *         setting.</li>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>InsufficientCapacityException Amazon Web Services doesn't currently have enough available capacity to
     *         fulfill your request. Try your request later.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.CreateVpcEndpointAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateVpcEndpointAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpcEndpointAssociationResponse> createVpcEndpointAssociation(
            CreateVpcEndpointAssociationRequest createVpcEndpointAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpcEndpointAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVpcEndpointAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpcEndpointAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateVpcEndpointAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateVpcEndpointAssociationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateVpcEndpointAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVpcEndpointAssociationRequest, CreateVpcEndpointAssociationResponse>()
                            .withOperationName("CreateVpcEndpointAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateVpcEndpointAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createVpcEndpointAssociationRequest));
            CompletableFuture<CreateVpcEndpointAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified <a>Firewall</a> and its <a>FirewallStatus</a>. This operation requires the firewall's
     * <code>DeleteProtection</code> flag to be <code>FALSE</code>. You can't revert this operation.
     * </p>
     * <p>
     * You can check whether a firewall is in use by reviewing the route tables for the Availability Zones where you
     * have firewall subnet mappings. Retrieve the subnet mappings by calling <a>DescribeFirewall</a>. You define and
     * update the route tables through Amazon VPC. As needed, update the route tables for the zones to remove the
     * firewall endpoints. When the route tables no longer use the firewall endpoints, you can remove the firewall
     * safely.
     * </p>
     * <p>
     * To delete a firewall, remove the delete protection if you need to using <a>UpdateFirewallDeleteProtection</a>,
     * then delete the firewall by calling <a>DeleteFirewall</a>.
     * </p>
     *
     * @param deleteFirewallRequest
     * @return A Java Future containing the result of the DeleteFirewall operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>UnsupportedOperationException The operation you requested isn't supported by Network Firewall.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DeleteFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFirewallResponse> deleteFirewall(DeleteFirewallRequest deleteFirewallRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFirewallRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFirewallRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFirewall");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFirewallResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFirewallResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteFirewallResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFirewallRequest, DeleteFirewallResponse>()
                            .withOperationName("DeleteFirewall").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFirewallRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFirewallRequest));
            CompletableFuture<DeleteFirewallResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified <a>FirewallPolicy</a>.
     * </p>
     *
     * @param deleteFirewallPolicyRequest
     * @return A Java Future containing the result of the DeleteFirewallPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>UnsupportedOperationException The operation you requested isn't supported by Network Firewall.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DeleteFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFirewallPolicyResponse> deleteFirewallPolicy(
            DeleteFirewallPolicyRequest deleteFirewallPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFirewallPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFirewallPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFirewallPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFirewallPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFirewallPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteFirewallPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFirewallPolicyRequest, DeleteFirewallPolicyResponse>()
                            .withOperationName("DeleteFirewallPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFirewallPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFirewallPolicyRequest));
            CompletableFuture<DeleteFirewallPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a transit gateway attachment from a Network Firewall. Either the firewall owner or the transit gateway
     * owner can delete the attachment.
     * </p>
     * <important>
     * <p>
     * After you delete a transit gateway attachment, traffic will no longer flow through the firewall endpoints.
     * </p>
     * </important>
     * <p>
     * After you initiate the delete operation, use <a>DescribeFirewall</a> to monitor the deletion status.
     * </p>
     *
     * @param deleteNetworkFirewallTransitGatewayAttachmentRequest
     * @return A Java Future containing the result of the DeleteNetworkFirewallTransitGatewayAttachment operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DeleteNetworkFirewallTransitGatewayAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteNetworkFirewallTransitGatewayAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNetworkFirewallTransitGatewayAttachmentResponse> deleteNetworkFirewallTransitGatewayAttachment(
            DeleteNetworkFirewallTransitGatewayAttachmentRequest deleteNetworkFirewallTransitGatewayAttachmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deleteNetworkFirewallTransitGatewayAttachmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteNetworkFirewallTransitGatewayAttachmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetworkFirewallTransitGatewayAttachment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteNetworkFirewallTransitGatewayAttachmentResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteNetworkFirewallTransitGatewayAttachmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteNetworkFirewallTransitGatewayAttachmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNetworkFirewallTransitGatewayAttachmentRequest, DeleteNetworkFirewallTransitGatewayAttachmentResponse>()
                            .withOperationName("DeleteNetworkFirewallTransitGatewayAttachment")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteNetworkFirewallTransitGatewayAttachmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteNetworkFirewallTransitGatewayAttachmentRequest));
            CompletableFuture<DeleteNetworkFirewallTransitGatewayAttachmentResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified <a>Proxy</a>.
     * </p>
     * <p>
     * Detaches a Proxy configuration from a NAT Gateway.
     * </p>
     *
     * @param deleteProxyRequest
     * @return A Java Future containing the result of the DeleteProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>UnsupportedOperationException The operation you requested isn't supported by Network Firewall.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DeleteProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteProxy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteProxyResponse> deleteProxy(DeleteProxyRequest deleteProxyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteProxyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteProxyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProxy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteProxyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteProxyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteProxyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteProxyRequest, DeleteProxyResponse>()
                            .withOperationName("DeleteProxy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteProxyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteProxyRequest));
            CompletableFuture<DeleteProxyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified <a>ProxyConfiguration</a>.
     * </p>
     *
     * @param deleteProxyConfigurationRequest
     * @return A Java Future containing the result of the DeleteProxyConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DeleteProxyConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteProxyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteProxyConfigurationResponse> deleteProxyConfiguration(
            DeleteProxyConfigurationRequest deleteProxyConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteProxyConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteProxyConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProxyConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteProxyConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteProxyConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteProxyConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteProxyConfigurationRequest, DeleteProxyConfigurationResponse>()
                            .withOperationName("DeleteProxyConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteProxyConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteProxyConfigurationRequest));
            CompletableFuture<DeleteProxyConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified <a>ProxyRuleGroup</a>.
     * </p>
     *
     * @param deleteProxyRuleGroupRequest
     * @return A Java Future containing the result of the DeleteProxyRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DeleteProxyRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteProxyRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteProxyRuleGroupResponse> deleteProxyRuleGroup(
            DeleteProxyRuleGroupRequest deleteProxyRuleGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteProxyRuleGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteProxyRuleGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProxyRuleGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteProxyRuleGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteProxyRuleGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteProxyRuleGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteProxyRuleGroupRequest, DeleteProxyRuleGroupResponse>()
                            .withOperationName("DeleteProxyRuleGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteProxyRuleGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteProxyRuleGroupRequest));
            CompletableFuture<DeleteProxyRuleGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified <a>ProxyRule</a>(s). currently attached to a <a>ProxyRuleGroup</a>
     * </p>
     *
     * @param deleteProxyRulesRequest
     * @return A Java Future containing the result of the DeleteProxyRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DeleteProxyRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteProxyRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteProxyRulesResponse> deleteProxyRules(DeleteProxyRulesRequest deleteProxyRulesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteProxyRulesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteProxyRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProxyRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteProxyRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteProxyRulesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteProxyRulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteProxyRulesRequest, DeleteProxyRulesResponse>()
                            .withOperationName("DeleteProxyRules").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteProxyRulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteProxyRulesRequest));
            CompletableFuture<DeleteProxyRulesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a resource policy that you created in a <a>PutResourcePolicy</a> request.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidResourcePolicyException The policy statement failed validation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResourcePolicyRequest, DeleteResourcePolicyResponse>()
                            .withOperationName("DeleteResourcePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteResourcePolicyRequest));
            CompletableFuture<DeleteResourcePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified <a>RuleGroup</a>.
     * </p>
     *
     * @param deleteRuleGroupRequest
     * @return A Java Future containing the result of the DeleteRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>UnsupportedOperationException The operation you requested isn't supported by Network Firewall.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DeleteRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRuleGroupResponse> deleteRuleGroup(DeleteRuleGroupRequest deleteRuleGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRuleGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRuleGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRuleGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRuleGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRuleGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteRuleGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRuleGroupRequest, DeleteRuleGroupResponse>()
                            .withOperationName("DeleteRuleGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRuleGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRuleGroupRequest));
            CompletableFuture<DeleteRuleGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified <a>TLSInspectionConfiguration</a>.
     * </p>
     *
     * @param deleteTlsInspectionConfigurationRequest
     * @return A Java Future containing the result of the DeleteTLSInspectionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DeleteTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTlsInspectionConfigurationResponse> deleteTLSInspectionConfiguration(
            DeleteTlsInspectionConfigurationRequest deleteTlsInspectionConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTlsInspectionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteTlsInspectionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTLSInspectionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTlsInspectionConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteTlsInspectionConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteTlsInspectionConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTlsInspectionConfigurationRequest, DeleteTlsInspectionConfigurationResponse>()
                            .withOperationName("DeleteTLSInspectionConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTlsInspectionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTlsInspectionConfigurationRequest));
            CompletableFuture<DeleteTlsInspectionConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified <a>VpcEndpointAssociation</a>.
     * </p>
     * <p>
     * You can check whether an endpoint association is in use by reviewing the route tables for the Availability Zones
     * where you have the endpoint subnet mapping. You can retrieve the subnet mapping by calling
     * <a>DescribeVpcEndpointAssociation</a>. You define and update the route tables through Amazon VPC. As needed,
     * update the route tables for the Availability Zone to remove the firewall endpoint for the association. When the
     * route tables no longer use the firewall endpoint, you can remove the endpoint association safely.
     * </p>
     *
     * @param deleteVpcEndpointAssociationRequest
     * @return A Java Future containing the result of the DeleteVpcEndpointAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DeleteVpcEndpointAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteVpcEndpointAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVpcEndpointAssociationResponse> deleteVpcEndpointAssociation(
            DeleteVpcEndpointAssociationRequest deleteVpcEndpointAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVpcEndpointAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVpcEndpointAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVpcEndpointAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVpcEndpointAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteVpcEndpointAssociationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteVpcEndpointAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVpcEndpointAssociationRequest, DeleteVpcEndpointAssociationResponse>()
                            .withOperationName("DeleteVpcEndpointAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteVpcEndpointAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteVpcEndpointAssociationRequest));
            CompletableFuture<DeleteVpcEndpointAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the data objects for the specified firewall.
     * </p>
     *
     * @param describeFirewallRequest
     * @return A Java Future containing the result of the DescribeFirewall operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFirewallResponse> describeFirewall(DescribeFirewallRequest describeFirewallRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFirewallRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFirewallRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFirewall");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFirewallResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFirewallResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeFirewallResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFirewallRequest, DescribeFirewallResponse>()
                            .withOperationName("DescribeFirewall").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFirewallRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFirewallRequest));
            CompletableFuture<DescribeFirewallResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the high-level information about a firewall, including the Availability Zones where the Firewall is
     * currently in use.
     * </p>
     *
     * @param describeFirewallMetadataRequest
     * @return A Java Future containing the result of the DescribeFirewallMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeFirewallMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFirewallMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFirewallMetadataResponse> describeFirewallMetadata(
            DescribeFirewallMetadataRequest describeFirewallMetadataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFirewallMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFirewallMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFirewallMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFirewallMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFirewallMetadataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeFirewallMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFirewallMetadataRequest, DescribeFirewallMetadataResponse>()
                            .withOperationName("DescribeFirewallMetadata").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFirewallMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFirewallMetadataRequest));
            CompletableFuture<DescribeFirewallMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the data objects for the specified firewall policy.
     * </p>
     *
     * @param describeFirewallPolicyRequest
     * @return A Java Future containing the result of the DescribeFirewallPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFirewallPolicyResponse> describeFirewallPolicy(
            DescribeFirewallPolicyRequest describeFirewallPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFirewallPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFirewallPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFirewallPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFirewallPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFirewallPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeFirewallPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFirewallPolicyRequest, DescribeFirewallPolicyResponse>()
                            .withOperationName("DescribeFirewallPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFirewallPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFirewallPolicyRequest));
            CompletableFuture<DescribeFirewallPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns key information about a specific flow operation.
     * </p>
     *
     * @param describeFlowOperationRequest
     * @return A Java Future containing the result of the DescribeFlowOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeFlowOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFlowOperation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFlowOperationResponse> describeFlowOperation(
            DescribeFlowOperationRequest describeFlowOperationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFlowOperationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFlowOperationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFlowOperation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFlowOperationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFlowOperationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeFlowOperationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFlowOperationRequest, DescribeFlowOperationResponse>()
                            .withOperationName("DescribeFlowOperation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFlowOperationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFlowOperationRequest));
            CompletableFuture<DescribeFlowOperationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the logging configuration for the specified firewall.
     * </p>
     *
     * @param describeLoggingConfigurationRequest
     * @return A Java Future containing the result of the DescribeLoggingConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLoggingConfigurationResponse> describeLoggingConfiguration(
            DescribeLoggingConfigurationRequest describeLoggingConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeLoggingConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeLoggingConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLoggingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeLoggingConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeLoggingConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeLoggingConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeLoggingConfigurationRequest, DescribeLoggingConfigurationResponse>()
                            .withOperationName("DescribeLoggingConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeLoggingConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeLoggingConfigurationRequest));
            CompletableFuture<DescribeLoggingConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the data objects for the specified proxy.
     * </p>
     *
     * @param describeProxyRequest
     * @return A Java Future containing the result of the DescribeProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeProxy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeProxyResponse> describeProxy(DescribeProxyRequest describeProxyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeProxyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProxyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProxy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeProxyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeProxyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeProxyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeProxyRequest, DescribeProxyResponse>()
                            .withOperationName("DescribeProxy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeProxyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeProxyRequest));
            CompletableFuture<DescribeProxyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the data objects for the specified proxy configuration.
     * </p>
     *
     * @param describeProxyConfigurationRequest
     * @return A Java Future containing the result of the DescribeProxyConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeProxyConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeProxyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeProxyConfigurationResponse> describeProxyConfiguration(
            DescribeProxyConfigurationRequest describeProxyConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeProxyConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProxyConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProxyConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeProxyConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeProxyConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeProxyConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeProxyConfigurationRequest, DescribeProxyConfigurationResponse>()
                            .withOperationName("DescribeProxyConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeProxyConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeProxyConfigurationRequest));
            CompletableFuture<DescribeProxyConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the data objects for the specified proxy configuration for the specified proxy rule group.
     * </p>
     *
     * @param describeProxyRuleRequest
     * @return A Java Future containing the result of the DescribeProxyRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeProxyRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeProxyRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeProxyRuleResponse> describeProxyRule(DescribeProxyRuleRequest describeProxyRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeProxyRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProxyRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProxyRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeProxyRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeProxyRuleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeProxyRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeProxyRuleRequest, DescribeProxyRuleResponse>()
                            .withOperationName("DescribeProxyRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeProxyRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeProxyRuleRequest));
            CompletableFuture<DescribeProxyRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the data objects for the specified proxy rule group.
     * </p>
     *
     * @param describeProxyRuleGroupRequest
     * @return A Java Future containing the result of the DescribeProxyRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeProxyRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeProxyRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeProxyRuleGroupResponse> describeProxyRuleGroup(
            DescribeProxyRuleGroupRequest describeProxyRuleGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeProxyRuleGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProxyRuleGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProxyRuleGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeProxyRuleGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeProxyRuleGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeProxyRuleGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeProxyRuleGroupRequest, DescribeProxyRuleGroupResponse>()
                            .withOperationName("DescribeProxyRuleGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeProxyRuleGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeProxyRuleGroupRequest));
            CompletableFuture<DescribeProxyRuleGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a resource policy that you created in a <a>PutResourcePolicy</a> request.
     * </p>
     *
     * @param describeResourcePolicyRequest
     * @return A Java Future containing the result of the DescribeResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeResourcePolicyResponse> describeResourcePolicy(
            DescribeResourcePolicyRequest describeResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeResourcePolicyRequest, DescribeResourcePolicyResponse>()
                            .withOperationName("DescribeResourcePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeResourcePolicyRequest));
            CompletableFuture<DescribeResourcePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the data objects for the specified rule group.
     * </p>
     *
     * @param describeRuleGroupRequest
     * @return A Java Future containing the result of the DescribeRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRuleGroupResponse> describeRuleGroup(DescribeRuleGroupRequest describeRuleGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRuleGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRuleGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRuleGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRuleGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRuleGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeRuleGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRuleGroupRequest, DescribeRuleGroupResponse>()
                            .withOperationName("DescribeRuleGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRuleGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRuleGroupRequest));
            CompletableFuture<DescribeRuleGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * High-level information about a rule group, returned by operations like create and describe. You can use the
     * information provided in the metadata to retrieve and manage a rule group. You can retrieve all objects for a rule
     * group by calling <a>DescribeRuleGroup</a>.
     * </p>
     *
     * @param describeRuleGroupMetadataRequest
     * @return A Java Future containing the result of the DescribeRuleGroupMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeRuleGroupMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeRuleGroupMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRuleGroupMetadataResponse> describeRuleGroupMetadata(
            DescribeRuleGroupMetadataRequest describeRuleGroupMetadataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRuleGroupMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRuleGroupMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRuleGroupMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRuleGroupMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRuleGroupMetadataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeRuleGroupMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRuleGroupMetadataRequest, DescribeRuleGroupMetadataResponse>()
                            .withOperationName("DescribeRuleGroupMetadata").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRuleGroupMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRuleGroupMetadataRequest));
            CompletableFuture<DescribeRuleGroupMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns detailed information for a stateful rule group.
     * </p>
     * <p>
     * For active threat defense Amazon Web Services managed rule groups, this operation provides insight into the
     * protections enabled by the rule group, based on Suricata rule metadata fields. Summaries are available for rule
     * groups you manage and for active threat defense Amazon Web Services managed rule groups.
     * </p>
     * <p>
     * To modify how threat information appears in summaries, use the <code>SummaryConfiguration</code> parameter in
     * <a>UpdateRuleGroup</a>.
     * </p>
     *
     * @param describeRuleGroupSummaryRequest
     * @return A Java Future containing the result of the DescribeRuleGroupSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeRuleGroupSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeRuleGroupSummary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRuleGroupSummaryResponse> describeRuleGroupSummary(
            DescribeRuleGroupSummaryRequest describeRuleGroupSummaryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRuleGroupSummaryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRuleGroupSummaryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRuleGroupSummary");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRuleGroupSummaryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRuleGroupSummaryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeRuleGroupSummaryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRuleGroupSummaryRequest, DescribeRuleGroupSummaryResponse>()
                            .withOperationName("DescribeRuleGroupSummary").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRuleGroupSummaryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRuleGroupSummaryRequest));
            CompletableFuture<DescribeRuleGroupSummaryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the data objects for the specified TLS inspection configuration.
     * </p>
     *
     * @param describeTlsInspectionConfigurationRequest
     * @return A Java Future containing the result of the DescribeTLSInspectionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTlsInspectionConfigurationResponse> describeTLSInspectionConfiguration(
            DescribeTlsInspectionConfigurationRequest describeTlsInspectionConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTlsInspectionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeTlsInspectionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTLSInspectionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTlsInspectionConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeTlsInspectionConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeTlsInspectionConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTlsInspectionConfigurationRequest, DescribeTlsInspectionConfigurationResponse>()
                            .withOperationName("DescribeTLSInspectionConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeTlsInspectionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeTlsInspectionConfigurationRequest));
            CompletableFuture<DescribeTlsInspectionConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the data object for the specified VPC endpoint association.
     * </p>
     *
     * @param describeVpcEndpointAssociationRequest
     * @return A Java Future containing the result of the DescribeVpcEndpointAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeVpcEndpointAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeVpcEndpointAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeVpcEndpointAssociationResponse> describeVpcEndpointAssociation(
            DescribeVpcEndpointAssociationRequest describeVpcEndpointAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeVpcEndpointAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeVpcEndpointAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeVpcEndpointAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeVpcEndpointAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeVpcEndpointAssociationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeVpcEndpointAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeVpcEndpointAssociationRequest, DescribeVpcEndpointAssociationResponse>()
                            .withOperationName("DescribeVpcEndpointAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeVpcEndpointAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeVpcEndpointAssociationRequest));
            CompletableFuture<DescribeVpcEndpointAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detaches <a>ProxyRuleGroup</a> resources from a <a>ProxyConfiguration</a>
     * </p>
     * <p>
     * A Proxy Configuration defines the monitoring and protection behavior for a Proxy. The details of the behavior are
     * defined in the rule groups that you add to your configuration.
     * </p>
     *
     * @param detachRuleGroupsFromProxyConfigurationRequest
     * @return A Java Future containing the result of the DetachRuleGroupsFromProxyConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DetachRuleGroupsFromProxyConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DetachRuleGroupsFromProxyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DetachRuleGroupsFromProxyConfigurationResponse> detachRuleGroupsFromProxyConfiguration(
            DetachRuleGroupsFromProxyConfigurationRequest detachRuleGroupsFromProxyConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detachRuleGroupsFromProxyConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                detachRuleGroupsFromProxyConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetachRuleGroupsFromProxyConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetachRuleGroupsFromProxyConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DetachRuleGroupsFromProxyConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DetachRuleGroupsFromProxyConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetachRuleGroupsFromProxyConfigurationRequest, DetachRuleGroupsFromProxyConfigurationResponse>()
                            .withOperationName("DetachRuleGroupsFromProxyConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DetachRuleGroupsFromProxyConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(detachRuleGroupsFromProxyConfigurationRequest));
            CompletableFuture<DetachRuleGroupsFromProxyConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified Availability Zone associations from a transit gateway-attached firewall. This removes the
     * firewall endpoints from these Availability Zones and stops traffic filtering in those zones. Before removing an
     * Availability Zone, ensure you've updated your transit gateway route tables to redirect traffic appropriately.
     * </p>
     * <note>
     * <p>
     * If <code>AvailabilityZoneChangeProtection</code> is enabled, you must first disable it using
     * <a>UpdateAvailabilityZoneChangeProtection</a>.
     * </p>
     * </note>
     * <p>
     * To verify the status of your Availability Zone changes, use <a>DescribeFirewall</a>.
     * </p>
     *
     * @param disassociateAvailabilityZonesRequest
     * @return A Java Future containing the result of the DisassociateAvailabilityZones operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DisassociateAvailabilityZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DisassociateAvailabilityZones"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateAvailabilityZonesResponse> disassociateAvailabilityZones(
            DisassociateAvailabilityZonesRequest disassociateAvailabilityZonesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateAvailabilityZonesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateAvailabilityZonesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateAvailabilityZones");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateAvailabilityZonesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateAvailabilityZonesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DisassociateAvailabilityZonesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateAvailabilityZonesRequest, DisassociateAvailabilityZonesResponse>()
                            .withOperationName("DisassociateAvailabilityZones").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateAvailabilityZonesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateAvailabilityZonesRequest));
            CompletableFuture<DisassociateAvailabilityZonesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified subnet associations from the firewall. This removes the firewall endpoints from the subnets
     * and removes any network filtering protections that the endpoints were providing.
     * </p>
     *
     * @param disassociateSubnetsRequest
     * @return A Java Future containing the result of the DisassociateSubnets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DisassociateSubnets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DisassociateSubnets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateSubnetsResponse> disassociateSubnets(
            DisassociateSubnetsRequest disassociateSubnetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateSubnetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateSubnetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateSubnets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateSubnetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateSubnetsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DisassociateSubnetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateSubnetsRequest, DisassociateSubnetsResponse>()
                            .withOperationName("DisassociateSubnets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateSubnetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateSubnetsRequest));
            CompletableFuture<DisassociateSubnetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * The results of a <code>COMPLETED</code> analysis report generated with <a>StartAnalysisReport</a>.
     * </p>
     * <p>
     * For more information, see <a>AnalysisTypeReportResult</a>.
     * </p>
     *
     * @param getAnalysisReportResultsRequest
     * @return A Java Future containing the result of the GetAnalysisReportResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.GetAnalysisReportResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/GetAnalysisReportResults"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAnalysisReportResultsResponse> getAnalysisReportResults(
            GetAnalysisReportResultsRequest getAnalysisReportResultsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAnalysisReportResultsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAnalysisReportResultsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAnalysisReportResults");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAnalysisReportResultsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAnalysisReportResultsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetAnalysisReportResultsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAnalysisReportResultsRequest, GetAnalysisReportResultsResponse>()
                            .withOperationName("GetAnalysisReportResults").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAnalysisReportResultsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAnalysisReportResultsRequest));
            CompletableFuture<GetAnalysisReportResultsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all traffic analysis reports generated within the last 30 days.
     * </p>
     *
     * @param listAnalysisReportsRequest
     * @return A Java Future containing the result of the ListAnalysisReports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListAnalysisReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListAnalysisReports"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAnalysisReportsResponse> listAnalysisReports(
            ListAnalysisReportsRequest listAnalysisReportsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAnalysisReportsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAnalysisReportsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAnalysisReports");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAnalysisReportsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAnalysisReportsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListAnalysisReportsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAnalysisReportsRequest, ListAnalysisReportsResponse>()
                            .withOperationName("ListAnalysisReports").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAnalysisReportsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAnalysisReportsRequest));
            CompletableFuture<ListAnalysisReportsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the metadata for the firewall policies that you have defined. Depending on your setting for max results
     * and the number of firewall policies, a single call might not return the full list.
     * </p>
     *
     * @param listFirewallPoliciesRequest
     * @return A Java Future containing the result of the ListFirewallPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListFirewallPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewallPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFirewallPoliciesResponse> listFirewallPolicies(
            ListFirewallPoliciesRequest listFirewallPoliciesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFirewallPoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFirewallPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFirewallPolicies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFirewallPoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFirewallPoliciesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListFirewallPoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFirewallPoliciesRequest, ListFirewallPoliciesResponse>()
                            .withOperationName("ListFirewallPolicies").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFirewallPoliciesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFirewallPoliciesRequest));
            CompletableFuture<ListFirewallPoliciesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the metadata for the firewalls that you have defined. If you provide VPC identifiers in your request,
     * this returns only the firewalls for those VPCs.
     * </p>
     * <p>
     * Depending on your setting for max results and the number of firewalls, a single call might not return the full
     * list.
     * </p>
     *
     * @param listFirewallsRequest
     * @return A Java Future containing the result of the ListFirewalls operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListFirewalls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewalls"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFirewallsResponse> listFirewalls(ListFirewallsRequest listFirewallsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFirewallsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFirewallsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFirewalls");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFirewallsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListFirewallsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListFirewallsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFirewallsRequest, ListFirewallsResponse>()
                            .withOperationName("ListFirewalls").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFirewallsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFirewallsRequest));
            CompletableFuture<ListFirewallsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the results of a specific flow operation.
     * </p>
     * <p>
     * Flow operations let you manage the flows tracked in the flow table, also known as the firewall table.
     * </p>
     * <p>
     * A flow is network traffic that is monitored by a firewall, either by stateful or stateless rules. For traffic to
     * be considered part of a flow, it must share Destination, DestinationPort, Direction, Protocol, Source, and
     * SourcePort.
     * </p>
     *
     * @param listFlowOperationResultsRequest
     * @return A Java Future containing the result of the ListFlowOperationResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListFlowOperationResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFlowOperationResults"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFlowOperationResultsResponse> listFlowOperationResults(
            ListFlowOperationResultsRequest listFlowOperationResultsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFlowOperationResultsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFlowOperationResultsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFlowOperationResults");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFlowOperationResultsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFlowOperationResultsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListFlowOperationResultsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFlowOperationResultsRequest, ListFlowOperationResultsResponse>()
                            .withOperationName("ListFlowOperationResults").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFlowOperationResultsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFlowOperationResultsRequest));
            CompletableFuture<ListFlowOperationResultsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all flow operations ran in a specific firewall. You can optionally narrow the request scope by
     * specifying the operation type or Availability Zone associated with a firewall's flow operations.
     * </p>
     * <p>
     * Flow operations let you manage the flows tracked in the flow table, also known as the firewall table.
     * </p>
     * <p>
     * A flow is network traffic that is monitored by a firewall, either by stateful or stateless rules. For traffic to
     * be considered part of a flow, it must share Destination, DestinationPort, Direction, Protocol, Source, and
     * SourcePort.
     * </p>
     *
     * @param listFlowOperationsRequest
     * @return A Java Future containing the result of the ListFlowOperations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListFlowOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFlowOperations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFlowOperationsResponse> listFlowOperations(ListFlowOperationsRequest listFlowOperationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFlowOperationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFlowOperationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFlowOperations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFlowOperationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFlowOperationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListFlowOperationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFlowOperationsRequest, ListFlowOperationsResponse>()
                            .withOperationName("ListFlowOperations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFlowOperationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFlowOperationsRequest));
            CompletableFuture<ListFlowOperationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the metadata for the proxies that you have defined. Depending on your setting for max results and the
     * number of proxies, a single call might not return the full list.
     * </p>
     *
     * @param listProxiesRequest
     * @return A Java Future containing the result of the ListProxies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListProxies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListProxies" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListProxiesResponse> listProxies(ListProxiesRequest listProxiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listProxiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listProxiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProxies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListProxiesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListProxiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListProxiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListProxiesRequest, ListProxiesResponse>()
                            .withOperationName("ListProxies").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListProxiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listProxiesRequest));
            CompletableFuture<ListProxiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the metadata for the proxy configuration that you have defined. Depending on your setting for max
     * results and the number of proxy configurations, a single call might not return the full list.
     * </p>
     *
     * @param listProxyConfigurationsRequest
     * @return A Java Future containing the result of the ListProxyConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListProxyConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListProxyConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListProxyConfigurationsResponse> listProxyConfigurations(
            ListProxyConfigurationsRequest listProxyConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listProxyConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listProxyConfigurationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProxyConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListProxyConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListProxyConfigurationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListProxyConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListProxyConfigurationsRequest, ListProxyConfigurationsResponse>()
                            .withOperationName("ListProxyConfigurations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListProxyConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listProxyConfigurationsRequest));
            CompletableFuture<ListProxyConfigurationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the metadata for the proxy rule groups that you have defined. Depending on your setting for max results
     * and the number of proxy rule groups, a single call might not return the full list.
     * </p>
     *
     * @param listProxyRuleGroupsRequest
     * @return A Java Future containing the result of the ListProxyRuleGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListProxyRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListProxyRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListProxyRuleGroupsResponse> listProxyRuleGroups(
            ListProxyRuleGroupsRequest listProxyRuleGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listProxyRuleGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listProxyRuleGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProxyRuleGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListProxyRuleGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListProxyRuleGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListProxyRuleGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListProxyRuleGroupsRequest, ListProxyRuleGroupsResponse>()
                            .withOperationName("ListProxyRuleGroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListProxyRuleGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listProxyRuleGroupsRequest));
            CompletableFuture<ListProxyRuleGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the metadata for the rule groups that you have defined. Depending on your setting for max results and
     * the number of rule groups, a single call might not return the full list.
     * </p>
     *
     * @param listRuleGroupsRequest
     * @return A Java Future containing the result of the ListRuleGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListRuleGroupsResponse> listRuleGroups(ListRuleGroupsRequest listRuleGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRuleGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRuleGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRuleGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRuleGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListRuleGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListRuleGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRuleGroupsRequest, ListRuleGroupsResponse>()
                            .withOperationName("ListRuleGroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRuleGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listRuleGroupsRequest));
            CompletableFuture<ListRuleGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the metadata for the TLS inspection configurations that you have defined. Depending on your setting for
     * max results and the number of TLS inspection configurations, a single call might not return the full list.
     * </p>
     *
     * @param listTlsInspectionConfigurationsRequest
     * @return A Java Future containing the result of the ListTLSInspectionConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListTLSInspectionConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTLSInspectionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTlsInspectionConfigurationsResponse> listTLSInspectionConfigurations(
            ListTlsInspectionConfigurationsRequest listTlsInspectionConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTlsInspectionConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listTlsInspectionConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTLSInspectionConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTlsInspectionConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTlsInspectionConfigurationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListTlsInspectionConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTlsInspectionConfigurationsRequest, ListTlsInspectionConfigurationsResponse>()
                            .withOperationName("ListTLSInspectionConfigurations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTlsInspectionConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTlsInspectionConfigurationsRequest));
            CompletableFuture<ListTlsInspectionConfigurationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the tags associated with the specified resource. Tags are key:value pairs that you can use to
     * categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall
     * policies, and rule groups.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the metadata for the VPC endpoint associations that you have defined. If you specify a fireawll, this
     * returns only the endpoint associations for that firewall.
     * </p>
     * <p>
     * Depending on your setting for max results and the number of associations, a single call might not return the full
     * list.
     * </p>
     *
     * @param listVpcEndpointAssociationsRequest
     * @return A Java Future containing the result of the ListVpcEndpointAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListVpcEndpointAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListVpcEndpointAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListVpcEndpointAssociationsResponse> listVpcEndpointAssociations(
            ListVpcEndpointAssociationsRequest listVpcEndpointAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listVpcEndpointAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVpcEndpointAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVpcEndpointAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListVpcEndpointAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListVpcEndpointAssociationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListVpcEndpointAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListVpcEndpointAssociationsRequest, ListVpcEndpointAssociationsResponse>()
                            .withOperationName("ListVpcEndpointAssociations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListVpcEndpointAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listVpcEndpointAssociationsRequest));
            CompletableFuture<ListVpcEndpointAssociationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates or updates an IAM policy for your rule group, firewall policy, or firewall. Use this to share these
     * resources between accounts. This operation works in conjunction with the Amazon Web Services Resource Access
     * Manager (RAM) service to manage resource sharing for Network Firewall.
     * </p>
     * <p>
     * For information about using sharing with Network Firewall resources, see <a
     * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/sharing.html">Sharing Network Firewall
     * resources</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     * <p>
     * Use this operation to create or update a resource policy for your Network Firewall rule group, firewall policy,
     * or firewall. In the resource policy, you specify the accounts that you want to share the Network Firewall
     * resource with and the operations that you want the accounts to be able to perform.
     * </p>
     * <p>
     * When you add an account in the resource policy, you then run the following Resource Access Manager (RAM)
     * operations to access and accept the shared resource.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourceShareInvitations.html">
     * GetResourceShareInvitations</a> - Returns the Amazon Resource Names (ARNs) of the resource share invitations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_AcceptResourceShareInvitation.html">
     * AcceptResourceShareInvitation</a> - Accepts the share invitation for a specified resource share.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For additional information about resource sharing using RAM, see <a
     * href="https://docs.aws.amazon.com/ram/latest/userguide/what-is.html">Resource Access Manager User Guide</a>.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidResourcePolicyException The policy statement failed validation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<PutResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutResourcePolicyRequest, PutResourcePolicyResponse>()
                            .withOperationName("PutResourcePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putResourcePolicyRequest));
            CompletableFuture<PutResourcePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Rejects a transit gateway attachment request for Network Firewall. When you reject the attachment request,
     * Network Firewall cancels the creation of routing components between the transit gateway and firewall endpoints.
     * </p>
     * <p>
     * Only the transit gateway owner can reject the attachment. After rejection, no traffic will flow through the
     * firewall endpoints for this attachment.
     * </p>
     * <p>
     * Use <a>DescribeFirewall</a> to monitor the rejection status. To accept the attachment instead of rejecting it,
     * use <a>AcceptNetworkFirewallTransitGatewayAttachment</a>.
     * </p>
     * <note>
     * <p>
     * Once rejected, you cannot reverse this action. To establish connectivity, you must create a new transit
     * gateway-attached firewall.
     * </p>
     * </note>
     *
     * @param rejectNetworkFirewallTransitGatewayAttachmentRequest
     * @return A Java Future containing the result of the RejectNetworkFirewallTransitGatewayAttachment operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.RejectNetworkFirewallTransitGatewayAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/RejectNetworkFirewallTransitGatewayAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RejectNetworkFirewallTransitGatewayAttachmentResponse> rejectNetworkFirewallTransitGatewayAttachment(
            RejectNetworkFirewallTransitGatewayAttachmentRequest rejectNetworkFirewallTransitGatewayAttachmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                rejectNetworkFirewallTransitGatewayAttachmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                rejectNetworkFirewallTransitGatewayAttachmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RejectNetworkFirewallTransitGatewayAttachment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RejectNetworkFirewallTransitGatewayAttachmentResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, RejectNetworkFirewallTransitGatewayAttachmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<RejectNetworkFirewallTransitGatewayAttachmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RejectNetworkFirewallTransitGatewayAttachmentRequest, RejectNetworkFirewallTransitGatewayAttachmentResponse>()
                            .withOperationName("RejectNetworkFirewallTransitGatewayAttachment")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RejectNetworkFirewallTransitGatewayAttachmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(rejectNetworkFirewallTransitGatewayAttachmentRequest));
            CompletableFuture<RejectNetworkFirewallTransitGatewayAttachmentResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Generates a traffic analysis report for the timeframe and traffic type you specify.
     * </p>
     * <p>
     * For information on the contents of a traffic analysis report, see <a>AnalysisReport</a>.
     * </p>
     *
     * @param startAnalysisReportRequest
     * @return A Java Future containing the result of the StartAnalysisReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.StartAnalysisReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/StartAnalysisReport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartAnalysisReportResponse> startAnalysisReport(
            StartAnalysisReportRequest startAnalysisReportRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startAnalysisReportRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startAnalysisReportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartAnalysisReport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartAnalysisReportResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartAnalysisReportResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartAnalysisReportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartAnalysisReportRequest, StartAnalysisReportResponse>()
                            .withOperationName("StartAnalysisReport").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartAnalysisReportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startAnalysisReportRequest));
            CompletableFuture<StartAnalysisReportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Begins capturing the flows in a firewall, according to the filters you define. Captures are similar, but not
     * identical to snapshots. Capture operations provide visibility into flows that are not closed and are tracked by a
     * firewall's flow table. Unlike snapshots, captures are a time-boxed view.
     * </p>
     * <p>
     * A flow is network traffic that is monitored by a firewall, either by stateful or stateless rules. For traffic to
     * be considered part of a flow, it must share Destination, DestinationPort, Direction, Protocol, Source, and
     * SourcePort.
     * </p>
     * <note>
     * <p>
     * To avoid encountering operation limits, you should avoid starting captures with broad filters, like wide IP
     * ranges. Instead, we recommend you define more specific criteria with <code>FlowFilters</code>, like narrow IP
     * ranges, ports, or protocols.
     * </p>
     * </note>
     *
     * @param startFlowCaptureRequest
     * @return A Java Future containing the result of the StartFlowCapture operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.StartFlowCapture
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/StartFlowCapture"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartFlowCaptureResponse> startFlowCapture(StartFlowCaptureRequest startFlowCaptureRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startFlowCaptureRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startFlowCaptureRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartFlowCapture");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartFlowCaptureResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartFlowCaptureResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartFlowCaptureResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartFlowCaptureRequest, StartFlowCaptureResponse>()
                            .withOperationName("StartFlowCapture").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartFlowCaptureRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startFlowCaptureRequest));
            CompletableFuture<StartFlowCaptureResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Begins the flushing of traffic from the firewall, according to the filters you define. When the operation starts,
     * impacted flows are temporarily marked as timed out before the Suricata engine prunes, or flushes, the flows from
     * the firewall table.
     * </p>
     * <important>
     * <p>
     * While the flush completes, impacted flows are processed as midstream traffic. This may result in a temporary
     * increase in midstream traffic metrics. We recommend that you double check your stream exception policy before you
     * perform a flush operation.
     * </p>
     * </important>
     *
     * @param startFlowFlushRequest
     * @return A Java Future containing the result of the StartFlowFlush operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.StartFlowFlush
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/StartFlowFlush"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartFlowFlushResponse> startFlowFlush(StartFlowFlushRequest startFlowFlushRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startFlowFlushRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startFlowFlushRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartFlowFlush");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartFlowFlushResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartFlowFlushResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartFlowFlushResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartFlowFlushRequest, StartFlowFlushResponse>()
                            .withOperationName("StartFlowFlush").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartFlowFlushRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startFlowFlushRequest));
            CompletableFuture<StartFlowFlushResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource. Tags are key:value pairs that you can use to categorize and
     * manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the
     * value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource,
     * up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall
     * policies, and rule groups.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the tags with the specified keys from the specified resource. Tags are key:value pairs that you can use
     * to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can manage tags for the Amazon Web Services resources that you manage through Network Firewall: firewalls,
     * firewall policies, and rule groups.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the <code>AvailabilityZoneChangeProtection</code> setting for a transit gateway-attached firewall. When
     * enabled, this setting prevents accidental changes to the firewall's Availability Zone configuration. This helps
     * protect against disrupting traffic flow in production environments.
     * </p>
     * <p>
     * When enabled, you must disable this protection before using <a>AssociateAvailabilityZones</a> or
     * <a>DisassociateAvailabilityZones</a> to modify the firewall's Availability Zone configuration.
     * </p>
     *
     * @param updateAvailabilityZoneChangeProtectionRequest
     * @return A Java Future containing the result of the UpdateAvailabilityZoneChangeProtection operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>ResourceOwnerCheckException Unable to change the resource because your account doesn't own it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateAvailabilityZoneChangeProtection
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateAvailabilityZoneChangeProtection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAvailabilityZoneChangeProtectionResponse> updateAvailabilityZoneChangeProtection(
            UpdateAvailabilityZoneChangeProtectionRequest updateAvailabilityZoneChangeProtectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAvailabilityZoneChangeProtectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateAvailabilityZoneChangeProtectionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAvailabilityZoneChangeProtection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAvailabilityZoneChangeProtectionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateAvailabilityZoneChangeProtectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateAvailabilityZoneChangeProtectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAvailabilityZoneChangeProtectionRequest, UpdateAvailabilityZoneChangeProtectionResponse>()
                            .withOperationName("UpdateAvailabilityZoneChangeProtection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAvailabilityZoneChangeProtectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAvailabilityZoneChangeProtectionRequest));
            CompletableFuture<UpdateAvailabilityZoneChangeProtectionResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables specific types of firewall analysis on a specific firewall you define.
     * </p>
     *
     * @param updateFirewallAnalysisSettingsRequest
     * @return A Java Future containing the result of the UpdateFirewallAnalysisSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateFirewallAnalysisSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallAnalysisSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFirewallAnalysisSettingsResponse> updateFirewallAnalysisSettings(
            UpdateFirewallAnalysisSettingsRequest updateFirewallAnalysisSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFirewallAnalysisSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateFirewallAnalysisSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFirewallAnalysisSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFirewallAnalysisSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFirewallAnalysisSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateFirewallAnalysisSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFirewallAnalysisSettingsRequest, UpdateFirewallAnalysisSettingsResponse>()
                            .withOperationName("UpdateFirewallAnalysisSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateFirewallAnalysisSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFirewallAnalysisSettingsRequest));
            CompletableFuture<UpdateFirewallAnalysisSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the flag, <code>DeleteProtection</code>, which indicates whether it is possible to delete the firewall.
     * If the flag is set to <code>TRUE</code>, the firewall is protected against deletion. This setting helps protect
     * against accidentally deleting a firewall that's in use.
     * </p>
     *
     * @param updateFirewallDeleteProtectionRequest
     * @return A Java Future containing the result of the UpdateFirewallDeleteProtection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>ResourceOwnerCheckException Unable to change the resource because your account doesn't own it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateFirewallDeleteProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallDeleteProtection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFirewallDeleteProtectionResponse> updateFirewallDeleteProtection(
            UpdateFirewallDeleteProtectionRequest updateFirewallDeleteProtectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFirewallDeleteProtectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateFirewallDeleteProtectionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFirewallDeleteProtection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFirewallDeleteProtectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFirewallDeleteProtectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateFirewallDeleteProtectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFirewallDeleteProtectionRequest, UpdateFirewallDeleteProtectionResponse>()
                            .withOperationName("UpdateFirewallDeleteProtection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateFirewallDeleteProtectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFirewallDeleteProtectionRequest));
            CompletableFuture<UpdateFirewallDeleteProtectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the description for the specified firewall. Use the description to help you identify the firewall when
     * you're working with it.
     * </p>
     *
     * @param updateFirewallDescriptionRequest
     * @return A Java Future containing the result of the UpdateFirewallDescription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateFirewallDescription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallDescription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFirewallDescriptionResponse> updateFirewallDescription(
            UpdateFirewallDescriptionRequest updateFirewallDescriptionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFirewallDescriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFirewallDescriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFirewallDescription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFirewallDescriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFirewallDescriptionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateFirewallDescriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFirewallDescriptionRequest, UpdateFirewallDescriptionResponse>()
                            .withOperationName("UpdateFirewallDescription").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateFirewallDescriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFirewallDescriptionRequest));
            CompletableFuture<UpdateFirewallDescriptionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A complex type that contains settings for encryption of your firewall resources.
     * </p>
     *
     * @param updateFirewallEncryptionConfigurationRequest
     * @return A Java Future containing the result of the UpdateFirewallEncryptionConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>ResourceOwnerCheckException Unable to change the resource because your account doesn't own it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateFirewallEncryptionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFirewallEncryptionConfigurationResponse> updateFirewallEncryptionConfiguration(
            UpdateFirewallEncryptionConfigurationRequest updateFirewallEncryptionConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFirewallEncryptionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateFirewallEncryptionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFirewallEncryptionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFirewallEncryptionConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateFirewallEncryptionConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateFirewallEncryptionConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFirewallEncryptionConfigurationRequest, UpdateFirewallEncryptionConfigurationResponse>()
                            .withOperationName("UpdateFirewallEncryptionConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateFirewallEncryptionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFirewallEncryptionConfigurationRequest));
            CompletableFuture<UpdateFirewallEncryptionConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the properties of the specified firewall policy.
     * </p>
     *
     * @param updateFirewallPolicyRequest
     * @return A Java Future containing the result of the UpdateFirewallPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFirewallPolicyResponse> updateFirewallPolicy(
            UpdateFirewallPolicyRequest updateFirewallPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFirewallPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFirewallPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFirewallPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFirewallPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFirewallPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateFirewallPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFirewallPolicyRequest, UpdateFirewallPolicyResponse>()
                            .withOperationName("UpdateFirewallPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateFirewallPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFirewallPolicyRequest));
            CompletableFuture<UpdateFirewallPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the flag, <code>ChangeProtection</code>, which indicates whether it is possible to change the firewall.
     * If the flag is set to <code>TRUE</code>, the firewall is protected from changes. This setting helps protect
     * against accidentally changing a firewall that's in use.
     * </p>
     *
     * @param updateFirewallPolicyChangeProtectionRequest
     * @return A Java Future containing the result of the UpdateFirewallPolicyChangeProtection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>ResourceOwnerCheckException Unable to change the resource because your account doesn't own it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateFirewallPolicyChangeProtection
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallPolicyChangeProtection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFirewallPolicyChangeProtectionResponse> updateFirewallPolicyChangeProtection(
            UpdateFirewallPolicyChangeProtectionRequest updateFirewallPolicyChangeProtectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFirewallPolicyChangeProtectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateFirewallPolicyChangeProtectionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFirewallPolicyChangeProtection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFirewallPolicyChangeProtectionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateFirewallPolicyChangeProtectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateFirewallPolicyChangeProtectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFirewallPolicyChangeProtectionRequest, UpdateFirewallPolicyChangeProtectionResponse>()
                            .withOperationName("UpdateFirewallPolicyChangeProtection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateFirewallPolicyChangeProtectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFirewallPolicyChangeProtectionRequest));
            CompletableFuture<UpdateFirewallPolicyChangeProtectionResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the logging configuration for the specified firewall.
     * </p>
     * <p>
     * To change the logging configuration, retrieve the <a>LoggingConfiguration</a> by calling
     * <a>DescribeLoggingConfiguration</a>, then change it and provide the modified object to this update call. You must
     * change the logging configuration one <a>LogDestinationConfig</a> at a time inside the retrieved
     * <a>LoggingConfiguration</a> object.
     * </p>
     * <p>
     * You can perform only one of the following actions in any call to <code>UpdateLoggingConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a new log destination object by adding a single <code>LogDestinationConfig</code> array element to
     * <code>LogDestinationConfigs</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delete a log destination object by removing a single <code>LogDestinationConfig</code> array element from
     * <code>LogDestinationConfigs</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change the <code>LogDestination</code> setting in a single <code>LogDestinationConfig</code> array element.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't change the <code>LogDestinationType</code> or <code>LogType</code> in a
     * <code>LogDestinationConfig</code>. To change these settings, delete the existing
     * <code>LogDestinationConfig</code> object and create a new one, using two separate calls to this update operation.
     * </p>
     *
     * @param updateLoggingConfigurationRequest
     * @return A Java Future containing the result of the UpdateLoggingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>LogDestinationPermissionException Unable to send logs to a configured logging destination.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateLoggingConfigurationResponse> updateLoggingConfiguration(
            UpdateLoggingConfigurationRequest updateLoggingConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateLoggingConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateLoggingConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLoggingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateLoggingConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateLoggingConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateLoggingConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateLoggingConfigurationRequest, UpdateLoggingConfigurationResponse>()
                            .withOperationName("UpdateLoggingConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateLoggingConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateLoggingConfigurationRequest));
            CompletableFuture<UpdateLoggingConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the properties of the specified proxy.
     * </p>
     *
     * @param updateProxyRequest
     * @return A Java Future containing the result of the UpdateProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>UnsupportedOperationException The operation you requested isn't supported by Network Firewall.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateProxy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateProxyResponse> updateProxy(UpdateProxyRequest updateProxyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateProxyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateProxyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateProxy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateProxyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateProxyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateProxyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateProxyRequest, UpdateProxyResponse>()
                            .withOperationName("UpdateProxy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateProxyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateProxyRequest));
            CompletableFuture<UpdateProxyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the properties of the specified proxy configuration.
     * </p>
     *
     * @param updateProxyConfigurationRequest
     * @return A Java Future containing the result of the UpdateProxyConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateProxyConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateProxyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateProxyConfigurationResponse> updateProxyConfiguration(
            UpdateProxyConfigurationRequest updateProxyConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateProxyConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateProxyConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateProxyConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateProxyConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateProxyConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateProxyConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateProxyConfigurationRequest, UpdateProxyConfigurationResponse>()
                            .withOperationName("UpdateProxyConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateProxyConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateProxyConfigurationRequest));
            CompletableFuture<UpdateProxyConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the properties of the specified proxy rule.
     * </p>
     *
     * @param updateProxyRuleRequest
     * @return A Java Future containing the result of the UpdateProxyRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateProxyRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateProxyRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateProxyRuleResponse> updateProxyRule(UpdateProxyRuleRequest updateProxyRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateProxyRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateProxyRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateProxyRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateProxyRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateProxyRuleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateProxyRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateProxyRuleRequest, UpdateProxyRuleResponse>()
                            .withOperationName("UpdateProxyRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateProxyRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateProxyRuleRequest));
            CompletableFuture<UpdateProxyRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates proxy rule group priorities within a proxy configuration.
     * </p>
     *
     * @param updateProxyRuleGroupPrioritiesRequest
     * @return A Java Future containing the result of the UpdateProxyRuleGroupPriorities operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateProxyRuleGroupPriorities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateProxyRuleGroupPriorities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateProxyRuleGroupPrioritiesResponse> updateProxyRuleGroupPriorities(
            UpdateProxyRuleGroupPrioritiesRequest updateProxyRuleGroupPrioritiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateProxyRuleGroupPrioritiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateProxyRuleGroupPrioritiesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateProxyRuleGroupPriorities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateProxyRuleGroupPrioritiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateProxyRuleGroupPrioritiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateProxyRuleGroupPrioritiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateProxyRuleGroupPrioritiesRequest, UpdateProxyRuleGroupPrioritiesResponse>()
                            .withOperationName("UpdateProxyRuleGroupPriorities").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateProxyRuleGroupPrioritiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateProxyRuleGroupPrioritiesRequest));
            CompletableFuture<UpdateProxyRuleGroupPrioritiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates proxy rule priorities within a proxy rule group.
     * </p>
     *
     * @param updateProxyRulePrioritiesRequest
     * @return A Java Future containing the result of the UpdateProxyRulePriorities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateProxyRulePriorities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateProxyRulePriorities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateProxyRulePrioritiesResponse> updateProxyRulePriorities(
            UpdateProxyRulePrioritiesRequest updateProxyRulePrioritiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateProxyRulePrioritiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateProxyRulePrioritiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateProxyRulePriorities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateProxyRulePrioritiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateProxyRulePrioritiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateProxyRulePrioritiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateProxyRulePrioritiesRequest, UpdateProxyRulePrioritiesResponse>()
                            .withOperationName("UpdateProxyRulePriorities").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateProxyRulePrioritiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateProxyRulePrioritiesRequest));
            CompletableFuture<UpdateProxyRulePrioritiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the rule settings for the specified rule group. You use a rule group by reference in one or more firewall
     * policies. When you modify a rule group, you modify all firewall policies that use the rule group.
     * </p>
     * <p>
     * To update a rule group, first call <a>DescribeRuleGroup</a> to retrieve the current <a>RuleGroup</a> object,
     * update the object as needed, and then provide the updated object to this call.
     * </p>
     *
     * @param updateRuleGroupRequest
     * @return A Java Future containing the result of the UpdateRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRuleGroupResponse> updateRuleGroup(UpdateRuleGroupRequest updateRuleGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRuleGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRuleGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRuleGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRuleGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRuleGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateRuleGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRuleGroupRequest, UpdateRuleGroupResponse>()
                            .withOperationName("UpdateRuleGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateRuleGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateRuleGroupRequest));
            CompletableFuture<UpdateRuleGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p/>
     *
     * @param updateSubnetChangeProtectionRequest
     * @return A Java Future containing the result of the UpdateSubnetChangeProtection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>ResourceOwnerCheckException Unable to change the resource because your account doesn't own it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateSubnetChangeProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateSubnetChangeProtection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSubnetChangeProtectionResponse> updateSubnetChangeProtection(
            UpdateSubnetChangeProtectionRequest updateSubnetChangeProtectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSubnetChangeProtectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSubnetChangeProtectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSubnetChangeProtection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSubnetChangeProtectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSubnetChangeProtectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateSubnetChangeProtectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSubnetChangeProtectionRequest, UpdateSubnetChangeProtectionResponse>()
                            .withOperationName("UpdateSubnetChangeProtection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateSubnetChangeProtectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateSubnetChangeProtectionRequest));
            CompletableFuture<UpdateSubnetChangeProtectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the TLS inspection configuration settings for the specified TLS inspection configuration. You use a TLS
     * inspection configuration by referencing it in one or more firewall policies. When you modify a TLS inspection
     * configuration, you modify all firewall policies that use the TLS inspection configuration.
     * </p>
     * <p>
     * To update a TLS inspection configuration, first call <a>DescribeTLSInspectionConfiguration</a> to retrieve the
     * current <a>TLSInspectionConfiguration</a> object, update the object as needed, and then provide the updated
     * object to this call.
     * </p>
     *
     * @param updateTlsInspectionConfigurationRequest
     * @return A Java Future containing the result of the UpdateTLSInspectionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn't perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateTlsInspectionConfigurationResponse> updateTLSInspectionConfiguration(
            UpdateTlsInspectionConfigurationRequest updateTlsInspectionConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateTlsInspectionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateTlsInspectionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTLSInspectionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateTlsInspectionConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateTlsInspectionConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "LogDestinationPermissionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceOwnerCheckException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "InvalidResourcePolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
                case "InvalidTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTokenException::builder).build());
                case "InternalServerError":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateTlsInspectionConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateTlsInspectionConfigurationRequest, UpdateTlsInspectionConfigurationResponse>()
                            .withOperationName("UpdateTLSInspectionConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateTlsInspectionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateTlsInspectionConfigurationRequest));
            CompletableFuture<UpdateTlsInspectionConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final NetworkFirewallServiceClientConfiguration serviceClientConfiguration() {
        return new NetworkFirewallServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(NetworkFirewallException::builder).protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.0");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        NetworkFirewallServiceClientConfigurationBuilder serviceConfigBuilder = new NetworkFirewallServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
