/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallAsyncClient;
import software.amazon.awssdk.services.networkfirewall.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkfirewall.model.ListProxyConfigurationsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListProxyConfigurationsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ProxyConfigurationMetadata;

public class ListProxyConfigurationsPublisher
implements SdkPublisher<ListProxyConfigurationsResponse> {
    private final NetworkFirewallAsyncClient client;
    private final ListProxyConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProxyConfigurationsPublisher(NetworkFirewallAsyncClient client, ListProxyConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProxyConfigurationsPublisher(NetworkFirewallAsyncClient client, ListProxyConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProxyConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProxyConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProxyConfigurationMetadata> proxyConfigurations() {
        Function<ListProxyConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.proxyConfigurations() != null) {
                return response.proxyConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProxyConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProxyConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListProxyConfigurationsResponse> {
        private ListProxyConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListProxyConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProxyConfigurationsResponse> nextPage(ListProxyConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListProxyConfigurationsPublisher.this.client.listProxyConfigurations(ListProxyConfigurationsPublisher.this.firstRequest);
            }
            return ListProxyConfigurationsPublisher.this.client.listProxyConfigurations((ListProxyConfigurationsRequest)((Object)ListProxyConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

