/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.networkfirewall.model.AZSyncState;
import software.amazon.awssdk.services.networkfirewall.model.AssociationSyncStateCopier;
import software.amazon.awssdk.services.networkfirewall.model.FirewallStatusValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcEndpointAssociationStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcEndpointAssociationStatus> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(VpcEndpointAssociationStatus.getter(VpcEndpointAssociationStatus::statusAsString)).setter(VpcEndpointAssociationStatus.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Map<String, AZSyncState>> ASSOCIATION_SYNC_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AssociationSyncState").getter(VpcEndpointAssociationStatus.getter(VpcEndpointAssociationStatus::associationSyncState)).setter(VpcEndpointAssociationStatus.setter(Builder::associationSyncState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationSyncState").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AZSyncState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ASSOCIATION_SYNC_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VpcEndpointAssociationStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final Map<String, AZSyncState> associationSyncState;

    private VpcEndpointAssociationStatus(BuilderImpl builder) {
        this.status = builder.status;
        this.associationSyncState = builder.associationSyncState;
    }

    public final FirewallStatusValue status() {
        return FirewallStatusValue.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasAssociationSyncState() {
        return this.associationSyncState != null && !(this.associationSyncState instanceof SdkAutoConstructMap);
    }

    public final Map<String, AZSyncState> associationSyncState() {
        return this.associationSyncState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociationSyncState() ? this.associationSyncState() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcEndpointAssociationStatus)) {
            return false;
        }
        VpcEndpointAssociationStatus other = (VpcEndpointAssociationStatus)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasAssociationSyncState() == other.hasAssociationSyncState() && Objects.equals(this.associationSyncState(), other.associationSyncState());
    }

    public final String toString() {
        return ToString.builder((String)"VpcEndpointAssociationStatus").add("Status", (Object)this.statusAsString()).add("AssociationSyncState", this.hasAssociationSyncState() ? this.associationSyncState() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "AssociationSyncState": {
                return Optional.ofNullable(clazz.cast(this.associationSyncState()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Status", STATUS_FIELD);
        map.put("AssociationSyncState", ASSOCIATION_SYNC_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcEndpointAssociationStatus, T> g) {
        return obj -> g.apply((VpcEndpointAssociationStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Map<String, AZSyncState> associationSyncState = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpcEndpointAssociationStatus model) {
            this.status(model.status);
            this.associationSyncState(model.associationSyncState);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FirewallStatusValue status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, AZSyncState.Builder> getAssociationSyncState() {
            Map<String, AZSyncState.Builder> result = AssociationSyncStateCopier.copyToBuilder(this.associationSyncState);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAssociationSyncState(Map<String, AZSyncState.BuilderImpl> associationSyncState) {
            this.associationSyncState = AssociationSyncStateCopier.copyFromBuilder(associationSyncState);
        }

        @Override
        public final Builder associationSyncState(Map<String, AZSyncState> associationSyncState) {
            this.associationSyncState = AssociationSyncStateCopier.copy(associationSyncState);
            return this;
        }

        public VpcEndpointAssociationStatus build() {
            return new VpcEndpointAssociationStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcEndpointAssociationStatus> {
        public Builder status(String var1);

        public Builder status(FirewallStatusValue var1);

        public Builder associationSyncState(Map<String, AZSyncState> var1);
    }
}

