/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.ProxyRule;
import software.amazon.awssdk.services.networkfirewall.model.ProxyRuleCondition;
import software.amazon.awssdk.services.networkfirewall.model.ProxyRuleConditionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProxyRuleResponse
extends NetworkFirewallResponse
implements ToCopyableBuilder<Builder, UpdateProxyRuleResponse> {
    private static final SdkField<ProxyRule> PROXY_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProxyRule").getter(UpdateProxyRuleResponse.getter(UpdateProxyRuleResponse::proxyRule)).setter(UpdateProxyRuleResponse.setter(Builder::proxyRule)).constructor(ProxyRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRule").build()}).build();
    private static final SdkField<List<ProxyRuleCondition>> REMOVED_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemovedConditions").getter(UpdateProxyRuleResponse.getter(UpdateProxyRuleResponse::removedConditions)).setter(UpdateProxyRuleResponse.setter(Builder::removedConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemovedConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProxyRuleCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateToken").getter(UpdateProxyRuleResponse.getter(UpdateProxyRuleResponse::updateToken)).setter(UpdateProxyRuleResponse.setter(Builder::updateToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_RULE_FIELD, REMOVED_CONDITIONS_FIELD, UPDATE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateProxyRuleResponse.memberNameToFieldInitializer();
    private final ProxyRule proxyRule;
    private final List<ProxyRuleCondition> removedConditions;
    private final String updateToken;

    private UpdateProxyRuleResponse(BuilderImpl builder) {
        super(builder);
        this.proxyRule = builder.proxyRule;
        this.removedConditions = builder.removedConditions;
        this.updateToken = builder.updateToken;
    }

    public final ProxyRule proxyRule() {
        return this.proxyRule;
    }

    public final boolean hasRemovedConditions() {
        return this.removedConditions != null && !(this.removedConditions instanceof SdkAutoConstructList);
    }

    public final List<ProxyRuleCondition> removedConditions() {
        return this.removedConditions;
    }

    public final String updateToken() {
        return this.updateToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemovedConditions() ? this.removedConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updateToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProxyRuleResponse)) {
            return false;
        }
        UpdateProxyRuleResponse other = (UpdateProxyRuleResponse)((Object)obj);
        return Objects.equals(this.proxyRule(), other.proxyRule()) && this.hasRemovedConditions() == other.hasRemovedConditions() && Objects.equals(this.removedConditions(), other.removedConditions()) && Objects.equals(this.updateToken(), other.updateToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProxyRuleResponse").add("ProxyRule", (Object)this.proxyRule()).add("RemovedConditions", this.hasRemovedConditions() ? this.removedConditions() : null).add("UpdateToken", (Object)this.updateToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProxyRule": {
                return Optional.ofNullable(clazz.cast(this.proxyRule()));
            }
            case "RemovedConditions": {
                return Optional.ofNullable(clazz.cast(this.removedConditions()));
            }
            case "UpdateToken": {
                return Optional.ofNullable(clazz.cast(this.updateToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProxyRule", PROXY_RULE_FIELD);
        map.put("RemovedConditions", REMOVED_CONDITIONS_FIELD);
        map.put("UpdateToken", UPDATE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProxyRuleResponse, T> g) {
        return obj -> g.apply((UpdateProxyRuleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallResponse.BuilderImpl
    implements Builder {
        private ProxyRule proxyRule;
        private List<ProxyRuleCondition> removedConditions = DefaultSdkAutoConstructList.getInstance();
        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProxyRuleResponse model) {
            super(model);
            this.proxyRule(model.proxyRule);
            this.removedConditions(model.removedConditions);
            this.updateToken(model.updateToken);
        }

        public final ProxyRule.Builder getProxyRule() {
            return this.proxyRule != null ? this.proxyRule.toBuilder() : null;
        }

        public final void setProxyRule(ProxyRule.BuilderImpl proxyRule) {
            this.proxyRule = proxyRule != null ? proxyRule.build() : null;
        }

        @Override
        public final Builder proxyRule(ProxyRule proxyRule) {
            this.proxyRule = proxyRule;
            return this;
        }

        public final List<ProxyRuleCondition.Builder> getRemovedConditions() {
            List<ProxyRuleCondition.Builder> result = ProxyRuleConditionListCopier.copyToBuilder(this.removedConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemovedConditions(Collection<ProxyRuleCondition.BuilderImpl> removedConditions) {
            this.removedConditions = ProxyRuleConditionListCopier.copyFromBuilder(removedConditions);
        }

        @Override
        public final Builder removedConditions(Collection<ProxyRuleCondition> removedConditions) {
            this.removedConditions = ProxyRuleConditionListCopier.copy(removedConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removedConditions(ProxyRuleCondition ... removedConditions) {
            this.removedConditions(Arrays.asList(removedConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removedConditions(Consumer<ProxyRuleCondition.Builder> ... removedConditions) {
            this.removedConditions(Stream.of(removedConditions).map(c -> (ProxyRuleCondition)((ProxyRuleCondition.Builder)ProxyRuleCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUpdateToken() {
            return this.updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        @Override
        public UpdateProxyRuleResponse build() {
            return new UpdateProxyRuleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProxyRuleResponse> {
        public Builder proxyRule(ProxyRule var1);

        default public Builder proxyRule(Consumer<ProxyRule.Builder> proxyRule) {
            return this.proxyRule((ProxyRule)((ProxyRule.Builder)ProxyRule.builder().applyMutation(proxyRule)).build());
        }

        public Builder removedConditions(Collection<ProxyRuleCondition> var1);

        public Builder removedConditions(ProxyRuleCondition ... var1);

        public Builder removedConditions(Consumer<ProxyRuleCondition.Builder> ... var1);

        public Builder updateToken(String var1);
    }
}

