/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.ProxyConfigurationMetadata;
import software.amazon.awssdk.services.networkfirewall.model.ProxyConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProxyConfigurationsResponse
extends NetworkFirewallResponse
implements ToCopyableBuilder<Builder, ListProxyConfigurationsResponse> {
    private static final SdkField<List<ProxyConfigurationMetadata>> PROXY_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProxyConfigurations").getter(ListProxyConfigurationsResponse.getter(ListProxyConfigurationsResponse::proxyConfigurations)).setter(ListProxyConfigurationsResponse.setter(Builder::proxyConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProxyConfigurationMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListProxyConfigurationsResponse.getter(ListProxyConfigurationsResponse::nextToken)).setter(ListProxyConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListProxyConfigurationsResponse.memberNameToFieldInitializer();
    private final List<ProxyConfigurationMetadata> proxyConfigurations;
    private final String nextToken;

    private ListProxyConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.proxyConfigurations = builder.proxyConfigurations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasProxyConfigurations() {
        return this.proxyConfigurations != null && !(this.proxyConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ProxyConfigurationMetadata> proxyConfigurations() {
        return this.proxyConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProxyConfigurations() ? this.proxyConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProxyConfigurationsResponse)) {
            return false;
        }
        ListProxyConfigurationsResponse other = (ListProxyConfigurationsResponse)((Object)obj);
        return this.hasProxyConfigurations() == other.hasProxyConfigurations() && Objects.equals(this.proxyConfigurations(), other.proxyConfigurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListProxyConfigurationsResponse").add("ProxyConfigurations", this.hasProxyConfigurations() ? this.proxyConfigurations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProxyConfigurations": {
                return Optional.ofNullable(clazz.cast(this.proxyConfigurations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProxyConfigurations", PROXY_CONFIGURATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProxyConfigurationsResponse, T> g) {
        return obj -> g.apply((ListProxyConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallResponse.BuilderImpl
    implements Builder {
        private List<ProxyConfigurationMetadata> proxyConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProxyConfigurationsResponse model) {
            super(model);
            this.proxyConfigurations(model.proxyConfigurations);
            this.nextToken(model.nextToken);
        }

        public final List<ProxyConfigurationMetadata.Builder> getProxyConfigurations() {
            List<ProxyConfigurationMetadata.Builder> result = ProxyConfigurationsCopier.copyToBuilder(this.proxyConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProxyConfigurations(Collection<ProxyConfigurationMetadata.BuilderImpl> proxyConfigurations) {
            this.proxyConfigurations = ProxyConfigurationsCopier.copyFromBuilder(proxyConfigurations);
        }

        @Override
        public final Builder proxyConfigurations(Collection<ProxyConfigurationMetadata> proxyConfigurations) {
            this.proxyConfigurations = ProxyConfigurationsCopier.copy(proxyConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proxyConfigurations(ProxyConfigurationMetadata ... proxyConfigurations) {
            this.proxyConfigurations(Arrays.asList(proxyConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proxyConfigurations(Consumer<ProxyConfigurationMetadata.Builder> ... proxyConfigurations) {
            this.proxyConfigurations(Stream.of(proxyConfigurations).map(c -> (ProxyConfigurationMetadata)((ProxyConfigurationMetadata.Builder)ProxyConfigurationMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListProxyConfigurationsResponse build() {
            return new ListProxyConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProxyConfigurationsResponse> {
        public Builder proxyConfigurations(Collection<ProxyConfigurationMetadata> var1);

        public Builder proxyConfigurations(ProxyConfigurationMetadata ... var1);

        public Builder proxyConfigurations(Consumer<ProxyConfigurationMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

