/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallAsyncClient;
import software.amazon.awssdk.services.networkfirewall.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkfirewall.model.Flow;
import software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationResultsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationResultsResponse;

public class ListFlowOperationResultsPublisher
implements SdkPublisher<ListFlowOperationResultsResponse> {
    private final NetworkFirewallAsyncClient client;
    private final ListFlowOperationResultsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFlowOperationResultsPublisher(NetworkFirewallAsyncClient client, ListFlowOperationResultsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFlowOperationResultsPublisher(NetworkFirewallAsyncClient client, ListFlowOperationResultsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFlowOperationResultsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFlowOperationResultsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Flow> flows() {
        Function<ListFlowOperationResultsResponse, Iterator> getIterator = response -> {
            if (response != null && response.flows() != null) {
                return response.flows().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFlowOperationResultsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFlowOperationResultsResponseFetcher
    implements AsyncPageFetcher<ListFlowOperationResultsResponse> {
        private ListFlowOperationResultsResponseFetcher() {
        }

        public boolean hasNextPage(ListFlowOperationResultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFlowOperationResultsResponse> nextPage(ListFlowOperationResultsResponse previousPage) {
            if (previousPage == null) {
                return ListFlowOperationResultsPublisher.this.client.listFlowOperationResults(ListFlowOperationResultsPublisher.this.firstRequest);
            }
            return ListFlowOperationResultsPublisher.this.client.listFlowOperationResults((ListFlowOperationResultsRequest)((Object)ListFlowOperationResultsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

