/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.AnalysisReport;
import software.amazon.awssdk.services.networkfirewall.model.AnalysisReportsCopier;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAnalysisReportsResponse
extends NetworkFirewallResponse
implements ToCopyableBuilder<Builder, ListAnalysisReportsResponse> {
    private static final SdkField<List<AnalysisReport>> ANALYSIS_REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnalysisReports").getter(ListAnalysisReportsResponse.getter(ListAnalysisReportsResponse::analysisReports)).setter(ListAnalysisReportsResponse.setter(Builder::analysisReports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisReports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalysisReport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAnalysisReportsResponse.getter(ListAnalysisReportsResponse::nextToken)).setter(ListAnalysisReportsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_REPORTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAnalysisReportsResponse.memberNameToFieldInitializer();
    private final List<AnalysisReport> analysisReports;
    private final String nextToken;

    private ListAnalysisReportsResponse(BuilderImpl builder) {
        super(builder);
        this.analysisReports = builder.analysisReports;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAnalysisReports() {
        return this.analysisReports != null && !(this.analysisReports instanceof SdkAutoConstructList);
    }

    public final List<AnalysisReport> analysisReports() {
        return this.analysisReports;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalysisReports() ? this.analysisReports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnalysisReportsResponse)) {
            return false;
        }
        ListAnalysisReportsResponse other = (ListAnalysisReportsResponse)((Object)obj);
        return this.hasAnalysisReports() == other.hasAnalysisReports() && Objects.equals(this.analysisReports(), other.analysisReports()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAnalysisReportsResponse").add("AnalysisReports", this.hasAnalysisReports() ? this.analysisReports() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnalysisReports": {
                return Optional.ofNullable(clazz.cast(this.analysisReports()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AnalysisReports", ANALYSIS_REPORTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAnalysisReportsResponse, T> g) {
        return obj -> g.apply((ListAnalysisReportsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallResponse.BuilderImpl
    implements Builder {
        private List<AnalysisReport> analysisReports = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnalysisReportsResponse model) {
            super(model);
            this.analysisReports(model.analysisReports);
            this.nextToken(model.nextToken);
        }

        public final List<AnalysisReport.Builder> getAnalysisReports() {
            List<AnalysisReport.Builder> result = AnalysisReportsCopier.copyToBuilder(this.analysisReports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalysisReports(Collection<AnalysisReport.BuilderImpl> analysisReports) {
            this.analysisReports = AnalysisReportsCopier.copyFromBuilder(analysisReports);
        }

        @Override
        public final Builder analysisReports(Collection<AnalysisReport> analysisReports) {
            this.analysisReports = AnalysisReportsCopier.copy(analysisReports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisReports(AnalysisReport ... analysisReports) {
            this.analysisReports(Arrays.asList(analysisReports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisReports(Consumer<AnalysisReport.Builder> ... analysisReports) {
            this.analysisReports(Stream.of(analysisReports).map(c -> (AnalysisReport)((AnalysisReport.Builder)AnalysisReport.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAnalysisReportsResponse build() {
            return new ListAnalysisReportsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAnalysisReportsResponse> {
        public Builder analysisReports(Collection<AnalysisReport> var1);

        public Builder analysisReports(AnalysisReport ... var1);

        public Builder analysisReports(Consumer<AnalysisReport.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

