/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.EnabledAnalysisType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalysisReport
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalysisReport> {
    private static final SdkField<String> ANALYSIS_REPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisReportId").getter(AnalysisReport.getter(AnalysisReport::analysisReportId)).setter(AnalysisReport.setter(Builder::analysisReportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisReportId").build()}).build();
    private static final SdkField<String> ANALYSIS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisType").getter(AnalysisReport.getter(AnalysisReport::analysisTypeAsString)).setter(AnalysisReport.setter(Builder::analysisType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisType").build()}).build();
    private static final SdkField<Instant> REPORT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReportTime").getter(AnalysisReport.getter(AnalysisReport::reportTime)).setter(AnalysisReport.setter(Builder::reportTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AnalysisReport.getter(AnalysisReport::status)).setter(AnalysisReport.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_REPORT_ID_FIELD, ANALYSIS_TYPE_FIELD, REPORT_TIME_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnalysisReport.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String analysisReportId;
    private final String analysisType;
    private final Instant reportTime;
    private final String status;

    private AnalysisReport(BuilderImpl builder) {
        this.analysisReportId = builder.analysisReportId;
        this.analysisType = builder.analysisType;
        this.reportTime = builder.reportTime;
        this.status = builder.status;
    }

    public final String analysisReportId() {
        return this.analysisReportId;
    }

    public final EnabledAnalysisType analysisType() {
        return EnabledAnalysisType.fromValue(this.analysisType);
    }

    public final String analysisTypeAsString() {
        return this.analysisType;
    }

    public final Instant reportTime() {
        return this.reportTime;
    }

    public final String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisReportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisReport)) {
            return false;
        }
        AnalysisReport other = (AnalysisReport)obj;
        return Objects.equals(this.analysisReportId(), other.analysisReportId()) && Objects.equals(this.analysisTypeAsString(), other.analysisTypeAsString()) && Objects.equals(this.reportTime(), other.reportTime()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"AnalysisReport").add("AnalysisReportId", (Object)this.analysisReportId()).add("AnalysisType", (Object)this.analysisTypeAsString()).add("ReportTime", (Object)this.reportTime()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnalysisReportId": {
                return Optional.ofNullable(clazz.cast(this.analysisReportId()));
            }
            case "AnalysisType": {
                return Optional.ofNullable(clazz.cast(this.analysisTypeAsString()));
            }
            case "ReportTime": {
                return Optional.ofNullable(clazz.cast(this.reportTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AnalysisReportId", ANALYSIS_REPORT_ID_FIELD);
        map.put("AnalysisType", ANALYSIS_TYPE_FIELD);
        map.put("ReportTime", REPORT_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalysisReport, T> g) {
        return obj -> g.apply((AnalysisReport)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String analysisReportId;
        private String analysisType;
        private Instant reportTime;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisReport model) {
            this.analysisReportId(model.analysisReportId);
            this.analysisType(model.analysisType);
            this.reportTime(model.reportTime);
            this.status(model.status);
        }

        public final String getAnalysisReportId() {
            return this.analysisReportId;
        }

        public final void setAnalysisReportId(String analysisReportId) {
            this.analysisReportId = analysisReportId;
        }

        @Override
        public final Builder analysisReportId(String analysisReportId) {
            this.analysisReportId = analysisReportId;
            return this;
        }

        public final String getAnalysisType() {
            return this.analysisType;
        }

        public final void setAnalysisType(String analysisType) {
            this.analysisType = analysisType;
        }

        @Override
        public final Builder analysisType(String analysisType) {
            this.analysisType = analysisType;
            return this;
        }

        @Override
        public final Builder analysisType(EnabledAnalysisType analysisType) {
            this.analysisType(analysisType == null ? null : analysisType.toString());
            return this;
        }

        public final Instant getReportTime() {
            return this.reportTime;
        }

        public final void setReportTime(Instant reportTime) {
            this.reportTime = reportTime;
        }

        @Override
        public final Builder reportTime(Instant reportTime) {
            this.reportTime = reportTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public AnalysisReport build() {
            return new AnalysisReport(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalysisReport> {
        public Builder analysisReportId(String var1);

        public Builder analysisType(String var1);

        public Builder analysisType(EnabledAnalysisType var1);

        public Builder reportTime(Instant var1);

        public Builder status(String var1);
    }
}

