/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TCPFlag {
    FIN("FIN"),
    SYN("SYN"),
    RST("RST"),
    PSH("PSH"),
    ACK("ACK"),
    URG("URG"),
    ECE("ECE"),
    CWR("CWR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TCPFlag> VALUE_MAP;
    private final String value;

    private TCPFlag(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TCPFlag fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TCPFlag> knownValues() {
        EnumSet<TCPFlag> knownValues = EnumSet.allOf(TCPFlag.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TCPFlag.class, TCPFlag::toString);
    }
}

