/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FirewallStatusValue {
    PROVISIONING("PROVISIONING"),
    DELETING("DELETING"),
    READY("READY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FirewallStatusValue> VALUE_MAP;
    private final String value;

    private FirewallStatusValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FirewallStatusValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FirewallStatusValue> knownValues() {
        EnumSet<FirewallStatusValue> knownValues = EnumSet.allOf(FirewallStatusValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FirewallStatusValue.class, FirewallStatusValue::toString);
    }
}

