/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteTlsInspectionConfigurationRequest extends NetworkFirewallRequest implements
        ToCopyableBuilder<DeleteTlsInspectionConfigurationRequest.Builder, DeleteTlsInspectionConfigurationRequest> {
    private static final SdkField<String> TLS_INSPECTION_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TLSInspectionConfigurationArn")
            .getter(getter(DeleteTlsInspectionConfigurationRequest::tlsInspectionConfigurationArn))
            .setter(setter(Builder::tlsInspectionConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSInspectionConfigurationArn")
                    .build()).build();

    private static final SdkField<String> TLS_INSPECTION_CONFIGURATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TLSInspectionConfigurationName")
            .getter(getter(DeleteTlsInspectionConfigurationRequest::tlsInspectionConfigurationName))
            .setter(setter(Builder::tlsInspectionConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSInspectionConfigurationName")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TLS_INSPECTION_CONFIGURATION_ARN_FIELD, TLS_INSPECTION_CONFIGURATION_NAME_FIELD));

    private final String tlsInspectionConfigurationArn;

    private final String tlsInspectionConfigurationName;

    private DeleteTlsInspectionConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.tlsInspectionConfigurationArn = builder.tlsInspectionConfigurationArn;
        this.tlsInspectionConfigurationName = builder.tlsInspectionConfigurationName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the TLS inspection configuration.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the TLS inspection configuration.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String tlsInspectionConfigurationArn() {
        return tlsInspectionConfigurationArn;
    }

    /**
     * <p>
     * The descriptive name of the TLS inspection configuration. You can't change the name of a TLS inspection
     * configuration after you create it.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The descriptive name of the TLS inspection configuration. You can't change the name of a TLS inspection
     *         configuration after you create it.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String tlsInspectionConfigurationName() {
        return tlsInspectionConfigurationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tlsInspectionConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(tlsInspectionConfigurationName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTlsInspectionConfigurationRequest)) {
            return false;
        }
        DeleteTlsInspectionConfigurationRequest other = (DeleteTlsInspectionConfigurationRequest) obj;
        return Objects.equals(tlsInspectionConfigurationArn(), other.tlsInspectionConfigurationArn())
                && Objects.equals(tlsInspectionConfigurationName(), other.tlsInspectionConfigurationName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteTlsInspectionConfigurationRequest")
                .add("TLSInspectionConfigurationArn", tlsInspectionConfigurationArn())
                .add("TLSInspectionConfigurationName", tlsInspectionConfigurationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TLSInspectionConfigurationArn":
            return Optional.ofNullable(clazz.cast(tlsInspectionConfigurationArn()));
        case "TLSInspectionConfigurationName":
            return Optional.ofNullable(clazz.cast(tlsInspectionConfigurationName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteTlsInspectionConfigurationRequest, T> g) {
        return obj -> g.apply((DeleteTlsInspectionConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkFirewallRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteTlsInspectionConfigurationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the TLS inspection configuration.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param tlsInspectionConfigurationArn
         *        The Amazon Resource Name (ARN) of the TLS inspection configuration.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsInspectionConfigurationArn(String tlsInspectionConfigurationArn);

        /**
         * <p>
         * The descriptive name of the TLS inspection configuration. You can't change the name of a TLS inspection
         * configuration after you create it.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param tlsInspectionConfigurationName
         *        The descriptive name of the TLS inspection configuration. You can't change the name of a TLS
         *        inspection configuration after you create it.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsInspectionConfigurationName(String tlsInspectionConfigurationName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFirewallRequest.BuilderImpl implements Builder {
        private String tlsInspectionConfigurationArn;

        private String tlsInspectionConfigurationName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTlsInspectionConfigurationRequest model) {
            super(model);
            tlsInspectionConfigurationArn(model.tlsInspectionConfigurationArn);
            tlsInspectionConfigurationName(model.tlsInspectionConfigurationName);
        }

        public final String getTlsInspectionConfigurationArn() {
            return tlsInspectionConfigurationArn;
        }

        public final void setTlsInspectionConfigurationArn(String tlsInspectionConfigurationArn) {
            this.tlsInspectionConfigurationArn = tlsInspectionConfigurationArn;
        }

        @Override
        public final Builder tlsInspectionConfigurationArn(String tlsInspectionConfigurationArn) {
            this.tlsInspectionConfigurationArn = tlsInspectionConfigurationArn;
            return this;
        }

        public final String getTlsInspectionConfigurationName() {
            return tlsInspectionConfigurationName;
        }

        public final void setTlsInspectionConfigurationName(String tlsInspectionConfigurationName) {
            this.tlsInspectionConfigurationName = tlsInspectionConfigurationName;
        }

        @Override
        public final Builder tlsInspectionConfigurationName(String tlsInspectionConfigurationName) {
            this.tlsInspectionConfigurationName = tlsInspectionConfigurationName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteTlsInspectionConfigurationRequest build() {
            return new DeleteTlsInspectionConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
