/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StreamExceptionPolicy {
    DROP("DROP"),
    CONTINUE("CONTINUE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StreamExceptionPolicy> VALUE_MAP;
    private final String value;

    private StreamExceptionPolicy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StreamExceptionPolicy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StreamExceptionPolicy> knownValues() {
        EnumSet<StreamExceptionPolicy> knownValues = EnumSet.allOf(StreamExceptionPolicy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StreamExceptionPolicy.class, StreamExceptionPolicy::toString);
    }
}

