/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class ProxyConfiguration
implements ToCopyableBuilder<Builder, ProxyConfiguration> {
    private final String scheme;
    private final String host;
    private final int port;
    private final Set<String> nonProxyHosts;

    private ProxyConfiguration(BuilderImpl builder) {
        this.scheme = builder.scheme;
        this.host = builder.host;
        this.port = builder.port;
        this.nonProxyHosts = Collections.unmodifiableSet(builder.nonProxyHosts);
    }

    public String scheme() {
        return this.scheme;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public Set<String> nonProxyHosts() {
        return this.nonProxyHosts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyConfiguration that = (ProxyConfiguration)o;
        if (this.port != that.port) {
            return false;
        }
        if (this.scheme != null ? !this.scheme.equals(that.scheme) : that.scheme != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        return this.nonProxyHosts.equals(that.nonProxyHosts);
    }

    public int hashCode() {
        int result = this.scheme != null ? this.scheme.hashCode() : 0;
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + this.port;
        result = 31 * result + this.nonProxyHosts.hashCode();
        return result;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    private static final class BuilderImpl
    implements Builder {
        private String scheme;
        private String host;
        private int port;
        private Set<String> nonProxyHosts = Collections.emptySet();

        private BuilderImpl() {
        }

        private BuilderImpl(ProxyConfiguration proxyConfiguration) {
            this.scheme = proxyConfiguration.scheme;
            this.host = proxyConfiguration.host;
            this.port = proxyConfiguration.port;
            this.nonProxyHosts = new HashSet<String>(proxyConfiguration.nonProxyHosts);
        }

        @Override
        public Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        @Override
        public Builder host(String host) {
            this.host = host;
            return this;
        }

        @Override
        public Builder port(int port) {
            this.port = port;
            return this;
        }

        @Override
        public Builder nonProxyHosts(Set<String> nonProxyHosts) {
            this.nonProxyHosts = nonProxyHosts != null ? new HashSet<String>(nonProxyHosts) : Collections.emptySet();
            return this;
        }

        public ProxyConfiguration build() {
            return new ProxyConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProxyConfiguration> {
        public Builder host(String var1);

        public Builder port(int var1);

        public Builder scheme(String var1);

        public Builder nonProxyHosts(Set<String> var1);
    }
}

