/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.net.URI;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.http.nio.netty.SdkEventLoopGroup;
import software.amazon.awssdk.http.nio.netty.internal.BetterSimpleChannelPool;
import software.amazon.awssdk.http.nio.netty.internal.CancellableAcquireChannelPool;
import software.amazon.awssdk.http.nio.netty.internal.ChannelPipelineInitializer;
import software.amazon.awssdk.http.nio.netty.internal.HandlerRemovingChannelPool;
import software.amazon.awssdk.http.nio.netty.internal.HealthCheckedChannelPool;
import software.amazon.awssdk.http.nio.netty.internal.HonorCloseOnReleaseChannelPool;
import software.amazon.awssdk.http.nio.netty.internal.NettyConfiguration;
import software.amazon.awssdk.http.nio.netty.internal.ReleaseOnceChannelPool;
import software.amazon.awssdk.http.nio.netty.internal.SdkChannelOptions;
import software.amazon.awssdk.http.nio.netty.internal.SdkChannelPoolMap;
import software.amazon.awssdk.http.nio.netty.internal.http2.HttpOrHttp2ChannelPool;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class AwaitCloseChannelPoolMap
extends SdkChannelPoolMap<URI, SimpleChannelPoolAwareChannelPool> {
    private static final Logger log = Logger.loggerFor(AwaitCloseChannelPoolMap.class);
    private final SdkChannelOptions sdkChannelOptions;
    private final SdkEventLoopGroup sdkEventLoopGroup;
    private final NettyConfiguration configuration;
    private final Protocol protocol;
    private final long maxStreams;
    private final SslProvider sslProvider;

    private AwaitCloseChannelPoolMap(Builder builder) {
        this.sdkChannelOptions = builder.sdkChannelOptions;
        this.sdkEventLoopGroup = builder.sdkEventLoopGroup;
        this.configuration = builder.configuration;
        this.protocol = builder.protocol;
        this.maxStreams = builder.maxStreams;
        this.sslProvider = builder.sslProvider;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected SimpleChannelPoolAwareChannelPool newPool(URI key) {
        SslContext sslContext = this.sslContext(key.getScheme());
        Bootstrap bootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.sdkEventLoopGroup.eventLoopGroup())).channelFactory(this.sdkEventLoopGroup.channelFactory())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.configuration.connectTimeoutMillis())).remoteAddress(key.getHost(), key.getPort());
        this.sdkChannelOptions.channelOptions().forEach((arg_0, arg_1) -> ((Bootstrap)bootstrap).option(arg_0, arg_1));
        AtomicReference<ChannelPool> channelPoolRef = new AtomicReference<ChannelPool>();
        ChannelPipelineInitializer handler = new ChannelPipelineInitializer(this.protocol, sslContext, this.maxStreams, channelPoolRef, this.configuration, key);
        BetterSimpleChannelPool simpleChannelPool = new BetterSimpleChannelPool(bootstrap, (ChannelPoolHandler)handler);
        channelPoolRef.set(this.wrapSimpleChannelPool(bootstrap, (ChannelPool)simpleChannelPool));
        return new SimpleChannelPoolAwareChannelPool(simpleChannelPool, channelPoolRef.get());
    }

    @Override
    public void close() {
        log.trace(() -> "Closing channel pools");
        Collection channelPools = this.pools().values();
        super.close();
        try {
            CompletableFuture.allOf((CompletableFuture[])channelPools.stream().map(pool -> ((SimpleChannelPoolAwareChannelPool)pool).underlyingSimpleChannelPool.closeFuture()).toArray(CompletableFuture[]::new)).get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    private ChannelPool wrapSimpleChannelPool(Bootstrap bootstrap, ChannelPool channelPool) {
        channelPool = new HonorCloseOnReleaseChannelPool(channelPool);
        channelPool = new HttpOrHttp2ChannelPool(channelPool, bootstrap.config().group(), this.configuration.maxConnections(), this.configuration);
        channelPool = new HandlerRemovingChannelPool(channelPool);
        channelPool = new ReleaseOnceChannelPool(channelPool);
        channelPool = new HealthCheckedChannelPool(bootstrap.config().group(), this.configuration, channelPool);
        channelPool = new CancellableAcquireChannelPool((EventExecutor)bootstrap.config().group().next(), channelPool);
        return channelPool;
    }

    private SslContext sslContext(String protocol) {
        if (!protocol.equalsIgnoreCase("https")) {
            return null;
        }
        try {
            return SslContextBuilder.forClient().sslProvider(this.sslProvider).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).trustManager(this.getTrustManager()).build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    }

    private TrustManagerFactory getTrustManager() {
        return this.configuration.trustAllCertificates() ? InsecureTrustManagerFactory.INSTANCE : null;
    }

    public static class Builder {
        private SdkChannelOptions sdkChannelOptions;
        private SdkEventLoopGroup sdkEventLoopGroup;
        private NettyConfiguration configuration;
        private Protocol protocol;
        private long maxStreams;
        private SslProvider sslProvider;

        private Builder() {
        }

        public Builder sdkChannelOptions(SdkChannelOptions sdkChannelOptions) {
            this.sdkChannelOptions = sdkChannelOptions;
            return this;
        }

        public Builder sdkEventLoopGroup(SdkEventLoopGroup sdkEventLoopGroup) {
            this.sdkEventLoopGroup = sdkEventLoopGroup;
            return this;
        }

        public Builder configuration(NettyConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder maxStreams(long maxStreams) {
            this.maxStreams = maxStreams;
            return this;
        }

        public Builder sslProvider(SslProvider sslProvider) {
            this.sslProvider = sslProvider;
            return this;
        }

        public AwaitCloseChannelPoolMap build() {
            return new AwaitCloseChannelPoolMap(this);
        }
    }

    static final class SimpleChannelPoolAwareChannelPool
    implements ChannelPool {
        private final BetterSimpleChannelPool underlyingSimpleChannelPool;
        private final ChannelPool actualChannelPool;

        private SimpleChannelPoolAwareChannelPool(BetterSimpleChannelPool underlyingSimpleChannelPool, ChannelPool actualChannelPool) {
            this.underlyingSimpleChannelPool = underlyingSimpleChannelPool;
            this.actualChannelPool = actualChannelPool;
        }

        public Future<Channel> acquire() {
            return this.actualChannelPool.acquire();
        }

        public Future<Channel> acquire(Promise<Channel> promise) {
            return this.actualChannelPool.acquire(promise);
        }

        public Future<Void> release(Channel channel) {
            return this.actualChannelPool.release(channel);
        }

        public Future<Void> release(Channel channel, Promise<Void> promise) {
            return this.actualChannelPool.release(channel, promise);
        }

        public void close() {
            this.actualChannelPool.close();
        }

        @SdkTestInternalApi
        BetterSimpleChannelPool underlyingSimpleChannelPool() {
            return this.underlyingSimpleChannelPool;
        }
    }
}

