/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
public final class OneTimeReadTimeoutHandler
extends SimpleChannelInboundHandler {
    private static final String READ_TIMEOUT_HANDLER_NAME = "RemoveAfterReadTimeoutHandler";
    private final long readTimeoutMillis;
    private final TimeUnit timeUnit;

    OneTimeReadTimeoutHandler(long readTimeoutMillis, TimeUnit timeUnit) {
        this.readTimeoutMillis = readTimeoutMillis;
        this.timeUnit = timeUnit;
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) {
        ReferenceCountUtil.retain((Object)msg);
        ctx.pipeline().addFirst(READ_TIMEOUT_HANDLER_NAME, (ChannelHandler)new ReadTimeoutHandler(this.readTimeoutMillis, this.timeUnit));
        ctx.fireChannelRead(msg);
        ctx.pipeline().remove(READ_TIMEOUT_HANDLER_NAME);
        ctx.pipeline().remove((ChannelHandler)this);
    }
}

