/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKey;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public class UnusedChannelExceptionHandler
extends ChannelHandlerAdapter {
    private static final Logger log = Logger.loggerFor(UnusedChannelExceptionHandler.class);

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        boolean channelInUse = this.getAttribute(ctx, ChannelAttributeKey.IN_USE).orElse(false);
        if (channelInUse) {
            ctx.fireExceptionCaught(cause);
        } else {
            ctx.close();
            Optional<CompletableFuture<Void>> executeFuture = this.getAttribute(ctx, ChannelAttributeKey.EXECUTE_FUTURE_KEY);
            if (executeFuture.isPresent() && !executeFuture.get().isDone()) {
                log.error(() -> "An exception occurred on an channel (" + ctx.channel().id() + ") that was not in use, but was associated with a future that wasn't completed. This indicates a bug in the Java SDK, where a future was not completed while the channel was in use. The channel has been closed, and the future will be completed to prevent any ongoing issues.", cause);
                executeFuture.get().completeExceptionally(cause);
            } else if (cause instanceof IOException) {
                log.debug(() -> "An I/O exception (" + cause.getMessage() + ") occurred on a channel (" + ctx.channel().id() + ") that was not in use. The channel has been closed. This is usually normal.");
            } else {
                log.warn(() -> "A non-I/O exception occurred on a channel (" + ctx.channel().id() + ") that was not in use. The channel has been closed to prevent any ongoing issues.", cause);
            }
        }
    }

    private <T> Optional<T> getAttribute(ChannelHandlerContext ctx, AttributeKey<T> key) {
        return Optional.ofNullable(ctx.channel().attr(key)).map(Attribute::get);
    }
}

