/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.pool.AbstractChannelPoolHandler;
import io.netty.channel.pool.ChannelPool;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http2.ForkedHttp2MultiplexCodecBuilder;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKey;
import software.amazon.awssdk.http.nio.netty.internal.http2.MultiplexedChannelRecord;
import software.amazon.awssdk.http.nio.netty.internal.http2.SdkHttp2FrameLogger;
import software.amazon.awssdk.utils.StringUtils;

@SdkInternalApi
public class ChannelPipelineInitializer
extends AbstractChannelPoolHandler {
    private final Protocol protocol;
    private final SslContext sslCtx;
    private final long clientMaxStreams;
    private final AtomicReference<ChannelPool> channelPoolRef;

    public ChannelPipelineInitializer(Protocol protocol, SslContext sslCtx, long clientMaxStreams, AtomicReference<ChannelPool> channelPoolRef) {
        this.protocol = protocol;
        this.sslCtx = sslCtx;
        this.clientMaxStreams = clientMaxStreams;
        this.channelPoolRef = channelPoolRef;
    }

    public void channelCreated(Channel ch) {
        ch.attr(ChannelAttributeKey.PROTOCOL_FUTURE).set(new CompletableFuture());
        ChannelPipeline pipeline = ch.pipeline();
        if (this.sslCtx != null) {
            pipeline.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
        }
        if (this.protocol == Protocol.HTTP2) {
            this.configureHttp2(ch, pipeline);
        } else {
            this.configureHttp11(ch, pipeline);
        }
    }

    private void configureHttp2(final Channel ch, ChannelPipeline pipeline) {
        ForkedHttp2MultiplexCodecBuilder codecBuilder = ForkedHttp2MultiplexCodecBuilder.forClient((ChannelHandler)new NoOpChannelInitializer()).headerSensitivityDetector((name, value) -> StringUtils.lowerCase((String)name.toString()).equals("authorization")).initialSettings(Http2Settings.defaultSettings().initialWindowSize(0x100000));
        SdkHttp2FrameLogger.frameLogger().ifPresent(codecBuilder::frameLogger);
        pipeline.addLast(new ChannelHandler[]{codecBuilder.build()});
        pipeline.addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<Http2SettingsFrame>(){

            protected void channelRead0(ChannelHandlerContext ctx, Http2SettingsFrame msg) {
                Long serverMaxStreams = Optional.ofNullable(msg.settings().maxConcurrentStreams()).orElse(Long.MAX_VALUE);
                ch.attr(ChannelAttributeKey.MAX_CONCURRENT_STREAMS).set((Object)Math.min(ChannelPipelineInitializer.this.clientMaxStreams, serverMaxStreams));
                ((CompletableFuture)ch.attr(ChannelAttributeKey.PROTOCOL_FUTURE).get()).complete(Protocol.HTTP2);
            }

            public void channelUnregistered(ChannelHandlerContext ctx) {
                if (!((CompletableFuture)ch.attr(ChannelAttributeKey.PROTOCOL_FUTURE).get()).isDone()) {
                    ChannelPipelineInitializer.this.channelError(new IOException("The channel was closed before the protocol could be determined."), ch);
                }
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                ChannelPipelineInitializer.this.channelError(cause, ch);
            }
        }});
    }

    private void channelError(Throwable cause, Channel ch) {
        ((CompletableFuture)ch.attr(ChannelAttributeKey.PROTOCOL_FUTURE).get()).completeExceptionally(cause);
        MultiplexedChannelRecord record = (MultiplexedChannelRecord)ch.attr(ChannelAttributeKey.CHANNEL_POOL_RECORD).get();
        if (record != null) {
            record.shutdownChildChannels(cause);
        }
        ch.eventLoop().submit(() -> {
            try {
                if (ch.isActive()) {
                    ch.close();
                }
            }
            finally {
                this.channelPoolRef.get().release(ch);
            }
        });
    }

    private void configureHttp11(Channel ch, ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
        ((CompletableFuture)ch.attr(ChannelAttributeKey.PROTOCOL_FUTURE).get()).complete(Protocol.HTTP1_1);
    }

    private static class NoOpChannelInitializer
    extends ChannelInitializer<Channel> {
        private NoOpChannelInitializer() {
        }

        protected void initChannel(Channel ch) {
        }
    }
}

