/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.ChannelPoolMap;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.net.URI;
import java.time.Duration;
import java.util.Optional;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkRequestContext;
import software.amazon.awssdk.http.async.AbortableRunnable;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.async.SdkHttpRequestProvider;
import software.amazon.awssdk.http.async.SdkHttpResponseHandler;
import software.amazon.awssdk.http.nio.netty.EventLoopGroupFactory;
import software.amazon.awssdk.http.nio.netty.NettySdkHttpClientFactory;
import software.amazon.awssdk.http.nio.netty.internal.ChannelPipelineInitializer;
import software.amazon.awssdk.http.nio.netty.internal.DelegatingEventLoopGroup;
import software.amazon.awssdk.http.nio.netty.internal.NonManagedEventLoopGroup;
import software.amazon.awssdk.http.nio.netty.internal.RequestAdapter;
import software.amazon.awssdk.http.nio.netty.internal.RequestContext;
import software.amazon.awssdk.http.nio.netty.internal.RunnableRequest;
import software.amazon.awssdk.http.nio.netty.internal.SdkChannelPoolMap;
import software.amazon.awssdk.http.nio.netty.internal.SharedEventLoopGroup;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.NumericUtils;

@SdkInternalApi
final class NettyNioAsyncHttpClient
implements SdkAsyncHttpClient {
    private final EventLoopGroup group;
    private final RequestAdapter requestAdapter = new RequestAdapter();
    private final ChannelPoolMap<URI, ChannelPool> pools;
    private final ServiceDefaults serviceDefaults;
    private final boolean trustAllCertificates;

    NettyNioAsyncHttpClient(NettySdkHttpClientFactory factory, AttributeMap serviceDefaultsMap) {
        this.serviceDefaults = new ServiceDefaults(serviceDefaultsMap);
        this.trustAllCertificates = factory.trustAllCertificates().orElse(Boolean.FALSE);
        this.group = factory.eventLoopGroupConfiguration().toEither().map(e -> (EventLoopGroup)e.map(NonManagedEventLoopGroup::new, EventLoopGroupFactory::create)).orElseGet(SharedEventLoopGroup::get);
        this.pools = this.createChannelPoolMap(this.serviceDefaults, factory.maxConnectionsPerEndpoint().orElse(this.serviceDefaults.getMaxConnections()));
    }

    private ChannelPoolMap<URI, ChannelPool> createChannelPoolMap(final ServiceDefaults serviceDefaults, final int maxConnectionsPerEndpoint) {
        return new SdkChannelPoolMap<URI, ChannelPool>(){

            @Override
            protected ChannelPool newPool(URI key) {
                Bootstrap bootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(NettyNioAsyncHttpClient.this.group)).channel(NettyNioAsyncHttpClient.this.resolveSocketChannelClass())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)serviceDefaults.getConnectionTimeout())).option(ChannelOption.TCP_NODELAY, (Object)true)).remoteAddress(key.getHost(), NettyNioAsyncHttpClient.port(key));
                SslContext sslContext = NettyNioAsyncHttpClient.this.sslContext(key.getScheme());
                return new FixedChannelPool(bootstrap, (ChannelPoolHandler)new ChannelPipelineInitializer(sslContext), maxConnectionsPerEndpoint);
            }
        };
    }

    public AbortableRunnable prepareRequest(SdkHttpRequest sdkRequest, SdkRequestContext requestContext, SdkHttpRequestProvider requestProvider, SdkHttpResponseHandler handler) {
        RequestContext context = new RequestContext(this.pools.get((Object)NettyNioAsyncHttpClient.stripPath(sdkRequest.getEndpoint())), sdkRequest, requestProvider, this.requestAdapter.adapt(sdkRequest), handler);
        return new RunnableRequest(context);
    }

    public <T> Optional<T> getConfigurationValue(SdkHttpConfigurationOption<T> key) {
        return this.serviceDefaults.getConfigurationValue(key);
    }

    public void close() {
        this.group.shutdownGracefully();
    }

    @ReviewBeforeRelease(value="Perhaps we should make the customer provide both event loop groupand channel in some kind of wrapper class to avoid having to do this.")
    private Class<? extends Channel> resolveSocketChannelClass() {
        EventLoopGroup unwrapped = this.group;
        while (unwrapped instanceof DelegatingEventLoopGroup) {
            unwrapped = ((DelegatingEventLoopGroup)unwrapped).getDelegate();
        }
        return unwrapped instanceof EpollEventLoopGroup ? EpollSocketChannel.class : NioSocketChannel.class;
    }

    private static URI stripPath(URI uri) {
        return (URI)FunctionalUtils.invokeSafely(() -> new URI(uri.getScheme(), null, uri.getHost(), NettyNioAsyncHttpClient.port(uri), null, null, null));
    }

    private static int port(URI uri) {
        return uri.getPort() != -1 ? uri.getPort() : (uri.getScheme().equalsIgnoreCase("https") ? 443 : 80);
    }

    private SslContext sslContext(String scheme) {
        if (scheme.equalsIgnoreCase("https")) {
            SslContextBuilder builder = SslContextBuilder.forClient().sslProvider(SslContext.defaultClientProvider());
            if (this.trustAllCertificates) {
                builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            }
            return (SslContext)FunctionalUtils.invokeSafely(() -> ((SslContextBuilder)builder).build());
        }
        return null;
    }

    private static class ServiceDefaults {
        private final AttributeMap serviceDefaults;

        private ServiceDefaults(AttributeMap serviceDefaults) {
            this.serviceDefaults = serviceDefaults;
        }

        @ReviewBeforeRelease(value="Not sure if Netty supports setting socket timeout. There's a ReadTimeoutHandler but thatfires if the connection is just idle which is not what we want.")
        public int getSocketTimeout() {
            return NumericUtils.saturatedCast((long)((Duration)this.serviceDefaults.get((AttributeMap.Key)SdkHttpConfigurationOption.SOCKET_TIMEOUT)).toMillis());
        }

        public int getConnectionTimeout() {
            return NumericUtils.saturatedCast((long)((Duration)this.serviceDefaults.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT)).toMillis());
        }

        @ReviewBeforeRelease(value="Does it make sense to use this value? Netty's implementation is max connections per endpoint so if it's a shared client it doesn't mean quite the same thing.")
        public int getMaxConnections() {
            return (Integer)this.serviceDefaults.get((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS);
        }

        @ReviewBeforeRelease(value="Support disabling strict hostname verification")
        public <T> Optional<T> getConfigurationValue(AttributeMap.Key<T> key) {
            return key == SdkHttpConfigurationOption.USE_STRICT_HOSTNAME_VERIFICATION ? Optional.empty() : Optional.ofNullable(this.serviceDefaults.get(key));
        }
    }
}

