/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExportTaskStatus {
    INITIALIZING("INITIALIZING"),
    EXPORTING("EXPORTING"),
    SUCCEEDED("SUCCEEDED"),
    FAILED("FAILED"),
    CANCELLING("CANCELLING"),
    CANCELLED("CANCELLED"),
    DELETED("DELETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExportTaskStatus> VALUE_MAP;
    private final String value;

    private ExportTaskStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExportTaskStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExportTaskStatus> knownValues() {
        EnumSet<ExportTaskStatus> knownValues = EnumSet.allOf(ExportTaskStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExportTaskStatus.class, ExportTaskStatus::toString);
    }
}

