/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.neptunegraph.model.DocumentValuedMapCopier;
import software.amazon.awssdk.services.neptunegraph.model.ExplainMode;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.PlanCacheType;
import software.amazon.awssdk.services.neptunegraph.model.QueryLanguage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecuteQueryRequest
extends NeptuneGraphRequest
implements ToCopyableBuilder<Builder, ExecuteQueryRequest> {
    private static final SdkField<String> GRAPH_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("graphIdentifier").getter(ExecuteQueryRequest.getter(ExecuteQueryRequest::graphIdentifier)).setter(ExecuteQueryRequest.setter(Builder::graphIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("graphIdentifier").build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryString").getter(ExecuteQueryRequest.getter(ExecuteQueryRequest::queryString)).setter(ExecuteQueryRequest.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("query").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("language").getter(ExecuteQueryRequest.getter(ExecuteQueryRequest::languageAsString)).setter(ExecuteQueryRequest.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()}).build();
    private static final SdkField<Map<String, Document>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(ExecuteQueryRequest.getter(ExecuteQueryRequest::parameters)).setter(ExecuteQueryRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> PLAN_CACHE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("planCache").getter(ExecuteQueryRequest.getter(ExecuteQueryRequest::planCacheAsString)).setter(ExecuteQueryRequest.setter(Builder::planCache)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planCache").build()}).build();
    private static final SdkField<String> EXPLAIN_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("explainMode").getter(ExecuteQueryRequest.getter(ExecuteQueryRequest::explainModeAsString)).setter(ExecuteQueryRequest.setter(Builder::explainMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("explain").build()}).build();
    private static final SdkField<Integer> QUERY_TIMEOUT_MILLISECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("queryTimeoutMilliseconds").getter(ExecuteQueryRequest.getter(ExecuteQueryRequest::queryTimeoutMilliseconds)).setter(ExecuteQueryRequest.setter(Builder::queryTimeoutMilliseconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryTimeoutMilliseconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_IDENTIFIER_FIELD, QUERY_STRING_FIELD, LANGUAGE_FIELD, PARAMETERS_FIELD, PLAN_CACHE_FIELD, EXPLAIN_MODE_FIELD, QUERY_TIMEOUT_MILLISECONDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExecuteQueryRequest.memberNameToFieldInitializer();
    private final String graphIdentifier;
    private final String queryString;
    private final String language;
    private final Map<String, Document> parameters;
    private final String planCache;
    private final String explainMode;
    private final Integer queryTimeoutMilliseconds;

    private ExecuteQueryRequest(BuilderImpl builder) {
        super(builder);
        this.graphIdentifier = builder.graphIdentifier;
        this.queryString = builder.queryString;
        this.language = builder.language;
        this.parameters = builder.parameters;
        this.planCache = builder.planCache;
        this.explainMode = builder.explainMode;
        this.queryTimeoutMilliseconds = builder.queryTimeoutMilliseconds;
    }

    public final String graphIdentifier() {
        return this.graphIdentifier;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final QueryLanguage language() {
        return QueryLanguage.fromValue(this.language);
    }

    public final String languageAsString() {
        return this.language;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, Document> parameters() {
        return this.parameters;
    }

    public final PlanCacheType planCache() {
        return PlanCacheType.fromValue(this.planCache);
    }

    public final String planCacheAsString() {
        return this.planCache;
    }

    public final ExplainMode explainMode() {
        return ExplainMode.fromValue(this.explainMode);
    }

    public final String explainModeAsString() {
        return this.explainMode;
    }

    public final Integer queryTimeoutMilliseconds() {
        return this.queryTimeoutMilliseconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.graphIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.planCacheAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.explainModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryTimeoutMilliseconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteQueryRequest)) {
            return false;
        }
        ExecuteQueryRequest other = (ExecuteQueryRequest)((Object)obj);
        return Objects.equals(this.graphIdentifier(), other.graphIdentifier()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.languageAsString(), other.languageAsString()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.planCacheAsString(), other.planCacheAsString()) && Objects.equals(this.explainModeAsString(), other.explainModeAsString()) && Objects.equals(this.queryTimeoutMilliseconds(), other.queryTimeoutMilliseconds());
    }

    public final String toString() {
        return ToString.builder((String)"ExecuteQueryRequest").add("GraphIdentifier", (Object)this.graphIdentifier()).add("QueryString", (Object)this.queryString()).add("Language", (Object)this.languageAsString()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("PlanCache", (Object)this.planCacheAsString()).add("ExplainMode", (Object)this.explainModeAsString()).add("QueryTimeoutMilliseconds", (Object)this.queryTimeoutMilliseconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "graphIdentifier": {
                return Optional.ofNullable(clazz.cast(this.graphIdentifier()));
            }
            case "queryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "language": {
                return Optional.ofNullable(clazz.cast(this.languageAsString()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "planCache": {
                return Optional.ofNullable(clazz.cast(this.planCacheAsString()));
            }
            case "explainMode": {
                return Optional.ofNullable(clazz.cast(this.explainModeAsString()));
            }
            case "queryTimeoutMilliseconds": {
                return Optional.ofNullable(clazz.cast(this.queryTimeoutMilliseconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("graphIdentifier", GRAPH_IDENTIFIER_FIELD);
        map.put("query", QUERY_STRING_FIELD);
        map.put("language", LANGUAGE_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("planCache", PLAN_CACHE_FIELD);
        map.put("explain", EXPLAIN_MODE_FIELD);
        map.put("queryTimeoutMilliseconds", QUERY_TIMEOUT_MILLISECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecuteQueryRequest, T> g) {
        return obj -> g.apply((ExecuteQueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneGraphRequest.BuilderImpl
    implements Builder {
        private String graphIdentifier;
        private String queryString;
        private String language;
        private Map<String, Document> parameters = DefaultSdkAutoConstructMap.getInstance();
        private String planCache;
        private String explainMode;
        private Integer queryTimeoutMilliseconds;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteQueryRequest model) {
            super(model);
            this.graphIdentifier(model.graphIdentifier);
            this.queryString(model.queryString);
            this.language(model.language);
            this.parameters(model.parameters);
            this.planCache(model.planCache);
            this.explainMode(model.explainMode);
            this.queryTimeoutMilliseconds(model.queryTimeoutMilliseconds);
        }

        public final String getGraphIdentifier() {
            return this.graphIdentifier;
        }

        public final void setGraphIdentifier(String graphIdentifier) {
            this.graphIdentifier = graphIdentifier;
        }

        @Override
        public final Builder graphIdentifier(String graphIdentifier) {
            this.graphIdentifier = graphIdentifier;
            return this;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public final Builder language(QueryLanguage language) {
            this.language(language == null ? null : language.toString());
            return this;
        }

        public final Map<String, Document> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, Document> parameters) {
            this.parameters = DocumentValuedMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, Document> parameters) {
            this.parameters = DocumentValuedMapCopier.copy(parameters);
            return this;
        }

        public final String getPlanCache() {
            return this.planCache;
        }

        public final void setPlanCache(String planCache) {
            this.planCache = planCache;
        }

        @Override
        public final Builder planCache(String planCache) {
            this.planCache = planCache;
            return this;
        }

        @Override
        public final Builder planCache(PlanCacheType planCache) {
            this.planCache(planCache == null ? null : planCache.toString());
            return this;
        }

        public final String getExplainMode() {
            return this.explainMode;
        }

        public final void setExplainMode(String explainMode) {
            this.explainMode = explainMode;
        }

        @Override
        public final Builder explainMode(String explainMode) {
            this.explainMode = explainMode;
            return this;
        }

        @Override
        public final Builder explainMode(ExplainMode explainMode) {
            this.explainMode(explainMode == null ? null : explainMode.toString());
            return this;
        }

        public final Integer getQueryTimeoutMilliseconds() {
            return this.queryTimeoutMilliseconds;
        }

        public final void setQueryTimeoutMilliseconds(Integer queryTimeoutMilliseconds) {
            this.queryTimeoutMilliseconds = queryTimeoutMilliseconds;
        }

        @Override
        public final Builder queryTimeoutMilliseconds(Integer queryTimeoutMilliseconds) {
            this.queryTimeoutMilliseconds = queryTimeoutMilliseconds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteQueryRequest build() {
            return new ExecuteQueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NeptuneGraphRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExecuteQueryRequest> {
        public Builder graphIdentifier(String var1);

        public Builder queryString(String var1);

        public Builder language(String var1);

        public Builder language(QueryLanguage var1);

        public Builder parameters(Map<String, Document> var1);

        public Builder planCache(String var1);

        public Builder planCache(PlanCacheType var1);

        public Builder explainMode(String var1);

        public Builder explainMode(ExplainMode var1);

        public Builder queryTimeoutMilliseconds(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

