/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BlankNodeHandling {
    CONVERT_TO_IRI("convertToIri"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BlankNodeHandling> VALUE_MAP;
    private final String value;

    private BlankNodeHandling(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BlankNodeHandling fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BlankNodeHandling> knownValues() {
        EnumSet<BlankNodeHandling> knownValues = EnumSet.allOf(BlankNodeHandling.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BlankNodeHandling.class, BlankNodeHandling::toString);
    }
}

