/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptunegraph.model.GraphSnapshotSummary;
import software.amazon.awssdk.services.neptunegraph.model.GraphSnapshotSummaryListCopier;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGraphSnapshotsResponse
extends NeptuneGraphResponse
implements ToCopyableBuilder<Builder, ListGraphSnapshotsResponse> {
    private static final SdkField<List<GraphSnapshotSummary>> GRAPH_SNAPSHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("graphSnapshots").getter(ListGraphSnapshotsResponse.getter(ListGraphSnapshotsResponse::graphSnapshots)).setter(ListGraphSnapshotsResponse.setter(Builder::graphSnapshots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphSnapshots").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GraphSnapshotSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListGraphSnapshotsResponse.getter(ListGraphSnapshotsResponse::nextToken)).setter(ListGraphSnapshotsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_SNAPSHOTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListGraphSnapshotsResponse.memberNameToFieldInitializer();
    private final List<GraphSnapshotSummary> graphSnapshots;
    private final String nextToken;

    private ListGraphSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.graphSnapshots = builder.graphSnapshots;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasGraphSnapshots() {
        return this.graphSnapshots != null && !(this.graphSnapshots instanceof SdkAutoConstructList);
    }

    public final List<GraphSnapshotSummary> graphSnapshots() {
        return this.graphSnapshots;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGraphSnapshots() ? this.graphSnapshots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGraphSnapshotsResponse)) {
            return false;
        }
        ListGraphSnapshotsResponse other = (ListGraphSnapshotsResponse)((Object)obj);
        return this.hasGraphSnapshots() == other.hasGraphSnapshots() && Objects.equals(this.graphSnapshots(), other.graphSnapshots()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListGraphSnapshotsResponse").add("GraphSnapshots", this.hasGraphSnapshots() ? this.graphSnapshots() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "graphSnapshots": {
                return Optional.ofNullable(clazz.cast(this.graphSnapshots()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("graphSnapshots", GRAPH_SNAPSHOTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGraphSnapshotsResponse, T> g) {
        return obj -> g.apply((ListGraphSnapshotsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneGraphResponse.BuilderImpl
    implements Builder {
        private List<GraphSnapshotSummary> graphSnapshots = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGraphSnapshotsResponse model) {
            super(model);
            this.graphSnapshots(model.graphSnapshots);
            this.nextToken(model.nextToken);
        }

        public final List<GraphSnapshotSummary.Builder> getGraphSnapshots() {
            List<GraphSnapshotSummary.Builder> result = GraphSnapshotSummaryListCopier.copyToBuilder(this.graphSnapshots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGraphSnapshots(Collection<GraphSnapshotSummary.BuilderImpl> graphSnapshots) {
            this.graphSnapshots = GraphSnapshotSummaryListCopier.copyFromBuilder(graphSnapshots);
        }

        @Override
        public final Builder graphSnapshots(Collection<GraphSnapshotSummary> graphSnapshots) {
            this.graphSnapshots = GraphSnapshotSummaryListCopier.copy(graphSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder graphSnapshots(GraphSnapshotSummary ... graphSnapshots) {
            this.graphSnapshots(Arrays.asList(graphSnapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder graphSnapshots(Consumer<GraphSnapshotSummary.Builder> ... graphSnapshots) {
            this.graphSnapshots(Stream.of(graphSnapshots).map(c -> (GraphSnapshotSummary)((GraphSnapshotSummary.Builder)GraphSnapshotSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListGraphSnapshotsResponse build() {
            return new ListGraphSnapshotsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NeptuneGraphResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGraphSnapshotsResponse> {
        public Builder graphSnapshots(Collection<GraphSnapshotSummary> var1);

        public Builder graphSnapshots(GraphSnapshotSummary ... var1);

        public Builder graphSnapshots(Consumer<GraphSnapshotSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

