/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UnprocessableExceptionReason {
    QUERY_TIMEOUT("QUERY_TIMEOUT"),
    INTERNAL_LIMIT_EXCEEDED("INTERNAL_LIMIT_EXCEEDED"),
    MEMORY_LIMIT_EXCEEDED("MEMORY_LIMIT_EXCEEDED"),
    STORAGE_LIMIT_EXCEEDED("STORAGE_LIMIT_EXCEEDED"),
    PARTITION_FULL("PARTITION_FULL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UnprocessableExceptionReason> VALUE_MAP;
    private final String value;

    private UnprocessableExceptionReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UnprocessableExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UnprocessableExceptionReason> knownValues() {
        EnumSet<UnprocessableExceptionReason> knownValues = EnumSet.allOf(UnprocessableExceptionReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UnprocessableExceptionReason.class, UnprocessableExceptionReason::toString);
    }
}

