/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.QueryState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetQueryResponse
extends NeptuneGraphResponse
implements ToCopyableBuilder<Builder, GetQueryResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetQueryResponse.getter(GetQueryResponse::id)).setter(GetQueryResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryString").getter(GetQueryResponse.getter(GetQueryResponse::queryString)).setter(GetQueryResponse.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()}).build();
    private static final SdkField<Integer> WAITED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("waited").getter(GetQueryResponse.getter(GetQueryResponse::waited)).setter(GetQueryResponse.setter(Builder::waited)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waited").build()}).build();
    private static final SdkField<Integer> ELAPSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("elapsed").getter(GetQueryResponse.getter(GetQueryResponse::elapsed)).setter(GetQueryResponse.setter(Builder::elapsed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elapsed").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(GetQueryResponse.getter(GetQueryResponse::stateAsString)).setter(GetQueryResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, QUERY_STRING_FIELD, WAITED_FIELD, ELAPSED_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetQueryResponse.memberNameToFieldInitializer();
    private final String id;
    private final String queryString;
    private final Integer waited;
    private final Integer elapsed;
    private final String state;

    private GetQueryResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.queryString = builder.queryString;
        this.waited = builder.waited;
        this.elapsed = builder.elapsed;
        this.state = builder.state;
    }

    public final String id() {
        return this.id;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final Integer waited() {
        return this.waited;
    }

    public final Integer elapsed() {
        return this.elapsed;
    }

    public final QueryState state() {
        return QueryState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.waited());
        hashCode = 31 * hashCode + Objects.hashCode(this.elapsed());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueryResponse)) {
            return false;
        }
        GetQueryResponse other = (GetQueryResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.waited(), other.waited()) && Objects.equals(this.elapsed(), other.elapsed()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetQueryResponse").add("Id", (Object)this.id()).add("QueryString", (Object)this.queryString()).add("Waited", (Object)this.waited()).add("Elapsed", (Object)this.elapsed()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "queryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "waited": {
                return Optional.ofNullable(clazz.cast(this.waited()));
            }
            case "elapsed": {
                return Optional.ofNullable(clazz.cast(this.elapsed()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("queryString", QUERY_STRING_FIELD);
        map.put("waited", WAITED_FIELD);
        map.put("elapsed", ELAPSED_FIELD);
        map.put("state", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetQueryResponse, T> g) {
        return obj -> g.apply((GetQueryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneGraphResponse.BuilderImpl
    implements Builder {
        private String id;
        private String queryString;
        private Integer waited;
        private Integer elapsed;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueryResponse model) {
            super(model);
            this.id(model.id);
            this.queryString(model.queryString);
            this.waited(model.waited);
            this.elapsed(model.elapsed);
            this.state(model.state);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final Integer getWaited() {
            return this.waited;
        }

        public final void setWaited(Integer waited) {
            this.waited = waited;
        }

        @Override
        public final Builder waited(Integer waited) {
            this.waited = waited;
            return this;
        }

        public final Integer getElapsed() {
            return this.elapsed;
        }

        public final void setElapsed(Integer elapsed) {
            this.elapsed = elapsed;
        }

        @Override
        public final Builder elapsed(Integer elapsed) {
            this.elapsed = elapsed;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(QueryState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public GetQueryResponse build() {
            return new GetQueryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NeptuneGraphResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetQueryResponse> {
        public Builder id(String var1);

        public Builder queryString(String var1);

        public Builder waited(Integer var1);

        public Builder elapsed(Integer var1);

        public Builder state(String var1);

        public Builder state(QueryState var1);
    }
}

