/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.TagMapCopier;
import software.amazon.awssdk.services.neptunegraph.model.VectorSearchConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGraphRequest
extends NeptuneGraphRequest
implements ToCopyableBuilder<Builder, CreateGraphRequest> {
    private static final SdkField<String> GRAPH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("graphName").getter(CreateGraphRequest.getter(CreateGraphRequest::graphName)).setter(CreateGraphRequest.setter(Builder::graphName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphName").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateGraphRequest.getter(CreateGraphRequest::tags)).setter(CreateGraphRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PUBLIC_CONNECTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("publicConnectivity").getter(CreateGraphRequest.getter(CreateGraphRequest::publicConnectivity)).setter(CreateGraphRequest.setter(Builder::publicConnectivity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicConnectivity").build()}).build();
    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyIdentifier").getter(CreateGraphRequest.getter(CreateGraphRequest::kmsKeyIdentifier)).setter(CreateGraphRequest.setter(Builder::kmsKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyIdentifier").build()}).build();
    private static final SdkField<VectorSearchConfiguration> VECTOR_SEARCH_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vectorSearchConfiguration").getter(CreateGraphRequest.getter(CreateGraphRequest::vectorSearchConfiguration)).setter(CreateGraphRequest.setter(Builder::vectorSearchConfiguration)).constructor(VectorSearchConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorSearchConfiguration").build()}).build();
    private static final SdkField<Integer> REPLICA_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("replicaCount").getter(CreateGraphRequest.getter(CreateGraphRequest::replicaCount)).setter(CreateGraphRequest.setter(Builder::replicaCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicaCount").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("deletionProtection").getter(CreateGraphRequest.getter(CreateGraphRequest::deletionProtection)).setter(CreateGraphRequest.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionProtection").build()}).build();
    private static final SdkField<Integer> PROVISIONED_MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("provisionedMemory").getter(CreateGraphRequest.getter(CreateGraphRequest::provisionedMemory)).setter(CreateGraphRequest.setter(Builder::provisionedMemory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedMemory").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_NAME_FIELD, TAGS_FIELD, PUBLIC_CONNECTIVITY_FIELD, KMS_KEY_IDENTIFIER_FIELD, VECTOR_SEARCH_CONFIGURATION_FIELD, REPLICA_COUNT_FIELD, DELETION_PROTECTION_FIELD, PROVISIONED_MEMORY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateGraphRequest.memberNameToFieldInitializer();
    private final String graphName;
    private final Map<String, String> tags;
    private final Boolean publicConnectivity;
    private final String kmsKeyIdentifier;
    private final VectorSearchConfiguration vectorSearchConfiguration;
    private final Integer replicaCount;
    private final Boolean deletionProtection;
    private final Integer provisionedMemory;

    private CreateGraphRequest(BuilderImpl builder) {
        super(builder);
        this.graphName = builder.graphName;
        this.tags = builder.tags;
        this.publicConnectivity = builder.publicConnectivity;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.vectorSearchConfiguration = builder.vectorSearchConfiguration;
        this.replicaCount = builder.replicaCount;
        this.deletionProtection = builder.deletionProtection;
        this.provisionedMemory = builder.provisionedMemory;
    }

    public final String graphName() {
        return this.graphName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Boolean publicConnectivity() {
        return this.publicConnectivity;
    }

    public final String kmsKeyIdentifier() {
        return this.kmsKeyIdentifier;
    }

    public final VectorSearchConfiguration vectorSearchConfiguration() {
        return this.vectorSearchConfiguration;
    }

    public final Integer replicaCount() {
        return this.replicaCount;
    }

    public final Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public final Integer provisionedMemory() {
        return this.provisionedMemory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.graphName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.publicConnectivity());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.vectorSearchConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedMemory());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGraphRequest)) {
            return false;
        }
        CreateGraphRequest other = (CreateGraphRequest)((Object)obj);
        return Objects.equals(this.graphName(), other.graphName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.publicConnectivity(), other.publicConnectivity()) && Objects.equals(this.kmsKeyIdentifier(), other.kmsKeyIdentifier()) && Objects.equals(this.vectorSearchConfiguration(), other.vectorSearchConfiguration()) && Objects.equals(this.replicaCount(), other.replicaCount()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && Objects.equals(this.provisionedMemory(), other.provisionedMemory());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGraphRequest").add("GraphName", (Object)this.graphName()).add("Tags", this.hasTags() ? this.tags() : null).add("PublicConnectivity", (Object)this.publicConnectivity()).add("KmsKeyIdentifier", (Object)this.kmsKeyIdentifier()).add("VectorSearchConfiguration", (Object)this.vectorSearchConfiguration()).add("ReplicaCount", (Object)this.replicaCount()).add("DeletionProtection", (Object)this.deletionProtection()).add("ProvisionedMemory", (Object)this.provisionedMemory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "graphName": {
                return Optional.ofNullable(clazz.cast(this.graphName()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "publicConnectivity": {
                return Optional.ofNullable(clazz.cast(this.publicConnectivity()));
            }
            case "kmsKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyIdentifier()));
            }
            case "vectorSearchConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vectorSearchConfiguration()));
            }
            case "replicaCount": {
                return Optional.ofNullable(clazz.cast(this.replicaCount()));
            }
            case "deletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "provisionedMemory": {
                return Optional.ofNullable(clazz.cast(this.provisionedMemory()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("graphName", GRAPH_NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("publicConnectivity", PUBLIC_CONNECTIVITY_FIELD);
        map.put("kmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        map.put("vectorSearchConfiguration", VECTOR_SEARCH_CONFIGURATION_FIELD);
        map.put("replicaCount", REPLICA_COUNT_FIELD);
        map.put("deletionProtection", DELETION_PROTECTION_FIELD);
        map.put("provisionedMemory", PROVISIONED_MEMORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGraphRequest, T> g) {
        return obj -> g.apply((CreateGraphRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneGraphRequest.BuilderImpl
    implements Builder {
        private String graphName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Boolean publicConnectivity;
        private String kmsKeyIdentifier;
        private VectorSearchConfiguration vectorSearchConfiguration;
        private Integer replicaCount;
        private Boolean deletionProtection;
        private Integer provisionedMemory;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGraphRequest model) {
            super(model);
            this.graphName(model.graphName);
            this.tags(model.tags);
            this.publicConnectivity(model.publicConnectivity);
            this.kmsKeyIdentifier(model.kmsKeyIdentifier);
            this.vectorSearchConfiguration(model.vectorSearchConfiguration);
            this.replicaCount(model.replicaCount);
            this.deletionProtection(model.deletionProtection);
            this.provisionedMemory(model.provisionedMemory);
        }

        public final String getGraphName() {
            return this.graphName;
        }

        public final void setGraphName(String graphName) {
            this.graphName = graphName;
        }

        @Override
        public final Builder graphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Boolean getPublicConnectivity() {
            return this.publicConnectivity;
        }

        public final void setPublicConnectivity(Boolean publicConnectivity) {
            this.publicConnectivity = publicConnectivity;
        }

        @Override
        public final Builder publicConnectivity(Boolean publicConnectivity) {
            this.publicConnectivity = publicConnectivity;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return this.kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final VectorSearchConfiguration.Builder getVectorSearchConfiguration() {
            return this.vectorSearchConfiguration != null ? this.vectorSearchConfiguration.toBuilder() : null;
        }

        public final void setVectorSearchConfiguration(VectorSearchConfiguration.BuilderImpl vectorSearchConfiguration) {
            this.vectorSearchConfiguration = vectorSearchConfiguration != null ? vectorSearchConfiguration.build() : null;
        }

        @Override
        public final Builder vectorSearchConfiguration(VectorSearchConfiguration vectorSearchConfiguration) {
            this.vectorSearchConfiguration = vectorSearchConfiguration;
            return this;
        }

        public final Integer getReplicaCount() {
            return this.replicaCount;
        }

        public final void setReplicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
        }

        @Override
        public final Builder replicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final Integer getProvisionedMemory() {
            return this.provisionedMemory;
        }

        public final void setProvisionedMemory(Integer provisionedMemory) {
            this.provisionedMemory = provisionedMemory;
        }

        @Override
        public final Builder provisionedMemory(Integer provisionedMemory) {
            this.provisionedMemory = provisionedMemory;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGraphRequest build() {
            return new CreateGraphRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NeptuneGraphRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGraphRequest> {
        public Builder graphName(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder publicConnectivity(Boolean var1);

        public Builder kmsKeyIdentifier(String var1);

        public Builder vectorSearchConfiguration(VectorSearchConfiguration var1);

        default public Builder vectorSearchConfiguration(Consumer<VectorSearchConfiguration.Builder> vectorSearchConfiguration) {
            return this.vectorSearchConfiguration((VectorSearchConfiguration)((VectorSearchConfiguration.Builder)VectorSearchConfiguration.builder().applyMutation(vectorSearchConfiguration)).build());
        }

        public Builder replicaCount(Integer var1);

        public Builder deletionProtection(Boolean var1);

        public Builder provisionedMemory(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

