/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.neptunegraph.model.ExportFilterElement;
import software.amazon.awssdk.services.neptunegraph.model.ExportFilterPerLabelMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportFilter> {
    private static final SdkField<Map<String, ExportFilterElement>> VERTEX_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("vertexFilter").getter(ExportFilter.getter(ExportFilter::vertexFilter)).setter(ExportFilter.setter(Builder::vertexFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vertexFilter").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExportFilterElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ExportFilterElement>> EDGE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("edgeFilter").getter(ExportFilter.getter(ExportFilter::edgeFilter)).setter(ExportFilter.setter(Builder::edgeFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("edgeFilter").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExportFilterElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERTEX_FILTER_FIELD, EDGE_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, ExportFilterElement> vertexFilter;
    private final Map<String, ExportFilterElement> edgeFilter;

    private ExportFilter(BuilderImpl builder) {
        this.vertexFilter = builder.vertexFilter;
        this.edgeFilter = builder.edgeFilter;
    }

    public final boolean hasVertexFilter() {
        return this.vertexFilter != null && !(this.vertexFilter instanceof SdkAutoConstructMap);
    }

    public final Map<String, ExportFilterElement> vertexFilter() {
        return this.vertexFilter;
    }

    public final boolean hasEdgeFilter() {
        return this.edgeFilter != null && !(this.edgeFilter instanceof SdkAutoConstructMap);
    }

    public final Map<String, ExportFilterElement> edgeFilter() {
        return this.edgeFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVertexFilter() ? this.vertexFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEdgeFilter() ? this.edgeFilter() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportFilter)) {
            return false;
        }
        ExportFilter other = (ExportFilter)obj;
        return this.hasVertexFilter() == other.hasVertexFilter() && Objects.equals(this.vertexFilter(), other.vertexFilter()) && this.hasEdgeFilter() == other.hasEdgeFilter() && Objects.equals(this.edgeFilter(), other.edgeFilter());
    }

    public final String toString() {
        return ToString.builder((String)"ExportFilter").add("VertexFilter", this.hasVertexFilter() ? this.vertexFilter() : null).add("EdgeFilter", this.hasEdgeFilter() ? this.edgeFilter() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vertexFilter": {
                return Optional.ofNullable(clazz.cast(this.vertexFilter()));
            }
            case "edgeFilter": {
                return Optional.ofNullable(clazz.cast(this.edgeFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Map<String, ExportFilterElement>>> map = new HashMap<String, SdkField<Map<String, ExportFilterElement>>>();
        map.put("vertexFilter", VERTEX_FILTER_FIELD);
        map.put("edgeFilter", EDGE_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportFilter, T> g) {
        return obj -> g.apply((ExportFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, ExportFilterElement> vertexFilter = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, ExportFilterElement> edgeFilter = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExportFilter model) {
            this.vertexFilter(model.vertexFilter);
            this.edgeFilter(model.edgeFilter);
        }

        public final Map<String, ExportFilterElement.Builder> getVertexFilter() {
            Map<String, ExportFilterElement.Builder> result = ExportFilterPerLabelMapCopier.copyToBuilder(this.vertexFilter);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setVertexFilter(Map<String, ExportFilterElement.BuilderImpl> vertexFilter) {
            this.vertexFilter = ExportFilterPerLabelMapCopier.copyFromBuilder(vertexFilter);
        }

        @Override
        public final Builder vertexFilter(Map<String, ExportFilterElement> vertexFilter) {
            this.vertexFilter = ExportFilterPerLabelMapCopier.copy(vertexFilter);
            return this;
        }

        public final Map<String, ExportFilterElement.Builder> getEdgeFilter() {
            Map<String, ExportFilterElement.Builder> result = ExportFilterPerLabelMapCopier.copyToBuilder(this.edgeFilter);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setEdgeFilter(Map<String, ExportFilterElement.BuilderImpl> edgeFilter) {
            this.edgeFilter = ExportFilterPerLabelMapCopier.copyFromBuilder(edgeFilter);
        }

        @Override
        public final Builder edgeFilter(Map<String, ExportFilterElement> edgeFilter) {
            this.edgeFilter = ExportFilterPerLabelMapCopier.copy(edgeFilter);
            return this;
        }

        public ExportFilter build() {
            return new ExportFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportFilter> {
        public Builder vertexFilter(Map<String, ExportFilterElement> var1);

        public Builder edgeFilter(Map<String, ExportFilterElement> var1);
    }
}

