/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunegraph.model.GraphStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GraphSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GraphSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GraphSummary.getter(GraphSummary::id)).setter(GraphSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GraphSummary.getter(GraphSummary::name)).setter(GraphSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GraphSummary.getter(GraphSummary::arn)).setter(GraphSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GraphSummary.getter(GraphSummary::statusAsString)).setter(GraphSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Integer> PROVISIONED_MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("provisionedMemory").getter(GraphSummary.getter(GraphSummary::provisionedMemory)).setter(GraphSummary.setter(Builder::provisionedMemory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedMemory").build()}).build();
    private static final SdkField<Boolean> PUBLIC_CONNECTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("publicConnectivity").getter(GraphSummary.getter(GraphSummary::publicConnectivity)).setter(GraphSummary.setter(Builder::publicConnectivity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicConnectivity").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpoint").getter(GraphSummary.getter(GraphSummary::endpoint)).setter(GraphSummary.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<Integer> REPLICA_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("replicaCount").getter(GraphSummary.getter(GraphSummary::replicaCount)).setter(GraphSummary.setter(Builder::replicaCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicaCount").build()}).build();
    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyIdentifier").getter(GraphSummary.getter(GraphSummary::kmsKeyIdentifier)).setter(GraphSummary.setter(Builder::kmsKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyIdentifier").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("deletionProtection").getter(GraphSummary.getter(GraphSummary::deletionProtection)).setter(GraphSummary.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionProtection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, ARN_FIELD, STATUS_FIELD, PROVISIONED_MEMORY_FIELD, PUBLIC_CONNECTIVITY_FIELD, ENDPOINT_FIELD, REPLICA_COUNT_FIELD, KMS_KEY_IDENTIFIER_FIELD, DELETION_PROTECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GraphSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String arn;
    private final String status;
    private final Integer provisionedMemory;
    private final Boolean publicConnectivity;
    private final String endpoint;
    private final Integer replicaCount;
    private final String kmsKeyIdentifier;
    private final Boolean deletionProtection;

    private GraphSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.status = builder.status;
        this.provisionedMemory = builder.provisionedMemory;
        this.publicConnectivity = builder.publicConnectivity;
        this.endpoint = builder.endpoint;
        this.replicaCount = builder.replicaCount;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.deletionProtection = builder.deletionProtection;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final GraphStatus status() {
        return GraphStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer provisionedMemory() {
        return this.provisionedMemory;
    }

    public final Boolean publicConnectivity() {
        return this.publicConnectivity;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final Integer replicaCount() {
        return this.replicaCount;
    }

    public final String kmsKeyIdentifier() {
        return this.kmsKeyIdentifier;
    }

    public final Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedMemory());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicConnectivity());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GraphSummary)) {
            return false;
        }
        GraphSummary other = (GraphSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.provisionedMemory(), other.provisionedMemory()) && Objects.equals(this.publicConnectivity(), other.publicConnectivity()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.replicaCount(), other.replicaCount()) && Objects.equals(this.kmsKeyIdentifier(), other.kmsKeyIdentifier()) && Objects.equals(this.deletionProtection(), other.deletionProtection());
    }

    public final String toString() {
        return ToString.builder((String)"GraphSummary").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("ProvisionedMemory", (Object)this.provisionedMemory()).add("PublicConnectivity", (Object)this.publicConnectivity()).add("Endpoint", (Object)this.endpoint()).add("ReplicaCount", (Object)this.replicaCount()).add("KmsKeyIdentifier", (Object)this.kmsKeyIdentifier()).add("DeletionProtection", (Object)this.deletionProtection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "provisionedMemory": {
                return Optional.ofNullable(clazz.cast(this.provisionedMemory()));
            }
            case "publicConnectivity": {
                return Optional.ofNullable(clazz.cast(this.publicConnectivity()));
            }
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "replicaCount": {
                return Optional.ofNullable(clazz.cast(this.replicaCount()));
            }
            case "kmsKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyIdentifier()));
            }
            case "deletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("provisionedMemory", PROVISIONED_MEMORY_FIELD);
        map.put("publicConnectivity", PUBLIC_CONNECTIVITY_FIELD);
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("replicaCount", REPLICA_COUNT_FIELD);
        map.put("kmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        map.put("deletionProtection", DELETION_PROTECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GraphSummary, T> g) {
        return obj -> g.apply((GraphSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String arn;
        private String status;
        private Integer provisionedMemory;
        private Boolean publicConnectivity;
        private String endpoint;
        private Integer replicaCount;
        private String kmsKeyIdentifier;
        private Boolean deletionProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(GraphSummary model) {
            this.id(model.id);
            this.name(model.name);
            this.arn(model.arn);
            this.status(model.status);
            this.provisionedMemory(model.provisionedMemory);
            this.publicConnectivity(model.publicConnectivity);
            this.endpoint(model.endpoint);
            this.replicaCount(model.replicaCount);
            this.kmsKeyIdentifier(model.kmsKeyIdentifier);
            this.deletionProtection(model.deletionProtection);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GraphStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getProvisionedMemory() {
            return this.provisionedMemory;
        }

        public final void setProvisionedMemory(Integer provisionedMemory) {
            this.provisionedMemory = provisionedMemory;
        }

        @Override
        public final Builder provisionedMemory(Integer provisionedMemory) {
            this.provisionedMemory = provisionedMemory;
            return this;
        }

        public final Boolean getPublicConnectivity() {
            return this.publicConnectivity;
        }

        public final void setPublicConnectivity(Boolean publicConnectivity) {
            this.publicConnectivity = publicConnectivity;
        }

        @Override
        public final Builder publicConnectivity(Boolean publicConnectivity) {
            this.publicConnectivity = publicConnectivity;
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Integer getReplicaCount() {
            return this.replicaCount;
        }

        public final void setReplicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
        }

        @Override
        public final Builder replicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return this.kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public GraphSummary build() {
            return new GraphSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GraphSummary> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(GraphStatus var1);

        public Builder provisionedMemory(Integer var1);

        public Builder publicConnectivity(Boolean var1);

        public Builder endpoint(String var1);

        public Builder replicaCount(Integer var1);

        public Builder kmsKeyIdentifier(String var1);

        public Builder deletionProtection(Boolean var1);
    }
}

