/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.neptunegraph.NeptuneGraphAsyncClient;
import software.amazon.awssdk.services.neptunegraph.internal.UserAgentUtils;
import software.amazon.awssdk.services.neptunegraph.model.GraphSummary;
import software.amazon.awssdk.services.neptunegraph.model.ListGraphsRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListGraphsResponse;

public class ListGraphsPublisher
implements SdkPublisher<ListGraphsResponse> {
    private final NeptuneGraphAsyncClient client;
    private final ListGraphsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGraphsPublisher(NeptuneGraphAsyncClient client, ListGraphsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGraphsPublisher(NeptuneGraphAsyncClient client, ListGraphsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGraphsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGraphsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GraphSummary> graphs() {
        Function<ListGraphsResponse, Iterator> getIterator = response -> {
            if (response != null && response.graphs() != null) {
                return response.graphs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGraphsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGraphsResponseFetcher
    implements AsyncPageFetcher<ListGraphsResponse> {
        private ListGraphsResponseFetcher() {
        }

        public boolean hasNextPage(ListGraphsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGraphsResponse> nextPage(ListGraphsResponse previousPage) {
            if (previousPage == null) {
                return ListGraphsPublisher.this.client.listGraphs(ListGraphsPublisher.this.firstRequest);
            }
            return ListGraphsPublisher.this.client.listGraphs((ListGraphsRequest)((Object)ListGraphsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

