/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.neptunegraph.NeptuneGraphClient;
import software.amazon.awssdk.services.neptunegraph.internal.UserAgentUtils;
import software.amazon.awssdk.services.neptunegraph.model.GraphSummary;
import software.amazon.awssdk.services.neptunegraph.model.ListGraphsRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListGraphsResponse;

public class ListGraphsIterable
implements SdkIterable<ListGraphsResponse> {
    private final NeptuneGraphClient client;
    private final ListGraphsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGraphsIterable(NeptuneGraphClient client, ListGraphsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGraphsResponseFetcher();
    }

    public Iterator<ListGraphsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GraphSummary> graphs() {
        Function<ListGraphsResponse, Iterator> getIterator = response -> {
            if (response != null && response.graphs() != null) {
                return response.graphs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGraphsResponseFetcher
    implements SyncPageFetcher<ListGraphsResponse> {
        private ListGraphsResponseFetcher() {
        }

        public boolean hasNextPage(ListGraphsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGraphsResponse nextPage(ListGraphsResponse previousPage) {
            if (previousPage == null) {
                return ListGraphsIterable.this.client.listGraphs(ListGraphsIterable.this.firstRequest);
            }
            return ListGraphsIterable.this.client.listGraphs((ListGraphsRequest)((Object)ListGraphsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

