/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptunegraph.model.EdgeLabelsCopier;
import software.amazon.awssdk.services.neptunegraph.model.EdgeStructure;
import software.amazon.awssdk.services.neptunegraph.model.EdgeStructuresCopier;
import software.amazon.awssdk.services.neptunegraph.model.LongValuedMapListCopier;
import software.amazon.awssdk.services.neptunegraph.model.NodeLabelsCopier;
import software.amazon.awssdk.services.neptunegraph.model.NodeStructure;
import software.amazon.awssdk.services.neptunegraph.model.NodeStructuresCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GraphDataSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GraphDataSummary> {
    private static final SdkField<Long> NUM_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numNodes").getter(GraphDataSummary.getter(GraphDataSummary::numNodes)).setter(GraphDataSummary.setter(Builder::numNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numNodes").build()}).build();
    private static final SdkField<Long> NUM_EDGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numEdges").getter(GraphDataSummary.getter(GraphDataSummary::numEdges)).setter(GraphDataSummary.setter(Builder::numEdges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numEdges").build()}).build();
    private static final SdkField<Long> NUM_NODE_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numNodeLabels").getter(GraphDataSummary.getter(GraphDataSummary::numNodeLabels)).setter(GraphDataSummary.setter(Builder::numNodeLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numNodeLabels").build()}).build();
    private static final SdkField<Long> NUM_EDGE_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numEdgeLabels").getter(GraphDataSummary.getter(GraphDataSummary::numEdgeLabels)).setter(GraphDataSummary.setter(Builder::numEdgeLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numEdgeLabels").build()}).build();
    private static final SdkField<List<String>> NODE_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("nodeLabels").getter(GraphDataSummary.getter(GraphDataSummary::nodeLabels)).setter(GraphDataSummary.setter(Builder::nodeLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeLabels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EDGE_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("edgeLabels").getter(GraphDataSummary.getter(GraphDataSummary::edgeLabels)).setter(GraphDataSummary.setter(Builder::edgeLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("edgeLabels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> NUM_NODE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numNodeProperties").getter(GraphDataSummary.getter(GraphDataSummary::numNodeProperties)).setter(GraphDataSummary.setter(Builder::numNodeProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numNodeProperties").build()}).build();
    private static final SdkField<Long> NUM_EDGE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numEdgeProperties").getter(GraphDataSummary.getter(GraphDataSummary::numEdgeProperties)).setter(GraphDataSummary.setter(Builder::numEdgeProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numEdgeProperties").build()}).build();
    private static final SdkField<List<Map<String, Long>>> NODE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("nodeProperties").getter(GraphDataSummary.getter(GraphDataSummary::nodeProperties)).setter(GraphDataSummary.setter(Builder::nodeProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<Map<String, Long>>> EDGE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("edgeProperties").getter(GraphDataSummary.getter(GraphDataSummary::edgeProperties)).setter(GraphDataSummary.setter(Builder::edgeProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("edgeProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Long> TOTAL_NODE_PROPERTY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalNodePropertyValues").getter(GraphDataSummary.getter(GraphDataSummary::totalNodePropertyValues)).setter(GraphDataSummary.setter(Builder::totalNodePropertyValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalNodePropertyValues").build()}).build();
    private static final SdkField<Long> TOTAL_EDGE_PROPERTY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalEdgePropertyValues").getter(GraphDataSummary.getter(GraphDataSummary::totalEdgePropertyValues)).setter(GraphDataSummary.setter(Builder::totalEdgePropertyValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalEdgePropertyValues").build()}).build();
    private static final SdkField<List<NodeStructure>> NODE_STRUCTURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("nodeStructures").getter(GraphDataSummary.getter(GraphDataSummary::nodeStructures)).setter(GraphDataSummary.setter(Builder::nodeStructures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeStructures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeStructure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EdgeStructure>> EDGE_STRUCTURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("edgeStructures").getter(GraphDataSummary.getter(GraphDataSummary::edgeStructures)).setter(GraphDataSummary.setter(Builder::edgeStructures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("edgeStructures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EdgeStructure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUM_NODES_FIELD, NUM_EDGES_FIELD, NUM_NODE_LABELS_FIELD, NUM_EDGE_LABELS_FIELD, NODE_LABELS_FIELD, EDGE_LABELS_FIELD, NUM_NODE_PROPERTIES_FIELD, NUM_EDGE_PROPERTIES_FIELD, NODE_PROPERTIES_FIELD, EDGE_PROPERTIES_FIELD, TOTAL_NODE_PROPERTY_VALUES_FIELD, TOTAL_EDGE_PROPERTY_VALUES_FIELD, NODE_STRUCTURES_FIELD, EDGE_STRUCTURES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GraphDataSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long numNodes;
    private final Long numEdges;
    private final Long numNodeLabels;
    private final Long numEdgeLabels;
    private final List<String> nodeLabels;
    private final List<String> edgeLabels;
    private final Long numNodeProperties;
    private final Long numEdgeProperties;
    private final List<Map<String, Long>> nodeProperties;
    private final List<Map<String, Long>> edgeProperties;
    private final Long totalNodePropertyValues;
    private final Long totalEdgePropertyValues;
    private final List<NodeStructure> nodeStructures;
    private final List<EdgeStructure> edgeStructures;

    private GraphDataSummary(BuilderImpl builder) {
        this.numNodes = builder.numNodes;
        this.numEdges = builder.numEdges;
        this.numNodeLabels = builder.numNodeLabels;
        this.numEdgeLabels = builder.numEdgeLabels;
        this.nodeLabels = builder.nodeLabels;
        this.edgeLabels = builder.edgeLabels;
        this.numNodeProperties = builder.numNodeProperties;
        this.numEdgeProperties = builder.numEdgeProperties;
        this.nodeProperties = builder.nodeProperties;
        this.edgeProperties = builder.edgeProperties;
        this.totalNodePropertyValues = builder.totalNodePropertyValues;
        this.totalEdgePropertyValues = builder.totalEdgePropertyValues;
        this.nodeStructures = builder.nodeStructures;
        this.edgeStructures = builder.edgeStructures;
    }

    public final Long numNodes() {
        return this.numNodes;
    }

    public final Long numEdges() {
        return this.numEdges;
    }

    public final Long numNodeLabels() {
        return this.numNodeLabels;
    }

    public final Long numEdgeLabels() {
        return this.numEdgeLabels;
    }

    public final boolean hasNodeLabels() {
        return this.nodeLabels != null && !(this.nodeLabels instanceof SdkAutoConstructList);
    }

    public final List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public final boolean hasEdgeLabels() {
        return this.edgeLabels != null && !(this.edgeLabels instanceof SdkAutoConstructList);
    }

    public final List<String> edgeLabels() {
        return this.edgeLabels;
    }

    public final Long numNodeProperties() {
        return this.numNodeProperties;
    }

    public final Long numEdgeProperties() {
        return this.numEdgeProperties;
    }

    public final boolean hasNodeProperties() {
        return this.nodeProperties != null && !(this.nodeProperties instanceof SdkAutoConstructList);
    }

    public final List<Map<String, Long>> nodeProperties() {
        return this.nodeProperties;
    }

    public final boolean hasEdgeProperties() {
        return this.edgeProperties != null && !(this.edgeProperties instanceof SdkAutoConstructList);
    }

    public final List<Map<String, Long>> edgeProperties() {
        return this.edgeProperties;
    }

    public final Long totalNodePropertyValues() {
        return this.totalNodePropertyValues;
    }

    public final Long totalEdgePropertyValues() {
        return this.totalEdgePropertyValues;
    }

    public final boolean hasNodeStructures() {
        return this.nodeStructures != null && !(this.nodeStructures instanceof SdkAutoConstructList);
    }

    public final List<NodeStructure> nodeStructures() {
        return this.nodeStructures;
    }

    public final boolean hasEdgeStructures() {
        return this.edgeStructures != null && !(this.edgeStructures instanceof SdkAutoConstructList);
    }

    public final List<EdgeStructure> edgeStructures() {
        return this.edgeStructures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.numEdges());
        hashCode = 31 * hashCode + Objects.hashCode(this.numNodeLabels());
        hashCode = 31 * hashCode + Objects.hashCode(this.numEdgeLabels());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodeLabels() ? this.nodeLabels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEdgeLabels() ? this.edgeLabels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.numNodeProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.numEdgeProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodeProperties() ? this.nodeProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEdgeProperties() ? this.edgeProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalNodePropertyValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalEdgePropertyValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodeStructures() ? this.nodeStructures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEdgeStructures() ? this.edgeStructures() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GraphDataSummary)) {
            return false;
        }
        GraphDataSummary other = (GraphDataSummary)obj;
        return Objects.equals(this.numNodes(), other.numNodes()) && Objects.equals(this.numEdges(), other.numEdges()) && Objects.equals(this.numNodeLabels(), other.numNodeLabels()) && Objects.equals(this.numEdgeLabels(), other.numEdgeLabels()) && this.hasNodeLabels() == other.hasNodeLabels() && Objects.equals(this.nodeLabels(), other.nodeLabels()) && this.hasEdgeLabels() == other.hasEdgeLabels() && Objects.equals(this.edgeLabels(), other.edgeLabels()) && Objects.equals(this.numNodeProperties(), other.numNodeProperties()) && Objects.equals(this.numEdgeProperties(), other.numEdgeProperties()) && this.hasNodeProperties() == other.hasNodeProperties() && Objects.equals(this.nodeProperties(), other.nodeProperties()) && this.hasEdgeProperties() == other.hasEdgeProperties() && Objects.equals(this.edgeProperties(), other.edgeProperties()) && Objects.equals(this.totalNodePropertyValues(), other.totalNodePropertyValues()) && Objects.equals(this.totalEdgePropertyValues(), other.totalEdgePropertyValues()) && this.hasNodeStructures() == other.hasNodeStructures() && Objects.equals(this.nodeStructures(), other.nodeStructures()) && this.hasEdgeStructures() == other.hasEdgeStructures() && Objects.equals(this.edgeStructures(), other.edgeStructures());
    }

    public final String toString() {
        return ToString.builder((String)"GraphDataSummary").add("NumNodes", (Object)this.numNodes()).add("NumEdges", (Object)this.numEdges()).add("NumNodeLabels", (Object)this.numNodeLabels()).add("NumEdgeLabels", (Object)this.numEdgeLabels()).add("NodeLabels", this.hasNodeLabels() ? this.nodeLabels() : null).add("EdgeLabels", this.hasEdgeLabels() ? this.edgeLabels() : null).add("NumNodeProperties", (Object)this.numNodeProperties()).add("NumEdgeProperties", (Object)this.numEdgeProperties()).add("NodeProperties", this.hasNodeProperties() ? this.nodeProperties() : null).add("EdgeProperties", this.hasEdgeProperties() ? this.edgeProperties() : null).add("TotalNodePropertyValues", (Object)this.totalNodePropertyValues()).add("TotalEdgePropertyValues", (Object)this.totalEdgePropertyValues()).add("NodeStructures", this.hasNodeStructures() ? this.nodeStructures() : null).add("EdgeStructures", this.hasEdgeStructures() ? this.edgeStructures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "numNodes": {
                return Optional.ofNullable(clazz.cast(this.numNodes()));
            }
            case "numEdges": {
                return Optional.ofNullable(clazz.cast(this.numEdges()));
            }
            case "numNodeLabels": {
                return Optional.ofNullable(clazz.cast(this.numNodeLabels()));
            }
            case "numEdgeLabels": {
                return Optional.ofNullable(clazz.cast(this.numEdgeLabels()));
            }
            case "nodeLabels": {
                return Optional.ofNullable(clazz.cast(this.nodeLabels()));
            }
            case "edgeLabels": {
                return Optional.ofNullable(clazz.cast(this.edgeLabels()));
            }
            case "numNodeProperties": {
                return Optional.ofNullable(clazz.cast(this.numNodeProperties()));
            }
            case "numEdgeProperties": {
                return Optional.ofNullable(clazz.cast(this.numEdgeProperties()));
            }
            case "nodeProperties": {
                return Optional.ofNullable(clazz.cast(this.nodeProperties()));
            }
            case "edgeProperties": {
                return Optional.ofNullable(clazz.cast(this.edgeProperties()));
            }
            case "totalNodePropertyValues": {
                return Optional.ofNullable(clazz.cast(this.totalNodePropertyValues()));
            }
            case "totalEdgePropertyValues": {
                return Optional.ofNullable(clazz.cast(this.totalEdgePropertyValues()));
            }
            case "nodeStructures": {
                return Optional.ofNullable(clazz.cast(this.nodeStructures()));
            }
            case "edgeStructures": {
                return Optional.ofNullable(clazz.cast(this.edgeStructures()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("numNodes", NUM_NODES_FIELD);
        map.put("numEdges", NUM_EDGES_FIELD);
        map.put("numNodeLabels", NUM_NODE_LABELS_FIELD);
        map.put("numEdgeLabels", NUM_EDGE_LABELS_FIELD);
        map.put("nodeLabels", NODE_LABELS_FIELD);
        map.put("edgeLabels", EDGE_LABELS_FIELD);
        map.put("numNodeProperties", NUM_NODE_PROPERTIES_FIELD);
        map.put("numEdgeProperties", NUM_EDGE_PROPERTIES_FIELD);
        map.put("nodeProperties", NODE_PROPERTIES_FIELD);
        map.put("edgeProperties", EDGE_PROPERTIES_FIELD);
        map.put("totalNodePropertyValues", TOTAL_NODE_PROPERTY_VALUES_FIELD);
        map.put("totalEdgePropertyValues", TOTAL_EDGE_PROPERTY_VALUES_FIELD);
        map.put("nodeStructures", NODE_STRUCTURES_FIELD);
        map.put("edgeStructures", EDGE_STRUCTURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GraphDataSummary, T> g) {
        return obj -> g.apply((GraphDataSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long numNodes;
        private Long numEdges;
        private Long numNodeLabels;
        private Long numEdgeLabels;
        private List<String> nodeLabels = DefaultSdkAutoConstructList.getInstance();
        private List<String> edgeLabels = DefaultSdkAutoConstructList.getInstance();
        private Long numNodeProperties;
        private Long numEdgeProperties;
        private List<Map<String, Long>> nodeProperties = DefaultSdkAutoConstructList.getInstance();
        private List<Map<String, Long>> edgeProperties = DefaultSdkAutoConstructList.getInstance();
        private Long totalNodePropertyValues;
        private Long totalEdgePropertyValues;
        private List<NodeStructure> nodeStructures = DefaultSdkAutoConstructList.getInstance();
        private List<EdgeStructure> edgeStructures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GraphDataSummary model) {
            this.numNodes(model.numNodes);
            this.numEdges(model.numEdges);
            this.numNodeLabels(model.numNodeLabels);
            this.numEdgeLabels(model.numEdgeLabels);
            this.nodeLabels(model.nodeLabels);
            this.edgeLabels(model.edgeLabels);
            this.numNodeProperties(model.numNodeProperties);
            this.numEdgeProperties(model.numEdgeProperties);
            this.nodeProperties(model.nodeProperties);
            this.edgeProperties(model.edgeProperties);
            this.totalNodePropertyValues(model.totalNodePropertyValues);
            this.totalEdgePropertyValues(model.totalEdgePropertyValues);
            this.nodeStructures(model.nodeStructures);
            this.edgeStructures(model.edgeStructures);
        }

        public final Long getNumNodes() {
            return this.numNodes;
        }

        public final void setNumNodes(Long numNodes) {
            this.numNodes = numNodes;
        }

        @Override
        public final Builder numNodes(Long numNodes) {
            this.numNodes = numNodes;
            return this;
        }

        public final Long getNumEdges() {
            return this.numEdges;
        }

        public final void setNumEdges(Long numEdges) {
            this.numEdges = numEdges;
        }

        @Override
        public final Builder numEdges(Long numEdges) {
            this.numEdges = numEdges;
            return this;
        }

        public final Long getNumNodeLabels() {
            return this.numNodeLabels;
        }

        public final void setNumNodeLabels(Long numNodeLabels) {
            this.numNodeLabels = numNodeLabels;
        }

        @Override
        public final Builder numNodeLabels(Long numNodeLabels) {
            this.numNodeLabels = numNodeLabels;
            return this;
        }

        public final Long getNumEdgeLabels() {
            return this.numEdgeLabels;
        }

        public final void setNumEdgeLabels(Long numEdgeLabels) {
            this.numEdgeLabels = numEdgeLabels;
        }

        @Override
        public final Builder numEdgeLabels(Long numEdgeLabels) {
            this.numEdgeLabels = numEdgeLabels;
            return this;
        }

        public final Collection<String> getNodeLabels() {
            if (this.nodeLabels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nodeLabels;
        }

        public final void setNodeLabels(Collection<String> nodeLabels) {
            this.nodeLabels = NodeLabelsCopier.copy(nodeLabels);
        }

        @Override
        public final Builder nodeLabels(Collection<String> nodeLabels) {
            this.nodeLabels = NodeLabelsCopier.copy(nodeLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeLabels(String ... nodeLabels) {
            this.nodeLabels(Arrays.asList(nodeLabels));
            return this;
        }

        public final Collection<String> getEdgeLabels() {
            if (this.edgeLabels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.edgeLabels;
        }

        public final void setEdgeLabels(Collection<String> edgeLabels) {
            this.edgeLabels = EdgeLabelsCopier.copy(edgeLabels);
        }

        @Override
        public final Builder edgeLabels(Collection<String> edgeLabels) {
            this.edgeLabels = EdgeLabelsCopier.copy(edgeLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edgeLabels(String ... edgeLabels) {
            this.edgeLabels(Arrays.asList(edgeLabels));
            return this;
        }

        public final Long getNumNodeProperties() {
            return this.numNodeProperties;
        }

        public final void setNumNodeProperties(Long numNodeProperties) {
            this.numNodeProperties = numNodeProperties;
        }

        @Override
        public final Builder numNodeProperties(Long numNodeProperties) {
            this.numNodeProperties = numNodeProperties;
            return this;
        }

        public final Long getNumEdgeProperties() {
            return this.numEdgeProperties;
        }

        public final void setNumEdgeProperties(Long numEdgeProperties) {
            this.numEdgeProperties = numEdgeProperties;
        }

        @Override
        public final Builder numEdgeProperties(Long numEdgeProperties) {
            this.numEdgeProperties = numEdgeProperties;
            return this;
        }

        public final Collection<? extends Map<String, Long>> getNodeProperties() {
            if (this.nodeProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nodeProperties;
        }

        public final void setNodeProperties(Collection<? extends Map<String, Long>> nodeProperties) {
            this.nodeProperties = LongValuedMapListCopier.copy(nodeProperties);
        }

        @Override
        public final Builder nodeProperties(Collection<? extends Map<String, Long>> nodeProperties) {
            this.nodeProperties = LongValuedMapListCopier.copy(nodeProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeProperties(Map<String, Long> ... nodeProperties) {
            this.nodeProperties(Arrays.asList(nodeProperties));
            return this;
        }

        public final Collection<? extends Map<String, Long>> getEdgeProperties() {
            if (this.edgeProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return this.edgeProperties;
        }

        public final void setEdgeProperties(Collection<? extends Map<String, Long>> edgeProperties) {
            this.edgeProperties = LongValuedMapListCopier.copy(edgeProperties);
        }

        @Override
        public final Builder edgeProperties(Collection<? extends Map<String, Long>> edgeProperties) {
            this.edgeProperties = LongValuedMapListCopier.copy(edgeProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edgeProperties(Map<String, Long> ... edgeProperties) {
            this.edgeProperties(Arrays.asList(edgeProperties));
            return this;
        }

        public final Long getTotalNodePropertyValues() {
            return this.totalNodePropertyValues;
        }

        public final void setTotalNodePropertyValues(Long totalNodePropertyValues) {
            this.totalNodePropertyValues = totalNodePropertyValues;
        }

        @Override
        public final Builder totalNodePropertyValues(Long totalNodePropertyValues) {
            this.totalNodePropertyValues = totalNodePropertyValues;
            return this;
        }

        public final Long getTotalEdgePropertyValues() {
            return this.totalEdgePropertyValues;
        }

        public final void setTotalEdgePropertyValues(Long totalEdgePropertyValues) {
            this.totalEdgePropertyValues = totalEdgePropertyValues;
        }

        @Override
        public final Builder totalEdgePropertyValues(Long totalEdgePropertyValues) {
            this.totalEdgePropertyValues = totalEdgePropertyValues;
            return this;
        }

        public final List<NodeStructure.Builder> getNodeStructures() {
            List<NodeStructure.Builder> result = NodeStructuresCopier.copyToBuilder(this.nodeStructures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeStructures(Collection<NodeStructure.BuilderImpl> nodeStructures) {
            this.nodeStructures = NodeStructuresCopier.copyFromBuilder(nodeStructures);
        }

        @Override
        public final Builder nodeStructures(Collection<NodeStructure> nodeStructures) {
            this.nodeStructures = NodeStructuresCopier.copy(nodeStructures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeStructures(NodeStructure ... nodeStructures) {
            this.nodeStructures(Arrays.asList(nodeStructures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeStructures(Consumer<NodeStructure.Builder> ... nodeStructures) {
            this.nodeStructures(Stream.of(nodeStructures).map(c -> (NodeStructure)((NodeStructure.Builder)NodeStructure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EdgeStructure.Builder> getEdgeStructures() {
            List<EdgeStructure.Builder> result = EdgeStructuresCopier.copyToBuilder(this.edgeStructures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEdgeStructures(Collection<EdgeStructure.BuilderImpl> edgeStructures) {
            this.edgeStructures = EdgeStructuresCopier.copyFromBuilder(edgeStructures);
        }

        @Override
        public final Builder edgeStructures(Collection<EdgeStructure> edgeStructures) {
            this.edgeStructures = EdgeStructuresCopier.copy(edgeStructures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edgeStructures(EdgeStructure ... edgeStructures) {
            this.edgeStructures(Arrays.asList(edgeStructures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edgeStructures(Consumer<EdgeStructure.Builder> ... edgeStructures) {
            this.edgeStructures(Stream.of(edgeStructures).map(c -> (EdgeStructure)((EdgeStructure.Builder)EdgeStructure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GraphDataSummary build() {
            return new GraphDataSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GraphDataSummary> {
        public Builder numNodes(Long var1);

        public Builder numEdges(Long var1);

        public Builder numNodeLabels(Long var1);

        public Builder numEdgeLabels(Long var1);

        public Builder nodeLabels(Collection<String> var1);

        public Builder nodeLabels(String ... var1);

        public Builder edgeLabels(Collection<String> var1);

        public Builder edgeLabels(String ... var1);

        public Builder numNodeProperties(Long var1);

        public Builder numEdgeProperties(Long var1);

        public Builder nodeProperties(Collection<? extends Map<String, Long>> var1);

        public Builder nodeProperties(Map<String, Long> ... var1);

        public Builder edgeProperties(Collection<? extends Map<String, Long>> var1);

        public Builder edgeProperties(Map<String, Long> ... var1);

        public Builder totalNodePropertyValues(Long var1);

        public Builder totalEdgePropertyValues(Long var1);

        public Builder nodeStructures(Collection<NodeStructure> var1);

        public Builder nodeStructures(NodeStructure ... var1);

        public Builder nodeStructures(Consumer<NodeStructure.Builder> ... var1);

        public Builder edgeStructures(Collection<EdgeStructure> var1);

        public Builder edgeStructures(EdgeStructure ... var1);

        public Builder edgeStructures(Consumer<EdgeStructure.Builder> ... var1);
    }
}

